define(function() {
  var intervflowwidgetservice = function () {

    let intervflowwidgetservice = {};
    this.intervFormManager = [];

    /**
     * pour identifier un formulaire, on utilise
     *  - formName: Le nom du fichier .form
     *  - title: Le titre affiché dans intervflowwidget
     *  - type: le type de formulaire
     * Deux formulaires sont considéré identique si les trois propriétés sont identiques
     * @param {*} formManager array intervFormManager
     * @param {*} formName 
     * @param {*} title 
     * @param {*} type 
     * @param {*} isOpen init state
     */
    let addFormToManager = (formManager, formName, title, type, isOpen) => {
      const identifiers = {
        formName: formName,
        title: title,
        type: type
      }
      formManager.push({
        form: identifiers,
        opened: isOpen
      });
    };

    /**
     * 
     * @param {*} formManager  array intervFormManager
     * @param {*} formName form name
     * @param {*} title form title
     * @param {*} type form type
     * @returns returns the form if it's in the manager
     *          undefined otherwise
     */
    let getFormInFormManager = (formManager, formName, title, type) => {
      return formManager.find(formInfo =>
        formInfo.form.formName === formName
        && formInfo.form.title === title
        && formInfo.form.type === type);
    };

    /**
     * Vérifie si le formulaire est ouvert d'après son titre et son type
     * @param link formulaire récupéré de la config
     * @returns {boolean} true si le formulaire est déjà ouvert
     */
    let isFormOpened = (link) => {
      let formInfo = getFormInFormManager(
        this.intervFormManager, link.config.templateform,
        link.title, link.type);

      if (formInfo !== undefined) {
        return formInfo.opened;
      } else {
        //if it's not in the list, it's closed
        return false;
      }
    };

    /**
     * Change l'état du formulaire dans la variable intervFormManager
     * intervFormManager[i].opened = isOpen
     * @param link formulaire récupéré de la config
     * @param isOpen boolean du nouvel état du formulaire
     */
    let setFormState = (link, isOpen) => {
      let formInfo = getFormInFormManager(
        this.intervFormManager, link.config.templateform,
        link.title, link.type);
      
      if (formInfo !== undefined) {
        //form found
        formInfo.opened = isOpen;
      } else {
        // form not found -> add it to the array
        addFormToManager(this.intervFormManager, link.config.templateform,
          link.title, link.type, isOpen);
      }
    };

    /**
     * set all panels to state closed. 
     * only one panel can be opened at a given time
     * so before openning one, you should call that function
     */
    let setPanelFormToClosed = () => {
      for (let formInfo of this.intervFormManager) {
        if (formInfo.form.type === "FormTable"
          ||formInfo.form.type === "DataTable") {
          formInfo.opened = false;
        }
      }
    };
    return {
      addFormToManager: addFormToManager,
      isFormOpened: isFormOpened,
      setFormState: setFormState,
      setPanelFormToClosed: setPanelFormToClosed
    }
  };
  return intervflowwidgetservice;
});