'use strict';
define(function() {
  var IndigauFactory = function($http) {

    /**
     * Function: importITV
     */
    function importITV(login, pass, jsonData) {
      var senddata = {
        login: login,
        pass: pass,
        json: jsonData,
        jsonResp: true,
      };

      var promise = $http({
        method: 'POST',
        url: '/indigau/apiXG/importITV.php',
        data: $.param(senddata),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
      });

      return promise;
    }

    /**
     * Function: razITV
     */
    function razITV(login, pass) {
      var senddata = {
        login: login,
        pass: pass,
      };

      var promise = $http({
        method: 'POST',
        url: '/indigau/apiXG/razITV.php',
        data: $.param(senddata),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
      });

      return promise;
    }

    /**
     * Function: getCritereITV
     */
    function getCritereITV(login, pass) {
      var senddata = {
        login: login,
        pass: pass,
      };

      var promise = $http({
        method: 'POST',
        url: '/indigau/apiXG/getCritereITV.php',
        data: $.param(senddata),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
      });

      return promise;
    }

    /**
     * Function: resultITV
     */
    function getCalculPage() {

      var promise = $http({
        method: 'GET',
        url: '/indigau/evaluation/calculs/autrescrit.php?from_ng=true',
      });

      return promise;
    }


    function calscores(
      div_retour, pagephp, div_max, pas, nomprogressbar, avancement, loadDialog
    ) {
      var promise = $http({
        method: 'POST',
        url: '/indigau/evaluation/' + pagephp,
        data: 'pas=' + pas,
      });
      return promise;
    }


    function getResCalcul(pPage, pParams, postOrGet) {
      var promise;
      if (postOrGet == 'post') {
        promise = $http({
          method: 'POST',
          url: '/indigau/evaluation/' + pPage,
          data: pParams,
        });
      } else {
        promise = $http.get('/indigau/evaluation/' + pPage + '?' + pParams);
      }
      return promise;
    }
    /**
     * Function: resultITV
     */
    function resultITV(login, pass, c1, c2, c3) {
      var senddata = {
        login: login,
        pass: pass,
        c1: c1,
        c2: c2,
        c3: c3,
      };

      var promise = $http({
        method: 'POST',
        url: '/indigau/apiXG/resultITV.php',
        data: $.param(senddata),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
      });

      return promise;
    }

    /**
     * Function: generatestyles
     */
    function generatestyles(canaLayerID, field1, field2, field3) {
      return $http.get(
        '/services/{portalid}/indigau/generatestyles?f=json' +
          '&canaLayerID=' +
          canaLayerID +
          '&field1=' +
          field1 +
          '&field2=' +
          field2 +
          '&field3=' +
          field3
      );
    }

    function initMatrices(dsname) {
      return $http.get(
        '/services/{portalid}/indigau/{appname}/defineDefaultMatrices?f=json' +
          '&datastorename=' +
          dsname
      );
    }

    /**
     * Function: initDb
     */
    function initDb(dsName) {
      return $http.get(
        '/services/{portalid}/indigau/{appname}/initDb?f=json' +
          '&datastorename=' +
          dsName
      );
    }

    /**
     * Function: getIndicateursAndChoixRegle
     */
    function getIndicateursAndChoixRegle(dsName) {
      return $http.get(
        '/services/{portalid}/indigau/getIndicateursAndChoixRegle?f=json' +
          '&datastorename=' +
          dsName
      );
    }

    /**
     * Function: getIndicateursAndChoixRegle
     */
    function getIndicateurVersions(typeOfVersion, dsName, idIndicateur) {
      return $http.get(
        '/services/{portalid}/indigau/getIndicateurVersions?f=json' +
          '&datastorename=' +
          dsName +
          '&idIndicateur=' +
          idIndicateur +
          '&typeOfVersion=' +
          typeOfVersion
      );
    }

    /**
     * Function: getIndicateursAndChoixRegle
     */
    function deleteVersion(typeOfVersions, dsName, ids) {
      return $http.get(
        '/services/{portalid}/indigau/deleteVersion?f=json' +
          '&datastorename=' +
          dsName +
          '&ids=' +
          ids +
          '&typeOfVersions=' +
          typeOfVersions
      );
    }

    function selectIndicateurVersion(typeOfVersion, dsName, id, indicateurId) {
      return $http.get(
        '/services/{portalid}/indigau/selectIndicateurVersion?f=json' +
          '&datastorename=' +
          dsName +
          '&id=' +
          id +
          '&idIndicateur=' +
          indicateurId +
          '&typeOfVersion=' +
          typeOfVersion
      );
    }

    function updateComplementDeNom(typeOfVersion, dsName, id, nom) {
      return $http.get(
        '/services/{portalid}/indigau/updateComplementDeNom?f=json' +
          '&datastorename=' +
          dsName +
          '&idVersion=' +
          id +
          '&nom=' +
          nom +
          '&typeOfVersion=' +
          typeOfVersion
      );
    }

    /**
     * Vérification de l'installation d'INDIGAU (moteur en PHP).
     * 29/06/2021: ne vérifie que l'existence et la possibilité
     * de créer le fichier troncon.csv.
     *
     * @param {*} appname
     * @param {*} datasource
     * @returns
     */
    let checkIndigau = (appname,datasource,indigauEngine) => {
      return $http.get(
        '/services/{portalid}/indigau/checkIndigau?f=json' +
        '&appname=' + appname +
        '&datasource=' + datasource+
        '&indigauEngine=' + !!indigauEngine
      );
    };


    return {
      importITV: importITV,
      razITV: razITV,
      getCritereITV: getCritereITV,
      resultITV: resultITV,
      generatestyles: generatestyles,
      getCalculPage: getCalculPage,
      calscores: calscores,
      getResCalcul: getResCalcul,
      initDb: initDb,
      getIndicateursAndChoixRegle: getIndicateursAndChoixRegle,
      getIndicateurVersions: getIndicateurVersions,
      selectIndicateurVersion: selectIndicateurVersion,
      updateComplementDeNom: updateComplementDeNom,
      deleteVersion: deleteVersion,
      initMatrices: initMatrices,
      checkIndigau: checkIndigau
    };
  };
  IndigauFactory.$inject = ['$http'];
  return IndigauFactory;
});
