'use strict';
define(() => {

  /**
   * Widget Import xlsx
   */
  class importxlsxwidget {
    constructor(
        importxlsxfactory,
        ImportExportFactory,
        ngDialog,
        FeatureAttachmentFactory,
        ConfigFactory,
        QueryFactory,
        $rootScope,
        $timeout,
        $window,
        $filter
    ) {
      return {
        templateUrl:
            'js/XG/widgets/mapapp/importxlsx/views/importxlsxwidget.html',
        restrict: 'AE',
        link: function (scope) {

          // Vérification que la configuration du widget est complète
          // Si oui, on récupère les valeurs possible de territoire
          scope.checkConfigAndGetTerritoryValues = (config) => {
            scope.config = config;
            if(scope.config.sheetType && scope.config.jsonFileName
                && scope.config.territoryComponentUid && scope.config.territoryAttributeName) {
              scope.config.complete = true;
              scope.territoryValues = [];
              scope.config.territoryValue = undefined;

              // Valeurs possibles pour le territoire
              QueryFactory.dataattribute(
                  scope.config.territoryComponentUid,
                  scope.config.territoryAttributeName
              ).then((res) => {
                scope.territoryValues = res.data;

                // Si aucune valeur possible de territoire, toastr warning le précisant
                if(scope.territoryValues.length === 0) {
                  require('toastr').warning($filter('translate')(
                      'importxlsxwidget.noPossibleValueForTerritory'));
                }
                // Si une seule valeur possible de territoire, on l'affecte automatiquement
                if(scope.territoryValues.length === 1) {
                  scope.config.territoryValue = scope.territoryValues[0];
                }
              });
            } else {
              scope.config.complete = false;
            }
          }

          // Récupération configuration
          scope.config = {};
          ConfigFactory.get('widgets', scope.ConfigName).then(
              res => {
                if(res && res.data && res.data !== '') {
                  scope.checkConfigAndGetTerritoryValues(res.data);
                }
              },
              () => {
                require('toastr').error($filter('translate')
                ('importexportwidget.config.getConfigErrorMsg'));
              }
          );

          // Bouton d'ouverture de la configuration
          scope.configImportXLSX = () => {
            ngDialog.open({
              template:
                  'js/XG/widgets/mapapp/importxlsx/views/importxlsxwidgetconfigredirection.html',
              className: 'ngdialog-theme-plain nopadding width450 miniclose',
              closeByDocument: false,
              title: $filter('translate')('importxlsxwidget.configTitle'),
              scope: scope
            });
          };

          // Lance le traitement, en simulation si save === false
          scope.importAndTreatXlsxFile = (save) => {
            // Supprime le résultat précédent
            scope.result = undefined;

            importxlsxfactory.importAndTreatXlsxFile(
                $rootScope.xgos.user.login,
                scope.config.territoryValue,
                scope.ConfigName,
                scope.uploadProcessID,
                save).then(res => {
                  scope.result=res.data;
            });
          };

          // Supprime les fichiers côté serveur et vide la dropzone
          scope.clearDropzone = () => {
            // Supprime le résultat précédent
            scope.result = undefined;

            // Nettoi les fichiers côté serveur
            ImportExportFactory.removeProcessFiles(scope.uploadProcessID).then(
                () => {
                  // Vide la dropzone
                  if (scope.dropzoneComponent.files.length > 0) {
                    scope.dropzoneComponent.removeAllFiles();
                  }
                },
                (error) => {
                  require('toastr').error(
                      $filter('translate')('importgpxwidget.removeallerror') + error.detail);
                }
            )
          };

          // Bouton télécharger du fichier de résultat
          // Génération d'un fichier texte pour le téléchargement à partir du résultat d'importAndTreatXlsxFile
          scope.generateResultFile = () => {
            let hiddenElement = document.createElement('a');

            hiddenElement.href = 'data:attachment/text,' + encodeURI(scope.result);
            hiddenElement.target = '_blank';
            hiddenElement.download = ('Resultats_' + scope.config.sheetType + '_' + scope.config.territoryValue)
            .replaceAll(' ', '_') + '.txt';
            hiddenElement.click();
          }

          // À l'import de fichier dans la dropbox
          scope.refreshAValue = () => {
            scope.result = undefined;
            // Refresh pour que les boutons soient disponibles
            $timeout(() => {});
          }
        },
      };
    }
  }

  importxlsxwidget.$inject = [
    'importxlsxfactory',
    'ImportExportFactory',
    'ngDialog',
    'FeatureAttachmentFactory',
    'ConfigFactory',
    'QueryFactory',
    '$rootScope',
    '$timeout',
    '$window',
    '$filter'
  ];
  return importxlsxwidget;
});