'use strict';

define([
  'angular',
  'widgets/mapapp/importexport/directives/importexportwidget',
  'widgets/mapapp/importexport/directives/exportWidgetAttachment',
  'widgets/mapapp/importexport/services/ImportExportFactory',

  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'toastr',
  'ol3js',
  'ng-table',
], function(angular, importexportwidget, exportWidgetAttachment, ImportExportFactory) {
  var gcimportexport = angular.module('gc_importexport', [
    'pascalprecht.translate',
  ]);

  // ajout service
  gcimportexport.factory('ImportExportFactory', ImportExportFactory);

  //ajout directive
  gcimportexport.directive('importexportwidget', importexportwidget);
  gcimportexport.directive('exportWidgetAttachment', exportWidgetAttachment);

  gcimportexport.filter('layernametrunc', function() {
    return function(val) {
      var maxLength = 15;
      if (val.length > maxLength) {
        var diff = val.length - maxLength;
        return '...' + val.substr(diff, val.length);
      } else {
        return val;
      }
    };
  });

  return gcimportexport;
});
