'use strict';
define(function() {
  var MBTILESService = function($http) {
    var MBTILESService = {};

    /**
     * Class : MBTILESService
     * Factory WebServices
     */

    /**
     * Function: exportMBTILES
     */
    function exportMBTILES(data) {
      var promise = $http.post('/services/{portalid}/mbtiles/export', data);
      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getProgression(p) {
      var promise = $http.post(
        '/services/{portalid}/mbtiles/get/progression?',
        p
      );

      return promise;
    }

    /**
     * Function: getFile
     * @param {string} format , geojson ou json
     */
    function getFile(p) {
      var promise = $http.post('/services/{portalid}/mbtiles/getFile?', p);

      return promise;
    }

    return {
      MBTILESService: MBTILESService,
      exportMBTILES: exportMBTILES,
      getProgression: getProgression,
      getFile: getFile,
    };
  };
  MBTILESService.$inject = ['$http'];
  return MBTILESService;
});
