'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    gcPopup,
    extendedNgDialog,
    gaDomUtils,
    $filter,
    GeoTreatmentFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/treatments/treatNearestLine.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        scope.activetreatment = '';
        scope.res = {};
        scope.inprogress = false;
        scope.interrupt = false;
        scope.geoLimit = GeoTreatmentFactory.DATABASE;

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        scope.stop = function() {
          GeoTreatmentFactory.stoptreatment(scope.state).then(function() {
            scope.inprogress = false;
            scope.interrupt = true;
          }).catch(handlePromiseError);
        };

        scope.run = function(fti1, fti2, distanceMin, distanceMax) {
          if (distanceMin > distanceMax) {
            require('toastr').error(
              $filter('translate')('geotreat.DistanceErrorMessage')
            );
            return;
          }
          scope.inprogress = true;
          const featureCollections = [];
          const spatialClause = 
            GeoTreatmentFactory.getSpatialClause(
              scope.geoLimit,
              scope.map,
              scope.limitZoneGeometry,
              [fti1.name, fti2.name],
              featureCollections);
          var param = {
            spatialclause: spatialClause,
            featureCollections: featureCollections,
            fti1: fti1.uid,
            fti2: fti2.uid,
            distanceMin: distanceMin,
            distanceMax: distanceMax,
            srid: scope.map.getView().getProjection().getCode()
          };
           GeoTreatmentFactory.treatment(param, 'NearestLine')
           .then(function(data) {
            scope.state = data.data;
            scope.httpStatus=data.status;
            GeoTreatmentFactory.tick(scope, [
              'linesupport',
              'linesource',
              'dist',
            ]);
          }).catch(handlePromiseError);
        };
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'gcPopup',
    'extendedNgDialog',
    'gaDomUtils',
    '$filter',
    'GeoTreatmentFactory',
  ];
  return basemapwidget;
});
