'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    gcPopup,
    extendedNgDialog,
    gaDomUtils,
    GeoTreatmentFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/treatments/treatFusionLine.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        scope.activetreatment = '';
        scope.res = {};
        scope.attributes_select = [];
        scope.limitZoneGeometry = null;
        scope.inprogress = false;
        scope.interrupt = false;
        scope.geoLimit = GeoTreatmentFactory.DATABASE;
        scope.typeOfGeotreatment = 'fusion';

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        scope.stop = function() {
          GeoTreatmentFactory.stoptreatment(scope.state).then(function() {
            scope.inprogress = false;
            scope.interrupt = true;
          }).catch(handlePromiseError);
        };

        scope.correction = function(obj) {
          scope.currentobj = obj;
          scope.dependdialog = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/geotreatment/views/modals/modal.correct.fusionLine.html',
            className:
              'ngdialog-theme-plain overflowY width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: {
              title: 'Corrections',
            },
          });
        };

        scope.run = function(fti1, attr) {
          scope.inprogress = true;
          const featureCollections = [];
          const spatialClause = 
            GeoTreatmentFactory.getSpatialClause(
              scope.geoLimit,
              scope.map,
              scope.limitZoneGeometry,
              [fti1.name],
              featureCollections);
          var param = {
            spatialclause: spatialClause,
            featureCollections: featureCollections,
            fti1: fti1.uid,
            attributes: attr,
            srid: scope.map.getView().getProjection().getCode()
          };
          GeoTreatmentFactory.treatment(
            param,
            'FusionLine'
          ).then(function(data) {
            scope.state = data.data;
            scope.httpStatus=data.status;
            GeoTreatmentFactory.tick(scope, ['line1', 'line2'], []);
          }).catch(handlePromiseError);
        };

        scope.$on('ftiChanged', function() {
          scope.attributes_select = [];
        });
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'gcPopup',
    'extendedNgDialog',
    'gaDomUtils',
    'GeoTreatmentFactory',
  ];
  return basemapwidget;
});
