'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    $rootScope
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/geosignet/views/geosignetwidget.html',
      restrict: 'A',

      link: function(scope, elt, attrs, ctrl) {
        var map = scope.map;
        scope.current_name = '';
        scope.currentuser = $rootScope.xgos.user.login;
        scope.places = [];
        ParametersFactory.getbytype('Geosignet').then(function(res) {
          angular.forEach(res.data, function(gs) {
            console.log(angular.toJson(gs.data));
            scope.places.push(gs);
          });
        });
        scope.add = function() {
          console.log('add geosignet');
          if (scope.current_name != '') {
            var size = map.getSize();
            var mapExtent = map.getView().calculateExtent(size);
            var p = {
              label: scope.current_name,
              extent: mapExtent,
            };
            ParametersFactory.add(p, 'Geosignet', p.label).then(function(res) {
              scope.places.push(res.data);
            });
          }
        };
        scope.remove = function(place) {
          ParametersFactory.remove(place.id).then(function(res) {
            var deleteIndex = scope.places
              .map(function(x) {
                return x.label;
              })
              .indexOf(place.label);
            scope.places.splice(deleteIndex, 1);
          });
        };
        scope.save = function() {};
        scope.go = function(place) {
          console.log(place.data.extent);
          var size = map.getSize();
          var view = map.getView();

          view.fit(place.data.extent, size);
        };
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    '$rootScope',
  ];
  return basemapwidget;
});
