'use strict';
define(function() {
  var toolbarexportmap = function(
      gclayers,
      $http,
      $window,
      PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/exportmapsvg/views/toolbarexportmapsvg.html',
      restrict: 'A',

      link: function(scope, element) {
        element.bind('click', function() {
          var map = scope.map;
          var btnElt = document.getElementById('downloadscreen');
          console.log('SVG...............');
          var currExtent = scope.map
            .getView()
            .calculateExtent(scope.map.getSize());
          var size = scope.map.getSize();
          var layers = gclayers.getOperationalLayerCollection();

          var typeNames = [];
          var styleNames = [];
          var layerinWMS = [];
          var reflayerinWMS = [];
          var layerind = [];
          var nbpergroup = 0;

          angular.forEach(layers, function(l) {
            var resolution = scope.map.getView().getResolution();
            if (
              l.visible &&
              l.getMaxResolution() > resolution &&
              l.getMinResolution() < resolution
            ) {
              typeNames.push(l.name);
              if (angular.isUndefined(l.style)) {
                styleNames.push('');
              } else {
                styleNames.push(l.style);
              }
            }
          });
          var URL =
            '/services/' +
            PortalsFactory.getPortalId() +
            '/geoserver/wms?token=' +
            localStorage.auth_token +
            '&SERVICE=WMS&VERSION=1.1.0&REQUEST=GetMap&LAYERS=' +
            typeNames.join(',') +
            '&STYLES=' +
            styleNames.join(',') +
            '&BBOX=' +
            currExtent.join(',') +
            '&WIDTH=' +
            size[0] +
            '&HEIGHT=' +
            size[1] +
            '&SRS=EPSG:3857&FORMAT=image/svg';
          $window.open(URL);
        });
      },
    };
  };

  toolbarexportmap.$inject = [
    'gclayers',
    '$http',
    '$window',
    'PortalsFactory'
  ];
  return toolbarexportmap;
});
