'use strict';
define(function() {
  var toolbarexportmap = function(
    gclayers,
    $http,
    $window,
    gaDomUtils,
    $filter,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/exportmap/views/toolbarsharemapsocial.html',
      restrict: 'A',

      link: function(scope, element, attrs, ctrl) {
        var uploadUrl = 'http://altereo.fr/';

        scope.picTaken = false;
        scope.picUploaded = false;
        scope.shareUrl = '';

        var image;

        /**
         * take the "picture"
         */
        scope.takePic = function() {
          scope.map.once('postcompose', function(event) {
            var canvas = event.context.canvas;
            image = canvas.toDataURL('image/png');

            scope.picTaken = true;
            scope.picUploaded = false;
          });

          scope.map.renderSync();
        };
        /**
         * show the "picture"
         */
        scope.showPic = function() {
          var nmablob = gaDomUtils.convertDataURItoBlob(image);
          var blobUrl = URL.createObjectURL(nmablob);
          window.open(blobUrl);
        };

        /**
         * uploadPic
         */
        scope.uploadPic = function() {
          gaDomUtils.showGlobalLoader();
          var imgname = gaJsUtils.generateShortUID(6);

          $http({
            method: 'POST',
            url: uploadUrl + 'kisimguploaderz.php',
            data: {
              name: imgname,
              image: image,
            },
            headers: {
              'Content-Type':
                'application/x-www-form-urlencoded; charset=UTF-8',
            },
          }).then(
            function result(res) {
              scope.shareUrl = uploadUrl + 'kisimg/?i=' + imgname;
              scope.picUploaded = true;
              gaDomUtils.hideGlobalLoader();
            },
            function error(er) {
              require('toastr').error(
                $filter('translate')('sharemapsocial.errorfail')
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          if (scope.isActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
          } else {
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isActive = true;
          }
        });

        scope.$on('closeToolsBar_toolbarsharemapsocial', function(event) {
          if (scope.isActive) $('#toolbar_sharemapsocial_popover').click();
          btnElt.removeClass('btn-info');
          btnElt.addClass('btn-default');
          scope.isActive = false;
        });
      },
    };
  };

  toolbarexportmap.$inject = [
    'gclayers',
    '$http',
    '$window',
    'gaDomUtils',
    '$filter',
    'gaJsUtils',
  ];
  return toolbarexportmap;
});
