'use strict';
define(function() {
  /**
   * ToolBarDirections directive
   */
  var toolbardirections = function(
    $compile,
    $http,
    $sce,
    $rootScope,
    GoogleMapsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/directions/views/toolbardirections.html',
      restrict: 'A',
      link: function(scope, element) {
        // Init variables
        var m = scope.map,
          isActive = false,
          fromLayer = false,
          toLayer = false,
          directionLayer = false,
          fromToLayer = false,
          dragInteraction = false
          // Panneau du choix des clés (ign, openroute ou google)
          scope.isActiveChooseKeyPanel = true;
        
          //Les cases à cocher sont visibles mais disabled si la clé n'y est pas
          if (!$rootScope.xgos.portal.parameters.apikey.openroute){
            scope.chooseOpenroute = true;
            scope.disableIfNoKeyOpenroute = true            
          } else {
            scope.chooseOpenroute = true;
            scope.disableIfNoKeyOpenroute = false  
          }
        
          if (!$rootScope.xgos.portal.parameters.apikey.google){
            scope.chooseGoogle = true;
            scope.disableIfNoKeyGoogle = true
          } else {
            scope.chooseGoogle = true;
            scope.disableIfNoKeyGoogle = false
          }
          
          if (!$rootScope.xgos.portal.parameters.apikey.ign){
            scope.chooseIgn = true;
            scope.disableIfNoKeyIgn = true
          } else {
            scope.chooseIgn = true;
            scope.disableIfNoKeyIgn = false
          }

          // La clé choisie
          scope.choosenkey = "";

        /* Click on the GoogleDirections toolbar button*/
        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          btnElt.removeClass('btn-info btn-default');
          // On nettoie la carte si on retire le panneau toolbardirection
          if (isActive) {
            scope.resetPoints();
            btnElt.addClass('btn-default');
            isActive = false;
            m.removeLayer(fromToLayer);
            m.removeLayer(directionLayer);
            m.removeInteraction(dragInteraction);
            scope.panelsManager.removePanel('directionControls');
          } else {
            // Ce qui se passe quand on active le panneau toolbardirection
            btnElt.addClass('btn-info');
            // reset variables
            fromLayer = toLayer = directionLayer = dragInteraction = false;
            // Addresses
            scope.addresses = { from: {}, to: {}, directions: {} };
            scope.travelMode = 'DRIVING';

            /* google map init */
            GoogleMapsFactory.lazyLoad().then(function() {
              /* from and to features... */
              var fromFeature = new ol.Feature({});
              fromFeature.setId('from');
              fromFeature.setStyle(
                new ol.style.Style({
                  image: new ol.style.Icon({
                    src: 'img/widget/directions/map_small_1.png',
                  }),
                })
              );

              var toFeature = new ol.Feature({});
              toFeature.setId('to');
              toFeature.setStyle(
                new ol.style.Style({
                  image: new ol.style.Icon({
                    src: 'img/widget/directions/map_small_2.png',
                  }),
                })
              );

              // Fix for cesium who cant handle points without geometry
              // https://github.com/openlayers/ol3-cesium/issues/161
              // TODO: remove when fixed in cesium
              fromFeature.setGeometry(new ol.geom.Point([0, 0]));
              toFeature.setGeometry(new ol.geom.Point([0, 0]));

              /* ... are added to the fromToLayer */
              fromToLayer = new ol.layer.Vector({
                source: new ol.source.Vector({
                  features: [fromFeature, toFeature],
                }),
              });
              m.addLayer(fromToLayer);

              // User can now click on the map
              isActive = true;
              
              if (scope.chooseGoogle === false && scope.chooseOpenroute === false) {
                scope.isActiveChooseKeyPanel = false
              } else if (scope.chooseGoogle === true && scope.chooseOpenroute === true){
                scope.isActiveChooseKeyPanel = true
              } else if (scope.chooseGoogle === true || scope.chooseOpenroute === true){
                scope.isActiveChooseKeyPanel = true
              }
              // directionsControl Panel
              scope.panelsManager.addPanel({
                id: 'directionControls',
                stickToRight: false,
                templateUrl:
                  'js/XG/widgets/mapapp/directions/views/directionscontrols.html',
                scope: scope,
                position: 'top',
                size: 135,
              });
            });
          }
        });
        // Conversion des coordonnées sans besoin de clé
        function coordinatesToLatLng(coords, projection){
          var transformCoordinates = ol.proj.transform(
            [coords[0], coords[1]],
            projection,
            'EPSG:4326'
          ),
          lat = Math.round(transformCoordinates[1] * 10000000) / 10000000,
          lng = Math.round(transformCoordinates[0] * 10000000) / 10000000;
          return [lng, lat];
        }

        // Conversion des coordonnées sans besoin de clé mais spécifiquement dans le cas du géocaodae par address
        function coordinatesToLatLngForAddress(coords, projection){
          var transformCoordinates = ol.proj.transform(
            [coords[0], coords[1]],
            'EPSG:4326',
            projection
          ),
          lat = Math.round(transformCoordinates[1] * 10000000) / 10000000,
          lng = Math.round(transformCoordinates[0] * 10000000) / 10000000;
          return [lng, lat];
        }
        // la couche du futur chemin qui sera tracé 
        var routeLayer = new ol.layer.Vector({}); 

        // Tracé du chemin et mis en carte
        function createRoute(geom, format) {

          // S'il y a un chemin sur la carte , l'éffacer avant de tracer le nouveau
           if (routeLayer.getSource()) {
            var features = routeLayer.getSource().getFeatures();
              features.forEach((feature) => {
                routeLayer.getSource().removeFeature(feature);                
              })
          }

          // Style du chemin
          var styles = {
            routePolyline: new ol.style.Style({
              stroke: new ol.style.Stroke({
                width: 6, color: [200, 40, 40, 0.8]
              })
            }),
            routeWkt: new ol.style.Style({
              stroke: new ol.style.Stroke({
                width: 6, color: [40, 40, 40, 0.8]
              })
            })
          };

          let route = {};
      
          if (format === "polyline") {
      
            route = new ol.format.Polyline({
              factor: 1e5
            }).readGeometry(geom, {
            dataProjection: 'EPSG:4326',
            featureProjection: 'EPSG:2154'
          });
          
      
          } else if (format === "wkt") {
            route = new ol.format.WKT().readGeometry(geom, {
            dataProjection: 'EPSG:4326',
            featureProjection: 'EPSG:3857'
          });
          } else {
            return false;
          }
          
      
          let feature = new ol.Feature({
            type: 'route',
            geometry: route
          });
          
      
          if (format === "polyline") {
            feature.setStyle(styles.routePolyline);
          } else if (format === "wkt") {
            feature.setStyle(styles.routeWkt);
          }

          routeLayer = new ol.layer.Vector({
            source: new ol.source.Vector({
              features: [feature],
            }),
          });

         m.addLayer(routeLayer)
        }

        // Requete ign qui retourne le geometry du chemin puis l'envoie dans la fonction createRoute pour le tracé sur la carte
        function computeRoad(from,to) {
          // DRIVING BICYCLING TRANSIT WALKING
          var profile = document.querySelector('#userProfile').value ;
         
          var reqs = 0;
       
          var road2Url = "https://wxs.ign.fr/calcul/geoportail/itineraire/rest/1.0.0/route?";
          var defaultResource= document.querySelector('#userResource').value;
          // pedestrian
         
         var defaultProfile=profile;
          var defaultOptimization=document.querySelector('#userOptimization').value;
          var defaultGraphName = "Voiture";
          var defaultMethod = "time";
  
          // Déclarations
          let request = {};
          let intermediatesPointsStr = "";
        
          // on récupère les valeurs 
          request.finalStart = from;
          request.finalEnd = to;
         
          request.finalIntermediates = intermediatesPointsStr;
        
          // Gestion des points de l'utilisateur
          if ( request.finalStart === "" || request.finalEnd === "" ) {
            // il n'y a pas assez de points pour faire un itinéraire
            return false;
          } 
          // loadUserParameter(request);
          request.finalResource = defaultResource;
          request.finalProfile = defaultProfile;
          request.finalOptimization = defaultOptimization;
          request.finalConstraint = "";

          let constraintObject = {};
          // Constraint
          let  plural = false;
          request.finalConstraint = "";
          if (document.forms["route-form"].elements["banned-highway"].checked) {
            if (plural) {
              request.finalConstraint = request.finalConstraint + "|";
            } else {
              plural = true;
            }
            constraintObject.constraintType = "banned";
            constraintObject.key = "wayType";
            constraintObject.operator = "=";
            constraintObject.value = "autoroute";
            request.finalConstraint = request.finalConstraint + JSON.stringify(constraintObject);
          }
          if (document.forms["route-form"].elements["banned-tunnel"].checked) {
            if (plural) {
              request.finalConstraint = request.finalConstraint + "|";
            } else {
              plural = true;
            }
            constraintObject.constraintType = "banned";
            constraintObject.key = "wayType";
            constraintObject.operator = "=";
            constraintObject.value = "tunnel";
            request.finalConstraint = request.finalConstraint + JSON.stringify(constraintObject);
          }
          if (document.forms["route-form"].elements["banned-bridge"].checked) {
            if (plural) {
              request.finalConstraint = request.finalConstraint + "|";
            } else {
              plural = true;
            }
            constraintObject.constraintType = "banned";
            constraintObject.key = "wayType";
            constraintObject.operator = "=";
            constraintObject.value = "pont";
            request.finalConstraint = request.finalConstraint + JSON.stringify(constraintObject);
          }
          if (document.forms["route-form"].elements["pref-imp"].checked) {
            if (plural) {
              request.finalConstraint = request.finalConstraint + "|";
            } else {
              plural = true;
            }
            constraintObject.constraintType = document.getElementById("pref-ou-avoid-imp").value;
            constraintObject.key = "importance";
            constraintObject.operator = document.getElementById("operator-imp").value;
            constraintObject.value = parseInt(document.getElementById("importance").value);
            request.finalConstraint = request.finalConstraint + JSON.stringify(constraintObject);
          }
          if (document.forms["route-form"].elements["pref-classt"].checked) {
            if (plural) {
              request.finalConstraint = request.finalConstraint + "|";
            } else {
              plural = true;
            }
            constraintObject.constraintType = document.getElementById("pref-ou-avoid-imp").value;
            constraintObject.key = "cpx_classement_administratif";
            constraintObject.operator = "=";
            constraintObject.value = document.getElementById("classement").value;
            request.finalConstraint = request.finalConstraint + JSON.stringify(constraintObject);
          }
          if (document.forms["route-form"].elements["pref-iti-vert"].checked) {
            if (plural) {
              request.finalConstraint = request.finalConstraint + "|";
            } else {
              plural = true;
            }
            constraintObject.constraintType = "prefer";
            constraintObject.key = "itineraire_vert";
            constraintObject.operator = "=";
            constraintObject.value = "vrai";
            request.finalConstraint = request.finalConstraint + JSON.stringify(constraintObject);
          }


          let requestStr = road2Url +
            "resource=" + request.finalResource +
            "&profile=" + request.finalProfile +
            "&optimization=" + request.finalOptimization +
            "&start=" + request.finalStart +
            "&end="  + request.finalEnd +
            "&intermediates=" + request.finalIntermediates +
            "&constraints=" + request.finalConstraint +
            "&geometryFormat=polyline&getSteps=true&getBbox=true";
          
          // on calcule l'itinéraire
          reqs++;
          fetch(requestStr)
          .then(function(response) {
            return response.json();
          })
          .then(function(responseJSON) {
         
          createRoute(responseJSON.geometry, "polyline")  

          }).catch(() => {
            reqs--;
            
          }); 
        
          return true;
        
        }

        /**
         * Drawing the directions
         */
        function drawDirections() {
          // if both points aren't set yet
          if (!fromLayer || !toLayer) return;

          require('toastr').info('Calculating directions');

          var startCoordinates = fromToLayer
              .getSource()
              .getFeatureById('from')
              .getGeometry()
              .getCoordinates();

            if (scope.choosenkey == 'googlekey'){
              start = GoogleMapsFactory.coordinatesToLatLng(
                startCoordinates,
                m.getView().getProjection()
              )
            } else {
              start = coordinatesToLatLng(
                startCoordinates,
                m.getView().getProjection()
              ) 
            }
           
            endCoordinates = fromToLayer
              .getSource()
              .getFeatureById('to')
              .getGeometry()
              .getCoordinates();

            if (scope.choosenkey == 'googlekey'){
              end = GoogleMapsFactory.coordinatesToLatLng(
                endCoordinates,
                m.getView().getProjection()
              )
            } else {
              end = coordinatesToLatLng(
                endCoordinates,
                m.getView().getProjection()
              ) 
            }
          

          // hide direction layer if already exists
          if (directionLayer) directionLayer.setVisible(0);

          var pan = {
            duration: 1200,
            source: m.getView().getCenter(),
          };
          var zoom = {
            resolution: m.getView().getResolution(),
          };
          m.getView().animate(pan, zoom);
          // Draw a straight line between the two points and use it's extent to fit the map extent
          var fitExtentLine = new ol.source.Vector({});
          fitExtentLine.addFeature(
            new ol.Feature({
              geometry: new ol.geom.LineString([
                startCoordinates,
                endCoordinates,
              ]),
            })
          );

          m.getView().fit(fitExtentLine.getExtent(), m.getSize());

          /* Sending the direction request to google */
          new google.maps.DirectionsService().route(
            {
              origin: start,
              destination: end,
              travelMode: google.maps.TravelMode[scope.travelMode],
            },
            function(response, status) {
              if (status == google.maps.DirectionsStatus.OK) {
                require('toastr').clear();

                /* Creating a line layer from the data received */
                var route = response.routes[0],
                  steps = route.legs[0].steps;

                // We dont use the overview_path which is smoothed and not precise enough
                // https://developers.google.com/maps/documentation/javascript/directions#DirectionsResults
                // instead we get all the points from the legs object
                var points = [];
                for (var a = 0; a < steps.length; a++) {
                  for (var b = 0; b < steps[a].path.length; b++) {
                    var latlng = steps[a].path[b];
                    var gcoord = GoogleMapsFactory.latLngTocoordinates(
                      {
                        lng: latlng.lng(),
                        lat: latlng.lat(),
                      },
                      m.getView().getProjection()
                    );
                    points.push(gcoord);
                  }
                }

                if (!directionLayer) {
                  // PathFeature
                  var pathFeature = new ol.Feature({
                    geometry: new ol.geom.LineString(points),
                  });
                  pathFeature.setId('path');
                  pathFeature.setStyle(
                    new ol.style.Style({
                      stroke: new ol.style.Stroke({
                        color: 'rgba(31,120,101,0.7)',
                        width: 10,
                      }),
                    })
                  );

                  // Add both features to the directionlayer
                  directionLayer = new ol.layer.Vector({
                    source: new ol.source.Vector({
                      features: [pathFeature],
                    }),
                  });

                  // insert directionlayer under the fromToLayer so it doesn't stack over the from & to points
                  m.getLayers().insertAt(
                    m.getLayers().getArray().length - 1,
                    directionLayer
                  );

                  // Update path layer
                } else {
                  directionLayer
                    .getSource()
                    .getFeatureById('path')
                    .setGeometry(new ol.geom.LineString(points));
                  directionLayer.setVisible(1);
                }

                // Update the addresses.directions attribute
                // in order to display the informations
                try {
                  scope.$apply(function() {
                    scope.addresses.directions = {
                      summary: response.routes[0].summary,
                      legs: response.routes[0].legs[0],
                    };
                  });
                } catch(err) {}

                /* Make the both end and start layer dragable */
                if (!dragInteraction) {
                  dragInteraction = GoogleMapsFactory.setDragableLayers([
                    fromToLayer,
                  ]);
                  m.addInteraction(dragInteraction);

                  /*
                                 Redraw the directions only when dragging is stopped
                                 */
                  var lastMovedLayer = false,
                    redrawInterval = false,
                    checkRedraw = function() {
                      if (
                        fromToLayer.getSource().getFeatureById('from').moving
                      ) {
                        lastMovedLayer = 'from';
                      } else if (
                        fromToLayer.getSource().getFeatureById('to').moving
                      ) {
                        lastMovedLayer = 'to';
                      } else {
                        clearInterval(redrawInterval);
                        redrawInterval = false;

                        drawDirections();

                        if (lastMovedLayer) {
                          var newCoordinates = fromToLayer
                            .getSource()
                            .getFeatureById(lastMovedLayer)
                            .getGeometry()
                            .getCoordinates();
                          getInformationsFromCoordinates(newCoordinates).then(
                            function(address) {
                              angular
                                .element(
                                  document.querySelector(
                                    '#' + lastMovedLayer + 'Address'
                                  )
                                )
                                .val(address);
                            }
                          );
                        }
                      }
                    };

                  // Redraw on drag
                  fromToLayer.on('change', function(bool) {
                    if (bool) {
                      if (!redrawInterval)
                        redrawInterval = setInterval(checkRedraw, 10);
                    }
                  });
                }
              } else {
                require('toastr').clear();
                require('toastr').error('Error : calculation failed');
              }
            }
          );
        }

        /**
         * Show the current hovered path leg
         * @param step
         */

        scope.highlightPath = function(step) {
          // hightlight path
          var points = [];
          for (var a = 0; a < step.path.length; a++) var latlng = step.path[a];
          points.push(
            GoogleMapsFactory.latLngTocoordinates(
              { lng: latlng.lng(), lat: latlng.lat() },
              m.getView().getProjection()
            )
          );

          // Add the highLightFeature if not already set
          if (directionLayer.getSource().getFeatureById('highlight') == null) {
            var highLightFeature = new ol.Feature({
              geometry: new ol.geom.LineString(points),
            });
            highLightFeature.setId('highlight');
            highLightFeature.setStyle(
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'rgba(240, 240, 174, 1)',
                  width: 10,
                }),
              })
            );
            directionLayer.getSource().addFeatures([highLightFeature]);
          } else {
            directionLayer
              .getSource()
              .getFeatureById('highlight')
              .setGeometry(new ol.geom.LineString(points));
          }
        };
        /**
         * Zoom to current highlighted path or to the whole path if index == -1
         * @param index
         */
        scope.currentHL = -1;
        scope.goTohighlightPath = function(index) {
          scope.currentHL = index;
          // Animate
          /*m.beforeRender(ol.animation.pan({
                            duration: 1200,
                            source:  (m.getView().getCenter())
                        }),
                        ol.animation.zoom({
                            resolution: m.getView().getResolution()
                        })
                    );*/
          var pan = {
            duration: 1200,
            source: m.getView().getCenter(),
          };
          var zoom = {
            resolution: m.getView().getResolution(),
          };
          m.getView().animate(pan, zoom);
          if (index != -1) {
            m.getView().fit(
              directionLayer
                .getSource()
                .getFeatureById('highlight')
                .getGeometry()
                .getExtent(),
              m.getSize()
            );
          } else {
            m.getView().fit(
              directionLayer
                .getSource()
                .getFeatureById('path')
                .getGeometry()
                .getExtent(),
              m.getSize()
            );
          }
        };

        /**
         * Show hide directions
         */
        scope.visibleDirections = true;
        scope.toggleDirections = function() {
          scope.visibleDirections = !scope.visibleDirections;
        };

        /**
         * Set instructions as html into legs steps
         * @param instruction
         * @returns {*}
         */
        scope.trustInstructions = function(instruction) {
          return $sce.trustAsHtml(instruction);
        };

        var fromToLayer = new ol.layer.Vector({});
        var to = new ol.layer.Vector({})
        var from = new ol.layer.Vector({})
        
        scope.resetPoints = function(){
          
          toLayer = false;
          fromLayer = false;
          // Effacement du tracé
          if (routeLayer.getSource()) {
            var features = routeLayer.getSource().getFeatures();
          }
          var emptyFeatures = [];
          if (routeLayer.getSource().getFeatures()) {
            features.forEach((feature) => {
              feature.getGeometry().setCoordinates([]) 
              emptyFeatures.push(feature);
            })
          }
          routeLayer = new ol.layer.Vector({
            source: new ol.source.Vector({
              features: emptyFeatures,
            }),
          });

        document.querySelector('#fromAddress').value = "";
        document.querySelector('#toAddress').value = "";
          // Effacement des points de depart et d arrivée 
          if (fromToLayer.getSource()) {
            var features1 = fromToLayer.getSource().getFeatures();
          }
          var emptyFeatures2 = [];
          if (features1) {
            features1.forEach((feature1) => {
              feature1.getGeometry().setCoordinates([])
              emptyFeatures2.push(feature1)
              
            })
          }
          fromToLayer = new ol.layer.Vector({
            source: new ol.source.Vector({
              features: emptyFeatures2,
            }),
          });

          m.removeLayer(to);
          m.removeLayer(from)

        }
        scope.ignForm = false;

        scope.checkedoign = function() {
      
        if (document.querySelector('#ignkey').checked == true) {
          scope.choosenkey  = 'ign';
          scope.chooseIgn ==  true
          scope.ignForm = true
          
         } else {
          scope.ignForm = false
          scope.chooseIgn ==  false
         }

        }

        scope.checkedopenroute = function(){
          if (document.querySelector('#openroutekey').checked == true) {
            scope.choosenkey  = 'openroute';
         } 
        }

        scope.checkedgoogle = function(){
          if (document.querySelector('#googlekey').checked == true) {
            scope.choosenkey  = 'googlekey';
         } 
        }

        scope.changeTravelMode = function(travelMode) {
          if (scope.travelMode == travelMode) return;
          scope.travelMode = travelMode;
          drawDirections();
        };

        /**
         * Place the marker with the id markerId according to coordinates
         * @param markerId
         * @param coordinates
         */
        var placeDirectionMarker = function(markerId, coordinates) {
          fromToLayer
            .getSource()
            .getFeatureById(markerId)
            .setGeometry(new ol.geom.Point(coordinates));

          if (markerId == 'from') fromLayer = true;
          if (markerId == 'to') toLayer = true;
        };

        /**
         * Selection through typeahead
         */
        scope.$on('$typeahead.select', function(value, index) {
          // from Address
          if (scope.addresses.from.hasOwnProperty('address_components')) {
            var fromLocation = scope.addresses.from.geometry.location,
              fromLocationTranslate = GoogleMapsFactory.latLngTocoordinates(
                fromLocation,
                m.getView().getProjection()
              );

            placeDirectionMarker('from', fromLocationTranslate);
          }
          // toAddress
          if (scope.addresses.to.hasOwnProperty('address_components')) {
            var toLocation = scope.addresses.to.geometry.location,
              toLocationTranslate = GoogleMapsFactory.latLngTocoordinates(
                toLocation,
                m.getView().getProjection()
              );

            placeDirectionMarker('to', toLocationTranslate);
          }

          drawDirections();
        });

        /**
         * Get Address Informations from GoogleMap api
         * @param coordinates
         * @returns {*}
         */
        var getInformationsFromCoordinates = function(coordinates) {

          if(scope.choosenkey == 'googlekey'){
            var latlng = GoogleMapsFactory.coordinatesToLatLng(
              coordinates,
              m.getView().getProjection()
            );
          } else {
            var latlng = coordinatesToLatLng(
              coordinates,
              m.getView().getProjection()
            );
          }


          return GoogleMapsFactory.getInformationsFromCoordinates(
            latlng,
            $rootScope.xgos.portal.parameters.apikey.google
          ).then(function(res) {
            return angular.isDefined(res.data.results[0])
              ? res.data.results[0].formatted_address
              : false;
          });
        };

        /**
         * Getting Coordinates Informations from GoogleMap api
         * @param address
         * @returns {*}
         */

        var oldGeocodeUrl = "https://wxs.ign.fr/jhyvi0fgmnuxvfv0zjzorvdn/geoportail/ols";
        var results = {
          "new": {
            response: {},
            markers: [],
            layer: {}
          },
          "old": {
            response: {},
            markers: [],
            layer: {}
          },
          overlays: {},
        };
        var startcoords = [];
        var endcoords = [];
       
        var fromFeature = new ol.Feature({});
        var toFeature = new ol.Feature({});
        var routeLayer = new ol.layer.Vector({});
        scope.getInformationsFromAddress = function() {

          fromToLayer = new ol.layer.Vector({
            source: new ol.source.Vector({
              features: [fromFeature, toFeature],
            }),
          });

          m.addLayer(fromToLayer)
          
          var newGeocodeUrl = "https://geocodage.ign.fr";
          
          var geocodingType = "address";
          var address = document.querySelector('#fromAddress').value;
          var address2 = document.querySelector('#toAddress').value;
          let new_url = newGeocodeUrl + "/look4/" + geocodingType + "/search?q=" + encodeURI(address);
          let new_url2 = newGeocodeUrl + "/look4/" + geocodingType + "/search?q=" + encodeURI(address2);

          if (address){
            fetch(
              new_url, {
                method: 'GET',
                mode: 'cors',
                cache: 'default'
              }
            ).then(response => {
                // reponse en json
                console.log("reponse du nouveau geocodeur : ",response)
                return response.json();
            })
            .then(response => {
                results.new.response = response;
                var locations = response.features;
                var locations1 = [];
          
                /* on vérifie qu'on a bien des locations, sous forme d'un tableau*/
                if (!locations || !Array.isArray(locations)) {
                  console.log("no locations in response ?");
                  return;
                }
          
                /* On parcourt les résultats pour les afficher sur la carte */
                for (var i = 0; i < locations.length; i++) {
                  // ajouter des véfications...
                  /* on crée un marker pour chaque réponse, avec une popup */
                  let feature = locations[i];
                  let properties = feature.properties;
                  
                  let freeform;
                  if (properties._type === "address") {
                    freeform = (properties.number || "") + " " + (properties.street || "") + ", " + (properties.postalCode || "") + " " + (properties.city || "");
                  } else {
                    freeform = properties.toponyme
                  }
                  locations1.push(locations[i])
                
                }
                if (locations.length === 1){
                
                  fromFeature.setId('from');
                  fromFeature.setStyle(
                    new ol.style.Style({
                      image: new ol.style.Icon({
                        src: 'img/widget/directions/map_small_1.png',
                      }),
                    })
                  );
                startcoords = locations[0].geometry.coordinates;
                placeDirectionMarker('from', coordinatesToLatLngForAddress(startcoords, m.getView().getProjection().nb))
                };
                return locations
            });
          } 

          fetch(
            new_url2, {
              method: 'GET',
              mode: 'cors',
              cache: 'default'
            }
          ).then(response => {
               // reponse en json
               console.log("reponse du nouveau geocodeur : ",response)
               return response.json();
           })
           .then(response => {
              results.new.response = response;
              var locations = response.features;
              var locations1 = [];
        
              /* on vérifie qu'on a bien des locations, sous forme d'un tableau*/
              if (!locations || !Array.isArray(locations)) {
                console.log("no locations in response ?");
                return;
              }
        
              /* On parcourt les résultats pour les afficher sur la carte */
              for (var i = 0; i < locations.length; i++) {
                // ajouter des véfications...
                /* on crée un marker pour chaque réponse, avec une popup */
                let feature = locations[i];
                let properties = feature.properties;
                
                let freeform;
                if (properties._type === "address") {
                  freeform = (properties.number || "") + " " + (properties.street || "") + ", " + (properties.postalCode || "") + " " + (properties.city || "");
                } else {
                  freeform = properties.toponyme
                }
                locations1.push(locations[i])
              
              }
              if (locations.length === 1){
                toFeature.setId('to');
                toFeature.setStyle(
                  new ol.style.Style({
                    image: new ol.style.Icon({
                      src: 'img/widget/directions/map_small_2.png',
                    }),
                  })
                );
                endcoords = locations[0].geometry.coordinates;

                placeDirectionMarker('to', coordinatesToLatLngForAddress(endcoords, m.getView().getProjection().nb))
              }

              /* ... are added to the fromToLayer */
              ;
              return locations
             
           });

           if (fromFeature.getGeometry() && toFeature.getGeometry()) {
              if (fromFeature.getGeometry().getCoordinates().length == 2 && toFeature.getGeometry().getCoordinates().length == 2) {
                computeRoad(startcoords,endcoords)
              }
           }
          
        
        };
        var start = [];
        var end = [];

        /* User clicking on the map */
        m.on('singleclick', function(evt) {
          if (!isActive) {
            return;
          } 
          /* If the initial position is not placed */
          if (isActive) {
            if (!fromLayer) {
              start = [];
              fromFeature.setId('from');
              fromFeature.setStyle(
                new ol.style.Style({
                  image: new ol.style.Icon({
                    src: 'img/widget/directions/map_small_1.png',
                  }),
                })
              );  
              start = evt.coordinate;
              placeDirectionMarker('from', start)
                var fakefrom = new ol.Feature({
                  geometry: new ol.geom.Point(start)
                  
              })
              const style1 = new ol.style.Style({
                image: new ol.style.Icon({
                  src: 'img/widget/directions/map_small_1.png',
                }),
              }) 

              fakefrom.setStyle(style1)

              from = new ol.layer.Vector({
                source: new ol.source.Vector({
                    features: [
                      fakefrom
                    ]
                })
            });

           
            m.addLayer(from);
              /* User placed the end layer, draw the direction */
            } else if (!toLayer && fromLayer) {

              toFeature.setId('to');
              toFeature.setStyle(
                new ol.style.Style({
                  image: new ol.style.Icon({
                    src: 'img/widget/directions/map_small_2.png',
                  }),
                })
              );
              
              end = evt.coordinate
              //toFeature.setGeometry(new ol.geom.Point(end))
               placeDirectionMarker('to',end)

               var faketo = new ol.Feature({
                geometry: new ol.geom.Point(end)
                
                })
                const style = new ol.style.Style({
                  image: new ol.style.Icon({
                    src: 'img/widget/directions/map_small_2.png',
                  }),
                }) 

                faketo.setStyle(style)

                to = new ol.layer.Vector({
                  source: new ol.source.Vector({
                      features: [
                        faketo
                      ]
                  })
              });

         
              m.addLayer(to);

              if (scope.choosenkey == 'google'){
                computeRoad(GoogleMapsFactory.coordinatesToLatLng(start,  m.getView().getProjection()),GoogleMapsFactory.coordinatesToLatLng(end,  m.getView().getProjection()))
              } else {
                computeRoad(coordinatesToLatLng(start,m.getView().getProjection().nb),coordinatesToLatLng(end,m.getView().getProjection().nb))
              }
            }
          }
      
        });

        // FORCE MARSEILLE
        //m.getView().fit([601639.0140164259, 5353630.833164874, 605078.680289259, 5355888.114156421], m.getSize());
        //m.getView().setZoom(9);
      },
    };
  };

  toolbardirections.$inject = [
    '$compile',
    '$http',
    '$sce',
    '$rootScope',
    'GoogleMapsFactory',
  ];
  return toolbardirections;
});
