'use strict';
define([
  'angular',
  'widgets/mapapp/dict/directives/dictWidget',
  'widgets/mapapp/dict/directives/commonPrintWidget',
  'widgets/mapapp/dict/services/DICTFactory',
  'widgets/mapapp/dict/services/PrintFactory',
], function(angular, dictwidget, commonPrintWidget, DICTFactory, PrintFactory) {
  // generation du module
  var gcDictWidget = angular.module('gc_dictwidget', [
    'pascalprecht.translate',
    'xeditable',
  ]);

  gcDictWidget.run([
    'editableOptions',
    function(editableOptions) {
      editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
    },
  ]);

  // ajout service
  gcDictWidget.factory('DICTFactory', DICTFactory);
  gcDictWidget.factory('PrintFactory', PrintFactory);

  // ajout directive
  gcDictWidget.directive('dictwidgetdirective', dictwidget);

  // ajout directive
  gcDictWidget.directive('comPrintWidget', commonPrintWidget);

  return gcDictWidget;
});
