'use strict';
define(function() {
  var IndicatorParamsFactory = function(ParametersFactory, $q) {
    var IndicatorParamsFactory = {};

    /**
     * Construit un objet json des paramètres de l'indicateur et de leur valeur.
     * @returns json object containing param names and param value
     */
    function buildJsonParams(parameters) {
      var jsondata = {};
      if (parameters !== undefined) {
        for (let i = 0; i < parameters.length; ++i) {
          if (parameters[i].value !== undefined) {
            if (
              parameters[i].type === 'date' &&
              typeof parameters[i].value === 'object'
            ) {
              //parameters[i].value est alors un objet Date, il suffit de le transformer en string,
              const dateValue = parameters[i].value.getTime();
              jsondata[parameters[i].name] = String(dateValue);
            } else {
              jsondata[parameters[i].name] = String(parameters[i].value);
            }
          }
        }
      }
      return jsondata;
    }

    function buildDataParameters(indicator, jsonParameters) {
      const dataParams = {};
      dataParams.type = 'indicator';
      dataParams.name = indicator.id;
      dataParams.data = jsonParameters;
      dataParams.description = String(indicator.totalPages);
      dataParams.state = 'public';
      return '' + JSON.stringify(dataParams);
    }

    /**
     * Add the indicator's parameters
     * @param indicator
     * @param {type} jsonParameters
     * @returns {Promise}
     */
    function addIndicatorParameters(indicator, jsonParameters) {
      const dataParams = buildDataParameters(indicator, jsonParameters);
      const deferred = $q.defer();

      //-- Vérifie si un paramètre avec le même nom et le même type existe déjà
      //-- -1- Recherche des paramètres du type "indicator"
      ParametersFactory.getbytype('indicator').then(function(res) {
        //- -2- Recherche du paramètre de type "indicator" ayant pour nom indicator.id
        for (var ind = 0; ind < res.data.length; ind++)
          if (res.data[ind].name === indicator.id) {
            //-- L'indicateur est trouvé, on le met à jour
            ParametersFactory.update(dataParams, res.data[ind].id).then(
              function(res) {
                deferred.resolve(res);
              }
            );
            break;
          }
        //-- Le paramètre n'est pas pré-existant: on l'ajoute
        if (ind === res.data.length){
          ParametersFactory.add(dataParams, 'indicator', indicator.id).then(
              function(res) {
                deferred.resolve(res);
              }
          );
        }
      });
      return deferred.promise;
    }

    /**
     * Update the indicator's parameters
     * @param indicator
     * @param {type} jsonParameters
     * @returns {Promise}
     */
    function updateIndicatorParameters(indicator, jsonParameters) {
      const dataParams = buildDataParameters(indicator, jsonParameters);
      return ParametersFactory.update(dataParams, indicator.identifier);
    }

    /**
     * Get the indicator's parameters
     * @param indicator
     * @returns {Promise}
     */
    function getIndicatorParametersByName(indicator) {
      return ParametersFactory.getbyname(indicator.id);
    }

    return {
      IndicatorParamsFactory: IndicatorParamsFactory,
      buildJsonParams: buildJsonParams,
      addIndicatorParameters: addIndicatorParameters,
      updateIndicatorParameters: updateIndicatorParameters,
      getIndicatorParametersByName: getIndicatorParametersByName,
    };
  };

  IndicatorParamsFactory.$inject = ['ParametersFactory', '$q'];
  return IndicatorParamsFactory;
});
