'use strict';
define(function() {
  /**
   * CSV GEOCODER
   */
  var csvgeocoder = function(
    kisGeocodageFactory,
    ConfigFactory,
    extendedNgDialog,
    $rootScope,
    gaDomUtils,
    $timeout,
    EditFactory,
    $filter,
    gclayers,
    FeatureTypeFactory,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/csvgeocoder/views/csvgeocoderwidget.html',
      restrict: 'EA',
      link: function(scope) {
        scope.csvConfig = {};
        scope.tmpCsvConfig = {};
        scope.steps = {
          current: 0,
        };

        var reader = new FileReader(),
          file,
          container,
          blob,
          parsed,
          parsedFeaturesLayer = gclayers.getImportLayer();

        /**
         * retrieve overlay from gcmap
         */
        var overlay;
        var getOverlay = function() {
          for (
            var i = scope.map.getOverlays().getLength() - 1;
            i >= 0;
            i -= 1
          ) {
            var ov = scope.map.getOverlays().getArray()[i];
            if (ov.get('origin') == 'bubble') {
              overlay = ov;
            }
          }
        };

        /**
         * setCsvTmpPopupContent
         * @param properties
         */
        var setCsvTmpPopupContent = function(properties) {
          document.getElementById('popup-content').innerHTML =
            '<table class="table table-bordered">' +
            '<tr>' +
            '<td> ' +
            $filter('translate')('csvgeocoder.popup.hit') +
            ' </td>' +
            '<td>' +
            properties.result_label +
            '</td>' +
            '</tr><tr>' +
            '<td> ' +
            $filter('translate')('csvgeocoder.popup.precision') +
            ' </td>' +
            '<td>' +
            properties.result_score +
            '</td>' +
            '</tr>' +
            '</table>';
        };

        // selection de feature temporaire
        var selectTmpFeature = new ol.interaction.Select({
          layers: [parsedFeaturesLayer],
        });
        selectTmpFeature.set('gctype', 'kis');
        selectTmpFeature.set('interaction', 'Select');
        selectTmpFeature.set('widget', 'Edition');

        var mouseCursor = new ol.interaction.Select({
          condition: ol.events.condition.pointerMove,
          layers: [parsedFeaturesLayer],
        });
        mouseCursor.set('gctype', 'kis');
        mouseCursor.set('interaction', 'Select');
        mouseCursor.set('widget', 'Edition');

        selectTmpFeature.on('select', function(e) {
          if (e.target.getFeatures().getLength() > 0) {
            var ft = e.target.getFeatures().getArray()[0];
            var properties = ft.getProperties()['geocode_data'];
            var coordinate = ft.getGeometry().getCoordinates();

            getOverlay();
            setCsvTmpPopupContent(properties);
            overlay.setPosition(coordinate);
          } else {
            //  console.log('noe');
          }
        });
        var mapdiv = angular
            .element(document)
            .find('#map')
            .eq(0),
          isHit = false;
        mouseCursor.on('select', function(e) {
          if (e.target.getFeatures().getLength() > 0) {
            mapdiv.addClass('hoverFeatureHelpCursor');
            isHit = true;
          } else if (isHit) {
            isHit = false;
            console.log('da');
            mapdiv.removeClass('hoverFeatureHelpCursor');
          }
        });

        /**
         * getDefaultAdresseStyle
         * @param color
         * @returns {ol.style.Style}
         */
        var getDefaultAdresseStyle = function(color) {
          return new ol.style.Style({
            image: new ol.style.Circle({
              radius: 8,
              fill: new ol.style.Fill({
                color: color,
              }),
            }),
          });
        };

        /**
         * resetAll
         */
        scope.resetAll = function() {
          scope.toImportFields = 0;
          scope.importCfg = {};
          scope.columnsForAddress = {};
          scope.geocodeResultsTranches = [
            {
              min: 0,
              max: 25,
              color: '#E67E22',
              nb: 0,
              import: false,
              visible: false,
            },
            {
              min: 25,
              max: 50,
              color: '#B89236',
              nb: 0,
              import: false,
              visible: false,
            },
            {
              min: 50,
              max: 80,
              color: '#8AA54A',
              nb: 0,
              import: false,
              visible: false,
            },
            {
              min: 80,
              max: 90,
              color: '#5CB95D',
              nb: 0,
              import: false,
              visible: false,
            },
            {
              min: 90,
              max: 100,
              color: '#2ECC71',
              nb: 0,
              import: false,
              visible: false,
            },
          ];
        };
        scope.resetAll();
        //   scope.map.addLayer(parsedFeaturesLayer);

        /**
         *  try and load the cfg for configfactory
         */
        ConfigFactory.get('csvgeocoder', scope.ConfigName).then(function(res) {
          if (angular.isDefined(res.data.geocoder)) {
            scope.csvConfig = res.data;
            scope.tmpCsvConfig = res.data;
          }
        });

        /**
         * Open the config menu
         */
        var cfgDialog;
        scope.openCsvGeocoderConfig = function() {
          if (cfgDialog) return;

          scope.geocoders = $rootScope.xgos.portal.parameters.kisgeocodage;

          cfgDialog = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/csvgeocoder/views/modals/modal.csvgeocoder.config.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: $filter('translate')('csvgeocoder.configuration_title'),
          });
          cfgDialog.closePromise.then(function(data) {
            cfgDialog = false;
          });
        };
        /**
         * Save the config
         */
        scope.saveCsvGeocoderConfig = function() {
          ConfigFactory.add(
            scope.tmpCsvConfig,
            'csvgeocoder',
            scope.ConfigName
          ).then(function(res) {
            require('toastr').success('Configuration sauvée');
            scope.csvConfig = angular.copy(scope.tmpCsvConfig);
            cfgDialog.close();
          });
        };

        /**
         * downloadFileName
         * set file to download name
         * @returns {string}
         */
        var downloadFileName = function() {
          var name = file.name || 'file';
          if (name.indexOf('.csv', name.length - 4) !== -1)
            name = name.slice(0, name.length - 4);
          return name + '.geocoded.csv';
        };

        var getTmpFeatureColor = function(infos) {
          var color,
            score = parseFloat(infos.result_score) * 100;

          for (var idx in scope.geocodeResultsTranches) {
            var tranche = scope.geocodeResultsTranches[idx];
            if (score > tranche.min && score <= tranche.max) {
              tranche.nb += 1;
              tranche.import = true;
              tranche.visible = true;
              color = tranche.color;
              break;
            }
          }

          return color;
        };

        /**
         * doPostCSV
         * post the csv to the geocoder
         * @returns {boolean}
         */
        scope.doPostCSV = function() {
          scope.map.removeInteraction(selectTmpFeature);
          scope.map.removeInteraction(mouseCursor);
          // allow feature selection
          scope.map.addInteraction(selectTmpFeature);
          scope.map.addInteraction(mouseCursor);

          var geoCoderCfg = kisGeocodageFactory.getGeocoderConfigFromId(
            scope.csvConfig.geocoder
          );

          var xhr = new XMLHttpRequest();
          xhr.open('POST', geoCoderCfg.url + '/search/csv/');
          xhr.overrideMimeType('text/csv');
          // var columns = document.querySelectorAll('#chosenColumns li');
          var formData = new FormData();

          for (var i in scope.columnsForAddress) {
            if (scope.columnsForAddress[i]) {
              formData.append('columns', i);
            }
          }
          formData.append('data', blob, file.name);
          formData.append('encoding', 'utf-8');
          formData.append('delimiter', scope.csvData.meta.delimiter);
          //  if (options.onSubmit) options.onSubmit({form: formData});

          //gaDomUtils.showGlobalLoader();
          //parsedFeaturesLayer.getSource().clear();

          xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
              // progressBar.parentNode.removeChild(progressBar);
              if (xhr.status === 200) {
                window.URL = window.URL || window.webkitURL;

                var responseText = xhr.responseText;

                scope.parsedObjects = Papa.parse(responseText, {
                  header: true,
                });
                console.log(scope.parsedObjects);

                var url = window.URL.createObjectURL(
                  new Blob(['\ufeff', responseText], {
                    type: 'text/csv; charset=utf-8',
                  })
                );
                var download = document.getElementById('downloador');
                download.href = url;
                download.download = downloadFileName();

                var coords,
                  nbFeatures = 0;
                if (
                  scope.parsedObjects.data &&
                  scope.parsedObjects.data.length
                ) {
                  scope.parsedObjects.data.forEach(function(add) {
                    if (add.longitude && add.latitude) {
                      coords = ol.proj.transform(
                        [parseFloat(add.longitude), parseFloat(add.latitude)],
                        'EPSG:4326',
                        scope.map.getView().getProjection()
                      );

                      var ft = new ol.Feature({
                        geometry: new ol.geom.Point(coords),
                      });

                      var color = getTmpFeatureColor(add);
                      ft.setProperties({
                        geocode_data: add,
                        score_color: color,
                        import: true,
                      });
                      ft.setStyle(getDefaultAdresseStyle(color));

                      if (
                        !(parsedFeaturesLayer instanceof ol.layer.Vector) &&
                        gclayers.getImportLayer() instanceof ol.layer.Vector
                      )
                        parsedFeaturesLayer = gclayers.getImportLayer();
                      parsedFeaturesLayer.getSource().addFeature(ft);
                      nbFeatures++;
                    }
                  });
                }

                scope.totalValidPoints = nbFeatures;
                scope.visblePointsNumber = nbFeatures;
                scope.toImportPointsNumber = nbFeatures;

                /*scope.map.beforeRender(ol.animation.pan({
                                        duration: 1000,
                                        source:  (scope.map.getView().getCenter())
                                    }),
                                    ol.animation.zoom({
                                        resolution: scope.map.getView().getResolution()
                                }));*/
                var pan = {
                  duration: 1000,
                  source: scope.map.getView().getCenter(),
                };
                var zoom = {
                  resolution: scope.map.getView().getResolution(),
                };
                scope.map.getView().animate(pan, zoom);

                scope.map
                  .getView()
                  .fit(
                    parsedFeaturesLayer.getSource().getExtent(),
                    scope.map.getSize()
                  );

                $timeout(function() {
                  gaDomUtils.hideGlobalLoader();
                  scope.steps.current = 2;
                });
              } else {
                require('toastr').error(
                  $filter('translate')('csvgeocoder.upload_error')
                );
                gaDomUtils.hideGlobalLoader();
              }
            }
          };

          xhr.send(formData);
          return false;
        };

        /**
         * download the csv file
         */
        scope.getFile = function() {
          download.click();
        };

        /**
         * setPointsImportAndVisibility
         */
        scope.setPointsImportAndVisibility = function() {
          $timeout(function() {
            scope.visblePointsNumber = 0;
            scope.toImportPointsNumber = 0;

            parsedFeaturesLayer.getSource().forEachFeature(function(feature) {
              var geocode_data = feature.getProperties()['geocode_data'];
              var score_color = feature.getProperties()['score_color'];
              var score = parseFloat(geocode_data.result_score) * 100;

              var visible = false;
              var toimport = false;

              // visibility
              for (var i in scope.geocodeResultsTranches) {
                var t = scope.geocodeResultsTranches[i];
                if (t.visible && score > t.min && score <= t.max) {
                  visible = true;
                  scope.visblePointsNumber++;
                  break;
                }
              }

              if (visible) {
                feature.setStyle(getDefaultAdresseStyle(score_color));
              } else {
                feature.setStyle(
                  new ol.style.Style({
                    image: new ol.style.Circle({
                      radius: 0,
                    }),
                  })
                );
              }

              // import
              for (var i in scope.geocodeResultsTranches) {
                var t = scope.geocodeResultsTranches[i];
                if (t.import && score > t.min && score <= t.max) {
                  toimport = true;
                  scope.toImportPointsNumber++;
                  break;
                }
              }

              // set import flag
              var props = feature.getProperties();
              props.import = toimport;
              feature.setProperties(props);
            });
          });
        };

        var Papa = require('papaparse');

        /**
         * loadCsvFile
         * @param input
         */
        scope.loadCsvFile = function(input) {
          scope.resetAll();
          file = input.files[0];

          // csv only
          if (!~file.name.indexOf('.csv')) {
            require('toastr').error(
              $filter('translate')('csvgeocoder.csv_only')
            );
            return;
          }
          if (file.size >= 5000000) {
            require('toastr').error(
              $filter('translate')('csvgeocoder.file_too_heavy')
            );
            return;
          }

          reader.readAsText(file, 'utf-8');

          reader.onload = function(e) {
            try {
              scope.$apply(function() {
                blob = new Blob([reader.result], {
                  type: 'text/csv; charset=utf-8',
                });
                scope.currentFileName = file.name;
                // errors
                // no lines
                // no header
  
                scope.csvData = Papa.parse(reader.result, {
                  header: true,
                });
                scope.extractData = angular.copy(scope.csvData.data).slice(0, 5);
  
                scope.steps.current = 1;
              });
            } catch(err) {}
          };
        };

        /**********************
         * Import -> feature
         ***********************/

        var liaisonsModal;
        scope.configureImport = function() {
          scope.geocodeSources = angular.copy(scope.parsedObjects.meta.fields);
          console.log(scope.geocodeSources);

          liaisonsModal = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/csvgeocoder/views/modals/modal.csvgeocoder.import.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('csvgeocoder.import_title'),
            draggable: true,
          });
        };
        /* close cfg modal */
        scope.submitGeocodeLiaison = function() {
          $timeout(function() {
            scope.toImportFields = Object.keys(scope.importCfg.liaisons).length;
            liaisonsModal.close();
          });
        };

        /**
         * Geocoded -> feature insert
         */
        scope.importGeocodedFeatures = function() {
          // list -> featureCollection
          var featureCollection = {};
          featureCollection.type = 'FeatureCollection';
          featureCollection.features = [];

          var featureInfo = FeatureTypeFactory.getFeatureByUid(
            scope.importCfg.ftid
          );

          parsedFeaturesLayer.getSource().forEachFeature(function(tmpFeature) {
            var format = new ol.format.GeoJSON();
            var feature = format.writeFeatureObject(
              new ol.Feature({
                geometry: tmpFeature.getGeometry(),
                properties: {},
              })
            );

            for (var i in scope.importCfg.liaisons) {
              for (var z = 0; z < featureInfo.attributes.length; z++) {
                if (
                  scope.importCfg.liaisons[i] == featureInfo.attributes[z].name
                ) {
                  feature.properties[
                    scope.importCfg.liaisons[i]
                  ] = gaJsUtils.castAttributeValueType(
                    tmpFeature.getProperties()['geocode_data'][i],
                    featureInfo.attributes[z].type,
                    'java.lang.String'
                  );
                }
              }
            }

            if (feature.properties.properties) {
              delete feature.properties.properties;
            }

            if (tmpFeature.getProperties()['import']) {
              featureCollection.features.push(feature);
            }
          });

          var ans = confirm($filter('translate')('csvgeocoder.confirm_import'));
          if (ans) {
            scope.map.removeInteraction(selectTmpFeature);
            scope.map.removeInteraction(mouseCursor);
            gaDomUtils.showGlobalLoader();

            EditFactory.add(
              scope.importCfg.ftid,
              featureCollection,
              scope.map.getView().getProjection().getCode()
            ).then(
              function(res) {
                console.log(res.data);
                scope.createdData = res.data.create.map(function(x) {
                  return x.id;
                });

                scope.steps.current = 3;
                gaDomUtils.hideGlobalLoader();
                // clear source
                parsedFeaturesLayer.getSource().clear();
                // reset layer importCfg.ftid
                $rootScope.$broadcast(
                  'gcOperationalLayerChange',
                  '',
                  'applyall'
                );
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /**
         * cancel the import and clear the map
         * annulerPreviewImport
         */
        scope.annulerPreviewImport = function() {
          scope.map.removeInteraction(selectTmpFeature);
          scope.map.removeInteraction(mouseCursor);
          parsedFeaturesLayer.getSource().clear();
          scope.steps.current = 0;
        };
      },
    };
  };
  csvgeocoder.$inject = [
    'kisGeocodageFactory',
    'ConfigFactory',
    'extendedNgDialog',
    '$rootScope',
    'gaDomUtils',
    '$timeout',
    'EditFactory',
    '$filter',
    'gclayers',
    'FeatureTypeFactory',
    'gaJsUtils',
  ];
  return csvgeocoder;
});
