'use strict';
define(function() {
  var basemapwidget = function(
    gclayers,
    EditFactory,
    gcPopup,
    ngDialog,
    ConfigFactory,
    FeatureTypeFactory,
    $timeout,
    $filter,
    ObjectFilesFactory
  ) {
    const GEOJSON_PARSER = new ol.format.GeoJSON();
    return {
      templateUrl:
        'js/XG/widgets/mapapp/cotationedition/views/cotationeditwidget.html',

      restrict: 'A',

      link: function(scope, elt, attrs, ctrl) {
        scope.editmode = ''; // UPDATE
        scope.ftis = {};
        scope.features = [];

        scope.editedfeatures = {};

        scope.tutu = {};
        scope.templatefeature = {
          type: 'Feature',
          geometry: {},
          properties: {},
        };

        scope.store = {
          lastrad: 0,
        };

        if (FeatureTypeFactory.resources.featuretypes.length > 0) {
          scope.layers = FeatureTypeFactory.resources.featuretypes;
        } else {
          FeatureTypeFactory.get().then(function() {
            scope.layers = FeatureTypeFactory.resources.featuretypes;
          });
        }

        scope.editableLayers = [];

        ////////////////////////////////////////////////////////////////////
        //
        // Gestion de la configuration du widget
        //
        ////////////////////////////////////////////////////////////////////
        scope.config = {};
        scope.config.layers = [];

        function initWidgetFromConfig() {
          scope.editableLayers.splice(0);
          var editLayers = [];

          for (var i = 0; i < scope.config.layers.length; i++) {
            if (scope.config.layers[i].selected) {
              editLayers.push(scope.config.layers[i]);
            }
          }

          scope.editableLayers = editLayers;
          console.log(scope.editableLayers);
        }

        /**
         * Récupèration de la configuration.
         * @returns {undefined}
         */
        scope.getConfig = function() {
          ConfigFactory.get('widgets', scope.ConfigName).then(
            function(res) {
              if (res.data !== '' && res.status == 200 && res.data.layers) {
                scope.config = res.data;
              } else {
                angular.forEach(scope.layers, function(f, index) {
                  if (f.name.toLowerCase().indexOf('cotation') != -1)
                    scope.config.layers.push({
                      uid: f.uid,
                      name: f.name,
                      selected: false,
                    });
                });
              }
              initWidgetFromConfig();
              console.info('Configuration de cotationeditwidget chargée.');
            },
            function(reason) {
              console.error(
                'Configuration de bizeditwidget non chargée: ' + reason
              );
            }
          );
        };
        scope.getConfig();

        /**
         * Ouvre l'IHM de la configuration et permet de la modifer.
         * @returns {undefined}
         */
        var ngDialogPromise;
        scope.openConfig = function() {
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/mapapp/cotationedition/views/configuration.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            scope: scope,
          });
          ngDialogPromise.then(
            function(data) {
              scope.saveconfig();
              require('toastr').info(data);
            },
            function(data) {
              scope.getConfig();
              require('toastr').info(data);
            }
          );
        };

        scope.isAllCheckedBox = {
          value: false,
        };
        scope.onConfigLayersCheckAll = function() {
          angular.forEach(scope.config.layers, function(l, index) {
            l.selected = scope.isAllCheckedBox.value;
          });
        };

        /**
         * Sauve dans le fichier de configuration, la configuration presente dans le scope courant.
         * @returns {undefined}
         */
        scope.saveconfig = function() {
          console.log(scope.ConfigName);
          ConfigFactory.add(scope.config, 'widgets', scope.ConfigName).then(
            function(res) {
              require('toastr').success(res.data);
              initWidgetFromConfig();
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
        };

        //Mise en évidence sur la carte de l'objet édité.
        scope.highLightFeature = function(f) {
          gclayers.addhighLightFeature(f);
          //ADD Timeout sur scope.removehighLightFeature si probleme pour retirer le highLight
        };
        scope.removehighLightFeature = function(f) {
          gclayers.removehighLightFeatures(f);
          //gclayers.clearhighLightFeatures();
        };
        scope.canceldeletefor = function(index, f) {
          gclayers.removehighLightFeatures(f);
          scope.remresult.modelfeatures.splice(index, 1);
        };

        scope.canceladdfor = function(index, f) {
          gclayers.removehighLightFeatures(f);
          gclayers.getimportsource().removeFeature(f);
          scope.remresult.modelfeatures.splice(index, 1);
        };

        scope.remresult = {
          todelfeatures: null,
          modelfeatures: null,
          isremoveactive: false,
          isaddactive: false,
        };

        function updateModelFeatures(newvalue, oldvalue, scope) {
          if (
            scope.remresult.todelfeatures &&
            scope.remresult.todelfeatures.totalFeatures > 0
          ) {
            if (scope.remresult.modelfeatures == null)
              scope.remresult.modelfeatures = [];

            var feats = GEOJSON_PARSER.readFeatures(
              scope.remresult.todelfeatures
            );
            for (var index in feats) {
              var feat = feats[index];
              scope.remresult.modelfeatures.push({
                editType: 'delete',
                id: feat.getId(),
                feat: feat,
              });
            }
          }
        }

        scope.$watch('remresult.todelfeatures', updateModelFeatures);

        function handleDeleteMode(newvalue, oldvalue, scope) {
          if (newvalue != oldvalue && newvalue == true) {
            scope.map.getInteractions().forEach(function(interaction) {
              if (interaction instanceof ol.interaction.Draw) {
                scope.map.removeInteraction(interaction);
              }
              /*if (interaction instanceof ol.interaction.DragPan) {
							 dragPan = interaction;
							 }*/
            });
            scope.result = angular.copy(scope.templatefeature);
            //scope.features=[];
            if (scope.editmode == 'DELETE') {
              scope.editmode = '';
              gclayers.clearEditLayer();
            } else {
              scope.editmode = 'DELETE';
              gclayers.clearEditLayer();
            }

            console.log('Mode Delete');
            scope.remresult.isaddactive = false;
          }
        }

        function handleAddMode(newvalue, oldvalue, scope) {
          if (newvalue != oldvalue && newvalue == true) {
            scope.map.getInteractions().forEach(function(interaction) {
              if (interaction instanceof ol.interaction.DragBox) {
                scope.map.removeInteraction(interaction);
              }
              /*if (interaction instanceof ol.interaction.DragPan) {
							 dragPan = interaction;
							 }*/
            });
            scope.result = angular.copy(scope.templatefeature);
            scope.features = [];
            if (scope.editmode == 'ADD') {
              scope.editmode = '';

              gclayers.clearEditLayer();
            } else if (scope.editmode == 'UPDATE') {
              scope.editmode = 'ADD';
              gclayers.clearEditLayer();
            } else {
              scope.editmode = 'ADD';
              gclayers.clearEditLayer();
            }
            console.log('Mode ADD');
            scope.remresult.isremoveactive = false;
          }
        }

        scope.$watch('remresult.isremoveactive', handleDeleteMode);

        scope.$watch('remresult.isaddactive', handleAddMode);

        scope.result = angular.copy(scope.templatefeature);
        scope.addmode = function() {
          scope.map.getInteractions().forEach(function(interaction) {
            if (interaction instanceof ol.interaction.DragBox) {
              scope.map.removeInteraction(interaction);
            }
            /*if (interaction instanceof ol.interaction.DragPan) {
						 dragPan = interaction;
						 }*/
          });
          scope.result = angular.copy(scope.templatefeature);
          scope.features = [];
          if (scope.editmode == 'ADD') {
            scope.editmode = '';

            gclayers.clearEditLayer();
          } else if (scope.editmode == 'UPDATE') {
            scope.editmode = 'ADD';
            gclayers.clearEditLayer();
          } else {
            scope.editmode = 'ADD';
            gclayers.clearEditLayer();
          }
          console.log('Mode ADD');
          //console.log(scope.map.getInteractions());
        };

        scope.uploadfile = {};
        scope.openpopupattribute = function() {
          scope.configurationTab = false;
          ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
            scope.selectfti.uid).then(res =>{
              if (typeof res === 'object' && res != null && res.active) {
                scope.configurationTab = res;
              }
          }).finally(() => {

            // KIS-2987: la configuration de la fiche-objet contient la largeur initiale de la popup
            // => affiche la popup après la récupération de la configuration de la fiche-objet.
            let hasTabs = false;
            let popupWidth = null;
            if (typeof scope.configurationTab !== 'boolean' && Array.isArray(scope.configurationTab.configuration)
                && scope.configurationTab.configuration.length > 0) {
              hasTabs = true;
              const firstConf = scope.configurationTab.configuration[0];
              if (firstConf.popupWidth > 0 && firstConf.popupWidth < window.innerWidth) {
                popupWidth = firstConf.popupWidth;
              }
            }

            // affecte une classe particulière à la gcPopup en présence d'une fiche-objet
            scope.p = gcPopup.open({
              scope: scope,
              title: $filter('translate')('edition.popup_title'),
              template:
                  'js/XG/widgets/mapapp/cotationedition/views/attribute_popup.html',
              showClose: true,
              minimizeMaximize: true,
              resizable: true,
              minWidth: hasTabs ? 430 : 400,
              minHeight: 300,
              width: popupWidth,
              className: hasTabs ? ' objectFilePopup' : ' nomaximize'
            });

            // Ajustement de la hauteur du tab-content dans le cas de plusieurs lignes d'onglets
            if (hasTabs) {

              // sélecteur de la règle CSS que l'on va modifier
              // on ne peut pas modifier directement le style de l'élement HTML car il est modifiable par le redimensionnement vertical
              const cssRuleIdentifier = '.gcPopup.objectFilePopup .popup-template .bizAttPopupMainDiv .scrolledTabs .tab-content';
              bizeditProvider.adjustObjectFileTabContentHeight(scope.p.popup.iddiv, cssRuleIdentifier,'scrolledTabs', 3);
            }
          });
        };

        scope.markfeaturesforremove = function() {
          console.log(scope.remresult.todelfeatures);
        };

        scope.update = function(fe) {
          console.log('update saving' + fe);
        };

        function handleApplyEditsRes(res) {
          if (res.data.create.length > 0 || res.data.delete.length > 0) {
            require('toastr').success('ok');

            gclayers.refreshlayerByid(scope.selectfti.uid, scope.map);
          }

          scope.clearall();

          //scope.removefeatures();
          //gclayers.refreshlayerByid(scope.fti.uid);
        }
        scope.savecotationsedits = function() {
          var addfeatures = {
            type: 'FeatureCollection',
            features: [],
          };

          var idsToDelete = [];
          for (var index in scope.remresult.modelfeatures) {
            var editDesc = scope.remresult.modelfeatures[index];
            if (editDesc.editType == 'add')
              addfeatures.features.push(editDesc.basefeat);
            else idsToDelete.push(editDesc.id);
          }

          var idsToDeleteStr = idsToDelete.join();

          var srid = scope.map
            ? scope.map
                .getView()
                .getProjection()
                .getCode()
            : '';

          EditFactory.applyedits(
            scope.selectfti.uid,
            idsToDeleteStr,
            addfeatures,
            srid
          ).then(handleApplyEditsRes);
        };

        scope.clearall = function() {
          console.log('eng saving');
          gclayers.clearEditLayer();
          gclayers.getimportsource().clear();
          scope.uploadfile = {};
          scope.features = [];
          scope.editmode = '';
          scope.remresult.isremoveactive = false;
          scope.remresult.isaddactive = false;
          scope.remresult.modelfeatures = [];
        };
        scope.validFeatures = function() {
          scope.result['fti'] = scope.selectfti.uid;
          var copiedRes = angular.copy(scope.result);
          copiedRes.properties.dimlength = scope.store.lastrad;
          scope.features.push(copiedRes);
          scope.result = angular.copy(scope.templatefeature);

          if (scope.remresult.modelfeatures == null)
            scope.remresult.modelfeatures = [];

          var feat = GEOJSON_PARSER.readFeature(copiedRes);

          gclayers.getimportsource().addFeature(feat);
          scope.remresult.modelfeatures.push({
            editType: 'add',
            id: scope.selectfti.name + '.NEW',
            feat: feat,
            basefeat: copiedRes,
          });

          scope.p.destroy();
        };
        scope.resetFeatures = function() {
          //scope.features.push(angular.copy(scope.result));
          scope.result = angular.copy(scope.templatefeature);
        };
        scope.openmodalpopup = function() {
          console.log(scope.attributefti);
        };

        //Reinitialisation si fermeture du widget
        scope.$on('closeTools_cotationeditwidget', function(e, arg) {
          if (arg.directive === 'cotationeditwidget') {
            scope.clearall();
            $timeout(function() {
              scope.$root.$digest();
            });
          }
        });
      },
    };
  };

  basemapwidget.$inject = [
    'gclayers',
    'EditFactory',
    'gcPopup',
    'ngDialog',
    'ConfigFactory',
    'FeatureTypeFactory',
    '$timeout',
    '$filter',
    'ObjectFilesFactory'
  ];
  return basemapwidget;
});
