'use strict';
define(function () {
  var BizTopologyFactory = function ($http, $location) {
    var BizTopologyFactory = {};
    /**
     * Class : BizTopologyFactory
     * Factory WebServices
     **/

    function checkRule(senddata, configname, metier, srid, filter) {
      let promise;
      if (filter) {
        promise = $http.post(
          '/services/{portalid}/business/checkrule?f=json'
          +  '&appname=' + $location.search().app
          + '&configname=' + configname + '&metier=' + metier
          + '&srid=' + srid + '&filter=' + filter, senddata
        );
      } else {
        promise = $http.post(
          '/services/{portalid}/business/checkrule?f=json' +
            '&appname=' +
            localStorage.getItem('app') +
            '&configname=' +
            configname + '&srid=' + srid +
            '&metier=' +
            metier,
          senddata
        );
      }

      return promise;
    }

    function getProgressionRuleCheck(p) {
      return $http.post(
        '/services/{portalid}/business/progression_rulecheck?' +
          'processUid=' +
          p.uid
      );
    }

    const stopProcess = (uid) => {
      return $http.get(
        '/services/{portalid}/business/stop?f=json' + '&uid=' + uid
      );
    };

    return {
      BizTopologyFactory: BizTopologyFactory,
      checkRule: checkRule,
      getProgressionRuleCheck: getProgressionRuleCheck,
      stopProcess: stopProcess,
    };
  };
  BizTopologyFactory.$inject = ['$http', '$location'];
  return BizTopologyFactory;
});
