'use strict'
define(function() {
  /**
   * Appels API pour l'édition métier
   * @param $http
   * @return {{checkDeposeConsistency: (function(*): *)}}
   */
  const bizeditFactory = ($http) => {

    /**
     * Vérification de la bonne cohérence entre les champs de la table d'un composant
     * et la table du composant de dépot (ex. TRONCON - TRONCON_DEPOSE).
     * @see <a href="https://altereo-informatique.atlassian.net/browse/KIS-3370">KIS-3370 | [DEPOSE D'OBJET] : Gestion des différences de typage de champs</a>
     * @param  {string} ftiUid valeur de l'attribut uid du fti du composant
     * @return {string[]} liste des erreurs de cohérence des champs et longeur de champs texte
     */
    const checkDeposeConsistency = (ftiUid) => {
      return $http.get('/services/{portalid}/edit/' + ftiUid + '/checkdeposeconsistency?f=json')
    };
    return {
      checkDeposeConsistency: checkDeposeConsistency
    }
  };
  bizeditFactory.$inject = ['$http'];
  return bizeditFactory;
});
