'use strict';
define(function () {

  var EditDescription = function() {

    //Construit un nouvel objet `editdescription` pour une fonctionnalité associée.
    const getCleanEditDescTemplate = () => {
      return {
        theme: '',
        editType: '',
        fastMode: false,
        fti: undefined,
        editedfeature: undefined,
        relatedfeatures: [],
        shareObjects: [],
        interactions: []
      };
    };
    // Exécute les règles sur related features d'un objet `editdescription`.
    const getTemplateRelatedFeature = (feature, editdescription) => {
      const ed = getCleanEditDescTemplate();
      // On récupère le editfeature du editdescription
      const mainfeature = editdescription.editedfeature;
      ed.editedfeature = feature.feature;
      ed.editType = feature.editType;
      ed.fti = feature.fti;
      // Copie des objets partagés, en excluant la fonctionnalité en cours de traitement
      ed.shareObjects = angular.copy(editdescription.shareObjects.filter((s) => s.feature != feature.feature));
      ed.relatedfeatures = angular.copy(editdescription.relatedfeatures.filter((f) => f.feature != feature.feature));
      // Ajoute la fonctionnalité principale comme une fonctionnalité associée
      ed.relatedfeatures.push({
        feature: mainfeature,
        editType: editdescription.editType,
        fti: editdescription.fti,
        isNew: editdescription.editType === 'add'
      });
      return ed;
    };


    return {
      getCleanEditDescTemplate: getCleanEditDescTemplate,
      getTemplateRelatedFeature: getTemplateRelatedFeature
    };
  };
  EditDescription.$inject = [];
  return EditDescription;
});

