'use strict';
define([
  'angular',
  'widgets/mapapp/bizedition/directives/bizeditwidget',
  'widgets/mapapp/bizedition/directives/bizeditpoint',
  'widgets/mapapp/bizedition/directives/bizeditline',
  'widgets/mapapp/bizedition/directives/bizeditpolygon',
  'widgets/mapapp/bizedition/directives/bizeditmultiupdate',
  'widgets/mapapp/bizedition/directives/bizeditreverseline',
  'widgets/mapapp/bizedition/directives/bizedittransform',
  'widgets/mapapp/bizedition/directives/bizedittransformauto',
  'widgets/mapapp/bizedition/directives/bizeditattributes',
  'widgets/mapapp/bizedition/controllers/attributesPopupCtrl',
  'widgets/mapapp/bizedition/directives/bizeditsave',
  'widgets/mapapp/bizedition/directives/bizeditremove',
  'widgets/mapapp/bizedition/directives/bizeditdepose',
  'widgets/mapapp/bizedition/services/EditRulesFactory',
  'widgets/mapapp/bizedition/services/EditTypesFactory',
  'widgets/mapapp/bizedition/services/bizeditProvider',
  'widgets/mapapp/bizedition/directives/distancePlacement',
  'widgets/mapapp/bizedition/directives/selectOptions',
  'widgets/mapapp/bizedition/services/CopyPasteAttributeFactory',
  'widgets/mapapp/bizedition/services/bizeditFactory',
  'widgets/mapapp/bizedition/services/EditDescription',
], function(
  angular,
  bizeditwidget,
  bizeditpoint,
  bizeditline,
  bizeditpolygon,
  bizeditmultiupdate,
  bizeditreverseline,
  bizedittransform,
  bizedittransformauto,
  bizeditattributes,
  attributesPopupCtrl,
  bizeditsave,
  bizeditremove,
  bizeditdepose,
  EditRulesFactory,
  EditTypesFactory,
  bizeditProvider,
  distancePlacement,
  selectOptions,
  CopyPasteAttributeFactory,
  bizeditFactory,
  EditDescription
) {
  // generation du module
  var gcbizedition = angular.module('gc_bizedition', [
    'pascalprecht.translate',
  ]);

  gcbizedition.directive('bizeditPoint', bizeditpoint);
  gcbizedition.directive('bizeditLine', bizeditline);
  gcbizedition.directive('bizeditPolygon', bizeditpolygon);

  gcbizedition.directive('bizeditMultiUpdate', bizeditmultiupdate);
  gcbizedition.directive('bizeditReverseLine', bizeditreverseline);
  gcbizedition.directive('bizeditTransform', bizedittransform);
  gcbizedition.directive('bizeditTransformauto', bizedittransformauto);
  gcbizedition.directive('bizeditAttributes', bizeditattributes);
  gcbizedition.controller('attributespopupctrl', attributesPopupCtrl);

  gcbizedition.directive('bizeditSave', bizeditsave);
  gcbizedition.directive('bizeditRemove', bizeditremove);
  gcbizedition.directive('bizeditDepose', bizeditdepose);
  gcbizedition.directive('bizeditwidget', bizeditwidget);
  gcbizedition.factory('EditRulesFactory', EditRulesFactory);
  gcbizedition.factory('EditTypesFactory', EditTypesFactory);
  gcbizedition.factory('CopyPasteAttributeFactory', CopyPasteAttributeFactory);
  gcbizedition.factory('BizEditFactory', bizeditFactory);
  gcbizedition.factory('EditDescription', EditDescription);

  gcbizedition.directive('distancePlacement', distancePlacement);

  gcbizedition.directive('selectOptions', selectOptions);

  /**
   * Providers
   */
  gcbizedition.provider('bizeditProvider', bizeditProvider);
  return gcbizedition;
});
