'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    $translate,
    SridFactory,
    $timeout,
    gcPopup,
    $rootScope,
    $filter,
    gcInteractions,
    $document,
    extendedNgDialog,
    gaJsUtils,
    bizeditProvider,
    mapJsUtils, gcRestrictionProvider
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/bizedition/views/bizeditline.html',
      restrict: 'A',
      scope: {
        map: '=map',
        editdescription: '=editdescription',
        drawinteraction: '=drawinteraction',
        isActive: '=isactive',
        toolbarwidget: '=?toolbarwidget',
        execrules: '&execrules', //correspond à 'performRules' dans le widget d'édition
        performendrules: '&performendrules', //pas utilisé
        reset: '&',
        isGuide: '=isguide',
        createGuide: '&createguide',
        updateGuide: '&updateguide',
        guide: '&',
        stopGuide: '&stopguide',
        isGuideOrth: '=isguideOrth',
        penteLine: '&penteline',
        updateGuideOrth: '&updateguideOrth',
        startGuideOrth: '&startguideOrth',
        stopGuideOrth: '&stopguideOrth',
        isGuideFly: '=isguidefly',
        updateGuideFly: '&updateguidefly',
        startGuideFly: '&startguidefly',
        stopGuideFly: '&stopguidefly',
        isAttributePopupOpen: '=?',
        ftisrid: '=?',
        drawMode: '=?', // 'normal': main levée, 'coord': par coordonnées,
        // 'lineaire': positionnement linéaire
        network: '=' // nom du réseau d'interconnexion des composants défini dans l'admin
      },
      link: function(scope) {
        //Gestion de l'indicateur et de la possibilité d'activer et
        //désactiver la fonctionnalité de snap.
        scope.snapState = { isOn: false };
        scope.map.on('snapAddedEvent', function(e) {
          scope.snapState.isOn = true;
        });
        scope.map.on('snapRemovedEvent', function(e) {
          scope.snapState.isOn = false;
        });

        scope.srids = SridFactory.sridsList;
        scope.isMeasureAngle = false;
        scope.isMeasureToolTip = false;

        /**
         * Handler de la case à cocher permettant d'activer ou de desactiver l'interaction de snap
         * (si la règle métier exécutée à l'initialisation à ajouter une interaction de snap)
         * @returns {undefined}
         */
        scope.switchSnap = () => {
          scope.snapState.isOn=!scope.snapState.isOn;
          for (let inter of scope.map.getInteractions().getArray()) {
            if (inter instanceof ol.interaction.Snap) {
              inter.setActive(scope.snapState.isOn);
            }
          }
        };

        //Interaction de dessin instancié plus loin dans le code.
        scope.drawinteraction = {};

        scope.drawModes = [
          {
            label: $filter('translate')('bizedition.drawModesNormal'),
            value: 'normal',
            id: 0
          },
          {
            label: $filter('translate')('bizedition.byCoordinates'),
            value: 'coord',
            id: 1
          },
          {
            label: $filter('translate')('bizedition.byDistance'),
            value: 'lineaire',
            id: 2
          }
        ];
        scope.drawMode = 'normal';

        $translate('bizedition.drawModesNormal').then(function(res) {
          scope.drawModes[0].label = res;
        });

        var distanceWarningMsg = '!';
        $translate('bizedition.distanceWarningMsg').then(function(res) {
          distanceWarningMsg = res;
        });
        var azimutWarningMsg = '!';
        $translate('bizedition.azimutWarningMsg').then(function(res) {
          azimutWarningMsg = res;
        });

        var branchementPlacementPopupTitle = '';
        $translate('bizedition.branchementplacement.title').then(function(res) {
          branchementPlacementPopupTitle = res;
        });

        //////// GESTION DES PROJECTIONS ///////////////////////////////

        const mapProjCode = scope.map.getView().getProjection().getCode();

        //Liste des systemes de projection
        scope.srids = SridFactory.sridsList;

        //Projection sélectionnée.
        if ($rootScope.xgos.mouseposition && $rootScope.xgos.mouseposition.srid) {
          scope.selectedsrid = angular.copy($rootScope.xgos.mouseposition.srid);
        } else {
          if (scope.map && mapProjCode) {
            scope.selectedsrid = angular.copy(mapProjCode)
          } else {
            scope.selectedsrid = {
              name: 'EPSG:3857',
              description:
                  '+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs',
            };
          }
        }

        //Récupération du code de projection de la carte
        //Récupération de la description de la projection de la carte
        let mapProjDescription = '';
        SridFactory.getbycode(mapProjCode).then(
          function(res) {
            mapProjDescription = res.data;
          },
          function() {
            require('toastr').error('Map SRID description not found !');
          }
        );

        /**
         * Appelée à chaque changement de projectiond dans la liste déroulante.
         * @returns {undefined}
         */
        scope.onSridSelected = function() {
          if (scope.selectedsrid.name) {
            //console.log(scope.selectedsrid);
            //scope.currentsrid.name = scope.selectedsrid;
            SridFactory.getbycode(scope.selectedsrid.name).then(
              function(res) {
                scope.selectedsrid.description = res.data;
              },
              function() {
                require('toastr').error('SRID description not found !');
              }
            );
          }
        };

        /**
         * Sélectionne le système de projection correspondant à celui de la carte.
         */
        scope.selectMapEPSG = () => {
          scope.selectedsrid = {
            name: mapProjCode,
            description: mapProjDescription
          };
        };

        var wgs84Sphere = new ol.Sphere(6378137);

        //////// FIN GESTION DES PROJECTIONS ///////////////////////////////

        /////// Gestion du toolTip de Mesure ///////////////////////////////

        /**
         * Calcule la valeur et formate la chaine de caractère
         *  indiquant la longueur quand l'indication de mesure est activée.
         * @param {ol.geom.LineString} line
         * @return {String}
         */
        function formatLength(line) {
          var length;
          if (true) {
            var coordinates = line.getCoordinates();
            length = 0;
            var sourceProj = scope.map.getView().getProjection();
            for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
              var c1 = ol.proj.transform(
                coordinates[i],
                sourceProj,
                'EPSG:4326'
              );
              var c2 = ol.proj.transform(
                coordinates[i + 1],
                sourceProj,
                'EPSG:4326'
              );
              length += wgs84Sphere.haversineDistance(c1, c2);
            }
          } else {
            length = Math.round(line.getLength() * 100) / 100;
          }
          var output;
          if (length > 100) {
            output = Math.round((length / 1000) * 100) / 100 + ' ' + 'km';
          } else {
            output = Math.round(length * 100) / 100 + ' ' + 'm';
          }
          return output;
        }

        /*
         * Handler du mouvement du pointeur de souris appelé lors du dessin
         * avec l'indication de mesure activée.
         * @param {type} evt
         * @returns {undefined}
         */
        var fct = function(evt) {
          if (!scope.isActive) {
            resetMeasureToolTip();
          }

          if (evt.dragging) {
            return;
          }

          if (scope.sketch) {
            var tooltipCoord = evt.coordinate;
            var output;
            var geom = scope.sketch.getGeometry();
            if (geom instanceof ol.geom.LineString) {
              output = formatLength(geom);
              tooltipCoord = geom.getLastCoordinate();
            }
            scope.measureTooltipElement.innerHTML = output;
            scope.measureTooltip.setPosition(tooltipCoord);
          }
        };
        /**
         * Creates a new measure tooltip
         */
        function createMeasureTooltip() {
          if (scope.measureTooltipElement) {
            scope.measureTooltipElement.parentNode.removeChild(
              scope.measureTooltipElement
            );
          }
          scope.measureTooltipElement = document.createElement('div');
          scope.measureTooltipElement.className = 'tooltip tooltip-measure';
          scope.measureTooltip = new ol.Overlay({
            element: scope.measureTooltipElement,
            offset: [0, -15],
            positioning: 'bottom-center',
          });
          scope.map.addOverlay(scope.measureTooltip);
        }

        //Crée une indication de mesure au niveau du pointeur.
        function measure() {
          scope.map.on('pointermove', fct);
          createMeasureTooltip();
        }

        //Retire l'indication de mesure.
        function resetMeasureToolTip() {
          scope.map.un('pointermove', fct);
          if (scope.measureTooltipElement != null) {
            scope.measureTooltipElement.remove();
          }
          scope.measureTooltipElement = null;
        }

        /**
         * Handler de la case à cocher de choix d'affichage ou non d'une indication
         * de longueur de la ligne dessinée.
         * @param {type} isMeasureToolTip
         * @returns {undefined}
         */
        scope.onMeasureTipChange = function(isMeasureToolTip) {
          if (isMeasureToolTip) {
            measure();
          } else {
            resetMeasureToolTip();
          }
        };

        scope.$watch('isActive', resetMeasureToolTip);

        /////// FIN  Gestion du toolTip de Mesure de l'angle et de la distance  ///////////////////
        /////////////////////Outil mesure angle
        function sqr(a) {
          return a * a;
        }
        function sign(x) {
          // Si x vaut NaN, le résultat vaudra NaN.
          // Si x vaut -0, le résultat vaudra -0.
          // Si x vaut +0, le résultat vaudra +0.
          // Si x est négatif et différent de -0, le résultat vaudra -1.
          // Si x est positif et différent de +0, le résultat vaudra +1.
          x = +x; // on convertit la valeur en un nombre
          if (x === 0 || isNaN(x)) {
            return Number(x);
          }
          return x > 0 ? 1 : -1;
        }
        /**
         * [calculateAng fonxtion de calcul de l'angle en fonction de 3 point]
         * @param   coordinates
         * @return {undefined}
         */
        scope.calculateAng = function(coordinates) {
          var radian = 0;
          var rad = 0;
          if (coordinates.length >= 3) {
            var coordA = coordinates[coordinates.length - 3];
            var coordB = coordinates[coordinates.length - 2];
            var coordC = coordinates[coordinates.length - 1];
          } else {
            coordB = coordinates[coordinates.length - 2];
            coordA = [
              coordinates[coordinates.length - 2][0] + 1,
              coordinates[coordinates.length - 2][1],
            ];
            coordC = coordinates[coordinates.length - 1];
          }

          var uX = coordA[0] - coordB[0];
          var uY = coordA[1] - coordB[1];
          var vX = coordC[0] - coordB[0];
          var vY = coordC[1] - coordB[1];
          var normU = Math.sqrt(sqr(uX) + sqr(uY));
          var normV = Math.sqrt(sqr(vX) + sqr(vY));
          var scalUV = uX * vX + uY * vY;
          var cosAng = scalUV / (normU * normV);
          // radian = Math.sign(uX*vY-uY*vX)*Math.acos(cosAng);
          rad = (sign(uX * vY - uY * vX) * Math.acos(cosAng) * 180) / Math.PI;
          radian = Math.round(rad * 100) / 100;
          if (radian < 0) radian = 360 + radian;

          return radian + '°';
          // return radian*180/Math.PI+ "°";
        };
        /**
         * [calculateDist calcul de distance entre les deux derniers points]
         * @param   coordinates
         * @return {undefined}
         */
        scope.calculateDist = function(coordinates) {
          var dist = 0;

          var coordB = coordinates[coordinates.length - 2];
          var coordC = coordinates[coordinates.length - 1];

          var dA = Math.sqrt(
            sqr(coordC[0] - coordB[0]) + sqr(coordC[1] - coordB[1])
          );
          if (dA > 100) {
            dist = Math.round((dA / 1000) * 100) / 100 + ' ' + 'km';
          } else {
            dist = Math.round(dA * 100) / 100 + ' ' + 'm';
          }

          return dist;
        };

        function fctMesureAngle(evt) {
          if (!scope.isActive) {
            scope.resetMeasureAngle();
          }

          if (scope.sketch) {
            var ang;
            var dist;
            var geom = scope.sketch.getGeometry();
            if (geom instanceof ol.geom.LineString) {
              var coordinates = geom.getCoordinates();

              ang = scope.calculateAng(coordinates);

              dist = scope.calculateDist(coordinates);
            }
            scope.measureAngleElement.innerHTML = ang + ', ' + dist;
            scope.measureAngle.setPosition(evt.coordinate);
          }
        }
        /**
         * Creates a new measure tooltip
         */
        function createMeasureAngle() {
          if (scope.measureAngleElement) {
            scope.measureAngleElement.parentNode.removeChild(
              scope.measureAngleElement
            );
          }
          scope.measureAngleElement = document.createElement('div');
          scope.measureAngleElement.className = 'tooltip tooltip-measure';
          scope.measureAngle = new ol.Overlay({
            element: scope.measureAngleElement,
            offset: [0, -15],
            positioning: 'bottom-center',
          });
          scope.map.addOverlay(scope.measureAngle);
        }

        //Crée une indication de mesure au niveau du pointeur.
        scope.measureAngl = function() {
          if (!scope.isMeasureAngle) {
            // enlève l'eventListener sur pointermove
            scope.resetMeasureAngle();
          }
          // eventListener ajouté
          scope.map.on('pointermove', fctMesureAngle);
          createMeasureAngle();
        };
        if (!('remove' in Element.prototype)) {
          Element.prototype.remove = function() {
            if (this.parentNode) {
              this.parentNode.removeChild(this);
            }
          };
        }

        //Retire l'indication de mesure.
        scope.resetMeasureAngle = function() {
          scope.map.un('pointermove', fctMesureAngle);
          if (scope.measureAngleElement != null) {
            scope.measureAngleElement.remove();
          }
          scope.measureAngleElement = null;
        };

        scope.$watch('isMeasureAngle', function(newval) {
          newval ? scope.measureAngl() : scope.resetMeasureAngle();
        });
        ////////////Fin outil mesure angle

        //Gestion de la création d'objet par saisie de point de départ et distance
        var distancePopup = undefined;
        var ctrlKeyEndpress = false;


        /**
         * Actions de prise en compte du dessin
         * qu'est en train de faire l'utilisateur.
         *
         * @param {} evt
         */
        const startAddOk = (evt) => {
          const markerPositionLayer = mapJsUtils.getLayerByProperty(scope.map, 'id',
            bizeditProvider.MARKER_POSITION_LAYER_ID);
          if (markerPositionLayer && markerPositionLayer.getSource()) {
            markerPositionLayer.getSource().clear();
          }
          scope.sketch = evt.feature;
          if (scope.isMeasureToolTip) {
            measure();
          }
          if (scope.isMeasureAngle) {
            scope.measureAngl();
          }

          if (scope.isGuide) {
            scope.guide();
          }
          if (scope.isGuideOrth) {
            scope.startGuideOrth();
          }
          if (scope.isGuideFly) {
            scope.startGuideFly();
          }
        };


        /**
         * Méthode appelée au clic sur le bouton correspondant à cette directive.
         * @returns {undefined}
         */
        scope.add = function () {
          //Activation si désactivé et desactivation si activé
          scope.isActive = !scope.isActive;
          if (!scope.isActive) {
            scope.reset();
            return;
          }
          if (scope.isGuide) {
            scope.guide();
          }
          firstPoint = undefined;

          scope.drawinteraction = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'LineString',
            geometryFunction: geometryCoordinatesUpdated,
          });

          scope.drawinteraction.set('gctype', 'kis');
          scope.drawinteraction.set('interaction', 'Draw');
          scope.drawinteraction.set('widget', 'Edition');
          scope.drawinteraction.setActive(true);
          //on start
          scope.drawinteraction.on('drawstart', function(evt) {
            console.log('drawstart');

            if (gcRestrictionProvider.hasRestrictionEdition()) {
              gcRestrictionProvider.GeometryInRestriction(
                evt.feature.getGeometry(),
                scope.map.getView().getProjection().getCode()
              ).then((res) => {
                if (JSON.parse(res.data)) {
                  startAddOk(evt);
                }
                else {
                  gcRestrictionProvider.showErrorMessage();
                }
              },
              function(res) {
                console.error(res.data);
              }
              );
            } else {
              startAddOk(evt);
            }
          });

          // on end
          scope.drawinteraction.on('drawend', () => {
            console.log('drawend');
            resetMeasureToolTip();
            scope.resetMeasureAngle();
            scope.stopGuideOrth();
            scope.stopGuideFly();

            $document.on('keydown', function(e) {
              if (e.keyCode == 9) {
                e.stopPropagation();
              }
            });
          });

          // Fonctionnalité de dessin avec distance et angle de chaque segment contraints
          if (scope.drawMode === 'distance') {
            scope.type = 'point';
            distancePopup = gcPopup.open({
              scope: scope,
              title: branchementPlacementPopupTitle,
              template:
                'js/XG/widgets/mapapp/bizedition/views/distancePlacementPopup.html',
              showClose: false,
            });
          }
          //Fonctionnalité draw interaction: scope.drawMode = "normal"
          else {
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            scope.map.addInteraction(scope.drawinteraction);
          }

          try {
            $timeout(() => {
              scope.$apply();
            });
          } catch (e) { }
          $timeout(() => {
            scope.execrules();
          });
        };

        /**
         * Au clic sur le marqueur de la popup "Création de ligne par coordonnées",
         * localise le vertex de la ligne
         * Méthode exfiltrée de la méthode add() pour essayer vainement d'en améliorer la lisibilité
         */
        scope.getMarkerPosition = () => {
          let Feature = new ol.Feature({
            geometry: new ol.geom.Point([scope.XConstraint, scope.YConstraint])
          });
          let iconStyle = new ol.style.Style({
            image: new ol.style.Icon( /** @type {olx.style.IconOptions} */ ({
              anchor: [0.5, 36],
              anchorXUnits: 'fraction',
              anchorYUnits: 'pixels',
              src: 'img/widget/adressLocation/marker.png'
            }))
          });
          Feature.setStyle(iconStyle);
          let vectorSource = new ol.source.Vector({
            features: [Feature]
          });
          const markerPositionLayer
            = mapJsUtils.addOrGetLayerByProperty(scope.map, 'id',
              bizeditProvider.MARKER_POSITION_LAYER_ID);
          markerPositionLayer.setSource(vectorSource);
          scope.map.getView().setCenter(Feature.getGeometry().getCoordinates());
        };


        var warningToastrDiv = undefined;
        function resetToastrDiv() {
          warningToastrDiv = undefined;
        }

        /*
         * Méthode fournie à l'interaction Draw permettant de modifier
         * dynamiquement la géométrie de l'objet en cours de saisie
         * en fonction des valeurs de contraintes rentrées
         * dans l'ihm du widget
         *
         * @param {type} coordinates
         * @returns {Number}
         */
        function geometryCoordinatesUpdated(coordinates, geom) {
          if (!geom) {
            if (firstPoint != undefined) {
              coordinates[0] = firstPoint.getCoordinates();
              coordinates[1] = firstPoint.getCoordinates();
            }

            geom = new ol.geom.LineString(coordinates);

            return geom;
          }

          //Si dessin avec contrainte azimut et/ou distance
          if (scope.isDistanceConstraint || scope.isAzimutConstraint) {
            //Messages si contrainte activée mais sans valeur rentrée
            if (
              scope.isDistanceConstraint &&
              (angular.isUndefined(scope.distanceConstraint) ||
                scope.distanceConstraint == null)
            ) {
              if (warningToastrDiv == undefined) {
                warningToastrDiv = require('toastr').warning(
                  distanceWarningMsg
                );
                $timeout(resetToastrDiv, 5000);
              }
              geom.setCoordinates(coordinates);
              return geom;
            }
            if (
              scope.isAzimutConstraint &&
              (angular.isUndefined(scope.angleConstraint) ||
                scope.angleConstraint == null)
            ) {
              if (warningToastrDiv == undefined) {
                warningToastrDiv = require('toastr').warning(azimutWarningMsg);
                $timeout(resetToastrDiv, 5000);
              }
              geom.setCoordinates(coordinates);
              return geom;
            }
            require('toastr').clear();

            //Si l'azimut est forcée par l'utilisateur, alors on lit cette valeur
            if (scope.isAzimutConstraint) {
              //Récupération de la valeur de l'angle azimut transformée en radian dans le sens trigo
              scope.angle =
                Math.PI / 2 - (scope.angleConstraint * Math.PI) / 180;
            }
            //Si angle non forcé (l'angle sera celui dessiné à la souris)
            else {
              scope.angle = calculateAngle(coordinates);
            }
            //Si la distance est forcée par l'utilisateur, alors on lit cette valeur
            if (scope.isDistanceConstraint) {
              scope.distance = scope.distanceConstraint;
            }
            //Si distance non forcée, on la calcule à partir des coordonnées des vertex
            //du dessin (cette distance sera celle dessinée à la souris)
            else {
              scope.distance = calculateDistance(coordinates);
            }

            //Si la distance est contrainte, pas de problème, on peut calculer et
            //remplacer la nouvelle dernière coordonée.
            //Si la distance n'est pas contrainte, l'azimut est alors ici forcement contraint,
            //il ne faut pas alors que la ligne se dessine dans la direction donnée
            //par l'angle SI le pointeur de la souris bouge dans une direction
            //complétement differente(sens inverse par ex.)
            //
            //Si le pointeur de la souris bouge dans une direction proche
            //de celle donnée par l'angle, OK on recalcule.
            if (
              scope.isDistanceConstraint == true ||
              isCoordinatesToUpdate(coordinates)
            ) {
              var latestCoord = coordinates[coordinates.length - 1];
              latestCoord = getLatestCoords(coordinates);
              coordinates[coordinates.length - 1] = latestCoord;
            }
            // Si seule l'azimut est contraint et que le pointeur de la souris
            // ne bouge pas dans une direction proche de l'angle contraint
            // on ne recalcule pas.
            else {
              //On positionne la dernière coordonnées au meme endroit que l'avant dernière
              coordinates[coordinates.length - 1] = [
                coordinates[coordinates.length - 2][0],
                coordinates[coordinates.length - 2][1],
              ];
            }

            geom.setCoordinates(coordinates);
          }
          //Si dessin avec contrainte X et/ou Y
          else if (scope.isXConstraint || scope.isYConstraint) {
            //Messages si contrainte activée mais sans valeur rentrée
            if (
              scope.isXConstraint &&
              (angular.isUndefined(scope.XConstraint) ||
                scope.XConstraint == null)
            ) {
              if (warningToastrDiv == undefined) {
                warningToastrDiv = require('toastr').warning(xWarningMsg);
                $timeout(resetToastrDiv, 5000);
              }
              geom.setCoordinates(coordinates);
              return geom;
            }
            if (
              scope.isYConstraint &&
              (angular.isUndefined(scope.YConstraint) ||
                scope.YConstraint == null)
            ) {
              if (warningToastrDiv == undefined) {
                warningToastrDiv = require('toastr').warning(yWarningMsg);
                $timeout(resetToastrDiv, 5000);
              }
              geom.setCoordinates(coordinates);
              return geom;
            }
            require('toastr').clear();

            var latestCoord2 = [scope.XConstraint, scope.YConstraint];

            coordinates[0] = getProjConstraintsCoordinates(latestCoord2);

            geom.setCoordinates(coordinates);
          } else {
            // Pas de contrainte, fonctionnement drawTool normal,
            // mais on est obligé de mettre à jour la geometrie avec
            // les coordonnées recues en argument.
            if (!ctrlKeyEndpress) {
              geom.setCoordinates(coordinates);
            }
          }

          return geom;
        }

        function setInteractionGeometry(coordinates) {
          scope.drawinteraction.e = coordinates;
          scope.drawinteraction.e.push(scope.drawinteraction.f);
          scope.drawinteraction.f = coordinates[coordinates.length - 1];
          scope.drawinteraction.U = map.getPixelFromCoordinate(
            coordinates[coordinates.length - 1]
          );

          scope.drawinteraction.bb.src.e = coordinates;
          scope.drawinteraction.bb.src.e.push(scope.drawinteraction.f);
          scope.drawinteraction.bb.src.f = coordinates[coordinates.length - 1];
          scope.drawinteraction.bb.src.U = map.getPixelFromCoordinate(
            coordinates[coordinates.length - 1]
          );

          scope.drawinteraction.bb.a.drawend.map(function(src) {
            src.src.e = coordinates;
            src.src.e.push(scope.drawinteraction.f);
            src.src.f = coordinates[coordinates.length - 1];
            src.src.U = map.getPixelFromCoordinate(
              coordinates[coordinates.length - 1]
            );
          });

          scope.drawinteraction.bb.a.drawstart.map(function(src) {
            src.src.e = coordinates;
            src.src.e.push(scope.drawinteraction.f);
            src.src.f = coordinates[coordinates.length - 1];
            src.src.U = map.getPixelFromCoordinate(
              coordinates[coordinates.length - 1]
            );
          });

          scope.drawinteraction.bb.a['change:active'].map(function(src) {
            src.src.e = coordinates;
            src.src.e.push(scope.drawinteraction.f);
            src.src.f = coordinates[coordinates.length - 1];
            src.src.U = map.getPixelFromCoordinate(
              coordinates[coordinates.length - 1]
            );
          });
        }

        //Valeurs de distance (m) et d'angle (Azimut en degres), sur lesquelles peut jouer l'utilisateur.
        scope.distanceConstraint = 5;
        scope.angleConstraint = 90;

        //Valeurs de distance (metre) et d'angle (Radian) sens trigo considérées pour le calcul de la position du dernier point de la ligne en cours de dessin.
        scope.distance = 0;
        scope.angle = 0;

        /**
         * Calcule la distance entre les deux derniers vertex du tableau
         * de coordinates de la geometrie en cours lors du dernier evenement de souris.
         * @param {ol.Coordinate} coordinates
         * @returns {Number}
         */
        function calculateDistance(coordinates) {
          var previousCoord = coordinates[coordinates.length - 2];
          var latestCoord = coordinates[coordinates.length - 1];

          var previousCoordProj = ol.proj.transform(
            previousCoord,
            mapProjCode,
            'EPSG:4326'
          );
          var latestCoordProj = ol.proj.transform(
            latestCoord,
            mapProjCode,
            'EPSG:4326'
          );

          var dist = wgs84Sphere.haversineDistance(
            previousCoordProj,
            latestCoordProj
          );

          return dist;
        }

        /**
         * Calcule l'angle (sens trigonometrique) formé entre l'axe x et
         * le segment des deux derniers vertex du tableau de coordinates
         * de la geometrie en cours lors du dernier evenement de souris.
         * @param {ol.Coordinate} coordinates
         * @returns {Number}
         */
        function calculateAngle(coordinates) {
          var previousCoord = coordinates[coordinates.length - 2];
          var latestCoord = coordinates[coordinates.length - 1];

          var dx = latestCoord[0] - previousCoord[0];
          var dy = latestCoord[1] - previousCoord[1];

          let radian = Math.atan(Math.abs(dy) / Math.abs(dx));

          //Ne fonctionne pas(renvoi Nan)
          //var radian = Math.atan2(dy / dx );

          if (dy < 0 && dx > 0) {
            // radian =  2*Math.PI - radian;
            radian = -radian;
          } else if (dx < 0 && dy > 0) {
            radian = -Math.PI - radian;
          } else if (dy < 0 && dx < 0) {
            radian = -Math.PI + radian;
          }

          return radian;
        }

        /**
         * Retourne les coordonnées du second point du segment à partir
         * de l'avant dernier passé en argument et des valeurs d'angle et
         * de distance entre ces deux points.
         * @param {ol.Coordinate} coordinates
         * @returns {Array}
         */
        function getLatestCoords(coordinates) {
          var previousCoord = coordinates[coordinates.length - 2];

          var x2 = previousCoord[0] + scope.distance * Math.cos(scope.angle);
          var y2 = previousCoord[1] + scope.distance * Math.sin(scope.angle);

          // Tant que la différence de distance entre la consigne et
          // le calcul est supérieur à 10cm, on recalcule les coordonnées x2,y2.
          var previousCoordProj = ol.proj.transform(
            previousCoord,
            mapProjCode,
            'EPSG:4326'
          );
          var latestCoordProj = ol.proj.transform(
            [x2, y2],
            mapProjCode,
            'EPSG:4326'
          );
          var dist = wgs84Sphere.haversineDistance(
            previousCoordProj,
            latestCoordProj
          );
          var inputDistanceCorrected = scope.distance;
          var nb = 0;
          //Diference entre la distance consigne et la distance obtenue.
          var deltaError = dist - scope.distance;
          while (Math.abs(deltaError) > 0.01) {
            if (deltaError < 0) {
              //inputDistanceCorrected += 0.01;
              inputDistanceCorrected -= deltaError;
            } else {
              // inputDistanceCorrected -= 0.01;
              inputDistanceCorrected -= deltaError;
            }
            x2 =
              previousCoord[0] + inputDistanceCorrected * Math.cos(scope.angle);
            y2 =
              previousCoord[1] + inputDistanceCorrected * Math.sin(scope.angle);

            latestCoordProj = ol.proj.transform(
              [x2, y2],
              mapProjCode,
              'EPSG:4326'
            );
            dist = wgs84Sphere.haversineDistance(
              previousCoordProj,
              latestCoordProj
            );
            deltaError = dist - scope.distance;
            nb++;
            if (nb > 1000) break;
          }
          return [x2, y2];
        }

        /**
         * Vérifie si le pointeur de la souris bouge dans une direction proche
         * de celle donnée par l'angle contraint
         * @param {ol.Coordinate} coordinates
         * @returns {undefined}
         */
        function isCoordinatesToUpdate(coordinates) {
          //Dernier vertex posé de la ligne
          var previousCoord = coordinates[coordinates.length - 2];
          //dernière position de la souris
          var latestCoord = coordinates[coordinates.length - 1];
          var dx = latestCoord[0] - previousCoord[0];
          var dy = latestCoord[1] - previousCoord[1];

          //Si les deux points sont au meme endroit
          if (dx == 0 && dy == 0) return true;

          //angle contraint en degrès
          var angle = 90 - scope.angleConstraint;
          //angle courant du segment en court de dessin
          var currentAngle = calculateAngle(coordinates) * (180 / Math.PI);

          //Si les angles courants et contraints sont trop éloignés,
          if (Math.abs(angle - currentAngle) > 45) {
            return false;
          }
          //sinon
          return true;
        }

        /**
         * Avertit l'utilisateur si une contrainte de dessin est activée
         *  mais qu'aucune valeur de contrainte d'angle ou de distance n'est renseignée.
         */
        scope.onAngDistClick = function() {
          if (scope.isDistanceConstraint || scope.isAzimutConstraint) {
            scope.isXConstraint = false;
            scope.isYConstraint = false;

            //Messages si contrainte activée mais sans valeur rentrée
            if (
              scope.isDistanceConstraint &&
              (angular.isUndefined(scope.distanceConstraint) ||
                scope.distanceConstraint == null)
            ) {
              alert(distanceWarningMsg);
            }
            if (
              scope.isAzimutConstraint &&
              (angular.isUndefined(scope.angleConstraint) ||
                scope.angleConstraint == null)
            ) {
              alert(azimutWarningMsg);
            }
          }
        };

        /**
         * Avertit l'utilisateur si une contrainte de dessin est activée
         *  mais qu'aucune valeur de contrainte de coordonées X ou Y n'est renseignée.
         */
        scope.onXYClick = function() {
          if (scope.isXConstraint || scope.isYConstraint) {
            scope.isDistanceConstraint = false;
            scope.isAzimutConstraint = false;

            // -- @TODO Message à définir !!!!!!!
            const xWarningMsg = '!';
            const yWarningMsg = '!';
            //Messages si contrainte activée mais sans valeur rentrée
            if (
              scope.isXConstraint &&
              (angular.isUndefined(scope.XConstraint) ||
                scope.XConstraint == null)
            ) {
              alert(xWarningMsg);
            }
            if (
              scope.isYConstraint &&
              (angular.isUndefined(scope.YConstraint) ||
                scope.YConstraint == null)
            ) {
              alert(yWarningMsg);
            }
          }
        };

        /**
         * Recalcule les coordonnées X et/ou Y rentrées dans le systeme
         *  de projection choisie dans le systeme de projection de la carte.
         * @param {ol.Coordinate} coordinates
         * @returns {Array}
         */
        function getProjConstraintsCoordinates(coordinates) {
          let x = coordinates[0];
          let y = coordinates[1];

          if (scope.isXConstraint) {
            const projCoords = proj4(
              scope.selectedsrid.description,
              mapProjDescription,
              [scope.XConstraint, scope.YConstraint]
            );
            x = projCoords[0];
          }
          if (scope.isYConstraint) {
            const projCoords = proj4(
              scope.selectedsrid.description,
              mapProjDescription,
              [scope.XConstraint, scope.YConstraint]
            );
            y = projCoords[1];
          }

          return [x, y];
        }

        //////// Gestion de la création d'objet par saisie de point de départ
        ///////  et distance /////////////

        let firstPoint = undefined;

        scope.createFromPointDistance = function() {
          firstPoint = scope.editdescription.editedfeature.getGeometry();
          distancePopup.destroy();
          gcInteractions.setCurrentToolBar(scope.toolbarwidget);
          scope.map.addInteraction(scope.drawinteraction);
          //Appel de performRules du widget d'édition
          //scope.execrules();
        };

        scope.$on('runAdd', function(event, p1) {
          if (p1.geomtype === 'LINE') {
            scope.add();
          }
        });

        /**
         * Au clic sur le bouton "création" (crayon),
         * exécute différentes méthodes en fonction du mode de dessin :<ul><li>
         * "main levée" (<code>drawMode = 'normal'</code>)</li><li>
         * "par coordonnées" (<code>drawMode = 'coord'</code>)</li></ul>
         */
        scope.startLineCreationByDrawMode = () => {
          if (scope.drawMode && !scope.isCreationPopupOpened) {
            switch (scope.drawMode) {
              case 'normal': // main levée
                scope.reset();
                scope.add();
                break;
              case 'coord': // par coordonnées
                openLineCreationByCoordinates();
                break;
              case 'lineaire': // positionnement linéaire
                openLineCreationByDistance();
                break;
            }
          }
        };


        /********************************
        CREATION DE LIGNE PAR COORDONNEES
        ********************************/

        /**
         * Au clic sur le bouton "création" (crayon)
         * pour démarrer la création d'une ligne en mode "par coordonnées" :<ul><li>
         * initialise un tableau de coordonnées</li><li>
         * exécute les règles métiers <code>onInit</code></li><li>
         * ouvre la popup "Création de ligne par coordonnées"</li></ul>
         */
        const openLineCreationByCoordinates = () => {
          // Initialise un tableau de coordonnées avec un premier point null
          scope.lineByCoords = [[null, null]];

          // change la classe CSS du bouton
          scope.isActive = true;
          scope.execrules();
          scope.isCreationPopupOpened = true;
          let isClosingPopup = false;
          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditline.coords.html',
            className: 'ngdialog-theme-plain noclose bizeditline-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bycoords.line.newModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                scope.isCreationPopupOpened = false;
                bizeditProvider.removeMarkerLayer(scope.map);
                bizeditProvider.draftLineByCoordsCleanRemoval(scope.map);
                isClosingPopup = true;
              }
            }
          });
        };

        /**
         * Au clic sur le bouton "Créer la ligne" dans la popup
         * "Création de ligne par coordonnées":<ul><li>
         * Créé une feature openlayers basé sur le tableau de coordonnées</li><li>
         * Créé un évènement contenant la feature créée</li><li>
         * Exécute les règles métiers <code>OnEnd</code> avec l'évènement en paramètre</li></ul>
         */
        scope.createLineByCoordinates = () => {
          // création de la feature ol MultiLiString
          const lineGeometry = new ol.geom.MultiLineString([scope.lineByCoords]);
          const lineFeature = new ol.Feature({
            geometry: lineGeometry,
          });

          // création de l'évènement basé sur la feature (simulation d'un évènement drawend)
          const evt = new Event('drawend');
          evt.feature = lineFeature;

          // exécute les règles métiers onEnd où la feature sera associée à l'objet editdescription
          scope.performendrules()(evt);

          // ajoute la feature dans la couche de dessin temporaire KIS
          gclayers.getDrawLayer().getSource().addFeature(lineFeature);
        };

        /**
         * Positionne un marqueur sur le sommet de la ligne en cours de création
         * @param {number} index rang du sommet parmi les sommets de la ligne
         */
        scope.getVertexPosition = (index) => {
          bizeditProvider.getVertexPosition(scope.map, scope.lineByCoords,
            scope.selectedsrid, index);
        };

        /**
         * Ajoute un nouveau sommet dans la ligne en cours de création
         * depuis la popup "Création d'une ligne par coordonnées"
         */
        scope.addVertex = () => {
          scope.lineByCoords.push([null, null]);
        };

        /**
         * Au clic sur le bouton "Supprimer le sommet" (poubelle)
         * dans la popup "Créer une ligne par coordonnées".
         * Supprime un sommet de la ligne en cours de construction.<br>
         * Rafraîchit le dessin provisoire de la ligne
         * @param {number} index rang du sommet à supprimer
         */
        scope.deleteVertex = (index) => {
          if (Number.isInteger(index)
            && Array.isArray(scope.lineByCoords)
            && scope.lineByCoords.length > index) {
            scope.lineByCoords.splice(index, 1);
            scope.buildDraftLineByCoords(null, true);
          }
        };

        /**
         * Au clic sur le bouton "Annuler" dans la popup "Créer une ligne par coordonnées".
         * Enlève les couches du marqueur et du tracé provisoire de la ligne.
         * Ré-initialise le widget.
         */
        scope.cancelLineByCoordinates = () => {
          scope.reset();
        };

        /**
         * Vérifie si les coordonnées XY du sommet de ligne respecte un format numérique
         * @param index rang du sommet dans les coordonnées de la ligne.
         * Si aucun index fourni alors index est égal au dernier rang du tableau
         * de coordonnées de la ligne
         * @return {boolean} true si les coordonnées du sommet respectent un format numérique
         */
        scope.isVertexValid = (index) => {
          if (Array.isArray(scope.lineByCoords)) {
            if (!Number.isInteger(index)) {
              index = scope.lineByCoords.length -1;
            }
            if (scope.lineByCoords.length > index) {
              return Number.isFinite(scope.lineByCoords[index][0])
              && Number.isFinite(scope.lineByCoords[index][1]);
            }
          }
          return false;
        };

        /**
         * Exécuté à chaque blur d'un input de coordonnées dans la popup
         * "Créer une ligne par coordonnées".<br>
         * Exécuté aussi à la suppression d'un sommet de ligne.<br>
         * Affiche provisoirement la ligne en cours de création
         * si le tableau de coordonnées a une longueur supérieure à 1.
         * Si la longueur du tableau de coordonnées de la directive est inférieure
         * à 2 alors la couche du tracé est enlevée de la carte.
         * @param {number|null} index rang du sommet ajouté dans la ligne
         * @param {boolean} hasDeletedVertex est true pour signaler la suppression
         *                        d'un sommet de ligne
         */
        scope.buildDraftLineByCoords = (index, hasDeletedVertex = false) => {
          bizeditProvider.buildDraftLineByCoords(scope.map, scope.lineByCoords,
            scope.selectedsrid, index, hasDeletedVertex);
        };

        /**
         * Dans la popup "Création de la ligne par coordonnées".
         * Teste si deux points valides sont saisis pour activer/désactiver
         * le bouton "Modifier la ligne"
         */
        scope.hasTwoCoordinatesValid = () => {
          return bizeditProvider.hasTwoCoordinatesValid(scope.lineByCoords);
        };



        /***********************************************************+***
         EDITION DE LIGNE PAR POSITIONNEMENT LINEAIRE (branchements ass)
         **************************************************************/

        /**
         * Au clic sur le bouton "création" (crayon)
         * pour démarrer la création d'une ligne en mode "par positionnement linéaire" :<ul><li>
         * initialise un tableau de coordonnées</li><li>
         * exécute les règles métiers <code>onInit</code></li><li>
         * ouvre la popup "Création de ligne par coordonnées"</li></ul>
         */
        const openLineCreationByDistance = () => {

          // Initialise les variables de la popup
          scope.lineByDistance = {
            side: 'left',
            angle: null,
            distance: null,
            length: null,
            validators: {
              hasPath: false,
              hasConnection: false
            }
          };

          // Initialise les données du parcours réseau
          scope.networkPath = {};
          scope.config = {
            netname: scope.network,
            minnodes: 2,
            maxnodes: 50,
            nodesincr: 1
          };

          // change la classe CSS du bouton
          scope.isActive = true;

          scope.execrules();
          scope.isCreationPopupOpened = true;
          let isClosingPopup = false;
          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditline.distance.html',
            className: 'ngdialog-theme-plain noclose bizeditline-distance-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bydist.line.newModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                scope.isCreationPopupOpened = false;
                bizeditProvider.removeConnectionLayer(scope.map);
                bizeditProvider.networkPathLayersCleanRemoval(scope.map);
                scope.map.getInteractions().forEach( interaction => {
                  if (interaction.get('id') === 'network-path-select'
                    || interaction.get('id') === 'network-node-select') {
                    interaction.setActive(false);
                    scope.map.removeInteraction(interaction);
                  }
                });
                isClosingPopup = true;
                scope.isActive = false;
              }
            }
          });
        };

        /**
         * Dans la popup "Création de ligne par positionnement linéaire",
         * vérifie que la valeur de distance saisie soit un nombre et
         * que la valeur soit comprise entre 0 et 100 (bornes comprises)
         * @return {boolean} true si la distance est un nombre compris
         *                   entre 0 et 100 (bornes comprises)
         */
        scope.isLineDistanceValid = () => {
          return Number.isFinite(scope.lineByDistance.distance)
              && scope.lineByDistance.distance >= 0 && scope.lineByDistance.distance <= 100;
        };

        /**
         * Dans la popup "Création de ligne par positionnement linéaire",
         * vérifie que la valeur d'angle saisie soit un nombre et que celui-ci
         * soit compris entre 0 et 180 (bornes comprises)
         * @return {boolean} true si l'angle est un nombre compris entre 0 et 180 (bornes comprises)
         */
        scope.isLineAngleValid = () => {
          return Number.isFinite(scope.lineByDistance.angle)
              && scope.lineByDistance.angle >= 0 && scope.lineByDistance.angle <= 180;
        };

        /**
         * Dans la popup "Création de ligne par positionnement linéaire",
         * vérifie que la valeur de longueur saisie soit un nombre et que celui-ci
         * soit compris entre 0 et 1000.
         * @return {boolean} true si la longueur est un nombre compris
         * entre 0 et 1000 (strictement supérieur à 0, 1000 inclus)
         */
        scope.isLineLengthValid = () => {
          return Number.isFinite(scope.lineByDistance.length)
              && scope.lineByDistance.length > 0 && scope.lineByDistance.length <= 1000;
        };

        /**
         * Gère l'activation du bouton "Calculer" de la popup "Positionnement de l'objet linéaire"
         * @return {boolean} true si les champs sont renseignés et si le parcours réseau est valide
         */
        scope.isLineFormValid = () => {
          return scope.isLineDistanceValid() && scope.isLineAngleValid()
            && scope.isLineLengthValid() && scope.lineByDistance.validators.hasPath;
        };

        /**
         * Au clic sur le bouton "Calculer" de la popup "Positionnement de l'objet linéaire"
         * Affiche la ligne calculée à partir des données saisies dans la popup.
         * La ligne est recalculée à chaque changement de valeur d'un input (hormis la distance)
         */
        scope.calculateAndDrawConnection = () => {
          if (gaJsUtils.notNullAndDefined(scope.networkPath, 'fullData.userDirectionPath')
              && scope.lineByDistance.validators.hasPath) {
            bizeditProvider.calculateAndDrawConnection(scope.map,
              scope.networkPath, scope.lineByDistance);
          }
        };

        /**
         * Au clic sur le bouton "Annuler" de la popup "Positionnement linéaire
         * d'une ligne":<ul><li>
         * purge et retire la layer du marqueur de l'emplacement du raccord</li><li>
         * purge et retire les layers du parcours réseau</li><li>
         * puis re-initialise le widget</li></ul>
         */
        scope.cancelLineByDistance = () => {
          scope.reset();
        };

        /**
         * Au clic sur le bouton "Créer la ligne" de la popup "Positionnement d'un objet linéaire",
         * Créé un objet à partir de l'emplacement calculé
         */
        scope.createLineByDistance = () => {
          const connectionLayer = scope.map.getLayers().getArray().find(
            layer => layer.get('id') === 'connection-layer');
          if (connectionLayer && connectionLayer.getSource()
          && connectionLayer.getSource().getFeatures().length > 0) {

            // on récupère la feature de la couche d'aperçu.
            // On ne recalcule pas une nouvelle géométrie
            const lineFeature = connectionLayer.getSource().getFeatures().find(
              feature => feature.get('id') === 'connection-feature');

            if (lineFeature) {

              // supprime la propriété 'id' pour ne pas provoquer de ClassCastException
              lineFeature.unset('id');

              // supprime le style de la ligne pour qu'elle puisse adopter
              // le style de la couche de dessin temporaire
              lineFeature.setStyle(null);

              // création de l'évènement basé sur la feature (simulation d'un évènement drawend)
              const evt = new Event('drawend');
              evt.feature = lineFeature;

              // exécute les règles métiers onEnd où la feature sera associée
              // à l'objet editdescription
              scope.performendrules()(evt);

              // ajoute la feature dans la couche de dessin temporaire KIS
              gclayers.getDrawLayer().getSource().addFeature(lineFeature);
              gclayers.getselectSource().addFeatures([lineFeature]);
            }
          }
        };

        /**
         * A la fin du parcours réseau,
         * on passe la variable à true pour permettre l'activation du bouton "Calculer"
         * de la popup "Positionnement de l'objet linéaire"
         */
        scope.onNetworkPathFinish = () => {
          scope.lineByDistance.validators.hasPath = true;
          scope.lineByDistance.validators.hasConnection = false;
        };

        /**
         * Après un clic sur le bouton "Sélectionner le noeud amont"
         * pour démarrer la saisie d'un parcours réseau,
         * le composant du parcours réseau envoie un évèmenent
         * lors de l'activation du dessin du parcours.
         * Cet évènement permet de détecter quand l'utilisateur démarre
         * une session de dessin de parcours.
         */
        scope.$on('networkPathDrawActivation',(event, isActivated) => {
          if (isActivated) {
            scope.lineByDistance.validators.hasPath = false;
          }
        });
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    '$translate',
    'SridFactory',
    '$timeout',
    'gcPopup',
    '$rootScope',
    '$filter',
    'gcInteractions',
    '$document',
    'extendedNgDialog',
    'gaJsUtils',
    'bizeditProvider',
    'mapJsUtils', 'gcRestrictionProvider'
  ];
  return gcelement;
});
