'use strict';
define(function() {
  var toolbarbasemap = function($timeout, gaJsUtils) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/basemap/views/toolbarbasemap.html',

      restrict: 'A',

      link: function(scope, element) {
        const btnElt = $(element.children()[0]);
        scope.$on('closeToolsBar_toolbarbasemap', () => {
          if (scope.isActive) $('#toolbar_basemap_popover').click();
          btnElt.removeClass('btn-info');
          btnElt.addClass('btn-default');
          scope.isActive = false;
        });
        btnElt.bind('click', () => {
          if (scope.isActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
          } else {
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isActive = true;
          }
        });


        // -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
        // -- Gestion de l'attente pour ne rendre accessible la commande qu'une fois
        // -- les couches chargées. Si on n'attend pas des dysfonctionnements
        //-- lors du choix du fond de plan apparaissent.

        // -- Commande inactive au départ
        scope.disableCommand = true;

        const map = gaJsUtils.getMap(scope);
        const checkLayers = () => {
          if (map.getLayers().getLength()>2) {
            // -- Les couches sont chargées, on rend active la commande de choix d'un fond de plan.
            scope.disableCommand = false;
          }
          else {
            // -- Tant que la couche mesure et la couche vide ( !!!! ) 
            // -- sont les seules présentes, on attend.
            $timeout(checkLayers,750);
          }
        };
        checkLayers();

        // -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
      },
    };
  };

  toolbarbasemap.$inject = ['$timeout','gaJsUtils'];
  return toolbarbasemap;
});
