'use strict';
define(function() {
  const AtlasService = function($rootScope, $q, ogcFactory, gaDomUtils, $timeout, ArcGisJob,
    AtlasArcGIS108Service, $filter) {
    var AtlasTiles = [];
    let map;
    let projectionCode;


    const ESRI_LINE_TEMPLATE = {
      geometryType: 'esriGeometryPolyline',
      features: [
        {
          attributes: {
            FID: 0,
          },
          geometry: {
            paths: [],
            spatialReference: {
              wkid: ''
            }
          }
        }
      ],
    };

    const ESRI_POLYGON_TEMPLATE = {
      geometryType: 'esriGeometryPolygon',
      features: [
        {
          attributes: {
            OBJECTID: 0,
          },
          geometry: {
            spatialReference: {
              wkid: ''
            },
            rings: []
          }
        }
      ]
    };

    var mapBlock = {
      class: 'org.mapfish.print.config.layout.MapBlock',
      spacingAfter: '30',
      absoluteX: 0,
      absoluteY: 0,
      width: '300',
      height: '300',
      borderSize: '1',
    };

    var textBlock = {
      absoluteX: 0,
      absoluteY: 0,
      class: 'org.mapfish.print.config.layout.TextBlock',
      font: 'Helvetica',
      fontSize: 14,
      fontEncoding: 'Cp1252',
      fontColor: 'black',
      spacingAfter: 0,
      align: 'CENTER',
      vertAlign: 'MIDDLE',
      backgroundColor: '#FFFFFF',
      width: '120',
      height: '120',
      borderSize: '0',
      text: 'Sommaire',
    };

    var margin = {
      top: 20,
      bottom: 20,
      left: 20,
      right: 20,
    };

    function getTiles() {
      return AtlasTiles;
    }

    function setMap(mp) {
      map = mp;
      projectionCode = map.getView().getProjection().getCode();
      if (projectionCode.length > 0) {
        const splitedCode = projectionCode.split(':');
        if (splitedCode.length === 2) {
          ESRI_LINE_TEMPLATE.srid = ESRI_POLYGON_TEMPLATE.srid = splitedCode[1];
        }
      }
    }

    function getMap() {
      return map;
    }

    function getPixelsFromExtent(ext) {
      var UL = map.getPixelFromCoordinate([ext[0], ext[1]]);
      var LR = map.getPixelFromCoordinate([ext[2], ext[3]]);
      return UL.concat(LR);
    }

    function getPixelsFromCoordinates(coordinates) {
      var data = [];
      for (var i = 0; i < coordinates.length; i++) {
        var pixels = map.getPixelFromCoordinate(coordinates[i]);
        data.push(pixels);
      }
      return data;
    }

    function getExtentFromPixels(ext) {
      var UL = map.getCoordinateFromPixel([ext[0], ext[1]]);
      var LR = map.getCoordinateFromPixel([ext[2], ext[3]]);
      return UL.concat(LR);
    }

    function penteLine(extent) {
      return (extent[3] - extent[1]) / (extent[2] - extent[0]);
    }

    function calculateRest(p, extent) {
      return p * extent[0] - extent[1];
    }

    function calculateAngle(coordA, coordB, coordC) {
      var rad = 0;

      var uX = coordA[0] - coordB[0];
      var uY = coordA[1] - coordB[1];
      var vX = coordC[0] - coordB[0];
      var vY = coordC[1] - coordB[1];
      var normU = distanceCalc(uX, uY);
      var normV = distanceCalc(vX, vY);
      var scalUV = uX * vX + uY * vY;
      var cosAng = scalUV / (normU * normV);
      rad = (Math.acos(cosAng) * Math.PI) / 180.0;

      return rad;
    }

    function calculatePoints(center, dx, dy) {
      var start_point = [center[0] - dx / 2, center[1] - dy / 2];
      var end_point = [center[0] + dx / 2, center[1] + dy / 2];

      return [start_point[0], end_point[1], end_point[0], start_point[1]];
    }

    function addTile(extent, extent_proj, atlas) {
      if (indexOfExtent(AtlasTiles.pixels, extent) === -1) {
        AtlasTiles.pixels.push(extent);
        AtlasTiles.extents.push(extent_proj);
        AtlasTiles.distances.push({
          dx: extent[2] - extent[0],
          dy: extent[3] - extent[1],
        });
        var key = 'lang' + $rootScope.xgos.portal.lang;
        var page = {
          center: ol.extent.getCenter(extent_proj),
          scale: Number(atlas.scale.value),
          rotation: 0,
        };
        page[key] = true;
        AtlasTiles.pages.push(page);
      }
    }

    function addTileElementary(extent, extent_proj, atlas, elementaryTiles) {
      elementaryTiles.pixels.push(extent);
      elementaryTiles.extents.push(extent_proj);
      elementaryTiles.distances.push({
        dx: extent[2] - extent[0],
        dy: extent[3] - extent[1],
      });
      var key = 'lang' + $rootScope.xgos.portal.lang;
      var page = {
        center: ol.extent.getCenter(extent_proj),
        scale: Number(atlas.scale.value),
        rotation: 0,
      };
      page[key] = true;
      elementaryTiles.pages.push(page);
    }

    function tilesEnd() {
      if (AtlasTiles.extents.length > 0) {
        var lastindex = AtlasTiles.extents.length - 1;
        angular.extend(AtlasTiles, {
          position: [
            AtlasTiles.extents[0][0],
            AtlasTiles.extents[lastindex][1],
          ],
          offset: [AtlasTiles.pixels[0][0], AtlasTiles.pixels[lastindex][1]],
          width: AtlasTiles.pixels[lastindex][2] - AtlasTiles.pixels[0][0],
          height: AtlasTiles.pixels[0][3] - AtlasTiles.pixels[lastindex][1],
        });
      }
    }


    const calculateTileForLine0 = (params, proms) => {
      const promise = calculTileForLine(params.center, params.Translate, params.dx, params.dy,
        params.layers, params.atlas, params.last_point, params.dzx, params.dzy
      );
      promise.then(
        () => {
          params.deferred.resolve('terminé');
        },
        () => {
          params.deferred.resolve('terminé');
        }
      );
      proms.push(promise);
    };


    function calculTile(dx, dy, start_point, end_point, init_point, last_point, atlas, layers ) {
      var deferred = $q.defer();
      var proms = [deferred.promise];
      end_point = [start_point[0] + dx, start_point[1] + dy];
      var extent = start_point.concat(end_point);
      var extent_proj = getExtentFromPixels(extent);

      var promise1;
      if (atlas.visibleonscreen === 'asVisibleOnMap') {
        promise1 = getfeaturesListInExtent(layers, extent_proj);
      } else {
        promise1 = getfeaturesListInExtentForConfig(layers, extent_proj, atlas);
      }
      promise1.then(
        function(res) {
          if (res.data.names.length > 0) addTile(extent, extent_proj, atlas);

          start_point = [start_point[0] + dx, start_point[1]];
          if (end_point[0] > last_point[0] && end_point[1] < last_point[1]) {
            start_point = [init_point[0], start_point[1] + dy];
          }

          if (!(end_point[0] > last_point[0] && end_point[1] > last_point[1])) {
            var promise = calculTile(
              dx,
              dy,
              start_point,
              end_point,
              init_point,
              last_point,
              atlas,
              layers
            );
            promise.then(
              function() {
                deferred.resolve('terminé');
              },
              function() {
                deferred.resolve('terminé');
              }
            );
            proms.push(promise);
          } else {
            deferred.resolve('terminé');
          }
        },
        function() {
          start_point = [start_point[0] + dx, start_point[1]];
          if (end_point[0] > last_point[0] && end_point[1] < last_point[1])
            start_point = [init_point[0], start_point[1] + dy];

          if (!(end_point[0] > last_point[0] && end_point[1] > last_point[1])) {
            var promise = calculTile(
              dx,
              dy,
              start_point,
              end_point,
              init_point,
              last_point,
              atlas,
              layers
            );
            promise.then(
              function() {
                deferred.resolve('terminé');
              },
              function() {
                deferred.resolve('terminé');
              }
            );
            proms.push(promise);
          } else {
            deferred.resolve('terminé');
          }
        }
      );
      proms.push(promise1);
      return $q.all(proms);
    }

    function calculTileForLine(
      center,
      Translate,
      dx,
      dy,
      layers,
      atlas,
      last_point,
      dzx,
      dzy
    ) {
      var deferred = $q.defer();
      var proms = [deferred.promise];
      center = [center[0] + Translate[0], center[1] + Translate[1]];
      var extent = calculatePoints(center, dx, dy);
      var extent_proj = getExtentFromPixels(extent);

      const params = { center, Translate, dx,  dy, layers, atlas, last_point, dzx,  dzy, deferred
      };

      var promise1;
      if (atlas.visibleonscreen === 'asVisibleOnMap') {
        promise1 = getfeaturesListInExtent(layers, extent_proj);
      } else {
        promise1 = getfeaturesListInExtentForConfig(layers, extent_proj, atlas);
      }
      promise1.then(
        function(res) {
          if (res.data.names.length > 0) addTile(extent, extent_proj, atlas);

          if (dzx > 0 && dzy < 0) {
            if (center[0] < last_point[0] && center[1] > last_point[1]) {
              calculateTileForLine0(params,proms);
            } else {
              deferred.resolve('terminé');
            }
          } else if (dzx > 0 && dzy > 0) {
            if (center[0] < last_point[0] && center[1] < last_point[1]) {
              calculateTileForLine0(params,proms);
            } else {
              deferred.resolve('terminé');
            }
          } else if (dzx < 0 && dzy > 0) {
            if (center[0] > last_point[0] && center[1] < last_point[1]) {
              calculateTileForLine0(params,proms);
            }
            else {
              deferred.resolve('terminé');
            }
          } else {
            if (center[0] > last_point[0] && center[1] > last_point[1]) {
              calculateTileForLine0(params,proms);
            }
            else {
              deferred.resolve('terminé');
            }
          }
        },
        function() {
          if (dzx > 0 && dzy < 0) {
            if (center[0] < last_point[0] && center[1] > last_point[1]) {
              calculateTileForLine0(params,proms);
            }
            else {
              deferred.resolve('terminé');
            }
          } else if (dzx > 0 && dzy > 0) {
            if (center[0] < last_point[0] && center[1] < last_point[1]) {
              calculateTileForLine0(params,proms);
            } else {
              deferred.resolve('terminé');
            }
          } else if (dzx < 0 && dzy > 0) {
            if (center[0] > last_point[0] && center[1] < last_point[1]) {
              calculateTileForLine0(params,proms);
            } else {
              deferred.resolve('terminé');
            }
          } else {
            if (center[0] > last_point[0] && center[1] > last_point[1]) {
              calculateTileForLine0(params,proms);
            }
            else {
              deferred.resolve('terminé');
            }
          }
        }
      );
      proms.push(promise1);
      return $q.all(proms);
    }

    function distanceCalc(dx, dy) {
      return Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));
    }

    function f1(
      center,
      Translate,
      dx,
      dy,
      layers,
      atlas,
      last_point,
      dzx,
      dzy,
      deferred,
      promises,
      elementaryTiles
    ) {
      var extent = calculatePoints(center, dx, dy);
      var extent_proj = getExtentFromPixels(extent);

      var promise;
      if (atlas.visibleonscreen === 'asVisibleOnMap') {
        promise = getfeaturesListInExtent(layers, extent_proj);
      } else {
        promise = getfeaturesListInExtentForConfig(layers, extent_proj, atlas);
      }
      promise.then(
        function(res) {
          if (res.data.names.length > 0)
            addTile(extent, extent_proj, atlas, elementaryTiles);

          if (center[0] < last_point[0] && center[1] > last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        },
        function() {
          if (center[0] < last_point[0] && center[1] > last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        }
      );
    }

    function f2(
      center,
      Translate,
      dx,
      dy,
      layers,
      atlas,
      last_point,
      dzx,
      dzy,
      deferred,
      promises,
      elementaryTiles
    ) {
      var extent = calculatePoints(center, dx, dy);
      var extent_proj = getExtentFromPixels(extent);

      var promise;
      if (atlas.visibleonscreen === 'asVisibleOnMap') {
        promise = getfeaturesListInExtent(layers, extent_proj);
      } else {
        promise = getfeaturesListInExtentForConfig(layers, extent_proj, atlas);
      }
      promise.then(
        function(res) {
          if (res.data.names.length > 0)
            addTile(extent, extent_proj, atlas, elementaryTiles);
          if (center[0] < last_point[0] && center[1] < last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        },
        function() {
          if (center[0] < last_point[0] && center[1] < last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        }
      );
      promises.push(promise);
    }

    function f3(
      center,
      Translate,
      dx,
      dy,
      layers,
      atlas,
      last_point,
      dzx,
      dzy,
      deferred,
      promises,
      elementaryTiles
    ) {
      var extent = calculatePoints(center, dx, dy);
      var extent_proj = getExtentFromPixels(extent);

      var promise;
      if (atlas.visibleonscreen === 'asVisibleOnMap') {
        promise = getfeaturesListInExtent(layers, extent_proj);
      } else {
        promise = getfeaturesListInExtentForConfig(layers, extent_proj, atlas);
      }
      promise.then(
        function(res) {
          if (res.data.names.length > 0)
            addTile(extent, extent_proj, atlas, elementaryTiles);

          if (center[0] > last_point[0] && center[1] < last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        },
        function() {
          if (center[0] > last_point[0] && center[1] < last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        }
      );
      promises.push(promise);
    }

    function f4(
      center,
      Translate,
      dx,
      dy,
      layers,
      atlas,
      last_point,
      dzx,
      dzy,
      deferred,
      promises
    ) {
      var extent = calculatePoints(center, dx, dy);
      var extent_proj = getExtentFromPixels(extent);

      var promise;
      if (atlas.visibleonscreen === 'asVisibleOnMap') {
        promise = getfeaturesListInExtent(layers, extent_proj);
      } else {
        promise = getfeaturesListInExtentForConfig(layers, extent_proj, atlas);
      }
      promise.then(
        function(res) {
          if (res.data.names.length > 0) addTile(extent, extent_proj, atlas);
          if (center[0] > last_point[0] && center[1] > last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        },
        function() {
          if (center[0] > last_point[0] && center[1] > last_point[1]) {
            var newpromise = calculTileForLine(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy
            );
            newpromise.then(function() {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        }
      );
      promises.push(promise);
    }

    function f5(
      center,
      Translate,
      dx,
      dy,
      layers,
      atlas,
      last_point,
      dzx,
      dzy,
      deferred,
      promises,
      selection,
      i,
      elementaryTiles
    ) {
      var ex = [
        Math.min(selection[i][0], selection[i + 1][0]),
        Math.max(selection[i][1], selection[i + 1][1]),
        Math.max(selection[i][0], selection[i + 1][0]),
        Math.min(selection[i][1], selection[i + 1][1]),
      ];

      var init_point = [ex[0], ex[3]];
      var last_point = [ex[2], ex[1]];

      var start_point = init_point;
      var end_point = [start_point[0] + dx, start_point[1] + dy];
      var extent = start_point.concat(end_point);
      var extent_proj = getExtentFromPixels(extent);

      var promise;
      if (atlas.visibleonscreen === 'asVisibleOnMap') {
        promise = getfeaturesListInExtent(layers, extent_proj);
      } else {
        promise = getfeaturesListInExtentForConfig(layers, extent_proj, atlas);
      }
      promise.then(
        function(res) {
          if (res.data.names.length > 0)
            addTileElementary(extent, extent_proj, atlas, elementaryTiles);

          start_point = [start_point[0] + dx, start_point[1]];
          if (end_point[0] > last_point[0] && end_point[1] < last_point[1])
            start_point = [init_point[0], start_point[1] + dy];

          if (!(end_point[0] > last_point[0] && end_point[1] > last_point[1])) {
            var newpromise = calculTile(
              dx,
              dy,
              start_point,
              end_point,
              init_point,
              last_point,
              atlas,
              layers
            );
            newpromise.then(function() {
              if (
                selection[i][1] > selection[i + 1][1] + dy ||
                    selection[i][0] > selection[i + 1][0] + dx
              ) {
                AtlasTiles.pixels = elementaryTiles.pixels.concat(
                  AtlasTiles.pixels
                );
                AtlasTiles.extents = elementaryTiles.extents.concat(
                  AtlasTiles.extents
                );
                AtlasTiles.distances = elementaryTiles.distances.concat(
                  AtlasTiles.distances
                );
                AtlasTiles.pages = elementaryTiles.pages.concat(
                  AtlasTiles.pages
                );
                AtlasTiles.pixels = AtlasTiles.pixels.reverse();
                AtlasTiles.extents = AtlasTiles.extents.reverse();
                AtlasTiles.distances = AtlasTiles.distances.reverse();
                AtlasTiles.pages = AtlasTiles.pages.reverse();
              } else {
                AtlasTiles.pixels = elementaryTiles.pixels.concat(
                  AtlasTiles.pixels
                );
                AtlasTiles.extents = elementaryTiles.extents.concat(
                  AtlasTiles.extents
                );
                AtlasTiles.distances = elementaryTiles.distances.concat(
                  AtlasTiles.distances
                );
                AtlasTiles.pages = elementaryTiles.pages.concat(
                  AtlasTiles.pages
                );
              }

              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            if (selection[i][1] > selection[i + 1][1]) {
              elementaryTiles.pixels = elementaryTiles.pixels.reverse();
              elementaryTiles.extents = elementaryTiles.extents.reverse();
              elementaryTiles.distances = elementaryTiles.distances.reverse();
              elementaryTiles.pages = elementaryTiles.pages.reverse();
              AtlasTiles.pixels = elementaryTiles.pixels.concat(
                AtlasTiles.pixels
              );
              AtlasTiles.extents = elementaryTiles.extents.concat(
                AtlasTiles.extents
              );
              AtlasTiles.distances = elementaryTiles.distances.concat(
                AtlasTiles.distances
              );
              AtlasTiles.pages = elementaryTiles.pages.concat(AtlasTiles.pages);
            } else {
              AtlasTiles.pixels = elementaryTiles.pixels.concat(
                AtlasTiles.pixels
              );
              AtlasTiles.extents = elementaryTiles.extents.concat(
                AtlasTiles.extents
              );
              AtlasTiles.distances = elementaryTiles.distances.concat(
                AtlasTiles.distances
              );
              AtlasTiles.pages = elementaryTiles.pages.concat(AtlasTiles.pages);
            }

            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        },
        function() {
          start_point = [start_point[0] + dx, start_point[1]];
          if (end_point[0] > last_point[0] && end_point[1] < last_point[1])
            start_point = [init_point[0], start_point[1] + dy];

          if (!(end_point[0] > last_point[0] && end_point[1] > last_point[1])) {
            var newpromise = calculTile(
              dx,
              dy,
              start_point,
              end_point,
              init_point,
              last_point,
              atlas,
              layers
            );
            newpromise.then(function() {
              if (selection[i][1] > selection[i + 1][1]) {
                elementaryTiles.pixels = elementaryTiles.pixels.reverse();
                elementaryTiles.extents = elementaryTiles.extents.reverse();
                elementaryTiles.distances = elementaryTiles.distances.reverse();
                elementaryTiles.pages = elementaryTiles.pages.reverse();
                AtlasTiles.pixels = AtlasTiles.pixels.concat(
                  elementaryTiles.pixels
                );
                AtlasTiles.extents = AtlasTiles.extents.concat(
                  elementaryTiles.extents
                );
                AtlasTiles.distances = AtlasTiles.distances.concat(
                  elementaryTiles.distances
                );
                AtlasTiles.pages = AtlasTiles.pages.concat(
                  elementaryTiles.pages
                );
              } else {
                AtlasTiles.pixels = AtlasTiles.pixels.concat(
                  elementaryTiles.pixels
                );
                AtlasTiles.extents = AtlasTiles.extents.concat(
                  elementaryTiles.extents
                );
                AtlasTiles.distances = AtlasTiles.distances.concat(
                  elementaryTiles.distances
                );
                AtlasTiles.pages = AtlasTiles.pages.concat(
                  elementaryTiles.pages
                );
              }
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0) tilesEnd();
            });
            promises.push(newpromise);
          } else {
            if (selection[i][1] > selection[i + 1][1]) {
              elementaryTiles.pixels = elementaryTiles.pixels.reverse();
              elementaryTiles.extents = elementaryTiles.extents.reverse();
              elementaryTiles.distances = elementaryTiles.distances.reverse();
              elementaryTiles.pages = elementaryTiles.pages.reverse();
              AtlasTiles.pixels = AtlasTiles.pixels.concat(
                elementaryTiles.pixels
              );
              AtlasTiles.extents = AtlasTiles.extents.concat(
                elementaryTiles.extents
              );
              AtlasTiles.distances = AtlasTiles.distances.concat(
                elementaryTiles.distances
              );
              AtlasTiles.pages = AtlasTiles.pages.concat(elementaryTiles.pages);
            } else {
              AtlasTiles.pixels = AtlasTiles.pixels.concat(
                elementaryTiles.pixels
              );
              AtlasTiles.extents = AtlasTiles.extents.concat(
                elementaryTiles.extents
              );
              AtlasTiles.distances = AtlasTiles.distances.concat(
                elementaryTiles.distances
              );
              AtlasTiles.pages = AtlasTiles.pages.concat(elementaryTiles.pages);
            }

            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        }
      );
      promises.push(promise);
    }
    function sign(x) {
      // Si x vaut NaN, le résultat vaudra NaN.
      // Si x vaut -0, le résultat vaudra -0.
      // Si x vaut +0, le résultat vaudra +0.
      // Si x est négatif et différent de -0, le résultat vaudra -1.
      // Si x est positif et différent de +0, le résultat vaudra +1.
      x = +x; // on convertit la valeur en un nombre
      if (x === 0 || isNaN(x)) {
        return Number(x);
      }
      return x > 0 ? 1 : -1;
    }

    function calcLine(layers, selection, print, atlas, i, deferred, promises) {
      var elementaryTiles = {
        pixels: [],
        extents: [],
        distances: [],
        pages: [],
      };

      var dx = print[2] - print[0];
      var dy = print[3] - print[1];

      var coords_am = selection[i];
      var coords_av = selection[i + 1];

      var dzx = coords_av[0] - coords_am[0];
      var dzy = coords_av[1] - coords_am[1];
      var pasy, pasx;
      if (Math.abs(dzx) > Math.abs(dx) && Math.abs(dzy) > Math.abs(dy)) {
        var pente = penteLine([0, 0, dzx, dzy]);
        var reste = calculateRest(pente, [0, 0, dzx, dzy]);

        pasx = dzx / Math.abs(dzx / dx);
        pasy = sign(dzy) * Math.abs(pente * pasx + reste);

        if (Math.abs(pasx) > dx) {
          pasx = sign(dzx) * dx;
          pasy = sign(dzy) * Math.abs(pente * pasx + reste);
        }

        if (Math.abs(pasy) > dy) {
          pasy = sign(dzy) * dy;
          pasx = sign(dzx) * Math.abs((pasy - reste) / pente);
        }

        var Translate = [pasx, pasy];

        var center = coords_am;
        var last_point = coords_av;

        if (dzx > 0 && dzy < 0) {
          if (
            center[0] <= last_point[0] &&
              center[1] >= last_point[1] &&
              i === 0
          ) {
            f1(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy,
              deferred,
              promises,
              elementaryTiles
            );
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        } else if (dzx > 0 && dzy > 0) {
          if (
            center[0] < last_point[0] &&
              center[1] < last_point[1] &&
              i === 0
          ) {
            f2(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy,
              deferred,
              promises,
              elementaryTiles
            );
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        } else if (dzx < 0 && dzy > 0) {
          if (
            center[0] > last_point[0] &&
              center[1] < last_point[1] &&
              i === 0
          ) {
            f3(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy,
              deferred,
              promises,
              elementaryTiles
            );
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        } else {
          if (
            center[0] > last_point[0] &&
              center[1] > last_point[1] &&
              i === 0
          ) {
            f4(
              center,
              Translate,
              dx,
              dy,
              layers,
              atlas,
              last_point,
              dzx,
              dzy,
              deferred,
              promises,
              elementaryTiles
            );
          } else {
            deferred.resolve('terminée');
            if (AtlasTiles.pixels.length > 0) tilesEnd();
          }
        }
      } else {
        f5(
          center,
          Translate,
          dx,
          dy,
          layers,
          atlas,
          last_point,
          dzx,
          dzy,
          deferred,
          promises,
          selection,
          i,
          elementaryTiles
        );
      }
    }

    function global(layers, selection, print, atlas) {
      var defer = $q.defer();
      var promises = [defer.promise];
      var specialTiles = {
        pixels: [],
        extents: [],
        distances: [],
        pages: [],
      };
      var selectionArray = selection;
      var selectionLength = selectionArray.length;

      var i = 0;
      if (i <= selectionLength - 2) {
        var select = [selection[i], selection[i + 1]];
        var promise = setTilesForLine(
          layers,
          selection,
          print,
          atlas,
          i,
          selectionLength,
          select,
          specialTiles
        );
        promise.then(function() {
          AtlasTiles = specialTiles;
          defer.resolve('terminé !');
        });
        promises.push(promise);
      } else {
        defer.resolve('terminé !');
      }

      return $q.all(promises);
    }

    function setTilesForLine(
      layers,
      selection,
      print,
      atlas,
      i,
      length,
      select,
      specialTiles
    ) {
      var defer = $q.defer();
      var promises = [defer.promise];
      var promise = setTiles(layers, select, print, atlas);
      promise.then(function() {
        specialTiles.pixels = $.unique(
          specialTiles.pixels.concat(AtlasTiles.pixels)
        );
        specialTiles.extents = $.unique(
          specialTiles.extents.concat(AtlasTiles.extents)
        );
        specialTiles.distances = $.unique(
          specialTiles.distances.concat(AtlasTiles.distances)
        );
        specialTiles.pages = $.unique(
          specialTiles.pages.concat(AtlasTiles.pages)
        );
        i++;
        if (i <= length - 2) {
          select = [selection[i], selection[i + 1]];
          var prom = setTilesForLine(
            layers,
            selection,
            print,
            atlas,
            i,
            length,
            select,
            specialTiles
          );
          prom.then(function() {
            defer.resolve('terminé !');
          });
          promises.push(prom);
        } else {
          defer.resolve('terminé !');
        }
      });
      promises.push(promise);
      return $q.all(promises);
    }



    function setTiles(layers, selection, print, atlas) {
      var deferred = $q.defer();
      var promises = [deferred.promise];

      AtlasTiles = {
        pixels: [],
        extents: [],
        distances: [],
        pages: [],
      };

      if (atlas.type === 'frame' || atlas.type === 'selection' || atlas.type === 'polygon') {
        var dx = print[2] - print[0];
        var dy = print[3] - print[1];

        let init_point = [selection[0], selection[3]];
        let last_point = [selection[2], selection[1]];

        var start_point = init_point;
        var end_point = [start_point[0] + dx, start_point[1] + dy];
        var extent = start_point.concat(end_point);
        var extent_proj = getExtentFromPixels(extent);

        var promise;
        if (atlas.visibleonscreen === 'asVisibleOnMap') {
          promise = getfeaturesListInExtent(layers, extent_proj);
        } else {
          promise = getfeaturesListInExtentForConfig(
            layers,
            extent_proj,
            atlas
          );
        }
        promise.then(
          function(res) {
            if (res.data.names.length > 0) addTile(extent, extent_proj, atlas);

            start_point = [start_point[0] + dx, start_point[1]];
            if (end_point[0] > last_point[0] && end_point[1] < last_point[1])
              start_point = [init_point[0], start_point[1] + dy];

            if (
              !(end_point[0] > last_point[0] && end_point[1] > last_point[1])
            ) {
              var newpromise = calculTile(
                dx,
                dy,
                start_point,
                end_point,
                init_point,
                last_point,
                atlas,
                layers
              );
              newpromise.then(function() {
                deferred.resolve('terminée');
                if (AtlasTiles.pixels.length > 0 && (atlas.type === 'frame' || atlas.type === 'polygon'))
                  tilesEnd();
              });
              promises.push(newpromise);
            } else {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0 && (atlas.type === 'frame' || atlas.type === 'polygon'))
                tilesEnd();
            }
          },
          function() {
            start_point = [start_point[0] + dx, start_point[1]];
            if (end_point[0] > last_point[0] && end_point[1] < last_point[1])
              start_point = [init_point[0], start_point[1] + dy];

            if (
              !(end_point[0] > last_point[0] && end_point[1] > last_point[1])
            ) {
              var newpromise = calculTile(
                dx,
                dy,
                start_point,
                end_point,
                init_point,
                last_point,
                atlas,
                layers
              );
              newpromise.then(function() {
                deferred.resolve('terminée');
                if (AtlasTiles.pixels.length > 0 && (atlas.type === 'frame' || atlas.type === 'polygon'))
                  tilesEnd();
              });
              promises.push(newpromise);
            } else {
              deferred.resolve('terminée');
              if (AtlasTiles.pixels.length > 0 && (atlas.type === 'frame' || atlas.type === 'polygon'))
                tilesEnd();
            }
          }
        );
        promises.push(promise);
      } else {
        var i = 0;
        calcLine(layers, selection, print, atlas, i, deferred, promises);
      }
      return $q.all(promises);
    }

    function bestPointtoStart(center, selection, dx, dy) {
      while (
        center[0] - dx / 2 > selection[0] ||
          center[1] - dy / 2 > selection[3]
      ) {
        center = [center[0] - dx / 2, center[1] - dy / 2];
      }
      return [center[0] - dx / 2, center[1] - dy / 2];
    }

    function searchForInitPoint(dx, dy, selection) {
      if (selection[2] === selection[0] && selection[1] === selection[3]) {
        return [selection[0] - dx / 2, selection[1] - dy / 2];
      } else {
        var center = [
          selection[0] + (selection[2] - selection[0]) / 2,
          selection[1] - (selection[1] - selection[3]) / 2,
        ];
        var extentFromCenter = [
          center[0] - dx / 2,
          center[1] + dy / 2,
          center[0] + dx / 2,
          center[1] - dy / 2,
        ];
        if (ol.extent.containsExtent(selection, extentFromCenter)) {
          return [center[0] - dx / 2, center[1] - dy / 2];
        } else {
          return bestPointtoStart(center, selection, dx, dy);
        }
      }
    }

    function calculTileForSelection(
      dx,
      dy,
      start_point,
      end_point,
      init_point,
      last_point,
      atlas,
      layers,
      selection
    ) {
      var deferred = $q.defer();
      var proms = [deferred.promise];
      end_point = [start_point[0] + dx, start_point[1] + dy];
      var extent = start_point.concat(end_point);
      var extent_proj = getExtentFromPixels(extent);
      addTile(extent, extent_proj, atlas, selection);

      start_point = [start_point[0] + dx, start_point[1]];
      if (end_point[0] > last_point[0] && end_point[1] < last_point[1])
        start_point = [init_point[0], start_point[1] + dy];

      if (!(end_point[0] > last_point[0] && end_point[1] > last_point[1])) {
        var promise = calculTileForSelection(
          dx,
          dy,
          start_point,
          end_point,
          init_point,
          last_point,
          atlas,
          layers,
          selection
        );
        promise.then(
          function() {
            deferred.resolve('terminé');
          },
          function() {
            deferred.resolve('terminé');
          }
        );
        proms.push(promise);
      } else {
        deferred.resolve('terminé');
      }
      return $q.all(proms);
    }

    function setTilesForSelection(layers, selection, print, atlas) {
      var deferred = $q.defer();
      var promises = [deferred.promise];

      var dx = print[2] - print[0];
      var dy = print[3] - print[1];

      var init_point = searchForInitPoint(dx, dy, selection);

      var last_point = [selection[2], selection[1]];

      var start_point = init_point;
      var end_point = [start_point[0] + dx, start_point[1] + dy];
      var extent = start_point.concat(end_point);
      var extent_proj = getExtentFromPixels(extent);
      addTile(extent, extent_proj, atlas, selection);

      start_point = [start_point[0] + dx, start_point[1]];
      if (end_point[0] > last_point[0] && end_point[1] < last_point[1])
        start_point = [init_point[0], start_point[1] + dy];

      if (!(end_point[0] > last_point[0] && end_point[1] > last_point[1])) {
        var newpromise = calculTileForSelection(
          dx,
          dy,
          start_point,
          end_point,
          init_point,
          last_point,
          atlas,
          layers,
          selection
        );
        newpromise.then(function() {
          deferred.resolve('terminée');
          if (AtlasTiles.pixels.length > 0 && (atlas.type === 'frame' || atlas.type === 'polygon'))
            tilesEnd();
        });
        promises.push(newpromise);
      } else {
        deferred.resolve('terminée');
        if (AtlasTiles.pixels.length > 0 && (atlas.type === 'frame' || atlas.type === 'polygon'))
          tilesEnd();
      }
      return $q.all(promises);
    }


    function getfeaturesListInExtent(layers, extent) {
      var leftX = extent[0];
      var bottomY = extent[1];
      var rightX = extent[2];
      var topY = extent[3];
      var filters = [];
      var resolution = map.getView().getResolution();
      angular.forEach(layers, function(layer) {
        if (
          layer.visible &&
            (layer.getMinResolution() == undefined ||
                resolution >= layer.getMinResolution()) &&
            (layer.getMaxResolution() == Infinity ||
                resolution < layer.getMaxResolution()) &&
            layer.get('fti')
        ) {
          filters.push(layer.get('fti').uid);
        }
      });
      if (filters.length > 0) {
        var filter = filters.join(',');
        var cql_filter =
            'INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))';
        const promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', filter,
          'json', projectionCode, cql_filter);
        promise.then(
          function(res) {
            res.data.names = $.unique(
              res.data.features.map(function(x) {
                return x.id.split('.')[0];
              })
            );
          },
          function(res) {
            res.data = {};
            res.data.names = [];
          }
        );
        return promise;
      } else {
        var deferred = $q.defer();
        deferred.resolved('terminé');
        return deferred.promise;
      }
    }

    function getfeaturesListInExtentForConfig(layers, extent, atlas) {
      var leftX = extent[0];
      var bottomY = extent[1];
      var rightX = extent[2];
      var topY = extent[3];
      var filters = [];
      angular.forEach(layers, function(layer) {
        if (
          layer.visible &&
            (layer.minScale == undefined ||
                Number(atlas.scale.value) >= layer.minScale) &&
            (layer.maxScale == undefined ||
                Number(atlas.scale.value) < layer.maxScale) &&
            layer.get('fti')
        ) {
          filters.push(layer.get('fti').uid);
        }
      });
      if (filters.length > 0) {
        var filter = filters.join(',');
        var cql_filter =
            'INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))';
        const promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', filter,
          'json', projectionCode, cql_filter);
        promise.then(
          function(res) {
            res.data.names = $.unique(
              res.data.features.map(function(x) {
                return x.id.split('.')[0];
              })
            );
          },
          function(res) {
            res.data = {};
            res.data.names = [];
          }
        );
        return promise;
      } else {
        var deferred = $q.defer();
        deferred.resolved('terminé');
        return deferred.promise;
      }
    }

    function rotatePoint(angle, point, center) {
      var s = Math.sin(angle);
      var c = Math.cos(angle);

      point[0] =
          center[0] + (point[0] - center[0]) * c - (point[1] - center[1]) * s;
      point[1] =
          center[1] + (point[1] - center[1]) * c + (point[0] - center[0]) * s;

      return point;
    }

    function calculateFullSize(model) {
      var res = {
        w: 0,
        h: 0,
      };
      switch (model.pageSize) {
        case 'A0':
          if (model.landscape == 'true') {
            res.w = 3371;
            res.h = 2383;
          } else {
            res.w = 2383;
            res.h = 3371;
          }
          break;
        case 'A1':
          if (model.landscape == 'true') {
            res.w = 2383;
            res.h = 1685;
          } else {
            res.w = 1685;
            res.h = 2383;
          }
          break;
        case 'A2':
          if (model.landscape == 'true') {
            res.w = 1685;
            res.h = 1191;
          } else {
            res.w = 1191;
            res.h = 1685;
          }
          break;
        case 'A3':
          if (model.landscape == 'true') {
            res.w = 1191;
            res.h = 842;
          } else {
            res.w = 842;
            res.h = 1191;
          }
          break;
        case 'A4':
          if (model.landscape == 'true') {
            res.w = 800; //842;
            res.h = 565; //595;
          } else {
            res.w = 565; //595;
            res.h = 800; //842;
          }
          break;
        case 'A5':
          if (model.landscape == 'true') {
            res.w = 595;
            res.h = 421;
          } else {
            res.w = 421;
            res.h = 595;
          }
          break;
      }
      return res;
    }

    function createItems(size) {
      var w = size.w - margin.left - margin.right;
      var h = size.h - margin.top - margin.bottom;

      var textHeight = Math.round(h / 4);
      var mapHeight = Math.round((h * 3) / 4);

      var textB = angular.copy(textBlock);
      textB.absoluteX = margin.left;
      textB.absoluteY = margin.top;
      textB.width = w;
      textB.height = textHeight;

      var mapB = angular.copy(mapBlock);
      mapB.absoluteX = margin.left;
      mapB.absoluteY = margin.top + textHeight;
      mapB.width = w;
      mapB.height = mapHeight;

      return [textB, mapB];
    }

    function getUniqueLayers(
      layers,
      legends,
      pages,
      fittedScale,
      mapFittedSize,
      items
    ) {
      var res = {
        layers: [],
        legends: [],
        scale: 0,
      };
      var numberLayers = 0;
      for (var i = 0; i < layers.length; i++) {
        try {
          var layGroup = layers[i];
          res.layers = layers[i].length > numberLayers ? layGroup : res.layers;
          numberLayers = layers[i].length;
        } catch (e) {
          console.error(e.message);
        }
      }
      var mapblock = items
        .map(function(x) {
          if (x.class === 'org.mapfish.print.config.layout.MapBlock') return x;
        })
        .filter(function(x) {
          if (x) return x;
        })[0];
      var width = mapblock.width;
      var height = mapblock.height;
      var coef = (mapFittedSize[0] * mapFittedSize[1]) / (width * height);
      res.scale = Math.ceil(fittedScale * (coef / 3));

      var key = 'lang' + $rootScope.xgos.portal.lang;
      var page = {
        center: [],
        scale: parseInt(res.scale),
        rotation: 0,
      };
      page[key] = true;
      res.pages = [page];

      return res;
    }

    function recurSetTilesFromSelection(
      layers,
      selection_extent,
      print_extent,
      atlas,
      defer,
      i,
      promises
    ) {
      i++;
      if (i < selection_extent.length) {
        var prom = setTilesForSelection(
          layers,
          selection_extent[i],
          print_extent,
          atlas
        );
        prom.then(
          function() {
            recurSetTilesFromSelection(
              layers,
              selection_extent,
              print_extent,
              atlas,
              defer,
              i,
              promises
            );
          },
          function() {
            recurSetTilesFromSelection(
              layers,
              selection_extent,
              print_extent,
              atlas,
              defer,
              i,
              promises
            );
          }
        );
        promises.push(prom);
      } else {
        tilesEnd();
        defer.resolve('terminé');
      }
    }

    function setTilesFromSelection(
      layers,
      selection_extent,
      print_extent,
      atlas
    ) {
      var defer = $q.defer();
      var promises = [defer.promise];
      var i = 0;
      AtlasTiles = {
        pixels: [],
        extents: [],
        distances: [],
        pages: [],
      };
      if (i < selection_extent.length) {
        var prom = setTilesForSelection(
          layers,
          selection_extent[i],
          print_extent,
          atlas
        );
        prom.then(
          function() {
            recurSetTilesFromSelection(
              layers,
              selection_extent,
              print_extent,
              atlas,
              defer,
              i,
              promises
            );
          },
          function() {
            recurSetTilesFromSelection(
              layers,
              selection_extent,
              print_extent,
              atlas,
              defer,
              i,
              promises
            );
          }
        );
        promises.push(prom);
      } else {
        tilesEnd();
        defer.resolve('terminé');
      }
      return $q.all(promises);
    }

    function equalsExtent(ar1, ar2) {
      if (
        ar1[0] === ar2[0] &&
          ar1[1] === ar2[1] &&
          ar1[2] === ar2[2] &&
          ar1[3] === ar2[3]
      )
        return true;
      else return false;
    }

    function indexOfExtent(ar1, ar2) {
      for (var i = 0; i < ar1.length; i++) {
        if (equalsExtent(ar1[i], ar2)) return i;
      }
      return -1;
    }

    function finalcheckResult(extents) {
      var result = [];
      for (var i = 0; i < extents.length; i++) {
        var ext = extents[i];
        for (var j = 0; j < extents.length; j++) {
          var exte = extents[j];
          if (ol.extent.intersects(exte, ext)) {
            ext = ol.extent.extend(exte, ext);
          }
        }
        if (indexOfExtent(result, ext) === -1) {
          result.push(ext);
        }
      }
      return result;
    }

    function simplifyExtents(extents) {
      var result = [];
      for (var i = 0; i < extents.length; i++) {
        var ext = extents[i];
        var changed = false;
        for (var j = 0; j < result.length; j++) {
          var exte = result[j];
          if (angular.equals(exte, ext)) {
            changed = true;
          } else if (ol.extent.containsExtent(exte, ext)) {
            extents[i] = result[j];
            ext = extents[i];
            changed = true;
          } else if (ol.extent.containsExtent(ext, exte)) {
            result[j] = extents[i];
            exte = extents[i];
            changed = true;
          } else if (ol.extent.intersects(exte, ext)) {
            exte = ol.extent.extend(exte, ext);
            result[j] = exte;
            ext = exte;
            extents[i] = ext;
            changed = true;
          }
        }
        if (!changed && indexOfExtent(result, extents[i]) === -1) {
          result.push(extents[i]);
        }
      }
      result = finalcheckResult(result);
      return result;
    }


    /**
     * Récupére l'URL de l'atlas à utiliser depuis la configuration.
     *
     * @param {*} config Configurationde l'atlas à éditer.
     * @returns URL du service atlas
     */
    const atlasUrl = (config, atlasType) => {
      let properties = ['urlArea','urlLine','urlAtlas'];
      if (atlasType) {
        properties = [atlasType];
      }
      for (const prop of properties) {
        if (config[prop]) {
          return config[prop];
        }
      }
    };


    /**
     * Préparation des URLs, et des données du POST pour le job d'atlas surfacique.
     *
     * @param {*} params Description de la demnde utilisateur
     * @param {*} postData Paramétre en sortie : POST du job atlas
     * @returns URL de base et URL précise de l'atlas
     */
    const prepareAreaAtlas = (params,postData) => {
      const result = {};
      const polygonCoords = params.atlasEsri.areaGeometry.coordinates;
      const atlasGeometry = angular.copy(ESRI_POLYGON_TEMPLATE);
      if (params.atlasMode === 'esri') {
        // -- Ticket 3383 : La propriété “srid” est ajoutée et
        // -- n’est pas reconnue par le service en version 10.7 d'ArcGIS.
        // -- L’information du srid est à indiquée dans la propriété “wkid”.
        atlasGeometry.features[0].geometry.spatialReference.wkid = ESRI_POLYGON_TEMPLATE.srid;
        delete atlasGeometry.srid;
      }
      atlasGeometry.features[0].geometry.rings = polygonCoords;
      postData.inputExtent=JSON.stringify(atlasGeometry);
      result.serviceUrl = atlasUrl(params.esriConfig, 'urlArea');
      result.atlasUrl = result.serviceUrl + '/submitJob' + '/execute?f=json';
      postData.export=params.atlasEsri.area_export_type;
      return result;
    };


    /**
     * Préparation des URLs, et des données du POST pour le job d'atlas linéaire.
     *
     * @param {*} params Description de la demnde utilisateur
     * @param {*} postData Paramétre en sortie : POST du job atlas
     * @returns URL de base et URL précise de l'atlas
     */
    const prepareLineAtlas = (params,postData) => {
      const result = {};
      const lineCoords = params.atlasEsri.lineGeometry.coordinates;
      const atlasGeometry = angular.copy(ESRI_LINE_TEMPLATE);
      if (params.atlasMode === 'esri') {
        // -- Ticket 3480 : La propriété “srid” est ajoutée et
        // -- n’est pas reconnue par le service en version 10.7 d'ArcGIS.
        // -- L’information du srid est à indiquée dans la propriété “wkid”.
        atlasGeometry.features[0].geometry.spatialReference.wkid = ESRI_LINE_TEMPLATE.srid;
        delete atlasGeometry.srid;
      }
      atlasGeometry.features[0].geometry.paths = [lineCoords];
      postData.line = JSON.stringify(atlasGeometry);
      result.serviceUrl = atlasUrl(params.esriConfig, 'urlLine');
      result.atlasUrl = result.serviceUrl + '/submitJob/execute?f=json';
      postData.export=params.atlasEsri.line_export_type;
      return result;
    };


    /**
     * Préparation des URLs, et des données du POST pour le job d'atlas d'ArcGIS version >= 10.8.
     *
     * @param {*} params Description de la demnde utilisateur
     * @param {*} postData Paramétre en sortie : POST du job atlas
     * @returns URL de base et URL précise de l'atlas
     */
    const prepareAg108Atlas = (params,postData) => {
      const result = {};
      AtlasArcGIS108Service.setArcGIS108SpecialParameters(params.scope, postData,
        params.atlasResponse);
      if (params.esriConfig.urlAtlas) {
        result.serviceUrl = params.esriConfig.urlAtlas;
      }
      else {
        result.serviceUrl = params.esriConfig.urlArea;
      }
      result.atlasUrl = result.serviceUrl + '/submitJob/execute?f=json';
      if (params.atlasEsri.type === 'line') {
        postData.geometryType = 'line';
        postData.geometry = postData.line;
      }
      else {
        postData.geometryType = 'extent';
        postData.geometry = postData.inputExtent;
      }
      return result;
    };


    /**
     * Action d'alerte en cas d'échzc d'accés au service par l'URL configurée
     * pour l'atlas.
     *
     * @param {*} res
     * @param {*} params
     * @param {*} defer
     */
    const atlasUrlOnError = (res, params, defer) => {
      if (res && res.message) {
        require('toastr').error(res.message);
      }
      else {
        require('toastr').error($filter('translate')('tools.atlas.wrong_url'));
      }
      if (params.scope) {
        params.scope.jobsStatus = 'failed';
      }
      // -- Selon si l'appelant a besoin d'un appel asynchrone ou non
      if (defer) {
        defer.reject();
      }
    };


    const prepareActionForFile = (params, defer) => {
      if (params.atlasFunction) {
        params.actionForFile = params.atlasFunction;
        params.actionParams = params.atlasFunctionParams;
        if (params.needsToWaitAtlasFunction) {
          // -- Celui qui a demandé un atlas veut attendre
          // -- que la fonction qui exploite le résultat de la génération de l'atlas
          // -- soit terminée avant de faire la suite.
          // -- Cas de la DICT où 'état de la DICt est actualisée quand on joint les documents.
          params.actionParams.atlasFunctionDefer = defer;
        }
      }
      else {
        params.actionForFile = 'window.open';
      }
    };


    /**
     * Lancement de la construction de l'atlas ArcGIS
     * suite à clic utilisateur sur commande bleue (imprimante)
     * ou pour création automatique de plan pour une DICT.
     *
     * atlasEsri
     * esriConfig     Configuration pour utiliser l'atlas ArcGIS
     * mode           'esri' ou 'esri_108' pour connaître la version d'arcgis utilisée
     * scope4Messages
     */
    const submitAtlasEsri = (params) => {

      const postData = {};
      postData.title = params.atlasEsri.title;
      postData.description = params.atlasEsri.description;
      postData.template = params.atlasEsri.selectedTemplate.name;
      postData.gridScale = params.atlasEsri.gridScale;
      if (params.atlasEsri.queryDefinitions) {
        // -- Filtrage de couches sur objets répondant à un critére (utile pour DICT)
        postData.queryDefinitions = params.atlasEsri.queryDefinitions;
      }

      let defer;
      if (params.otherParams && params.otherParams.needsPromise) {
        defer = $q.defer();
        params.otherParams.promise = defer.promise;
      }

      let atlasInfo;
      if (params.atlasEsri.type === 'area' &&
          angular.isDefined(params.atlasEsri.areaGeometry)) {
        atlasInfo = prepareAreaAtlas(params,postData);
      }
      else if (params.atlasEsri.type === 'line' &&
          angular.isDefined(params.atlasEsri.lineGeometry)) {
        atlasInfo = prepareLineAtlas(params,postData);
      }
      if (params.atlasMode === 'esri_108') {
        atlasInfo = prepareAg108Atlas(params,postData);
      }
      if (angular.isDefined(atlasInfo.atlasUrl)) {
        if (params.atlasMode === 'esri') {
          // -- Mettre l'attente globale uniquement
          // -- quand on utilise le service d'atlas de la version avant ArcGIS 10.8
          gaDomUtils.showGlobalLoader();
        }
        $.post(atlasInfo.atlasUrl, postData).then((res) => {
          if (res.error) {
            atlasUrlOnError (res, params, defer);
          }
          else {
            if (params.scope) {
              params.scope.jobId = res.jobId;
            }
            else {
              params.jobid = res.jobId;
            }
            $timeout(() => {
              prepareActionForFile(params, defer);
              ArcGisJob.runEsriJob(params.scope, atlasInfo.serviceUrl, res, params)
                .then((jsonRes) => {
                  if (defer && !params.needsToWaitAtlasFunction) {
                    defer.resolve(jsonRes);
                  }
                }, () => {
                  if (defer && !params.needsToWaitAtlasFunction) {
                    defer.reject();
                  }
                }).finally(() => {
                  gaDomUtils.hideGlobalLoader();
                  if (params.scope.buildingAtlas) {
                    params.scope.buildingAtlas = false;
                  }
                });
            }, 500);
          }
        }, (res) => {
          atlasUrlOnError (res, params, defer);
        }
        );
      }
    };


    return {
      setTiles: setTiles,
      getTiles: getTiles,
      setMap: setMap,
      getMap: getMap,
      getPixelsFromExtent: getPixelsFromExtent,
      getPixelsFromCoordinates: getPixelsFromCoordinates,
      penteLine: penteLine,
      calculateRest: calculateRest,
      calculateAngle: calculateAngle,
      calculatePoints: calculatePoints,
      rotatePoint: rotatePoint,
      getfeaturesListInExtent: getfeaturesListInExtent,
      getfeaturesListInExtentForConfig: getfeaturesListInExtentForConfig,
      calculateFullSize: calculateFullSize,
      mapBlock: mapBlock,
      textBlock: textBlock,
      createItems: createItems,
      getUniqueLayers: getUniqueLayers,
      global: global,
      setTilesFromSelection: setTilesFromSelection,
      simplifyExtents: simplifyExtents,
      indexOfExtent: indexOfExtent,
      submitAtlasEsri
    };
  };
  AtlasService.$inject = ['$rootScope', '$q', 'ogcFactory', 'gaDomUtils', '$timeout',
    'ArcGisJob', 'AtlasArcGIS108Service', '$filter'];
  return AtlasService;
});
