'use strict';
define(function() {
  var gcabout = function(ConfigFactory, gcPopup, $translate) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/about/views/gcabout.html',

      restrict: 'A',
      link: function(scope, element, attrs, ctrl) {
        scope.showConfig = false;
        //scope.mode = localStorage.mode;

        scope.aboutConfig = {};

        ConfigFactory.get('about', 'aboutConfig').then(function(res) {
          var data = res.data;
          scope.aboutConfig.imageUrl = data.imageUrl;
          scope.aboutConfig.text1 = data.text1;
          scope.aboutConfig.text2 = data.text2;
        });

        scope.openAboutConfigPopUp = function() {
          scope.showConfig = true;
        };

        scope.saveAboutConfig = function() {
          ConfigFactory.add(scope.aboutConfig, 'about', 'aboutConfig').then(
            function(res) {
              scope.showConfig = false;
              if (res.data == 'true')
                $translate('about.configurationSaveSuccessMsg').then(function(
                  res
                ) {
                  require('toastr').success(res);
                });
              else
                $translate('about.configurationSaveErrorMsg').then(function(
                  res
                ) {
                  require('toastr').error(res);
                });
            }
          );
        };

        scope.cancelEditConfig = function() {
          scope.showConfig = false;
        };
      },
    };
  };

  gcabout.$inject = ['ConfigFactory', 'gcPopup', '$translate'];
  return gcabout;
});
