'use strict';
define(function() {
  var IndigauAppFactory = function(
    $rootScope,
    HpoAppFactory,
    IndigauAppFactory,
    InitProvider,
    CarteInitProvider
  ) {
    function getAppFactory() {
      if ($rootScope.xgos && $rootScope.xgos.sector === 'hpo')
        return HpoAppFactory;
      else {
        return IndigauAppFactory;
      }
    }

    function getInitProvider() {
      if ($rootScope.xgos && $rootScope.xgos.sector === 'hpo')
        return InitProvider;
      else {
        return CarteInitProvider;
      }
    }

    return {
      getAppFactory: getAppFactory,
      getInitProvider: getInitProvider,
    };
  };
  IndigauAppFactory.$inject = [
    '$rootScope',
    'HpoAppFactory',
    'IndigauAppFactory',
    'InitProvider',
    'CarteInitProvider',
  ];
  return IndigauAppFactory;
});
