'use strict';
define(function() {
  const refreshRerau = function (
    itvSoumFactory,
    $timeout,
    processFactory,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/widgets/indigauapp/home_admin_data/views/directives/refreshRerau.html',
      restrict: 'EA',
      scope: {},
      link: function(scope) {
        let arcgisConf;
        let indigauEngine = false;
        itvSoumFactory.getConf('indigauItvCfg').then(conf => {
          indigauEngine= conf.config.useIndigauEngine;
          arcgisConf = itvSoumFactory.arcgisConfToUrl(conf);
        });
        function checkRefreshProgression() {
          processFactory
            .getProcessByUid(scope.refreshProcesUid)
            .then(function(res) {
              if (res.data) {
                scope.refreshState = res.data.etat;
                switch (res.data.etat) {
                  case 'RUNNING':
                    scope.pbPercent = res.data.progress + '%';
                    scope.pipeCount = res.data.count;
                    $timeout(checkRefreshProgression, 1500);
                    break;
                  case 'FAILED':
                    swal({
                      title: $filter('translate')(
                        'indigau.itv.refreshrerau.failed'
                      ),
                      text: res.data.errorMessage,
                      type: 'error',
                    });
                    break;
                  case 'INTERRUPTED':
                    swal({
                      title: $filter('translate')(
                        'indigau.itv.refreshrerau.interrupted'
                      ),
                      text: '',
                      type: 'success',
                    });
                    break;
                  case 'FINISHED':
                    scope.pbPercent = '100%';
                    scope.pipeCount = res.data.count;
                    swal({
                      title: $filter('translate')(
                        'indigau.itv.refreshrerau.finished'
                      ),
                      text: '',
                      type: 'success',
                    });
                    break;
                }
              }
            });
        }

        function init() {
          scope.pbPercent = '0%';
          processFactory
            .getProcessByType('refresh indigau scores')
            .then(function(res) {
              if (res.data) {
                for (let ind = 0; ind < res.data.length; ind++) {
                  if (
                    res.data[ind].type == 'refresh indigau scores' &&
                    res.data[ind].etat == 'RUNNING'
                  ) {
                    //-- Un rafraichissement est en cours,
                    //-- il ne faut pas en lancer 2 en même temps.
                    scope.refreshState = 'RUNNING';
                    scope.refreshProcesUid = res.data[ind].uid;
                    checkRefreshProgression();
                    break;
                  }
                }
              }
            });
        }

        scope.refreshRerau = function() {
          itvSoumFactory.refreshRerau('', indigauEngine, arcgisConf)
            .then((res) => {
              if (res.data.etat == 'fini') {
                scope.refreshState = 'RUNNING';
                scope.refreshProcesUid = res.data.objValeur.uid;
                checkRefreshProgression();
              }
              else if (res.data.etat == 'erreur') {
                swal({
                  title: $filter('translate')(
                    'indigau.itv.refreshrerau.' + res.data.errorList[0].message_kis
                  ),
                  text: res.data.errorMessage,
                  type: 'error',
                });
              }
            });
        };

        scope.interruptRefresh = function() {
          itvSoumFactory.interruptRefresh(scope.refreshProcesUid);
        };

        init();
      },
    };
  };

  refreshRerau.$inject = [ 'itvSoumFactory', '$timeout', 'processFactory',
    '$filter',
  ];
  return refreshRerau;
});
