'use strict';
define(function() {
  var modelSelectDataHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    EditFactory,
    $rootScope,
    $filter,
    ngDialog,
    $timeout,
    ParametersFactory,
    gaDomUtils,
    HpoAppServices,
    ImportExportFactory,
    HpoAppModelServices,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/model/views/directives/utilities/model_select_data_hpo.html',
      restrict: 'EA',
      scope: {
        ftiuid: '=',
        currentModel: '=?',
        identifiant: '=?',
        disabledAll: '=?',
        selectionMode: '=?',
        ftihistory: '=?',
        ftijeudonnee: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.getExistingJeu = function() {
          gaDomUtils.showGlobalLoader();
          QueryFactory.data(
            scope.ftiuid,
            scope.where || '1=1',
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res.data && res.data.features) {
                scope.existingModels = res.data.features;
                if (!scope.selectionMode) {
                  if (
                    scope.currentModel.selectedjeu &&
                    scope.currentModel.selectedjeu.IDENTIFIANT
                  ) {
                    scope.existingModels.map(function(x) {
                      if (
                        x &&
                        x.properties &&
                        x.properties.IDENTIFIANT &&
                        x.properties.IDENTIFIANT ===
                          scope.currentModel.selectedjeu.IDENTIFIANT
                      ) {
                        scope.currentModel.selectedjeu = x.properties;
                        scope.currentModel.idjeu = x.id;
                      }
                    });
                  }
                } else {
                  if (
                    scope.currentModel.info &&
                    scope.currentModel.info.IDENTIFIANT
                  ) {
                    scope.existingModels.map(function(x) {
                      if (
                        x &&
                        x.properties &&
                        x.properties.IDENTIFIANT &&
                        x.properties.IDENTIFIANT ===
                          scope.currentModel.info.IDENTIFIANT
                      ) {
                        scope.currentModel.info = x.properties;
                        scope.currentModel.idmodel = x.id;
                      }
                    });
                  }
                }
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        scope.getExistingJeu();

        if (!scope.selectionMode) {
          scope.currentModel.getExistingJeu = scope.getExistingJeu;
          scope.$watch('identifiant', function(newval) {
            if (newval) {
              var idx = scope.existingModels
                .map(function(x) {
                  return x.properties.IDENTIFIANT;
                })
                .indexOf(newval);
              if (~idx) {
                scope.currentModel.selectedjeu =
                  scope.existingModels[idx].properties;
                scope.currentModel.idjeu = scope.existingModels[idx].id;
              }
            }
          });

          scope.$watch('currentModel', function(newval) {
            if (
              newval &&
              scope.existingModels &&
              newval.selectedjeu &&
              newval.selectedjeu.IDENTIFIANT
            ) {
              var idx = scope.existingModels
                .map(function(x) {
                  return x.properties.IDENTIFIANT;
                })
                .indexOf(newval.selectedjeu.IDENTIFIANT);
              if (~idx) {
                scope.currentModel.selectedjeu =
                  scope.existingModels[idx].properties;
                scope.currentModel.idjeu = scope.existingModels[idx].id;
              }
            }
          });
        } else {
          scope.$watch('currentModel.info', function(newval) {
            if (newval) {
              gaDomUtils.showGlobalLoader();
              HpoAppModelServices.getModel(
                scope.ftihistory.uid,
                newval.IDENTIFIANT,
                scope.ftijeudonnee.uid
              ).then(
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  if (res && res.data) {
                    Object.keys(res.data).map(function(key) {
                      if (
                        angular.isUndefined(res.data[key]) ||
                        res.data[key] === null
                      )
                        delete res.data[key];
                    });
                    Object.assign(scope.currentModel, res.data);
                    if (
                      scope.currentModel.info &&
                      scope.currentModel.info.IDENTIFIANT
                    ) {
                      scope.existingModels.map(function(x) {
                        if (
                          x &&
                          x.properties &&
                          x.properties.IDENTIFIANT &&
                          x.properties.IDENTIFIANT ===
                            scope.currentModel.info.IDENTIFIANT
                        ) {
                          scope.currentModel.info = x.properties;
                          scope.currentModel.idmodel = x.id;
                        }
                      });
                    }
                  } else {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          });
        }
      },
    };
  };

  modelSelectDataHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'EditFactory',
    '$rootScope',
    '$filter',
    'ngDialog',
    '$timeout',
    'ParametersFactory',
    'gaDomUtils',
    'HpoAppServices',
    'ImportExportFactory',
    'HpoAppModelServices',
    'QueryFactory',
  ];
  return modelSelectDataHpo;
});
