'use strict';
define(function() {
  var modelSurvieHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    HpoAppModelServices,
    gaDomUtils,
    QueryFactory,
    InitProvider,
    EditFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/model/views/directives/model/model_survie_hpo.html',
      restrict: 'EA',
      scope: {
        model: '=?',
        uniqueElement: '=?',
        selectionMode: '=?',
        inverseOrder: '=?',
        isCalage: '=?'
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        scope.ftihistoryattributes = scope.ftihistory.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftihistory.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftihistory.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftihistory.name
                ))
            )
              return x;
          }
        );
        scope.ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        scope.ftijeudonneeattributes = scope.ftijeudonnee.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftijeudonnee.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftijeudonnee.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftijeudonnee.name
                ))
            )
              return x;
          }
        );

        scope.fticalage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage'
        )[0];
        scope.ftivalidation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'validation'
        )[0];
        scope.ftiprevsion = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];

        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoModelSurvieConfig' +
          scope.ftihistory.uid;
        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';
        scope.propertiestoexclude = {};
        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.currentModel = dataHpo.savedata;
          }
        };

        scope.tabs = [
          {
            title: 'hpo.model.choice.informations',
          },
          {
            title: 'hpo.model.choice.historic',
          },
        ];
        scope.tabs.activeTab = 0;

        /**
         * Historique des modèles
         * @type {Array}
         */
        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';

        scope.currentheight = ($window.innerHeight * 1.2) / 2 + 'px';

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ];

        var setCalageConfig = function() {
          scope.newTabs = [
            {
              title: 'hpo.model.choice.infos',
            },
            {
              title: 'hpo.model.calage.historicassoc',
            },
            {
              title: 'hpo.model.validation.historicassoc',
            },
            {
              title: 'hpo.model.prevision.historicassoc',
            },
          ];
          scope.newTabs.activeTab = 0;
        };

        scope.editModel = function(obj) {
          if (obj) {
            gaDomUtils.showGlobalLoader();
            HpoAppModelServices.getModel(
              scope.ftihistory.uid,
              obj.properties.IDENTIFIANT,
              scope.ftijeudonnee.uid
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.newCurrentModel = res.data;
                  scope.newCurrentModel.filter =
                    '"IDENTIFIANT_MODELE" = \'' +
                    scope.newCurrentModel.identifiant +
                    "'";
                  setCalageConfig();
                  var dialog = ngDialog.openConfirm({
                    template:
                      'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.choice.update.html',
                    className:
                      'ngdialog-theme-plain width1100 nopadding miniclose',
                    scope: scope,
                  });
                  dialog.then(function(data) {
                    if (data) {
                      console.log(data);
                      gaDomUtils.showGlobalLoader();
                      HpoAppModelServices.updateModel(data).then(
                        function(res) {
                          try {
                            if (res.data && res.status) {
                              AlertHpoFactory.getSimpleSuccess(
                                $filter('translate')(
                                  'hpo.data.exchange.succes'
                                ),
                                $filter('translate')(
                                  'hpo.model.choice.successupdate'
                                ),
                                true
                              );
                              $rootScope.$broadcast(
                                'reloadDatatable',
                                scope.ftihistory.uid
                              );
                              getExistingNames();
                              scope.emptyModel();
                            } else {
                              AlertHpoFactory.showErrorMessage(res);
                            }
                          } catch (e) {
                            console.error(e.stack);
                          }
                          gaDomUtils.hideGlobalLoader();
                        },
                        function(res) {
                          gaDomUtils.hideGlobalLoader();
                          AlertHpoFactory.showErrorMessage(res);
                        }
                      );
                    }
                  });
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.refreshData = function() {
          $rootScope.$broadcast('reloadDatatable', scope.ftihistory.uid);
        };

        scope.datatableModeleCrudHpo = {
          update: { func: scope.editModel },
          remove: true,
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-left',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        /**
         * Création d'un nouveau modèle
         * @type {Array}
         */
        scope.emptyModel = function(btn) {
          if (!btn) {
            scope.currentModel = scope.model || {
              result: {},
              ftiuid: scope.ftihistory.uid,
              ftiuidjeu: scope.ftijeudonnee.uid,
              useexisting: 'yes',
            };
          } else {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.currentModel = scope.model || {
                  result: {},
                  ftiuid: scope.ftihistory.uid,
                  ftiuidjeu: scope.ftijeudonnee.uid,
                  useexisting: 'yes',
                };
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.model.choice.empty') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };
        scope.emptyModel(false);

        scope.$watch('model', function(newval) {
          if (newval) {
            scope.currentModel = newval;
          }
        });

        scope.existingNames = [];
        var getExistingNames = function() {
          gaDomUtils.showGlobalLoader();
          var where = '';
          if (scope.currentModel && scope.currentModel.name)
            where += ' NOT ("NOM" = \'' + scope.currentModel.name + "')";
          QueryFactory.dataattributeCorrectedDate(
            scope.ftihistory.uid,
            'NOM',
            where
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res && res.data) {
                scope.existingNames = res.data;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        getExistingNames();

        var keys = [
          'name',
          'range',
          'dateobsstartfail',
          'dateendobsfail',
        ];
        var keysjeu = ['namedata'];
        scope.disableAnalyseButton = function(currentModel) {
          if (!currentModel) return true;

          if (
            scope.currentModel &&
            scope.currentModel.name &&
            scope.existingNames &&
            scope.existingNames.length > 0 &&
            scope.existingNames.indexOf(currentModel.name) !== -1
          ) {
            return true;
          }

          var noexists = false;
          for (var i = 0; i < keys.length; i++) {
            if (!currentModel.hasOwnProperty(keys[i])) {
              noexists = true;
              break;
            }
          }
          if (currentModel.useexisting === 'no') {
            for (var i = 0; i < keysjeu.length; i++) {
              if (!currentModel.hasOwnProperty(keysjeu[i])) {
                noexists = true;
                break;
              }
            }
          } else {
            if (!currentModel.selectedjeu) noexists = true;
          }

          if (
            currentModel.dateobsstartfail &&
            currentModel.dateendobsfail
          ) {
            var dateobsstartfail = new Date(currentModel.dateobsstartfail);
            var dateendobsfail = new Date(currentModel.dateendobsfail);
            if (dateendobsfail < dateobsstartfail) return true;
          } else {
            return true;
          }

          return noexists;
        };

        /**
         * Jeu de données
         * @type {Array}
         */
        scope.ftis = [];
        scope.ftisdefail = [];
        scope.ftis_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid'
        );
        scope.ftisnodefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid_no_defail'
        );
        scope.ftisdefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid_defail'
        );

        var ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
        for (var i = 0; i < ftis.length; i++) {
          var fti = ftis[i];
          if (!HpoCarteAppFactory.getAppFactory().getFuiteTables(fti)) {
            scope.ftis.push(fti);
            var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
              fti
            );
            var idx = ftis
              .map(function(x) {
                return x.uid;
              })
              .indexOf(ftidefailuid);
            if (idx !== -1) scope.ftisdefail.push(ftis[idx]);
          }
        }
        scope.modes = HpoCarteAppFactory.getAppFactory().getHpoFilterModes(
          true
        );

        /**
         * Create new model func
         * @type {Array}
         */
        scope.createNewModel = function() {
          console.log(scope.currentModel);
          gaDomUtils.showGlobalLoader();
          HpoAppModelServices.createNewModel(scope.currentModel).then(
            function(res) {
              try {
                if (res.data && res.status) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')('hpo.model.choice.success'),
                    true
                  );
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.ftihistory.uid
                  );
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.ftijeudonnee.uid
                  );
                  $rootScope.$broadcast('inititaliseApplicationBranch');
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                console.error(e.stack);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.$on('changedHpoValue', function(evt, arg) {
          if (arg && arg.clauseWhere && arg.operands) {
            scope.currentModel.result = {
              clauseWhere: arg.clauseWhere,
              operands: arg.operands,
            };
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('hpo.common.success'),
              $filter('translate')('hpo.data.validation.getsuccess'),
              false
            );
          }
        });

        scope.$watch('currentModel.useexisting', function(newval, oldval) {
          if (newval && newval === 'yes' && scope.currentModel.getExistingJeu)
            scope.currentModel.getExistingJeu();
          if (oldval && newval && newval !== oldval) {
            if (scope.currentModel.hasOwnProperty('namedata'))
              delete scope.currentModel['namedata'];
            if (scope.currentModel.hasOwnProperty('commentairedata'))
              delete scope.currentModel['commentairedata'];
            scope.currentModel.result = {};
            if (scope.currentModel.hasOwnProperty('ftidefail'))
              delete scope.currentModel['ftidefail'];
            if (scope.currentModel.hasOwnProperty('fti'))
              delete scope.currentModel['fti'];
            if (scope.currentModel.hasOwnProperty('ftidefail'))
              delete scope.currentModel['ftidefail'];
            if (scope.currentModel.hasOwnProperty('selectedjeu'))
              delete scope.currentModel['selectedjeu'];
            if (scope.currentModel.hasOwnProperty('identifiantdata'))
              delete scope.currentModel['identifiantdata'];
          }
        });

        scope.setStartcurrentModel = function() {};

        /**
         * Récupération de la valeur min ou max des fuites
         * @type {Array}
         */
        scope.getDateValue = function(extreme) {
          var sendata = {
            useexisting: scope.currentModel.useexisting,
            fti: scope.currentModel.fti?scope.currentModel.fti:scope.currentModel.selectedjeu.UID_TABLE_DONNEE,
            ftidefail: scope.currentModel.ftidefail?scope.currentModel.ftidefail:scope.currentModel.selectedjeu.UID_TABLE_FUITE,
            where:
              scope.currentModel.result && scope.currentModel.result.clauseWhere
                ? scope.currentModel.result.clauseWhere
                : '',
            config: HpoCarteAppFactory.getInitProvider().getHpoConfig(),
            extreme: extreme,
          };
          gaDomUtils.showGlobalLoader();
          HpoAppModelServices.getJeuValueDate(
            sendata,
            scope.currentModel.selectedjeu &&
              scope.currentModel.selectedjeu.IDENTIFIANT
              ? scope.currentModel.selectedjeu.IDENTIFIANT
              : '',
                scope.currentModel.selectedjeu &&
                scope.currentModel.selectedjeu.TABLE_FUITE
                ? scope.currentModel.selectedjeu.TABLE_FUITE
                : ''
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res.data) {
                switch (extreme) {
                  case 'min':
                    scope.currentModel.dateobsstartfail = HpoCarteAppFactory.getAppFactory().formatDate(
                      res.data
                    );
                    break;
                  case 'max':
                    scope.currentModel.dateendobsfail = HpoCarteAppFactory.getAppFactory().formatDate(
                      res.data
                    );
                    break;
                  default:
                    break;
                }
                require('toastr').success(
                  $filter('translate')('hpo.common.valueget')
                );
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        /**
         * Disable get min max date dépend des données de fuites
         * @type {Array}
         */
        scope.disbaledGetDate = function() {
          if (scope.currentModel.useexisting === 'yes') {
            if (scope.currentModel.selectedjeu) {
              return false;
            } else {
              return true;
            }
          } else {
            if (scope.currentModel.fti && scope.currentModel.ftidefail) {
              return false;
            } else {
              return true;
            }
          }
        };

        scope.postRemove = function(resultat) {
          let identifiants = resultat
            .map(function(x) {
              return x.properties.IDENTIFIANT;
            })
            .join("','");
            HpoCarteAppFactory.getAppFactory().checkDeleteCalageValidation(identifiants);
            $rootScope.$broadcast('inititaliseApplicationBranch');
        };
      },
    };
  };

  modelSurvieHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'HpoAppModelServices',
    'gaDomUtils',
    'QueryFactory',
    'InitProvider',
    'EditFactory',
  ];
  return modelSurvieHpo;
});
