'use strict';
define(function() {
  var modelPrevisionHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    HpoAppModelServices,
    gaDomUtils,
    QueryFactory,
    InitProvider,
    EditFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/model/views/directives/model/model_prevision_hpo.html',
      restrict: 'EA',
      scope: {
        model: '=?',
        uniqueElement: '=?',
        whereFilter: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.hpoSimplifyVisualize = scope.$parent.$parent.hpoSimplifyVisualize;
        scope.ended = false;
        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        scope.ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        scope.fticalage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage'
        )[0];
        scope.ftivalidation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'validation'
        )[0];
        scope.ftiprevision = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];
        scope.ftiprevisionattributes = scope.ftiprevision.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftiprevision.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftiprevision.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftiprevision.name
                ))
            )
              return x;
          }
        );

        scope.translateFtiAttributes = HpoCarteAppFactory.getAppFactory().getTranslateAttributes(
          scope.ftiprevision.name
        );
        scope.hideFilter = Object.keys(scope.translateFtiAttributes);

        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoModelPrevisionConfig' +
          scope.ftiprevision.uid;
        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';
        scope.propertiestoexclude = {};
        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.currentModel = dataHpo.savedata;
          }
        };

        scope.tabs = [
          {
            title: 'hpo.model.prevision.informations',
          },
          {
            title: 'hpo.model.prevision.historic',
          },
        ];
        scope.tabs.activeTab = angular.isDefined(scope.whereFilter) ? 1 : 0;
        if (angular.isDefined(scope.whereFilter)) scope.hideList = true;

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'search', attributes: { 'aria-hidden': 'true' } },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ];

        scope.existingNames = [];
        var getExistingNames = function() {
          gaDomUtils.showGlobalLoader();
          var where = '';
          if (scope.currentModel && scope.currentModel.nameprevision)
            where +=
              ' NOT ("NOM_PREVISION" = \'' + scope.currentModel.nameprevision + "')";
          QueryFactory.dataattributeCorrectedDate(
            scope.ftiprevision.uid,
            'NOM_PREVISION',
            where
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res && res.data) {
                scope.existingNames = res.data;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        getExistingNames();

        scope.editPrevision = function(obj) {
          if (obj) {
            gaDomUtils.showGlobalLoader();
            HpoAppModelServices.getPrevision(
              scope.ftiprevision.uid,
              obj.properties.IDENTIFIANT,
              obj.properties.IDENTIFIANT_MODELE,
              obj.properties.IDENTIFIANT_CALAGE,
              scope.ftijeudonnee.uid,
              scope.ftihistory.uid,
              scope.fticalage.uid
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.newCurrentModel = HpoCarteAppFactory.getAppFactory().updateFtiWithAttributs(res.data, ['MATAGE','JENKS']);
                  if(scope.hpoSimplifyVisualize){
                    scope.newCurrentModel.fti.attributes = scope.newCurrentModel.fti.attributes.filter(
                    function(x){
                      if(x.name.indexOf("_cox") == -1) return x
                    })
                  }
                  if (
                    scope.newCurrentModel &&
                    scope.newCurrentModel.status &&
                    scope.newCurrentModel.status !== 'FINISHED'
                  ) {
                    switch (scope.newCurrentModel.status) {
                      case 'FAILED':
                        scope.newCurrentModel.message =
                          $filter('translate')('hpo.model.calage.failed') +
                          ' ' +
                          scope.newCurrentModel.step +
                          '. ' +
                          $filter('translate')('hpo.model.calage.reason') +
                          ' ' +
                          scope.newCurrentModel.raison;
                        break;
                      case 'RUNNING':
                        scope.newCurrentModel.message = $filter('translate')(
                          'hpo.model.calage.running'
                        );
                        break;
                    }
                  } else {
                    scope.tableName = HpoCarteAppFactory.getAppFactory().getPrevisionTableName(
                      scope.newCurrentModel.identifiantcalage,
                      scope.newCurrentModel.identifiantprevision
                    );
                    scope.newCurrentModel.duree = HpoCarteAppFactory.getAppFactory().differenceDates(
                      scope.newCurrentModel.datestartsimulation,
                      scope.newCurrentModel.dateendsimulation
                    );
                  }
                  var dialog = ngDialog.open({
                    template:
                      'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.prevision.info.html',
                    className:
                      'ngdialog-theme-plain width1100 nopadding miniclose',
                    scope: scope,
                  });
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';

        scope.refreshData = function() {
          $rootScope.$broadcast('reloadDatatable', scope.ftiprevision.uid);
        };

        scope.datatableCalageCrudHpo = {
          update: { func: scope.editPrevision },
          remove: true,
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-left',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        /**
         * Création d'un nouveau modèle
         * @type {Array}
         */
        scope.emptyModel = function(btn) {
          if (!btn) {
            scope.currentModel = scope.model || {
              fticalageuid: scope.fticalage.uid,
              ftivalidationuid: scope.ftivalidation.uid,
              ftiprevisionuid: scope.ftiprevision.uid,
              fticalagename: scope.fticalage.name,
              ftivalidationname: scope.ftivalidation.name,
              ftiprevisionname: scope.ftiprevision.name,
            };
            scope.information = {};
          } else {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.currentModel = scope.model || {
                  fticalageuid: scope.fticalage.uid,
                  ftivalidationuid: scope.ftivalidation.uid,
                  ftiprevisionuid: scope.ftiprevision.uid,
                  fticalagename: scope.fticalage.name,
                  ftivalidationname: scope.ftivalidation.name,
                  ftiprevisionname: scope.ftiprevision.name,
                };
                scope.information = {};
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.model.choice.empty') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };
        scope.emptyModel(false);

        var keys = [
          'name',
          'namedata',
          'namecalage',
          'nameprevision',
          'fti',
          'ftidefail',
          'dateprevisionstart',
          'dateprevisionend',
        ];
        scope.disableAnalyseButton = function(currentModel) {
          if (!currentModel) return true;

          if (
            scope.currentModel &&
            scope.currentModel.nameprevision &&
            scope.existingNames &&
            scope.existingNames.length > 0 &&
            scope.existingNames.indexOf(currentModel.nameprevision) !== -1
          ) {
            return true;
          }

          var noexists = false;
          for (var i = 0; i < keys.length; i++) {
            if (
              !currentModel.hasOwnProperty(keys[i]) ||
              !currentModel[keys[i]]
            ) {
              noexists = true;
              break;
            }
          }
          return noexists;
        };

        scope.startPrevision = function() {
          console.log(scope.currentModel);
          var model = angular.copy(scope.currentModel);
          delete model.editTypeList;
          delete model.selectedjeu;
          delete model.info;
          model.config = HpoCarteAppFactory.getInitProvider().getHpoConfig();
          gaDomUtils.showGlobalLoader();
          model.createUser = $rootScope.xgos.user.login
          HpoAppModelServices.createPrevision(model).then(
            function(res) {
              try {
                if (res.data && res.status) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')('hpo.model.prevision.success'),
                    true
                  );
                  $rootScope.$broadcast('inititaliseApplicationBranch');
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                console.error(e.stack);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.getExistingCalage = function() {
          gaDomUtils.showGlobalLoader();
          QueryFactory.data(
            scope.fticalage.uid,
            '"IDENTIFIANT_MODELE" = \'' +
              scope.currentModel.identifiant +
              '\' AND "STATUS" = \'FINISHED\' AND "FINALISER" = TRUE',
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res.data && res.data.features) {
                scope.temp_calage = {};
                scope.existingCalage = res.data.features;
                if (
                  scope.currentModel &&
                  scope.currentModel.identifiantcalage &&
                  (!scope.temp_calage ||
                    !scope.temp_calage.properties ||
                    !scope.temp_calage.properties.IDENTIFIANT)
                ) {
                  var idx = scope.existingCalage
                    .map(function(x) {
                      if (x && x.properties && x.properties.IDENTIFIANT)
                        return x.properties.IDENTIFIANT;
                    })
                    .indexOf(scope.currentModel.identifiantcalage);
                  if (~idx) scope.temp_calage = scope.existingCalage[idx];
                }
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.temp_calage = {};
        scope.$watch('currentModel.identifiant', function(newval) {
          if (newval) {
            scope.temp_calage = {};
            scope.getExistingCalage();
          }
        });
        scope.$watch('temp_calage.properties.IDENTIFIANT', function(newval) {
          if (newval) {
            scope.currentModel.namecalage = scope.temp_calage.properties.NOM;
            scope.currentModel.commentairecalage =
              scope.temp_calage.properties.COMMENTAIRE;
            scope.currentModel.identifiantcalage =
              scope.temp_calage.properties.IDENTIFIANT;
            scope.currentModel.idcalage = scope.temp_calage.id;
          }
        });

        scope.redoPrevision = function(obj) {
          if (obj) {
            var callback = function(confirmed) {
              if (confirmed) {
                gaDomUtils.showGlobalLoader();
                HpoAppModelServices.getPrevision(
                  scope.ftiprevision.uid,
                  obj.properties.IDENTIFIANT,
                  obj.properties.IDENTIFIANT_MODELE,
                  obj.properties.IDENTIFIANT_CALAGE,
                  scope.ftijeudonnee.uid,
                  scope.ftihistory.uid,
                  scope.fticalage.uid,
                  true,
                  $rootScope.xgos.user.login
                ).then(
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    if (res.data && res.status) {
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.data.exchange.succes'),
                        $filter('translate')('hpo.model.prevision.success'),
                        true
                      );
                      scope.emptyModel();
                      $timeout(function() {
                        $rootScope.$broadcast(
                          'reloadDatatable',
                          scope.ftiprevision.uid
                        );
                        getExistingNames();
                      }, 1000);
                    } else {
                      AlertHpoFactory.showErrorMessage(res);
                    }
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            };
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              $filter('translate')('hpo.model.prevision.confirm_rerun'),
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };

        scope.dataVisPrevision = (obj) => {
          scope.objValidationPrevision = obj;
          scope.typeDataVis = "prevision";
          ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.validation.prevision.statistique.html',
            className:
              'ngdialog-theme-plain width100 nopadding miniclose',
            scope: scope,
          });
        }

        scope.buttonSpecialActions = [
          {
            class: 'btn btn-success btn-xs',
            icone: 'fa fa-play',
            text: $filter('translate')('hpo.model.calage.rerun'),
            callFunction: scope.redoPrevision,
            disableFunc: function(obj) {
              if (
                !obj ||
                !obj.properties ||
                !obj.properties.STATUS ||
                obj.properties.STATUS === 'RUNNING'
              )
                return true;
              else return false;
            },
          },
          {
            class: 'btn btn-primary btn-xs',
            icone: 'fa fa-bar-chart',
            text: $filter('translate')('hpo.admin.dashBoardAutomatique.dataVis'),
            callFunction: scope.dataVisPrevision,
            disableFunc: function (obj) {
              if (
                !obj ||
                !obj.properties ||
                !obj.properties.STATUS ||
                obj.properties.STATUS === 'RUNNING'
              )
                return true;
              else return false;
            },
          }
        ];
        scope.ended = true;

        scope.finaliserStep = function(newCurrentModel) {
          var where = " IN ('" + newCurrentModel.idprevision + "') ";
          gaDomUtils.showGlobalLoader();
          EditFactory.updatebyfilter(
            scope.ftiprevision.uid,
            where,
            'FINALISER',
            'boolean',
            true
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              newCurrentModel.finaliser = true;
              AlertHpoFactory.successUpdate();
              $rootScope.$broadcast('reloadDatatable', scope.ftiprevision.uid);
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.postRemove = function(resultat) {
          let identifiants = resultat
            .map(function(x) {
              return x.properties.IDENTIFIANT;
            })
            .join("','");
            HpoCarteAppFactory.getAppFactory().checkDeleteChantierAutomatique(identifiants);
            $rootScope.$broadcast('inititaliseApplicationBranch');
        };

      },
    };
  };

  modelPrevisionHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'HpoAppModelServices',
    'gaDomUtils',
    'QueryFactory',
    'InitProvider',
    'EditFactory',
  ];
  return modelPrevisionHpo;
});
