'use strict';
define(function() {
  var modelCalageHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    HpoAppModelServices,
    gaDomUtils,
    QueryFactory,
    InitProvider,
    EditFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/model/views/directives/model/model_calage_hpo.html',
      restrict: 'EA',
      scope: {
        model: '=?',
        uniqueElement: '=?',
        whereFilter: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.hpoSimplifyVisualize = scope.$parent.$parent.hpoSimplifyVisualize;
        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        scope.ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        scope.fticalage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage'
        )[0];
        scope.fticalagesynthese = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage_synthese'
        )[0];
        scope.ftivalidation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'validation'
        )[0];
        scope.fticalageattributes = scope.fticalage.attributes.filter(function(
          x
        ) {
          if (
            x &&
            ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
              scope.fticalage.name
            ) &&
              HpoCarteAppFactory.getAppFactory()
                .getExcludedAttributes(scope.fticalage.name)
                .indexOf(x.name) === -1) ||
              !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.fticalage.name
              ))
          )
            return x;
        });
        scope.ftiprevsion = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];
        scope.translateFtiAttributes = HpoCarteAppFactory.getAppFactory().getTranslateAttributes(
          scope.fticalage.name
        );
        scope.hideFilter = Object.keys(scope.translateFtiAttributes);

        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoModelCalageConfig' +
          scope.fticalage.uid;
        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';
        scope.propertiestoexclude = {};
        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.currentModel = dataHpo.savedata;
          }
        };

        scope.tabs = [
          {
            title: 'hpo.model.calage.informations',
          },
          {
            title: 'hpo.model.calage.historic',
          },
        ];
        scope.tabs.activeTab = angular.isDefined(scope.whereFilter) ? 1 : 0;
        if (angular.isDefined(scope.whereFilter)) scope.hideList = true;

        scope.existingNames = [];
        var getExistingNames = function() {
          gaDomUtils.showGlobalLoader();
          var where = '';
          if (scope.currentModel && scope.currentModel.namecalage)
            where += ' NOT ("NOM" = \'' + scope.currentModel.namecalage + "')";
          QueryFactory.dataattributeCorrectedDate(
            scope.fticalage.uid,
            'NOM',
            where
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res && res.data) {
                scope.existingNames = res.data;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        getExistingNames();

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Visualisation du paramétrage',
            },
          },
        ];
        scope.editCalage = function(obj) {
          if (obj) {
            gaDomUtils.showGlobalLoader();
            HpoAppModelServices.getCalage(
              scope.fticalage.uid,
              obj.properties.IDENTIFIANT,
              obj.properties.IDENTIFIANT_MODELE,
              scope.ftijeudonnee.uid,
              scope.ftihistory.uid,
              scope.fticalagesynthese.uid,
              scope.ftivalidation.uid
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.newCurrentModel = res.data;
                  if (
                    scope.newCurrentModel &&
                    !scope.newCurrentModel.converged
                  ) {
                    switch (scope.newCurrentModel.status) {
                      case 'FAILED':
                        scope.newCurrentModel.message =
                          $filter('translate')('hpo.model.calage.failed') +
                          ' ' +
                          scope.newCurrentModel.step +
                          '. ' +
                          $filter('translate')('hpo.model.calage.reason') +
                          ' ' +
                          scope.newCurrentModel.raison;
                        break;
                      case 'RUNNING':
                        scope.newCurrentModel.message = $filter('translate')(
                          'hpo.model.calage.running'
                        );
                        break;
                    }
                    if(scope.newCurrentModel.datestartsimulation && scope.newCurrentModel.dateendsimulation){
                      scope.newCurrentModel.duree = HpoCarteAppFactory.getAppFactory().differenceDates(
                        scope.newCurrentModel.datestartsimulation,
                        scope.newCurrentModel.dateendsimulation
                      );
                    }
                  } else {
                    scope.newCurrentModel.duree = HpoCarteAppFactory.getAppFactory().differenceDates(
                      scope.newCurrentModel.datestartsimulation,
                      scope.newCurrentModel.dateendsimulation
                    );
                  }

                  var dialog = ngDialog.open({
                    template:
                      'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.calage.info.html',
                    className:
                      'ngdialog-theme-plain width1100 nopadding miniclose',
                    scope: scope,
                  });
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';

        scope.refreshData = function() {
          $rootScope.$broadcast('reloadDatatable', scope.fticalage.uid);
        };

        scope.datatableCalageCrudHpo = {
          update: { func: scope.editCalage },
          remove: true,
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-left',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        /**
         * Création d'un nouveau modèle
         * @type {Array}
         */
        scope.emptyModel = function(btn) {
          if (!btn) {
            scope.currentModel = scope.model || {
              fticalageuid: scope.fticalage.uid,
              ftivalidationuid: scope.ftivalidation.uid,
              fticalagesyntheseuid: scope.fticalagesynthese.uid,
              fticalagename: scope.fticalage.name,
              ftivalidationname: scope.ftivalidation.name,
              fticalagesynthesename: scope.fticalagesynthese.name,
            };
            scope.information = {};
          } else {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.currentModel = scope.model || {
                  fticalageuid: scope.fticalage.uid,
                  ftivalidationuid: scope.ftivalidation.uid,
                  fticalagesyntheseuid: scope.fticalagesynthese.uid,
                  fticalagename: scope.fticalage.name,
                  ftivalidationname: scope.ftivalidation.name,
                  fticalagesynthesename: scope.fticalagesynthese.name,
                };
                scope.information = {};
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.model.choice.empty') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };
        scope.emptyModel(false);

        scope.$watch('currentModel.selectedjeu.IDENTIFIANT', function(newval) {
          if (newval) {
            var obj = HpoCarteAppFactory.getAppFactory().getAttributesCalage(
              scope.currentModel.fti
            );
            scope.currentModel.editTypeList = scope.currentModel
              .editTypeList || {
              leftData: obj.available,
              leftDisplayAttribute: 'alias',
              rightData: obj.required,
              rightDisplayAttribute: 'alias',
              leftTitle: $filter('translate')(
                'hpo.model.calage.attributeavailable'
              ),
              rightTitle: $filter('translate')(
                'hpo.model.calage.attributetouse'
              ),
              source: 'left',
              disableDragFromRight: obj.required.map(function(x) {
                return x.name;
              }),
              keytocheck: 'name',
            };
            $timeout(function() {
              angular
                .element('.dualListBox .list')
                .height(angular.element('.contenu-hpo').height() - 50);
            }, 500);
          }
        });

        scope.addAllAttributes = function(i) {
          if (i) {
            scope.currentModel.editTypeList.rightData = scope.currentModel.editTypeList.rightData.concat(
              scope.currentModel.editTypeList.leftData
            );
            scope.currentModel.editTypeList.leftData = [];
          } else {
            var callback = function(confirmed) {
              if (confirmed) {
                var obj = HpoCarteAppFactory.getAppFactory().getAttributesCalage(
                  scope.currentModel.fti
                );
                scope.currentModel.editTypeList.leftData = obj.available;
                scope.currentModel.editTypeList.rightData = obj.required;
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              $filter('translate')('hpo.common.sur'),
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };

        var keys = [
          'name',
          'namedata',
          'namecalage',
          'fti',
          'ftidefail',
        ];
        scope.disableAnalyseButton = function(currentModel) {
          if (!currentModel) return true;

          if (
            scope.currentModel &&
            scope.currentModel.namecalage &&
            scope.existingNames &&
            scope.existingNames.length > 0 &&
            scope.existingNames.indexOf(currentModel.namecalage) !== -1
          ) {
            return true;
          }

          var noexists = false;
          for (var i = 0; i < keys.length; i++) {
            if (!currentModel.hasOwnProperty(keys[i])) {
              noexists = true;
              break;
            }
          }
          if (
            !currentModel ||
            !currentModel.editTypeList ||
            !currentModel.editTypeList.rightData ||
            currentModel.editTypeList.rightData.length === 0
          )
            noexists = true;
          return noexists;
        };

        scope.startCalage = function() {
          console.log(scope.currentModel);
          var model = angular.copy(scope.currentModel);
          model.attributs = model.editTypeList.rightData
            .map(function(x) {
              return x.name;
            })
            .join(',');
          if (!model.attributs) model.attributs = '';
          delete model.editTypeList;
          delete model.selectedjeu;
          delete model.info;
          model.config = HpoCarteAppFactory.getInitProvider().getHpoConfig();
          model.createUser = $rootScope.xgos.user.login
          gaDomUtils.showGlobalLoader();
          HpoAppModelServices.createCalage(model).then(
            function(res) {
              try {
                if (res.data && res.status) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')('hpo.model.calage.success'),
                    true
                  );
                  $rootScope.$broadcast('inititaliseApplicationBranch');
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                console.error(e.stack);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.redoCalage = function(obj) {
          if (obj) {
            var callback = function(confirmed) {
              if (confirmed) {
                gaDomUtils.showGlobalLoader();
                HpoAppModelServices.getCalage(
                  scope.fticalage.uid,
                  obj.properties.IDENTIFIANT,
                  obj.properties.IDENTIFIANT_MODELE,
                  scope.ftijeudonnee.uid,
                  scope.ftihistory.uid,
                  scope.fticalagesynthese.uid,
                  scope.ftivalidation.uid,
                  true,
                  $rootScope.xgos.user.login
                ).then(
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    if (res.data && res.status) {
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.data.exchange.succes'),
                        $filter('translate')('hpo.model.calage.success'),
                        true
                      );
                      scope.emptyModel();
                      $timeout(function() {
                        $rootScope.$broadcast(
                          'reloadDatatable',
                          scope.fticalage.uid
                        );
                        getExistingNames();
                      }, 1000);
                    } else {
                      AlertHpoFactory.showErrorMessage(res);
                    }
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            };
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              $filter('translate')('hpo.model.calage.confirm_rerun'),
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };

        scope.buttonSpecialActions = [
          {
            class: 'btn btn-success btn-xs',
            icone: 'fa fa-play',
            text: $filter('translate')('hpo.model.calage.rerun'),
            callFunction: scope.redoCalage,
            disableFunc: function(obj) {
              if (
                !obj ||
                !obj.properties ||
                !obj.properties.STATUS ||
                obj.properties.STATUS === 'RUNNING'
              )
                return true;
              else return false;
            },
          },
        ];

        $timeout(function() {
          scope.height =
            angular.element('.xgos_content').height() -
            angular.element('.nav.nav-tabs').height() -
            angular.element('.gcDatatableCrud').height() -
            angular.element('.add-border').height() -
            110 +
            'px';
          angular.element('.contenu-hpo').height(scope.height);
        }, 500);

        scope.postRemove = function(resultat) {
          let identifiants = resultat
            .map(function(x) {
              return x.properties.IDENTIFIANT;
            })
            .join("','");
          let where = '"IDENTIFIANT" IN (\'' + identifiants + "')";
          EditFactory.deleteWhere(scope.ftivalidation.uid,where).then((res)=>{
            HpoCarteAppFactory.getAppFactory().checkDeletePrevision(identifiants);
          });
          $rootScope.$broadcast('inititaliseApplicationBranch');
        };
      },
    };
  };

  modelCalageHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'HpoAppModelServices',
    'gaDomUtils',
    'QueryFactory',
    'InitProvider',
    'EditFactory',
  ];
  return modelCalageHpo;
});
