/**
 *
 */
'use strict';
define(function() {
  var gcMainHpoController = function(
    $scope,
    HpoCarteAppFactory,
    AlertHpoFactory,
    $filter,
    ngDialog,
    DataStoreFactory,
    InitProvider,
    gaDomUtils,
    ConfigFactory,
    $rootScope,
    $location,
    $interval
  ) {
    $scope.isConfigDone = undefined;
    $scope.updateConfig = function() {
      gaDomUtils.showGlobalLoader();
      HpoCarteAppFactory.getAppFactory()
        .updateConfig($scope.HpoConfig)
        .then(
          function(res) {
            if (res && res.data) {
              $scope.HpoConfig = res.data;
              HpoCarteAppFactory.getInitProvider().setHpoConfig(
                $scope.HpoConfig
              );
              HpoCarteAppFactory.getInitProvider()
                .initialiseApplication()
                .then(
                  function() {
                    HpoCarteAppFactory.getAppFactory().initFactory();
                    $scope.isConfigDone = true;
                    $scope.dialog.close();
                    gaDomUtils.hideGlobalLoader();
                  },
                  function() {
                    gaDomUtils.hideGlobalLoader();
                  }
                );
            } else {
              gaDomUtils.hideGlobalLoader();
            }
          },
          function(res) {
            AlertHpoFactory.showErrorMessage(res);
            gaDomUtils.hideGlobalLoader();
          }
        );
    };

    $scope.initApp = function(datastore) {
      if (datastore) {
        $scope.HpoConfig.datastoreuid = datastore.uid;
        $scope.HpoConfig.datastoreName = datastore.name;
        $scope.HpoConfig.dbmutualise = datastore.dbmutualise;
        HpoCarteAppFactory.getInitProvider().setHpoConfig($scope.HpoConfig);
        HpoCarteAppFactory.getAppFactory().initFactory();
        $scope.updateConfig();
      }
    };

    ConfigFactory.get('main', 'appconfig').then(
      function(res) {
        if (((res && res.data) || res.data === '')&& (res.data.code !== 403)) {
          HpoCarteAppFactory.getInitProvider()
            .initialiseApplication()
            .then(function() {
              if (res.data && res.data.datastoreuid) {
                $scope.HpoConfig = res.data;
                HpoCarteAppFactory.getInitProvider().setHpoConfig(
                  $scope.HpoConfig
                );
                HpoCarteAppFactory.getAppFactory().initFactory();
                $scope.isConfigDone = true;
              } else {
                $scope.HpoConfig = {};
                HpoCarteAppFactory.getInitProvider().setHpoConfig(
                  $scope.HpoConfig
                );
                HpoCarteAppFactory.getAppFactory().initFactory();
                $scope.isConfigDone = false;
                DataStoreFactory.get().then(
                  function(res) {
                    if (res && res.data) {
                      $scope.datastores = res.data;
                      $scope.initDatastore = undefined;
                      $scope.dialog = ngDialog.open({
                        template:
                          'js/XG/widgets/hpoapp/main/views/controller/config.html',
                        className: 'ngdialog-theme-plain width800 configHpo',
                        closeByDocument: false,
                        title: $filter('translate')('hpo.init.datastore'),
                        scope: $scope,
                      });
                    }
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            });
        }
      },
      function(res) {
        AlertHpoFactory.showErrorMessage(res);
      }
    );

    // TODO Recup id from URL
    function getParameterByName(name) {
      name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
      var regex = new RegExp('[\\?&]' + name + '=([^&#]*)'),
        results = regex.exec($location.$$absUrl);
      return results === null
        ? ''
        : decodeURIComponent(results[1].replace(/\+/g, ' '));
    }

    $scope.mode = getParameterByName('mode');
    localStorage.setItem('mode', $scope.mode);

    $scope.app = getParameterByName('app');
    localStorage.setItem('app', $scope.app);

    $scope.portalid = getParameterByName('portal');

    var gcMain = angular.module('gcMainHpo');
    gcMain.app = $scope.app;
    gcMain.portalid = $scope.portalid;

    if (!$rootScope.xgos) $rootScope.xgos = {};
    if (!$rootScope.xgos.hpo)
      $rootScope.xgos.hpo = {
        clauseWhere: '1=1',
        srid: undefined,
        operands: [],
      };

    $rootScope.initApplicationInformations = function() {
      HpoCarteAppFactory.getInitProvider()
        .initialiseApplication()
        .then(
          function() {
            console.log('Init done with success');
            var callback = function(isconfirm) {
              if (isconfirm) {
                $rootScope.$broadcast('inititaliseApplicationBranch');
              }
            };
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.info'),
              $filter('translate')('hpo.common.refreshModule'),
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
            // AlertHpoFactory.getSimpleSuccess( $filter('translate')('hpo.common.info'),
            //         $filter('translate')('hpo.common.reloaded') , false , "success");
          },
          function() {
            console.error('unable to reinitialise application parameter');
            AlertHpoFactory.showErrorMessage(res);
          }
        );
    };
  };
  gcMainHpoController.$inject = [
    '$scope',
    'HpoCarteAppFactory',
    'AlertHpoFactory',
    '$filter',
    'ngDialog',
    'DataStoreFactory',
    'InitProvider',
    'gaDomUtils',
    'ConfigFactory',
    '$rootScope',
    '$location',
    '$interval',
  ];

  return gcMainHpoController;
});
