'use strict';
define([
  'angular',

  /**
   * directives
   */
  'widgets/hpoapp/home_admin_data/directives/listeData',
  'widgets/hpoapp/home_admin_data/directives/countsGroup',
  'widgets/hpoapp/home_admin_data/directives/hpoStatisticsCounts',
  'widgets/hpoapp/home_admin_data/directives/hpoStatisticsCount',
  'widgets/hpoapp/home_admin_data/directives/importHistoriqueHpo',
  'widgets/hpoapp/home_admin_data/directives/importHpo',
  'widgets/hpoapp/home_admin_data/directives/mappingHpo',
  'widgets/hpoapp/home_admin_data/directives/importMappingHpo',
  'widgets/hpoapp/home_admin_data/directives/importFeatures',
  'widgets/hpoapp/home_admin_data/directives/preparationDataHpo',
  'widgets/hpoapp/home_admin_data/directives/preparationAnalysisDataHpo',
  'widgets/hpoapp/home_admin_data/directives/preparationCorrectionDataHpo',

  'widgets/hpoapp/home_admin_data/directives/validateDataHpo',
  'widgets/hpoapp/home_admin_data/directives/standardisationDataHpo',
  'widgets/hpoapp/home_admin_data/directives/statisticAnalyseHpo',
  'widgets/hpoapp/home_admin_data/directives/historicAnalyseHpo',

  'widgets/hpoapp/home_admin_data/directives/adminHpo',
  'widgets/hpoapp/home_admin_data/directives/adminDatastoreHpo',
  'widgets/hpoapp/home_admin_data/directives/adminFeaturesHpo',
  'widgets/hpoapp/home_admin_data/directives/adminBasemapHpo',
  'widgets/hpoapp/home_admin_data/directives/adminTableHpo',
  'widgets/hpoapp/home_admin_data/directives/adminStatistique',

  /**
   * utilities
   */
  'widgets/hpoapp/home_admin_data/directives/utilities/filterAsElastic',
  'widgets/hpoapp/home_admin_data/directives/utilities/saveAndGetTemplateHpo',
  'widgets/hpoapp/home_admin_data/directives/utilities/css_manipulate',
  'widgets/hpoapp/home_admin_data/directives/utilities/ScientificCalculator',
  'widgets/hpoapp/home_admin_data/directives/utilities/changeAttributeType',
  'widgets/hpoapp/home_admin_data/directives/utilities/troncateRoundValue',
  'widgets/hpoapp/home_admin_data/directives/utilities/changeAttributeValue',
  'widgets/hpoapp/home_admin_data/directives/utilities/createUpdateAttribute',
  'widgets/hpoapp/home_admin_data/directives/utilities/rules/setRuleHpoValue',
  'widgets/hpoapp/home_admin_data/directives/utilities/rules/setRuleHpoDiscretisation',
  'widgets/hpoapp/home_admin_data/directives/utilities/rules/setRuleHpoRegroupement',
  'widgets/hpoapp/home_admin_data/directives/utilities/rules/setRuleHpoCalculator',
  'widgets/hpoapp/home_admin_data/directives/utilities/map/hpoMap',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/createFilterHpo',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/selectAttributesHpo',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/dashboardHpo',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/dashboardHpoAutomatique',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/dashboardHpoAutomatiqueTabs',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/mapStandarisation',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/distributionTermsKmInstalledByYear',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/cassesPerYearsPerKmPerCommune',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/completenessDataQuantitativeModalite',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/dashboardHpoFeedback',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/dashboardHpoEnrichment',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/dashboardHpoValidation',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/dashboardHpoChantierauto',
  'widgets/hpoapp/home_admin_data/directives/utilities/addComponentConfigHpo',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/calculDashboardHpo',
  'widgets/hpoapp/home_admin_data/directives/utilities/data/selectDataHpo',

  /**
   * Services
   */
  'widgets/hpoapp/home_admin_data/services/HpoAppServices',
  'widgets/hpoapp/home_admin_data/services/HpoDataVisServices',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  listeData,
  countsGroup,
  hpoStatisticsCounts,
  hpoStatisticsCount,
  importHistoriqueHpo,
  importHpo,
  mappingHpo,
  importMappingHpo,
  importFeatures,
  preparationDataHpo,
  preparationAnalysisDataHpo,
  preparationCorrectionDataHpo,
  validateDataHpo,
  standardisationDataHpo,
  statisticAnalyseHpo,
  historicAnalyseHpo,
  adminHpo,
  adminDatastoreHpo,
  adminFeaturesHpo,
  adminBasemapHpo,
  adminTableHpo,
  adminStatistique,
  filterAsElastic,
  saveAndGetTemplateHpo,
  cssManipulate,
  ScientificCalculator,
  changeAttributeType,
  troncateRoundValue,
  changeAttributeValue,
  createUpdateAttribute,
  setRuleHpoValue,
  setRuleHpoDiscretisation,
  setRuleHpoRegroupement,
  setRuleHpoCalculator,
  hpoMap,
  createFilterHpo,
  selectAttributesHpo,
  dashboardHpo,
  dashboardHpoAutomatique,
  dashboardHpoAutomatiqueTabs,
  mapStandarisation,
  distributionTermsKmInstalledByYear,
  cassesPerYearsPerKmPerCommune,
  completenessDataQuantitativeModalite,
  dashboardHpoFeedback,
  dashboardHpoEnrichment,
  dashboardHpoValidation,
  dashboardHpoChantierauto,
  addComponentConfigHpo,
  calculDashboardHpo,
  selectDataHpo,
  HpoAppServices,
  HpoDataVisServices
) {
  // generation du module
  var gcMain = angular.module('gcMainHpoHomeAdminData', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Directives
   */
  gcMain.directive('countsGroup', countsGroup);
  gcMain.directive('hpoStatisticsCounts', hpoStatisticsCounts);
  gcMain.directive('hpoStatisticsCount', hpoStatisticsCount);
  gcMain.directive('listeDataHpo', listeData);
  gcMain.directive('importHpo', importHpo);
  gcMain.directive('mappingHpo', mappingHpo);
  gcMain.directive('importFeaturesHpo', importFeatures);
  gcMain.directive('importMappingHpo', importMappingHpo);
  gcMain.directive('importHistoriqueHpo', importHistoriqueHpo);
  gcMain.directive('preparationDataHpo', preparationDataHpo);
  gcMain.directive('preparationAnalysisDataHpo', preparationAnalysisDataHpo);
  gcMain.directive(
    'preparationCorrectionDataHpo',
    preparationCorrectionDataHpo
  );
  gcMain.directive('validateDataHpo', validateDataHpo);
  gcMain.directive('standardisationDataHpo', standardisationDataHpo);
  gcMain.directive('statisticAnalyseHpo', statisticAnalyseHpo);
  gcMain.directive('historicAnalyseHpo', historicAnalyseHpo);

  gcMain.directive('adminHpo', adminHpo);
  gcMain.directive('adminDatastoreHpo', adminDatastoreHpo);
  gcMain.directive('adminFeaturesHpo', adminFeaturesHpo);
  gcMain.directive('adminBasemapHpo', adminBasemapHpo);
  gcMain.directive('adminTableHpo', adminTableHpo);
  gcMain.directive('adminStatistique', adminStatistique);

  /**
   * utilities
   */
  gcMain.directive('filterAsElastic', filterAsElastic);
  gcMain.directive('saveAndGetTemplateHpo', saveAndGetTemplateHpo);
  gcMain.directive('cssManipulate', cssManipulate);
  gcMain.directive('scientificCalculator', ScientificCalculator);
  gcMain.directive('changeAttributeType', changeAttributeType);
  gcMain.directive('troncateRoundValue', troncateRoundValue);
  gcMain.directive('changeAttributeValue', changeAttributeValue);
  gcMain.directive('createUpdateAttribute', createUpdateAttribute);
  gcMain.directive('setRuleHpoValue', setRuleHpoValue);
  gcMain.directive('setRuleHpoDiscretisation', setRuleHpoDiscretisation);
  gcMain.directive('setRuleHpoRegroupement', setRuleHpoRegroupement);
  gcMain.directive('setRuleHpoCalculator', setRuleHpoCalculator);
  gcMain.directive('hpoMap', hpoMap);
  gcMain.directive('createFilterHpo', createFilterHpo);
  gcMain.directive('selectionAttributesHpo', selectAttributesHpo);
  gcMain.directive('dashboardHpo', dashboardHpo);
  gcMain.directive('dashboardHpoAutomatique', dashboardHpoAutomatique);
  gcMain.directive('dashboardHpoAutomatiqueTabs', dashboardHpoAutomatiqueTabs);
  gcMain.directive('mapStandarisation', mapStandarisation);
  gcMain.directive('distributionTermsKmInstalledByYear', distributionTermsKmInstalledByYear);
  gcMain.directive('cassesPerYearsPerKmPerCommune', cassesPerYearsPerKmPerCommune);
  gcMain.directive('completenessDataQuantitativeModalite', completenessDataQuantitativeModalite);
  gcMain.directive('dashboardHpoFeedback', dashboardHpoFeedback);
  gcMain.directive('dashboardHpoEnrichment', dashboardHpoEnrichment);
  gcMain.directive('dashboardHpoValidation', dashboardHpoValidation);
  gcMain.directive('dashboardHpoChantierauto', dashboardHpoChantierauto);
  gcMain.directive('addComponentConfigHpo', addComponentConfigHpo);
  gcMain.directive('calculDashboardHpo', calculDashboardHpo);
  gcMain.directive('selectDataHpo', selectDataHpo);

  /**
   * Services
   */
  gcMain.factory('HpoAppServices', HpoAppServices);
  gcMain.factory('HpoDataVisServices', HpoDataVisServices);

  return gcMain;
});
