'use strict';
define(function() {
  var validateDataHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    ngProgressFactory,
    $location,
    InitProvider
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/validate_data_hpo.html',
      restrict: 'EA',
      scope: {
        type: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        if (scope.type)
          scope.configName =
            HpoCarteAppFactory.getAppFactory().getAppname() +
            '_' +
            scope.type +
            '_' +
            'HpoValidateDataConfig';
        else {
          scope.configName =
            HpoCarteAppFactory.getAppFactory().getAppname() +
            '_' +
            'HpoValidateDataConfig';
        }
        if ($rootScope.xgos && $rootScope.xgos.user && $rootScope.xgos.user.uid)
          scope.configNameLast =
            scope.configName + '_' + $rootScope.xgos.user.uid;
        else {
          scope.configNameLast = scope.configName + '_ANONYMOUS';
        }
        var configData = HpoCarteAppFactory.getInitProvider().getHpoConfig();
        scope.saveLastModification = function() {
          ParametersFactory.getbytype(scope.configNameLast).then(function(res) {
            if (res.data && res.data.length > 0) {
              ParametersFactory.remove(res.data[0].id).then(
                function() {
                  ParametersFactory.add(
                    scope.validation,
                    scope.configNameLast,
                    null
                  ).then(
                    function() {
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.common.successave'),
                        false,
                        'success'
                      );
                    },
                    function() {
                      AlertHpoFactory.getSimpleFail(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.common.faildsave'),
                        true,
                        'error'
                      );
                    }
                  );
                },
                function() {
                  AlertHpoFactory.getSimpleFail(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')('hpo.common.faildsave'),
                    true,
                    'error'
                  );
                }
              );
            } else {
              ParametersFactory.add(
                scope.validation,
                scope.configNameLast,
                null
              ).then(
                function(res) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')('hpo.common.successave'),
                    false,
                    'success'
                  );
                },
                function(res) {
                  AlertHpoFactory.getSimpleFail(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')('hpo.common.faildsave'),
                    true,
                    'error'
                  );
                }
              );
            }
          });
        };

        scope.removeLastSavedModification = function() {
          if (scope.saved && scope.saved.length > 0) {
            var callback = function(isconfirm) {
              if (isconfirm) {
                ParametersFactory.remove(scope.saved[0].id).then(
                  function() {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.info'),
                      $filter('translate')('hpo.common.succesremove'),
                      false,
                      'success'
                    );
                    scope.saved = undefined;
                    try {
                      scope.$apply();
                    } catch(err) {}
                  },
                  function() {
                    AlertHpoFactory.getSimpleFail(
                      $filter('translate')('hpo.common.info'),
                      $filter('translate')('hpo.common.faildremove'),
                      true,
                      'error'
                    );
                  }
                );
              }
            };
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.info'),
              $filter('translate')('hpo.common.surremovelatest'),
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };

        var fti = HpoCarteAppFactory.getAppFactory().getFeatureTypes('prep')[0];
        scope.datatableHeight =
          angular.element('.xgos_content').height() - 150 + 'px';
        scope.mapheight = $window.innerHeight - 150 + 'px';

        scope.ftis = [];
        scope.ftisdefail = [];
        scope.ftis_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid'
        );
        scope.ftisnodefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid_no_defail'
        );
        scope.ftisdefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid_defail'
        );

        var ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
        for (var i = 0; i < ftis.length; i++) {
          var fti = ftis[i];
          if (!HpoCarteAppFactory.getAppFactory().getFuiteTables(fti)) {
            scope.ftis.push(fti);
            var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
              fti
            );
            var idx = ftis
              .map(function(x) {
                return x.uid;
              })
              .indexOf(ftidefailuid);
            if (idx !== -1) scope.ftisdefail.push(ftis[idx]);
          }
        }
        // scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes("data_no_defail");
        // scope.ftisdefail = HpoCarteAppFactory.getAppFactory().getFeatureTypes("data_defail");
        // scope.ftis_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes("valid");
        // scope.ftisnodefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes("valid_no_defail");
        // scope.ftisdefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes("valid_defail");

        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid_hist'
        )[0];
        scope.disabledEdit = HpoCarteAppFactory.getAppFactory().getDisabledEditAttributes(
          scope.ftihistory.name
        );
        scope.translateFtiAttributes = HpoCarteAppFactory.getAppFactory().getTranslateAttributes(
          scope.ftihistory.name
        );
        scope.ftihistoryattributes = scope.ftihistory.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftihistory.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftihistory.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftihistory.name
                ))
            )
              return x;
          }
        );

        if (scope.type === 'withtransfert')
          scope.tabs = [
            {
              title: $filter('translate')('hpo.data.validation.add'),
            },
            {
              title: $filter('translate')('hpo.data.validation.historic'),
            },
          ];
        else
          scope.tabs = [
            {
              title: $filter('translate')('hpo.data.validation.add'),
            },
          ];
        scope.tabs.activeTab = 0;

        if (scope.type === 'withtransfert')
          scope.steps = [
            {
              id: 'select_table',
              label: $filter('translate')(
                'hpo.data.validation.steps.select_table'
              ),
              position: 0,
            },
            {
              id: 'validate_select_table',
              label: $filter('translate')(
                'hpo.data.validation.steps.validate_select_table'
              ),
              position: 1,
            },
            {
              id: 'selection_table_transfer',
              label: $filter('translate')(
                'hpo.data.validation.steps.selection_table_transfer'
              ),
              position: 2,
            },
            {
              id: 'validate_compatibility',
              label: $filter('translate')(
                'hpo.data.validation.steps.validate_compatibility'
              ),
              position: 3,
            },
            {
              id: 'submit',
              label: $filter('translate')('hpo.data.validation.steps.submit'),
              position: 4,
            },
          ];
        else {
          scope.steps = [
            {
              id: 'select_table',
              label: $filter('translate')(
                'hpo.data.validation.steps.select_table'
              ),
              position: 0,
            },
            {
              id: 'validate_select_table',
              label: $filter('translate')(
                'hpo.data.validation.steps.validate_select_table'
              ),
              position: 1,
            },
            {
              id: 'finalise',
              label: $filter('translate')('hpo.data.validation.steps.finalise'),
              position: 2,
            },
          ];
        }

        scope.modes = HpoCarteAppFactory.getAppFactory().getHpoFilterModes();
        scope.analysistoolsLinesColumns = HpoCarteAppFactory.getAppFactory()
          .getAnalysisToolsLines()
          .map(function(x) {
            if (['doublonanalysis', 'emptyanalysis'].indexOf(x.value) !== -1)
              return x;
          })
          .filter(function(x) {
            if (x) return x;
          });
        scope.analysistoolsLinesColumns2 = HpoCarteAppFactory.getAppFactory()
          .getAnalysisToolsLines()
          .map(function(x) {
            if (['doublonanalysis'].indexOf(x.value) !== -1) return x;
          })
          .filter(function(x) {
            if (x) return x;
          });
        scope.analysistoolsCompatibility = HpoCarteAppFactory.getAppFactory().getAnalysisToolsCompatility();

        scope.analysistoolsFuites = HpoCarteAppFactory.getAppFactory().getAnalysisToolsFuites();
        var initSteps = function() {
          scope.validation = {
            position: 0,
            maxposition: 0,
            result: {},
            fti: undefined,
            ftidefail: undefined,
            mode: scope.modes[0],
            geoj: {},
            analysistool: {
              doublonanalysis: true,
              emptyanalysis: true,
              fuiteanalysis: true,
            },
            analysistool2: {
              doublonanalysis: true,
              fuiteanalysis: true,
              compatibility: true,
            },
            pass: false,
            pass1: false,
            transfert: {},
            finished: false,
          };
        };

        initSteps();
        $timeout(function() {
          ParametersFactory.getbytype(scope.configNameLast).then(
            function(res) {
              if (res.data && res.data.length > 0) {
                scope.saved = res.data;
                var callback = function(isconfirm) {
                  if (isconfirm) {
                    scope.validation = scope.saved[0].data;
                    if (scope.validation && scope.validation.fti)
                      scope.ftis.map(function(x) {
                        if (x && x.uid && x.uid === scope.validation.fti.uid)
                          scope.validation.fti = x;
                      });
                    if (scope.validation && scope.validation.ftidefail)
                      scope.ftisdefail.map(function(x) {
                        if (
                          x &&
                          x.uid &&
                          x.uid === scope.validation.ftidefail.uid
                        )
                          scope.validation.ftidefail = x;
                      });
                    if (scope.validation && scope.validation.mode)
                      scope.modes.map(function(x) {
                        if (x && x.id && x.id === scope.validation.mode.id)
                          scope.validation.mode = x;
                      });
                    if (
                      scope.validation &&
                      scope.validation.geoj &&
                      scope.validation.geoj.features
                    ) {
                      scope.validation.attributestouseindatatable = HpoCarteAppFactory.getAppFactory().getFuiteAnalysisAttributes();
                      scope.validation.attrstotranslate = HpoCarteAppFactory.getAppFactory().HPO_DIVERS_PARAMS();
                    }
                  }
                  try {
                    scope.$apply();
                  } catch(err) {}
                };
                AlertHpoFactory.alertConfirmCallback(
                  $filter('translate')('hpo.common.info'),
                  $filter('translate')('hpo.common.getlastsaved'),
                  'info',
                  true,
                  undefined,
                  '#F50072',
                  true,
                  undefined,
                  undefined,
                  true,
                  true,
                  callback
                );
              }
            },
            function(res) {
              console.error(res);
            }
          );
        }, 1000);

        scope.stopnumber = scope.steps.length - 1;
        scope.addStep = function(i) {
          if (
            (i > 0 && scope.validation.position < scope.steps.length - 1) ||
            i < 0
          ) {
            var bool = false;
            scope.validation.position = scope.validation.position + i;
            if (scope.validation.maxposition < scope.validation.position)
              bool = true;
            scope.validation.maxposition = Math.max(
              scope.validation.maxposition,
              scope.validation.position
            );
            if (scope.validation.maxposition === 2 && bool) {
              var dest = angular
                .copy(scope.ftis)
                .concat(angular.copy(scope.ftisdefail))
                .map(function(x) {
                  if (
                    x.uid !== scope.validation.fti.uid &&
                    x.uid !== scope.validation.ftidefail.uid
                  )
                    return x;
                })
                .filter(function(x) {
                  if (x) return x;
                });
              scope.validation.mapping = {
                sourceslayers: [
                  angular.copy(scope.validation.fti),
                  angular.copy(scope.validation.ftidefail),
                ],
                sources: angular
                  .copy(scope.validation.fti)
                  .attributes.map(function(x) {
                    return x.name;
                  }),
                destinationsftis: dest,
                maj: {},
                liaisons: {},
                values: {},
                dateformatValues: {},
                result: {},
              };
            }
          } else if (
            scope.validation.position === scope.validation.maxposition &&
            scope.validation.maxposition === scope.steps.length - 1 &&
            ((scope.steps.length > 3 &&
              scope.validation.transfert[scope.validation.ftidefail.uid] &&
              scope.validation.transfert[scope.validation.fti.uid]) ||
              (scope.steps.length === 3 && i > 0))
          ) {
            ParametersFactory.getbytype(scope.configNameLast).then(
              function(res) {
                if (res.data && res.data.length > 0) {
                  ParametersFactory.remove(res.data[0].id).then(
                    function() {
                      initSteps();
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.common.succesfinished'),
                        true,
                        'success'
                      );
                    },
                    function(res) {
                      console.error(res);
                      initSteps();
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.common.succesfinished'),
                        true,
                        'success'
                      );
                    }
                  );
                } else {
                  initSteps();
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')('hpo.common.succesfinished'),
                    true,
                    'success'
                  );
                }
              },
              function(res) {
                console.error(res);
                initSteps();
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.info'),
                  $filter('translate')('hpo.common.succesfinished'),
                  true,
                  'success'
                );
              }
            );
          }
        };

        scope.saveMapping = function(res) {
          if (!res.filetype) res.filetype = 'db';
          if (!res.copydata) res.copydata = true;
          if (res.ftiuidsource === scope.validation.fti.uid)
            res.cqlfilter = scope.validation.result.clauseWhere || '1=1';
          else {
            res.cqlfilter = scope.validation.result.clauseWhereDefail || '1=1';
          }
          scope.validation.mapping.result[res.ftiuidsource] = res;
          var idx = scope.validation.mapping.sourceslayers
            .map(function(x) {
              return x.uid;
            })
            .indexOf(res.ftiuidsource);
          if (idx !== -1) scope.validation.mapping.sourceslayers.splice(idx, 1);
          idx = scope.validation.mapping.destinationsftis
            .map(function(x) {
              return x.uid;
            })
            .indexOf(res.ftuiddestination);
          if (idx !== -1)
            scope.validation.mapping.destinationsftis.splice(idx, 1);
          $rootScope.$broadcast('removedelement', res.ftisourcename);
          AlertHpoFactory.getSimpleSuccess(
            $filter('translate')('hpo.common.success'),
            $filter('translate')('hpo.common.mappingsuccess'),
            true,
            'success'
          );
        };

        scope.description = $filter('translate')(
          'hpo.data.validation.description'
        );
        scope.descriptionlight = $filter('translate')(
          'hpo.data.validation.descriptionlight'
        );
        scope.descriptionStep1 = $filter('translate')(
          'hpo.data.validation.description1'
        );
        scope.descriptionlightStep1 = $filter('translate')(
          'hpo.data.validation.descriptionlight1'
        );
        scope.descriptionStep2 = $filter('translate')(
          'hpo.data.validation.description2'
        );
        scope.descriptionlightStep2 = $filter('translate')(
          'hpo.data.validation.descriptionlight2'
        );
        scope.descriptionStep3 = $filter('translate')(
          'hpo.data.validation.description3'
        );
        scope.descriptionlightStep3 = $filter('translate')(
          'hpo.data.validation.descriptionlight3'
        );
        scope.descriptionStep4 = $filter('translate')(
          'hpo.data.validation.description4'
        );
        scope.descriptionlightStep4 = $filter('translate')(
          'hpo.data.validation.descriptionlight4'
        );
        scope.descriptionStep5 = $filter('translate')(
          'hpo.data.validation.description5'
        );
        scope.descriptionlightStep5 = $filter('translate')(
          'hpo.data.validation.descriptionlight5'
        );
        scope.descriptionfinalise = $filter('translate')(
          'hpo.data.validation.descriptionfinalise'
        );
        scope.full = false;
        scope.full1 = false;
        scope.full2 = false;
        scope.full3 = false;
        scope.full4 = false;
        scope.full5 = false;

        scope.changed = true;
        scope.changedCorrectionToolOrFti = function() {
          if (scope.validation.fti && scope.validation.fti.name) {
            var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
              scope.validation.fti
            );
            var idx = scope.ftisdefail
              .map(function(x) {
                return x.uid;
              })
              .indexOf(ftidefailuid);
            if (idx !== -1) scope.validation.ftidefail = scope.ftisdefail[idx];
          }
          if (
            scope.validation.fti &&
            scope.validation.mode &&
            scope.validation.mode.id === 'map'
          ) {
            scope.changed = false;
            $timeout(function() {
              scope.changed = true;
            }, 500);
          }
        };

        scope.checkApplyedForm = function() {
          var bool = true;
          if (scope.validation) {
            switch (scope.validation.position) {
              case 0:
                if (scope.validation.fti && scope.validation.ftidefail)
                  bool = false;
                break;
              case 1:
                if (
                  angular.isDefined(scope.validation.pass) &&
                  scope.validation.pass
                )
                  bool = false;
                break;
              case 2:
                if (
                  (scope.validation.mapping &&
                    scope.validation.mapping.sourceslayers &&
                    scope.validation.mapping.sourceslayers.length === 0) ||
                  scope.steps.length === 3
                )
                  bool = false;
                break;
              case 3:
                if (
                  angular.isDefined(scope.validation.pass1) &&
                  scope.validation.pass1
                )
                  bool = false;
                break;
              case 4:
                if (
                  scope.validation.transfert &&
                  scope.validation.fti &&
                  scope.validation.fti.uid &&
                  scope.validation.ftidefail &&
                  scope.validation.ftidefail.uid &&
                  scope.validation.transfert[scope.validation.fti.uid] &&
                  scope.validation.transfert[scope.validation.ftidefail.uid]
                )
                  bool = false;
                break;
            }
          }
          return bool;
        };

        scope.buttonactions = [];
        scope.analyseSelection = function() {
          var attributestocheck = {};
          scope.validation.fti.attributes.map(function(x) {
            if (x.name && !x.isNillable) attributestocheck[x.name] = true;
          });
          var analysis = {
            analysistool: 'fuiteanalysis',
            tableselected: scope.validation.ftidefail,
            tableselecteddata: scope.validation.fti,
            selectedattributesdata: attributestocheck,
            operands: scope.validation.result.operands,
            clauseWhere: scope.validation.result.clauseWhere,
            emptyanalysis: scope.validation.analysistool.emptyanalysis,
            doublonanalysis: scope.validation.analysistool.doublonanalysis,
            getfuitefromdata: true,
            result: [],
            geoj: {},
            attributestoselect: {},
            expression: '',
            interpreteattributes: 'and',
            interpreteconditions: 'and',
            selectedall: false,
            attributestouseindatatable: [],
            supplementAttributes: null,
            adminConfig: configData,
          };
          gaDomUtils.showGlobalLoader();
          HpoAppServices.analyseData(analysis).then(
            function(res) {
              if (res.data && res.data.status) {
                scope.validation.geoj = res.data.result;
                scope.validation.result.clauseWhereDefail =
                  res.data.clausewhere || '1=1';
                try {
                  if (
                    scope.validation.geoj &&
                    scope.validation.geoj.features &&
                    scope.validation.geoj.features.length === 0
                  ) {
                    scope.validation.pass = true;
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.common.canpass'),
                      true,
                      'info'
                    );
                  } else {
                    scope.validation.attributestouseindatatable = HpoCarteAppFactory.getAppFactory().getFuiteAnalysisAttributes();
                    scope.validation.attrstotranslate = HpoCarteAppFactory.getAppFactory().HPO_DIVERS_PARAMS();
                    scope.validation.pass = true;
                    scope.validation.geoj.features.map(function(x) {
                      if (x && x.properties && !x.properties.acceptable)
                        scope.validation.pass = false;
                    });
                    if (!scope.validation.pass)
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.warning'),
                        $filter('translate')(
                          'hpo.data.validation.needcorrection'
                        ),
                        true,
                        'warning'
                      );
                    else {
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.common.canpass'),
                        true,
                        'info'
                      );
                    }
                  }
                } catch (e) {
                  console.error(e.stack);
                }
              } else {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.info'),
                  $filter('translate')('hpo.common.canpass'),
                  false
                );
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.analyseMapping = function() {
          var attributestocheck = {};
          scope.validation.fti.attributes.map(function(x) {
            if (x.name && !x.isNillable) attributestocheck[x.name] = true;
          });
          var analysis = {
            analysistool: 'compatibility',
            tableselected: scope.validation.fti,
            tableselecteddata: scope.validation.ftidefail,
            selectedattributesdata: attributestocheck,
            operands: scope.validation.result.operands,
            clauseWhere: scope.validation.result.clauseWhere,
            doublonanalysis: scope.validation.analysistool.doublonanalysis,
            compatibility: scope.validation.analysistool.compatibility,
            fuiteanalysis: scope.validation.analysistool.fuiteanalysis,
            getfuitefromdata: true,
            result: [],
            geoj: {},
            attributestoselect: {},
            expression: '',
            interpreteattributes: 'and',
            interpreteconditions: 'and',
            selectedall: false,
            attributestouseindatatable: [],
            supplementAttributes: null,
            correspondance: scope.validation.mapping.result,
            adminConfig: configData,
          };
          gaDomUtils.showGlobalLoader();
          HpoAppServices.analyseData(analysis).then(
            function(res) {
              if (res.data && res.data.status) {
                scope.validation.geoj1 = res.data.result;
                try {
                  if (
                    scope.validation.geoj1 &&
                    scope.validation.geoj1.features &&
                    scope.validation.geoj1.features.length === 0
                  ) {
                    scope.validation.pass1 = true;
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.common.canpass'),
                      true,
                      'info'
                    );
                  } else {
                    scope.validation.attributestouseindatatable = HpoCarteAppFactory.getAppFactory().getFuiteAnalysisAttributes();
                    scope.validation.attrstotranslate = HpoCarteAppFactory.getAppFactory().HPO_DIVERS_PARAMS();
                    scope.validation.pass1 = true;
                    scope.validation.geoj1.features.map(function(x) {
                      if (x && x.properties && !x.properties.acceptable)
                        scope.validation.pass1 = false;
                    });
                    if (!scope.validation.pass1)
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.warning'),
                        $filter('translate')(
                          'hpo.data.validation.needcorrection'
                        ),
                        true,
                        'warning'
                      );
                    else {
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.common.canpass'),
                        true,
                        'info'
                      );
                    }
                  }
                } catch (e) {
                  console.error(e.stack);
                }
              } else {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.info'),
                  $filter('translate')('hpo.common.canpass'),
                  false
                );
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };
        scope.progressbar = {};
        scope.isrunning = {};
        scope.runTransfer = function(element) {
          scope.validation.transfert[element] = false;
          scope.isrunning[element] = true;
          scope.progressbar[element] = ngProgressFactory.createInstance();
          var el = document.getElementById(element);
          scope.progressbar[element].setParent(el);
          scope.progressbar[element].setHeight(el.clientHeight + el.clientTop);
          scope.progressbar[element].setColor('#339999');
          scope.progressbar[element].start();
          var res = scope.validation.mapping.result[element];
          var promise = ImportExportFactory.loaddata(
            res.processid,
            res.filetype === 'db' ? res.ftiuidsource : res.ftisourcename,
            res.ftuiddestination,
            res.liaison,
            res.srsid,
            res.cqlfilter,
            false,
            res.maj && res.maj.maj_component ? res.maj.maj_component : false,
            false,
            res.maj && res.maj.maj_component && res.maj.attribut
              ? res.maj.attribut
              : undefined,
            res.maj &&
              res.maj.maj_component &&
              res.maj.value &&
              res.maj.value.name
              ? res.maj.value.name
              : undefined,
            '',
            '',
            '',
            res.defaultvalues,
            res.copydata,
            res.defaultDateFormat,
            true,
            scope.ftihistory.uid,
            scope.validation.commentaire,
            $location.search().app
          );
          promise.then(
            function(result) {
              if (
                angular.isDefined(result.data) &&
                parseInt(result.data) >= 0
              ) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  result.data +
                    $filter('translate')(
                      res.maj && res.maj.maj_component
                        ? 'hpo.data.exchange.update'
                        : 'hpo.data.exchange.add'
                    ),
                  true
                );
              } else {
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('hpo.data.exchange.fail'),
                  result.data +
                    $filter('translate')(
                      res.maj && res.maj.maj_component
                        ? 'hpo.data.exchange.update'
                        : 'hpo.data.exchange.add'
                    ),
                  true
                );
              }
              $rootScope.$broadcast('reloadDatatable', scope.ftihistory.uid);
              scope.progressbar[element].complete();
              scope.validation.transfert[element] = true;
              scope.isrunning[element] = false;
            },
            function(res) {
              if (angular.isDefined(result.data))
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('hpo.data.exchange.fail'),
                  result.data,
                  true
                );
              scope.progressbar[element].complete();
              scope.validation.transfert[element] = true;
              scope.isrunning[element] = false;
            }
          );
          return promise;
        };

        scope.runalltransferts = function() {
          scope.isrunning.all = true;
          scope.runTransfer(scope.validation.fti.uid).then(
            function(res) {
              $timeout(function() {
                scope.runTransfer(scope.validation.ftidefail.uid).then(
                  function(res) {
                    scope.isrunning.all = false;
                  },
                  function(res) {
                    scope.isrunning.all = false;
                  }
                );
              }, 1000);
            },
            function(res) {
              scope.isrunning.all = false;
            }
          );
        };

        scope.$on('changedHpoValue', function(evt, arg) {
          if (arg && arg.clauseWhere && arg.operands) {
            if (scope.validation.maxposition > scope.validation.position) {
              var callback = function(isconfirm) {
                if (isconfirm) {
                  scope.validation.result = {
                    clauseWhere: arg.clauseWhere,
                    operands: arg.operands,
                  };
                  Object.assign(scope.validation, {
                    position: 0,
                    maxposition: 0,
                    geoj: {},
                    analysistool: {
                      doublonanalysis: true,
                      emptyanalysis: true,
                      fuiteanalysis: true,
                    },
                    analysistool2: {
                      doublonanalysis: true,
                      fuiteanalysis: true,
                      compatibility: true,
                    },
                    pass: false,
                    pass1: false,
                    transfert: {},
                  });
                  if (
                    scope.validation.hasOwnProperty(
                      'attributestouseindatatable'
                    )
                  )
                    delete scope.validation.attributestouseindatatable;
                  if (scope.validation.hasOwnProperty('mapping'))
                    delete scope.validation.mapping;
                  if (scope.validation.hasOwnProperty('attrstotranslate'))
                    delete scope.validation.attrstotranslate;
                  if (scope.validation.hasOwnProperty('geoj1'))
                    delete scope.validation.geoj1;
                  $timeout(function() {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.data.validation.getsuccess'),
                      false
                    );
                  }, 600);
                  try {
                    scope.$apply();
                  } catch(err) {}
                }
              };
              AlertHpoFactory.alertConfirmCallback(
                $filter('translate')('hpo.common.info'),
                $filter('translate')('hpo.common.changedstep'),
                'info',
                true,
                undefined,
                '#F50072',
                true,
                undefined,
                undefined,
                true,
                true,
                callback
              );
            } else {
              scope.validation.result = {
                clauseWhere: arg.clauseWhere,
                operands: arg.operands,
              };
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('hpo.common.success'),
                $filter('translate')('hpo.data.validation.getsuccess'),
                false
              );
            }
          }
        });

        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';
        scope.getReturnedTemplateCorrection = function(dataHpo) {
          if (dataHpo) {
            scope.validation = dataHpo.savedata;
            if (scope.validation.fti && scope.validation.fti.uid) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.validation.fti.uid);
              if (~idx) {
                scope.validation.fti = scope.ftis[idx];
              }
            }
            if (scope.validation.ftidefail && scope.validation.ftidefail.uid) {
              var idx = scope.ftisdefail
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.validation.ftidefail.uid);
              if (~idx) {
                scope.validation.ftidefail = scope.ftisdefail[idx];
              }
            }
          }
        };

        scope.unDoValidation = function(obj) {
          console.log(obj);
          var callback = function(confirmed) {
            if (confirmed) {
              gaDomUtils.showGlobalLoader();
              HpoAppServices.UndoValidation(
                scope.ftihistory.uid,
                obj.properties.TRANSACTION_UID
              ).then(
                function(res) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')('hpo.common.undosuccess'),
                    true
                  );
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.ftihistory.uid
                  );
                  gaDomUtils.hideGlobalLoader();
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            $filter('translate')('hpo.common.undodescription'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.buttonSpecialActions = [
          {
            class: 'btn btn-default btn-xs',
            icone: 'fa fa-undo',
            text: $filter('translate')('hpo.common.undo'),
            callFunction: scope.unDoValidation,
          },
        ];

        scope.datatableCrudHpo = {
          remove: true,
        };
      },
    };
  };

  validateDataHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'ngProgressFactory',
    '$location',
    'InitProvider',
  ];
  return validateDataHpo;
});
