'use strict';
define(function() {
  var HpoMap = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoAppFactory,
    $window,
    ngDialog,
    $filter,
    $rootScope,
    $timeout,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    gcDirectivesList,
    panelsManager,
    ConfigFactory,
    $location,
    SelectManager,
    gcWMS,
    gclayers,
    PortalsFactory,
    $aside,
    RolesFactory,
    BaseMapFactory,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/map/hpo_map.html',
      restrict: 'EA',
      controller: ['$scope', function($scope) {
        function createMap() {

          $scope.mapheight = $window.innerHeight + 'px';

          var map = new ol.Map({
            layers: [
              new ol.layer.Image({
                //source: new ol.source.OSM()
              }),
            ],
            controls: ol.control
              .defaults({
                attribution: false,
                rotate: true,
                zoomOptions: {
                  zoomInLabel: '+',
                  zoomOutLabel: '-',
                  zoomInTipLabel: '',
                  zoomOutTipLabel: '',
                },
              })
              .extend([new ol.control.FullScreen()]),
            interactions: ol.interaction
              .defaults({
                altShiftDragRotate: true,
                touchRotate: false,
                keyboard: false,
              })
              .extend([new ol.interaction.DragZoom()]),

            renderer: 'canvas',
            target: 'hpo-map',
            view: new ol.View({
              projection: 'EPSG:3857',
              center: [0, 0],
              minResolution: 0.005,
              //minResolution: 0.03732276771737122,
              zoom: 10,
            }),
            ol3Logo: false,
          });

          /**
           * Used to return the main map app for components which cannot access the ngview (ie Calendar)
           * @returns {ol.Map}
           */
          $rootScope.xgos.getMapAppMap = function() {
            return map;
          };

          /**
           * [viewport description]
           * @type {ViewPort Openlayer}
           */
          var viewport = $(map.getViewport());
          map.on('dragstart', function() {
            viewport.addClass(dragClass);
          });
          map.on('dragend', function() {
            viewport.removeClass(dragClass);
          });
          return map;
        }
        $scope.map = createMap();

        // TODO Recup id from URL
        function getParameterByName(name) {
          name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
          var regex = new RegExp('[\\?&]' + name + '=([^&#]*)'),
            results = regex.exec($location.$$absUrl);
          return results === null
            ? ''
            : decodeURIComponent(results[1].replace(/\+/g, ' '));
        }

        $scope.menuOptions = [
          [
            'Zoom in',
            function() {
              var view = $scope.map.getView();
              view.animate({
                duration: 1000,
                source: view.getCenter(),
                resolution: view.getResolution(),
              });
              view.setZoom(+view.getZoom() + 1);
            },
          ],
          [
            'Zoom out',
            function() {
              var view = $scope.map.getView();
              /*var
                          pan = ol.animation.pan({
                            duration: 1000,
                            source: view.getCenter()
                          }),
                          zoom = ol.animation.zoom({
                            duration: 1000,
                            resolution: view.getResolution()
                          })
                        ;
                        $scope.map.beforeRender(pan, zoom);*/
              view.animate({
                duration: 1000,
                source: view.getCenter(),
                resolution: view.getResolution(),
              });
              view.setZoom(+view.getZoom() - 1);
            },
          ],
        ];
        $scope.filterFunc = gaJsUtils.filterFunc;
        $scope.DirectivesList = gcDirectivesList.listtools();
        $scope.ToolBarList = gcDirectivesList.listtoolbars();

        /**
         * transform the DirectivesList to be used for display
         * @param savedTools
         * @returns {Array}
         */
        var formatToolsList = function(savedTools) {
          var availableTools = [];
          var defaultTools = angular.copy($scope.DirectivesList);

          // some of the tools saved have a non default category name
          for (var i in savedTools) {
            var isDefaultTool =
              defaultTools
                .map(function(x) {
                  return x.categorie;
                })
                .indexOf(savedTools[i].categorie) != -1;
            if (!isDefaultTool) {
              defaultTools.push({
                categorie: savedTools[i].categorie,
                isCustom: 1,
              });
            }
          }

          defaultTools.forEach(function(tool) {
            var found = -1;

            availableTools.forEach(function(at, atindex) {
              if (at.category == tool.categorie) found = atindex;
            });

            if (found == -1) {
              availableTools.push({
                category: tool.categorie,
                used: false,
                items: [],
                activeItems: 0,
                isCustom: tool.isCustom,
              });
              found = availableTools.length - 1;
            }

            $scope.amountOfActiveCategories = 0;
          });

          return availableTools;
        };


        // -----------------------------------------------
        // transform the toolbars list (available toolbars)

        $scope.$watch(
          'toolsbarbutton',
          function(toolsbarbutton) {
            $scope.amountOfTools = 0;
            if (toolsbarbutton)
              toolsbarbutton.forEach(function(tb, index) {
                $scope.ToolBarList.forEach(function(available) {
                  if (index == 0) {
                    delete available.used;
                    delete available.position;
                  }
                  if (available.name == tb.name) {
                    available.used = true;
                    available.position = index;
                    $scope.amountOfTools++;
                  }
                });
              });
          },
          1
        );

        $scope.tools = [];
        /*$scope.tableft = [{"title": "Existant" },{"title":"Modele"}];  ;
                     $scope.tableft.activeTab = 0;  */
        $scope.mode = getParameterByName('mode');
        localStorage.setItem('mode', $scope.mode);
        // console.log($scope.mode);

        //$scope.map.addControl(new ol.control.OverviewMap())
        // We add manually the keyboard interactions to have the possibility to
        // specify a condition
        //
        //

        var keyboardPan = new ol.interaction.KeyboardPan({
          /*condition: function() {
                         return (true);
                         }*/
        });

        /**
         * applyMapParametersFromUrl (from urlsharing widget)
         * Some parameters (bbox,visible layers or selected objects...) may be passed in the url
         * extract and apply
         */
        var applyMapParametersFromUrl = function() {
          if ($location.search().fuid) {
            var url_fuid = $location.search().fuid.split(',');
            gclayers.getOperationalLayerg2c().forEach(function(layer) {
              layer.setVisible(false);
              url_fuid.forEach(function(fuid) {
                if (layer.fti.uid == fuid) layer.setVisible(true);
              });
            });
            $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
          }

          // fid
          if ($location.search().fid) {
            var url_fid = [];
            $location
              .search()
              .fid.split(';')
              .forEach(function(f) {
                var fids_name = f.split(':');
                fids_name[1].split(',').forEach(function(fid) {
                  var feature_id = fids_name[0] + '.' + fid;
                  url_fid.push(feature_id);
                });
              });
            var groupe_ids;
            var featureCollection;
            var index = 0;
            gclayers.getOperationalLayerg2c().forEach(function(layer) {
              groupe_ids = [];
              url_fid.forEach(function(fid) {
                if (layer.fti.name == fid.split('.')[0]) {
                  groupe_ids.push(fid);
                }
              });

              if (groupe_ids.length > 0) {
                var promise = QueryFactory.get(
                  layer.fti.uid,
                  groupe_ids.toString()
                );
                promise.then(function(res) {
                  if (index == 0) {
                    featureCollection = res.data;
                    index++;
                  } else {
                    res.data.features.forEach(function(f) {
                      featureCollection.features.push(f);
                    });
                  }
                  featureCollection.totalFeatures =
                    featureCollection.features.length;
                  SelectManager.addFeaturesFromGeojson(featureCollection);
                  console.log(res.data);
                });
              }
            });

            var pop = gcPopup.open({
              scope: $scope,
              title: 'Informations : ',
              content: '<div selectfeaturetreewidget></div>',
              showClose: true,
              onclose: function() {
                SelectManager.clear();
              },
            });

            SelectManager.setpop(pop);
          }

          // Extra parameters from URL
          // bbox
          if ($location.search().bbox) {
            var url_bbox = $location
              .search()
              .bbox.split(',')
              .map(function(x) {
                return parseFloat(x);
              });
            $timeout(function() {
              $scope.map.getView().fit(url_bbox, $scope.map.getSize());
            });
          }
        };

        /**
         *
         */
        $scope.options = {};

        /**
         *
         */
        $scope.map.addInteraction(keyboardPan);
        //$scope.map.addInteraction(new ol.interaction.KeyboardZoom());
        //////////////////////////////////////////////
        /// INITIALISATION DES LAYERS DE LA MAP    ///
        //////////////////////////////////////////////
        // Ajout des couches du FeatureTypeFactory au systeme gclayer
        try {
          var MAP_MODEL_CONFIGURATION_NAME = 'MAP_MODELS_USERS';
          var MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME =
            'MAP_MODELS_LAST_EDITED' + $rootScope.xgos.user.uid;
        } catch (e) {
          console.error(e.stack);
        }

        if ($scope.configUser) {
          MAP_MODEL_CONFIGURATION_NAME =
            'MAP_MODELS_USERS_' + $scope.configUser;
          MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME = $scope.configUser;
        }

        function getMainMapConfig(res, b) {
          if (!res.data == '') {
            $scope.propmap = res.data;
            if (!angular.isUndefined($scope.propmap.extent)) {
              $scope.go($scope.propmap.extent);
              if (angular.isDefined($scope.propmap.zoom))
                $scope.map.getView().setZoom($scope.propmap.zoom);
            }
            if (!angular.isUndefined($scope.propmap.bcklayer)) {
              $scope.baselayers;
              if (
                $scope.propmap &&
                $scope.propmap.bcklayer &&
                $scope.propmap.bcklayer.length > 0
              )
                $scope.propmap.bcklayer = [
                  $scope.propmap.bcklayer[$scope.propmap.bcklayer.length - 1],
                ];
              gclayers.forceClearBackgroundLayer();
              if (BaseMapFactory.resources.basemaps.length == 0) {
                BaseMapFactory.get().then(function(res) {
                  $scope.baselayers = BaseMapFactory.resources.basemaps;
                  $scope.propmap.bcklayer.forEach(function(ft) {
                    $scope.baselayers.forEach(function(bl) {
                      if (ft.label == bl.name) {
                        gclayers.addBackGroundLayerByDesc(bl);
                      }
                    });
                    //console.log(ft.label);
                    // gclayers.addBackGroundLayerByLabel(ft.label);
                  });
                });
              } else {
                $scope.baselayers = BaseMapFactory.resources.basemaps;
                $scope.propmap.bcklayer.forEach(function(ft) {
                  $scope.baselayers.forEach(function(bl) {
                    if (ft.label == bl.name) {
                      gclayers.addBackGroundLayerByDesc(bl);
                    }
                  });
                  //console.log(ft.label);
                  // gclayers.addBackGroundLayerByLabel(ft.label);
                });
              }
            }
          }
          applyMapParametersFromUrl();
        }

        function sortLayersByIndex(layer1, layer2) {
          var index1 = layer1.get('index');
          var index2 = layer2.get('index');
          if (index1 == null) return -1;
          else if (index2 == null) return 1;
          else if (index1 < index2) return -1;
          return 1;
        }

        function addOperationalLayer(layer) {
          if (layer.fti.type === 'esri' && layer.fti.geographic) {
            gclayers.addOperationalLayerESRI(layer);
          } else if (layer.fti.geographic && layer.fti.published) {
            gclayers.addOperationalLayerg2c(layer);
          }
        }

        function clearGclayers() {
          try {
            if (gclayers.getOperationalLayer().length > 0) {
              gclayers.clearGroupLayer();
              gclayers.clearOperationalLayer();
              gclayers.clearOperationalLayerg2c();
              gclayers.clearOperationalLayerESRI();
              gclayers.clearEditLayer();
              gclayers.clearhighLightFeatures();
            }
          } catch (e) {
            console.log('cleared');
          }
        }
        clearGclayers();

        function getMainMapModel(res) {
          if (!res.data == '') {
            var mappedLayers = [];
            var noMappedLayers = [];
            var featureList = $scope.fti
              ? [$scope.fti]
              : $scope.ftis
                ? $scope.ftis
                : FeatureTypeFactory.resources.featuretypes;
            featureList.forEach(function(fType) {
              if (
                fType &&
                fType.uid &&
                fType.uid.indexOf('kis_anc_ef') === -1
              ) {
                var deleteIndex = res.data
                  .map(function(x) {
                    if (x.fti) {
                      return x.fti.uid;
                    }
                    else {
                      //-- On ne stocke plus le FTI complet dans le mapmodel.
                      return x.ftiUid;
                    }                  })
                  .indexOf(fType.uid);
                if (deleteIndex != -1) {
                  var t = res.data[deleteIndex];
                  var modelfti = fType;
                  if (modelfti != null) {
                    ///////
                    t.fti = modelfti;
                    t.theme = fType.theme;
                    var l = gcWMS.getOlLayerFromMapModelElement(t);
                    if ($scope.fti && !l.selected) l.selected = true;
                    mappedLayers.push(l);
                    /*if (t.fti.type === "esri" && t.fti.geographic ) {
                                      gclayers.addOperationalLayerESRI(l);
                                      } else if ( t.fti.geographic && t.fti.published ) {
                                      gclayers.addOperationalLayerg2c(l);
                                      }*/
                    //gclayers.addOperationalLayer(l);
                  }
                } else {
                  if (fType.type === 'esri' && fType.geographic) {
                    var l = gcWMS.getOlLayerFromFeaturetypeInfo(fType, ind);
                    if ($scope.fti && !l.selected) l.selected = true;
                    //gclayers.addOperationalLayerESRI(l);
                    noMappedLayers.push(l);
                  } else if (fType.geographic && fType.published) {
                    var l = gcWMS.getOlLayerFromFeaturetypeInfo(fType, ind);
                    if ($scope.fti && !l.selected) l.selected = true;
                    noMappedLayers.push(l);
                    // console.log(l.name);
                    //gclayers.addOperationalLayerg2c(l);
                    //gclayers.addOperationalLayer(l);
                  }
                }
              }
            });

            mappedLayers = mappedLayers.sort(sortLayersByIndex);
            for (var i = 0; i < mappedLayers.length; i++)
              addOperationalLayer(mappedLayers[i]);
            for (var i = 0; i < noMappedLayers.length; i++)
              addOperationalLayer(noMappedLayers[i]);
          } else {
            // AUcun map model alors on ajoute tous les composants
            //console.log("Pas de config  " +FeatureTypeFactory.resources.featuretypes);
            var ind = 0;
            var featureList = $scope.fti
              ? [$scope.fti]
              : $scope.ftis
                ? $scope.ftis
                : FeatureTypeFactory.resources.featuretypes;
            featureList.forEach(function(fType) {
              if (
                fType &&
                fType.uid &&
                fType.uid.indexOf('kis_anc_ef') === -1
              ) {
                if (fType.geographic && fType.published) {
                  var l = gcWMS.getOlLayerFromFeaturetypeInfo(fType, ind);
                  if ($scope.fti && !l.selected) l.selected = true;
                  if (fType.type === 'esri' && fType.geographic) {
                    gclayers.addOperationalLayerESRI(l);
                  } else if (fType.geographic && fType.published) {
                    gclayers.addOperationalLayerg2c(l);
                  }
                  //gclayers.addOperationalLayer(l);
                }
                ind++;
                //gclayers.addOperationalLayer(l);
                //$scope.map.addLayer(l);
              }
            });
          }
        }

        function loadModelList() {
          var promise = ParametersFactory.getbytype(
            MAP_MODEL_CONFIGURATION_NAME
          );
          promise.then(
            function(res) {
              if ($scope.mapModels == undefined) $scope.mapModels = [];
              else $scope.mapModels.splice(0, $scope.mapModels.length);
              for (var ii = 0; ii < res.data.length; ii++)
                $scope.mapModels.push(res.data[ii]);
            },
            function(res) {
              console.error('no config user');
            }
          );
          return promise;
        }

        var setDefaultFunctionMap = function(b) {
          ParametersFactory.getbytype(
            MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME
          ).then(
            function(res) {
              if (res.data.length > 0) {
                var model = res.data[0].data;
                if (b) {
                  $scope.mapModels.map(function(x) {
                    if (x.data.id === model.data.id) model.data = x.data;
                  });
                }
                getMainMapConfig({ data: model.propmap });
                getMainMapModel(model);
                $rootScope.$broadcast('gcOperationalLayerOnInit');
              } else {
                ConfigFactory.get('main', 'map').then(function(res) {
                  getMainMapConfig(res);
                  ConfigFactory.get('main', 'mapmodel').then(function(res) {
                    getMainMapModel(res);
                    $rootScope.$broadcast('gcOperationalLayerOnInit');
                  });
                });
              }
            },
            function() {
              ConfigFactory.get('main', 'map').then(function(res) {
                getMainMapConfig(res);
                ConfigFactory.get('main', 'mapmodel').then(function(res) {
                  getMainMapModel(res);
                  $rootScope.$broadcast('gcOperationalLayerOnInit');
                });
              });
            }
          );
        };

        var modelinitialisation = FeatureTypeFactory.get().then(function() {
          var errorMsg;
          errorMsg = '<h4>Erreur</h4> ';
          errorMsg += '<br/><h4>Details</h4>';

          if (FeatureTypeFactory.resources.featuretypes == undefined) {
            errorMsg += '<br/>FeatureTypes non définis';
            require('toastr').error(errorMsg);
          } else if (FeatureTypeFactory.resources.featuretypes.code == 403) {
            errorMsg +=
              '<br/>' + FeatureTypeFactory.resources.featuretypes.message;
            require('toastr').error(errorMsg);
          } else {
            loadModelList().then(function() {
              setDefaultFunctionMap(true);
            });
          }
        });

        $scope.$on('gcUpdateMainConfig', function(event, conf, b) {
          getMainMapModel(conf);
          getMainMapConfig({ data: conf.propmap }, true);
          $rootScope.$broadcast('gcOperationalLayerOnInit', b);
        });

        /**
         * forceReloadDefaultMapConfig
         * Reload the default map cfg
         */
        $rootScope.$on(
          'forceReloadDefaultMapConfig',
          function(event, args) {
            setDefaultFunctionMap(1);
          },
          1
        );

        // $scope.$on('reloadDefaultConfig', function(event , args) {
        //     setDefaultFunctionMap(args);
        // });

        /* if (ol.has.WEBGL)
     {

     /* $scope.ol3d = new olcs.OLCesium({map: $scope.map});
     var scene = $scope.ol3d.getCesiumScene();

     var terrainProvider = new Cesium.CesiumTerrainProvider({
     url : '//assets.agi.com/stk-terrain/world'
     });
     scene.terrainProvider = terrainProvider;*/
        //}

        /**
         *
         *
         */
        //console.log(app._invokeQueue[0][2][1]);

        // Init panelsManager and reference it into scope
        panelsManager.init();
        $scope.panelsManager = panelsManager;

        ConfigFactory.get('main', 'toolbar').then(function(res) {
          if (!res.data == '') {
            res.data.forEach(function(t) {
              $scope.addtoolsbar(t);
            });
          }
        });
        //les Widgets
        ConfigFactory.get('main', 'tools').then(function(res) {
          console.log($rootScope.xgos.user);
          if (res.data.code == 403) {
            var errorMsg = '<h4>Erreur 403</h4> ';
            errorMsg += '<br/><h4>Details</h4>';
            errorMsg += '<br/>' + res.data.message;
            require('toastr').error(errorMsg);
          } else {
            if (res.data != '') {
              var menu = [];
              if (angular.isArray(res.data)) {
                angular.forEach(res.data, function(cat) {
                  var cateMenu = {};
                  cateMenu.categorie = cat.categorie;
                  cateMenu.modules = [];
                  angular.forEach(cat.modules, function(module) {
                    if (angular.isUndefined(module.roles)) {
                      module.roles = [];
                    }
                    if ($rootScope.xgos.user.name != 'root') {
                      if (module.roles.length > 0) {
                        var ok = false;

                        angular.forEach($rootScope.xgos.user.roles, function(
                          ro
                        ) {
                          var deleteIndex = module.roles
                            .map(function(x) {
                              return x;
                            })
                            .indexOf(ro.name);
                          if (deleteIndex > -1) {
                            ok = true;
                          }
                        });
                        if (ok) {
                          cateMenu.modules.push(module);
                        }
                      } else {
                        cateMenu.modules.push(module);
                      }
                    } else {
                      // je suis root
                      cateMenu.modules.push(module);
                    }
                  });
                  $scope.tools.push(cateMenu);
                });
              } else {
                var temp = res.data;
                angular.forEach(temp, function(value, key) {
                  var em = {};
                  em.categorie = key;
                  em.modules = value;
                  $scope.tools.push(em);
                });
              }
            }
          }
        });

        ConfigFactory.get('main', 'map').then(function(res) {
          if (!res.data == '') {
            $scope.propmap = res.data;
          }
        });

        $scope.propmap = {};

        /**
         * [hideaside use to hide aside]
         * @return nothing
         */
        $scope.toggleaside = function() {
          /* console.clear();
                         console.log('ICI');*/
          var map_aside = document.getElementById('map_aside');
          if (parseInt(map_aside.style['left'], 10) < 0) {
            map_aside.className = map_aside.className.replace('hide_aside', '');
            document.body.className = document.body.className + ' aside-open';
            map_aside.style['left'] = 0;
          } else {
            map_aside.className = map_aside.className + ' hide_aside';
            document.body.className = document.body.className.replace(
              'aside-open',
              ''
            );
            map_aside.style['left'] =
              '-' + (parseInt(map_aside.clientWidth) - 30) + 'px';
            console.log(map_aside.style['left']);
          }
        };

        // delete if it already exists
        if (document.getElementById('map_aside') !== null) {
          document.getElementById('map_aside').outerHTML = '';
        }
        $aside({
          scope: $scope,
          placement: 'left',
          backdrop: false,
          template: 'js/XG/widgets/mapapp/main/views/asides/left.html',
          keyboard: false,
        });

        /* ------------------
                     MAP  CONFIG
                     ------------------- */
        $scope.mapConfigTabs = [
          {
            title: 'map_config.tabs.menu.title',
          },
          {
            title: 'map_config.tabs.tools.title',
          },
        ];
        $scope.mapConfigTabs.activeTab = 0;

        /**
         *
         */
        $scope.savemapconfig = function() {
          var size = $scope.map.getSize();
          console.log($scope.map);
          console.log($scope.map.getView());
          console.log(size);
          console.log($scope.map.getView().calculateExtent(size));
          $scope.propmap.extent = $scope.map.getView().calculateExtent(size);
          $scope.propmap.zoom = $scope.map.getView().getZoom();
          $scope.propmap.srid = $scope.map
            .getView()
            .getProjection()
            .getCode();
          $scope.propmap.bcklayer = [];
          gclayers.getBackGroundLayer().forEach(function(ft) {
            $scope.propmap.bcklayer.push({ label: ft.label });
          });
          if (
            $scope.propmap &&
            $scope.propmap.bcklayer &&
            $scope.propmap.bcklayer.length > 0
          )
            $scope.propmap.bcklayer = [
              $scope.propmap.bcklayer[$scope.propmap.bcklayer.length - 1],
            ];

          if (!$scope.specialDashboard) {
            ConfigFactory.add($scope.propmap, 'main', 'map').then(function(
              res
            ) {
              require('toastr').success('Configuration sauvée');
            });

            $scope.mapmodel();
          } else {
            if (!$scope.defaultModel)
              $scope.defaultModel = {
                propmap: $scope.propmap,
                data: $scope.mapmodel(),
              };
            else {
              $scope.defaultModel.propmap = $scope.propmap;
              $scope.defaultModel.data = $scope.mapmodel();
            }
            if (!$scope.defaultModel || !$scope.defaultModel.id) {
              ParametersFactory.add(
                $scope.defaultModel,
                MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME,
                MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME
              ).then(
                function(res) {
                  if (res.data) {
                    $scope.defaultModel = res.data.data;
                    $scope.defaultModel.id = res.data.id;
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.info'),
                      $filter('translate')('hpo.common.successave'),
                      false,
                      'success'
                    );
                    $scope.savedconfig = true;
                    $scope.configid = $scope.defaultModel.id;
                  } else {
                    AlertHpoFactory.getSimpleFail(
                      $filter('translate')('hpo.common.info'),
                      $filter('translate')('hpo.common.faildsave'),
                      true,
                      'error'
                    );
                    $scope.savedconfig = true;
                    $scope.configid = $scope.defaultModel.id;
                  }
                },
                function() {}
              );
            } else {
              ParametersFactory.remove($scope.defaultModel.id).then(
                function() {
                  ParametersFactory.add(
                    $scope.defaultModel,
                    MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME,
                    MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME
                  ).then(
                    function(res) {
                      if (res.data) {
                        $scope.defaultModel = res.data.data;
                        $scope.defaultModel.id = res.data.id;
                        AlertHpoFactory.getSimpleSuccess(
                          $filter('translate')('hpo.common.info'),
                          $filter('translate')('hpo.common.successave'),
                          false,
                          'success'
                        );
                        $scope.savedconfig = true;
                        $scope.configid = $scope.defaultModel.id;
                      } else {
                        AlertHpoFactory.getSimpleFail(
                          $filter('translate')('hpo.common.info'),
                          $filter('translate')('hpo.common.faildsave'),
                          true,
                          'error'
                        );
                        $scope.savedconfig = true;
                        $scope.configid = $scope.defaultModel.id;
                      }
                    },
                    function(res) {
                      AlertHpoFactory.showErrorMessage(res);
                    }
                  );
                },
                function(res) {
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          }
        };

        /**
         *
         */
        $scope.savetoolbars = function() {
          ConfigFactory.add($scope.toolsbarbutton, 'main', 'toolbar').then(
            function(res) {
              require('toastr').success(
                $filter('translate')('map_config.config_saved')
              );
            }
          );
        };

        $scope.mapmodel = function() {
          //var lay = gclayers.getOperationalLayer();
          var lay = gclayers.getOperationalLayerg2c();
          var data = [];
          for (var ind = 0; ind < lay.length; ind++) {
            if (!angular.isUndefined(lay[ind].fti)) {
              var a = {
                name: lay[ind].name,
                index: lay.indexOf(lay[ind]),
                maxScale: lay[ind].maxScale,
                minScale: lay[ind].minScale,
                selected: lay[ind].selected,
                invertedOpacity: lay[ind].invertedOpacity,
                minResolution: lay[ind].minResolution,
                maxResolution: lay[ind].maxResolution,
                visible: lay[ind].visible,
                cql_filter: lay[ind].cql_filter,
                layerDefs: lay[ind].layerDefs,
                theme: lay[ind].theme,
                style: lay[ind].style,
                fti: lay[ind].fti,
              };
              //console.log(a);
              data.push(a);
            }
          }
          lay = gclayers.getOperationalLayerESRI();
          for (var ind = 0; ind < lay.length; ind++) {
            if (!angular.isUndefined(lay[ind].fti)) {
              var a = {
                name: lay[ind].name,
                index: lay.indexOf(lay[ind]),
                maxScale: lay[ind].maxScale,
                minScale: lay[ind].minScale,
                selected: lay[ind].selected,
                invertedOpacity: lay[ind].invertedOpacity,
                minResolution: lay[ind].minResolution,
                maxResolution: lay[ind].maxResolution,
                visible: lay[ind].visible,
                cql_filter: lay[ind].cql_filter,
                layerDefs: lay[ind].layerDefs,
                theme: lay[ind].theme,

                fti: lay[ind].fti,
              };
              //console.log(a);
              data.push(a);
            }
          }
          if (!$scope.specialDashboard) {
            ConfigFactory.add(data, 'main', 'mapmodel').then(
              function(res) {
                //require('toastr').success(res.data);
              },
              function(reason) {
                require('toastr').error(reason);
              }
            );
          } else {
            return data;
          }
        };

        $scope.savetools = function() {
          // remove empty categories
          /*for (var i = $scope.tools.length - 1; i >= 0; i -= 1) {
                             if ($scope.tools[i].modules.length == 0) {
                             $scope.tools.splice(i, 1);
                             }
                             }*/

          ConfigFactory.add($scope.tools, 'main', 'tools').then(function(res) {
            //require('toastr').success("Configuration sauvee");
          });
        };


        $scope.go = (extent) => {
          //console.log(place.extent);
          //const mapElement = document.getElementById('hpo-map');
          //const size = [mapElement.offsetWidth, mapElement.offsetHeight];
          const size = $scope.map.getSize();
          const view = $scope.map.getView();

          $rootScope.doNotPropagateMapRefresh = true;
          view.fit(extent, size);
        };


        /*
       *  Une fois la carte openlayers initialisée, il se peut que sa taille
       *  ne soit pas correcte (en hauteur). Il y a des cas de démarrage où
       *  elle ne prend pas les 100% de la fenêtre ... du coup,
       *  on reaffecte la hauteur une fois les initialisations faites.
       */
        $scope.map.once('postcompose', () => {
          $timeout(function() {
            $scope.map.setSize([$scope.map.getSize()[0], window.innerHeight]);
          }, 500);
        });


        /**
         * [addtools use to addtool on the aside object ]
         * @param  {[tools]} tool [add tool to the aside manadger ]
         * @return nothing
         */
        $scope.openmodifytools = function(tool) {
          $scope.oldtool = tool;
          $scope.curtool = angular.copy(tool);
          var configDialog = ngDialog.open({
            template: 'js/XG/widgets/mapapp/main/views/toolmodify.html',
            className: 'ngdialog-theme-plain',

            closeByDocument: false,
            scope: $scope,
          });
        };
        /*$scope.openaddtools = function(tool)
                         {
                         console.log(tool);
                         $scope.curtool = angular.copy(tool);
                         var configDialog = ngDialog.open({
                         template: 'js/XG/widgets/mapapp/main/views/toolconfig.html',
                         className: 'ngdialog-theme-plain',

                         closeByDocument: false,
                         scope: $scope
                         });
                         };*/
        $scope.modifytools = function(tool) {
          $scope.removetool($scope.oldtool);
          $scope.addtools(tool);
        };
        $scope.addtools = function(tool) {
          //var deleteIndex = $scope.tools.map(function(x) { return x.name; }).indexOf(tool.name);
          tool.chosenTitle = tool.title;
          //if (deleteIndex == -1)
          //{

          if (angular.isUndefined(tool.categorie)) {
            tool.categorie = 'Divers';
          }
          if (angular.isUndefined(tool.mode)) {
            tool.mode = 'Panel';
          }
          var toolselement = null;
          $scope.tools.forEach(function(m) {
            if (m.categorie == tool.categorie) {
              toolselement = m;
            }
          });
          if (toolselement == null) {
            toolselement = {};
            if (angular.isUndefined(tool.categorie)) {
              tool.categorie = 'Divers';
            }

            toolselement.categorie = tool.categorie;
            toolselement.modules = [];
            toolselement.modules.push(tool);
            $scope.tools.push(toolselement);
          } else {
            toolselement.modules.push(tool);
          }

          $scope.configToolPopup.close();

          /* if (!angular.isUndefined($scope.tools[tool.categorie] ))
                             {

                             $scope.tools[tool.categorie].push(tool); ;
                             }
                             else
                             {

                             $scope.tools[tool.categorie] = [];
                             $scope.tools[tool.categorie].push(tool); ;
                             }*/

          //$scope.tools.push(tool);
          //}
        };

        $scope.movetoolbar = function(index, direction) {
          if (
            (index == 0 && direction == 'up') ||
            (index == $scope.amountOfTools - 1 && direction == 'down')
          )
            return false;
          var newIndex = direction == 'up' ? index - 1 : index + 1;
          $scope.toolsbarbutton.splice(
            index,
            0,
            $scope.toolsbarbutton.splice(newIndex, 1)[0]
          );
        };

        /**
         * Move a tool up
         * @param tool
         * @param category
         */
        $scope.uptool = function(tool, category) {
          var moveIndex = category.modules
            .map(function(x) {
              return x.name + x.title;
            })
            .indexOf(tool.name + tool.title);
          $scope.moveelement(category.modules, moveIndex, -1);
        };

        /**
         * Move a tool down
         * @param tool
         * @param category
         */
        $scope.downtool = function(tool, category) {
          var moveIndex = category.modules
            .map(function(x) {
              return x.name + x.title;
            })
            .indexOf(tool.name + tool.title);
          $scope.moveelement(category.modules, moveIndex, 1);
        };

        /**
         * delete categorie
         * @param categorie
         */
        $scope.deleteCategorie = function(categorie) {
          var ans = confirm(
            $filter('translate')('map_config.toolsbar.confirm_delete_categorie')
          );
          if (ans) {
            var deleteIndex = $scope.tools
              .map(function(x) {
                return x.categorie;
              })
              .indexOf(categorie.categorie);
            $scope.tools.splice(deleteIndex, 1);
          }
        };

        /** move categorie up **/
        $scope.upcategorie = function(categorie) {
          console.log(categorie);
          var deleteIndex = $scope.tools
            .map(function(x) {
              return x.categorie;
            })
            .indexOf(categorie.categorie);
          console.log(deleteIndex);
          $scope.moveelement($scope.tools, deleteIndex, -1);
        };
        /** move categorie down **/
        $scope.downcategorie = function(categorie) {
          var deleteIndex = $scope.tools
            .map(function(x) {
              return x.categorie;
            })
            .indexOf(categorie.categorie);
          console.log(deleteIndex);
          $scope.moveelement($scope.tools, deleteIndex, 1);
        };

        $scope.removecategorie = function(categorie) {
          var deleteIndex = $scope.tools
            .map(function(x) {
              return x.categorie;
            })
            .indexOf(categorie.categorie);
          $scope.tools.splice(deleteIndex, 1);
          //var deleteIndex  = $scope.tools.hasOwnProperty(categorie);
          // delete $scope.tools[categorie];
        };

        /**
         * Move an element (tool/category)
         * @param table
         * @param index
         * @param delta
         * @returns {boolean}
         */
        $scope.moveelement = function(table, index, delta) {
          if (index < 0 || index >= table.length) {
            return false;
          }
          var index2 = index + delta;
          if (index2 < 0 || index2 >= table.length) {
            return false;
          }
          var temp_item = table[index];
          table[index] = table[index2];
          table[index2] = temp_item;
          return true;
        };

        //Role @RB voi si on le met pas avant
        RolesFactory.get().then(function(fdata) {
          console.log(fdata);
          $scope.rolelist = RolesFactory.resources.roles;
        });
        /**
         * [addRolesTool description]
         * @param {[type]} tool  [description]
         * @param {[type]} nRole [description]
         */
        $scope.addRolesTool = function(tool, nRole) {
          console.log(tool);
          console.log(nRole);
          if (angular.isUndefined(tool.roles)) {
            tool.roles = [];
          }
          var deleteIndex = tool.roles
            .map(function(x) {
              return x;
            })
            .indexOf(nRole.name);
          if (deleteIndex == -1) {
            tool.roles.push(nRole.name);

            console.log(tool.roles);
          }
        };
        /**
         * [removeRolesTool description]
         * @param  {[type]} tool        [description]
         * @param  {[type]} nRole       [description]
         * @param  {[type]} deleteIndex [description]
         * @return {[type]}             [description]
         */
        $scope.removeRolesTool = function(tool, nRole, deleteIndex) {
          tool.roles.splice(deleteIndex, 1);
        };

        /**
         * Remove tool from category
         * @param tool
         * @param category
         */
        $scope.removetool = function(tool, category) {
          var deleteIndex = category.modules
            .map(function(x) {
              return x.name + x.title;
            })
            .indexOf(tool.name + tool.title);
          category.modules.splice(deleteIndex, 1);
        };

        $scope.removetoolsbar = function(toolbar) {
          var deleteIndex = $scope.toolsbarbutton
            .map(function(x) {
              return x.name;
            })
            .indexOf(toolbar.name);
          $scope.toolsbarbutton.splice(deleteIndex, 1);
        };
        $scope.addtoolsbar = function(toolbar) {
          $scope.toolsbarbutton.push(toolbar);
        };

        /**
         * edit a toolbar item configuration (popup)
         * @param tool
         * @param category
         * @param isnew
         */
        $scope.editToolsBarConfig = function(tool, category, isnew) {
          /*$scope.savecurtool = angular.copy(tool);*/
          $scope.curtool = angular.copy(tool);
          $scope.curtoolSvg = angular.copy(tool);
          $scope.curtool.categorie = category.categorie;
          $scope.curcategory = category;
          $scope.isNewTool = isnew;
          $scope.categoriesList = $scope.tools.map(function(a) {
            return a.categorie;
          });

          $scope.configToolPopup = ngDialog.open({
            template: 'js/XG/widgets/mapapp/main/views/toolconfig.html',
            className: 'ngdialog-theme-plain width600 miniclose nopadding',
            closeByDocument: false,
            scope: $scope,
          });
        };

        /**
         * Update a tool bar
         */
        $scope.updateToolsBarCfg = function() {
          // same categorie, only other parameters were changed (title, cfg)
          if ($scope.curtool.categorie == $scope.curcategory.categorie) {
            delete $scope.curtool.categorie; // not used anymore, no need to save it
            $scope.curcategory.modules.forEach(function(mod, i) {
              if (
                mod.name == $scope.curtool.name &&
                mod.title == $scope.curtoolSvg.title
              ) {
                $scope.curcategory.modules[i] = $scope.curtool;
              }
            });

            // different category
          } else {
            // only if the tool was previously set in a category (not a new tool)
            if ($scope.curcategory) {
              // remove from original category
              $scope.curcategory.modules.forEach(function(mod, i) {
                if (
                  mod.name == $scope.curtool.name &&
                  mod.title == $scope.curtoolSvg.title
                ) {
                  $scope.curcategory.modules.splice(i, 1);
                }
              });
              // if the category is now empty
              if ($scope.curcategory.modules.length == 0) {
                var categoryIndex = $scope.tools
                  .map(function(x) {
                    return x.categorie;
                  })
                  .indexOf($scope.curcategory.categorie);
                $scope.tools.splice(categoryIndex, 1);
              }
            }

            // add to new category
            var newCategoryIndex = $scope.tools
              .map(function(x) {
                return x.categorie;
              })
              .indexOf($scope.curtool.categorie);
            delete $scope.curtool.categorie; // not used anymore, no need to save it
            $scope.tools[newCategoryIndex].modules.push($scope.curtool);
            setDirectivesListExtraInformation();
          }

          $scope.configToolPopup.close();
        };

        /**
         * Add or remove a tool (left side)
         * @param tool
         */
        $scope.configToolPopup = {};
        $scope.addOrRemoveFromToolslist = function(tool) {
          /* if(!tool.hasOwnProperty('used') || !tool.used){
                             $scope.editToolsBarConfig(tool,1);
                             // $scope.addtools(tool);
                             }else{
                             $scope.removetool(tool);
                             }*/
        };

        /**
         * setDirectivesListExtraInformation for display in new tool modal
         */
        var setDirectivesListExtraInformation = function() {
          var arr = {};
          $scope.DirectivesList.forEach(function(d) {
            if (!arr[d.categorie]) arr[d.categorie] = [];
            d.used = 0;
            $scope.tools.forEach(function(t) {
              t.modules.forEach(function(m) {
                if (m.directive == d.directive) {
                  d.used = d.used + 1;
                }
              });
            });
            arr[d.categorie].push(d);
          });

          $scope.DirectivesListExtra = arr;
        };
        /** Add a tool modal **/
        $scope.addToolModal = function() {
          $scope.newTool = {};
          // transform DirectivesList into an object ordered by categorie with extra info
          // (how many times its already used for example)
          setDirectivesListExtraInformation();
          $scope.newToolDialog = ngDialog.open({
            template: 'js/XG/widgets/mapapp/main/views/new_tool.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: $scope,
          });
        };

        /** Add a category modal **/
        var oldCategoryName;
        $scope.editCategoryModal = function(category) {
          $scope.categoryAdded = false;
          $scope.editCategory = {};
          $scope.isNewCategory = true;
          if (category) {
            $scope.isNewCategory = false;
            $scope.editCategory.name = category.categorie;
            oldCategoryName = category.categorie;
          }
          $scope.editCategoryDialog = ngDialog.open({
            template: 'js/XG/widgets/mapapp/main/views/new_category.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: $scope,
          });
        };

        /** Add a category **/
        $scope.addCategory = function() {
          $scope.editCategoryDialog.close();
          if ($scope.isNewCategory) {
            $scope.categoryAdded = true;
            $scope.tools.push({
              categorie: $scope.editCategory.name,
              modules: [],
            });
          } else {
            for (var i in $scope.tools) {
              if ($scope.tools[i].categorie == oldCategoryName) {
                $scope.tools[i].categorie = $scope.editCategory.name;
              }
            }
          }
        };

        /**
         * Reset all the toolbars
         */
        $scope.resetToolsBar = function() {
          var ans = confirm(
            $filter('translate')('map_config.toolsbar.reset_title')
          );
          if (ans) {
            $scope.tools = [];
          }
        };
        /**
         * Add or remove a toolbar (right side)
         * @param toolbar
         */
        $scope.addOrRemoveFromToolsbar = function(toolbar) {
          if (!toolbar.used) {
            $scope.toolsbarbutton.push(toolbar);
          } else {
            var deleteIndex = $scope.toolsbarbutton
              .map(function(x) {
                return x.name;
              })
              .indexOf(toolbar.name);
            $scope.toolsbarbutton.splice(deleteIndex, 1);
          }
        };

        /**
         * Save everything (tools,toolbars,map
         */
        $scope.saveToolsAndToolsBarsConfig = function() {
          // save tools
          $scope.savetools();
          // save toolbars
          $scope.savetoolbars();
        };

        $scope.configpopup = function() {
          //console.log("mainconfig");
          $scope.mapConfigTabs.activeTab = 0;
          var configDialog = ngDialog.open({
            template: 'js/XG/widgets/mapapp/main/views/toolbarconfig.html',
            className: 'ngdialog-theme-plain width800 miniclose',
            closeByDocument: false,
            scope: $scope,
          });
        };
        /**
         * [toolsbarbutton Array of the vertical toolbar button ]
         * @type {Array}
         */
        $scope.toolsbarbutton = [
          /*{
                             "type": "widget",
                             "name": "gctoolbarasideleft",
                             "config": "b"
                             }*/
        ];

        /*****************************************************************************************/
        /**
         * [app description]
         * @type {[type]}
         */
        $scope.app = getParameterByName('app');
        localStorage.setItem('app', $scope.app);
        //-- Store the application name on the main module, in order
        //-- the application won't be overwritten by the local storage
        //-- value in case many tabs are opened on different applications.
        var gcMain = angular.module('gcMain');
        gcMain.app = $scope.app;
        /**
         * [portalid description]
         * @type {[type]}
         */
        $scope.portalid = getParameterByName('portal');
        //
        //
        PortalsFactory.setPortal($scope.portalid);

        gcMain.portalid = $scope.portalid;

        $scope.tableheight =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';
      },],
      scope: {
        fti: '=?',
        ftis: '=?',
        res: '=?',
        hidefilterbtn: '=?',
        configUser: '=?',
        specialDashboard: '=?',
        savedconfig: '=?',
        configid: '=?',
        onlyMap: '=?',
        canconfigmap: '=?',
        suppFunctions: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.useThisFitler = function() {
          if (
            $rootScope.xgos &&
            $rootScope.xgos.hpo &&
            $rootScope.xgos.hpo.clauseWhere
          )
            $rootScope.$broadcast('changedHpoValue', $rootScope.xgos.hpo);
        };
      },
    };
  };

  HpoMap.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoAppFactory',
    '$window',
    'ngDialog',
    '$filter',
    '$rootScope',
    '$timeout',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'gcDirectivesList',
    'panelsManager',
    'ConfigFactory',
    '$location',
    'SelectManager',
    'gcWMS',
    'gclayers',
    'PortalsFactory',
    '$aside',
    'RolesFactory',
    'BaseMapFactory',
    'gaJsUtils',
  ];
  return HpoMap;
});
