'use strict';
define(function() {
  var dashboardHpoValidation = function(
    HpoCarteAppFactory,
    HpoDataVisServices,
    FeatureTypeFactory,
    $filter,
    gaDomUtils,
    gcMapUtils, $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/dashboard_hpo_validation.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {

        /**
         * Récupére l'iframe qui contiendra la carte préparée en HTML dés qu'elle est disponible.
         * Une fois disponible, on définie une fonction à appeler une fois le contenu chargé.
         * Quand l'iframe est chargée avec succès,
         * le drapeau 'loadingIframe' du scope est mis à false.
         *
         */
        const setOnLoadForIframe = () => {
          const mapIframe= document.getElementById('urlMapIFrame');
          if (mapIframe) {
            mapIframe.onload = () => {
              // -- "onload" n'est pas du angularjs, il faut donc utiliser
              // -- un $timeout pour que la directive soit actualisée.
              $timeout(() => {
                scope.loadingIframe = false;
              });
            };
          }
          else {
            $timeout(setOnLoadForIframe,500);
          }
        };

        $timeout(setOnLoadForIframe);


        var cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
        scope.baseMap = cfg.baseMap?cfg.baseMap:'toner-lite';
        let defined = false;
        if(scope.objValidationPrevision){
          defined = true;
          scope.components = {
            uidJeu: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
              'jeu_de_donnee'
            )[0].uid,
            uidCalage: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
              'calage'
            )[0].uid,
            identifiant: scope.objValidationPrevision.properties.IDENTIFIANT,
            identifiantModel: scope.objValidationPrevision.properties.IDENTIFIANT_MODELE,
            identifiantJeuDonnee: scope.objValidationPrevision.properties.ID_JEU_DONNEE,
            identifiantCalage: scope.objValidationPrevision.properties.IDENTIFIANT_CALAGE,
            cfg: cfg,
            s3: true,
            type: scope.typeDataVis
          };
        }
        if (defined){
          scope.previewftis = [FeatureTypeFactory.getFeatureByUid(cfg.ftiStatuid),FeatureTypeFactory.getFeatureByUid(cfg.ftiStatdefailuid)];
          const colors = ['#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
            '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
            '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
            '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
            '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
            '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
            '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
            '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
            '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
            '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8']
          gaDomUtils.showGlobalLoader();
          HpoDataVisServices.getStatsMateriauValidPrev(scope.components).then((res)=>{
            gaDomUtils.hideGlobalLoader();
            var data1 = [{
              values: Object.values(res.data['MATERIAU']),
              labels: Object.keys(res.data['MATERIAU']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];

            var layout1 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInService'),
            };

            Plotly.newPlot('distributionTermsMat', data1, layout1);
            scope.distributionTermsMat = true;

            let colorsRisque = [];
            Object.keys(res.data['MATERIAU_RISQUE']).forEach(mat =>{
              colorsRisque.push(colors[Object.keys(res.data['MATERIAU']).indexOf(mat)])
            });

            var data2 = [{
              values: Object.values(res.data['MATERIAU_RISQUE']),
              labels: Object.keys(res.data['MATERIAU_RISQUE']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colorsRisque
              }
            }];

            var layout2 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInRisque'),
            };

            Plotly.newPlot('distributionTermsMatRisque', data2, layout2);
            scope.distributionTermsMatRisque = true;

            // DATE_DE_POSE
            var data3 = [{
              values: Object.values(res.data['DATE_DE_POSE']),
              labels: Object.keys(res.data['DATE_DE_POSE']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];

            var layout3 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInService'),
            };

            Plotly.newPlot('distributionTermsYears', data3, layout3);
            scope.distributionTermsYears = true;

            let colorsRisque2 = [];
            Object.keys(res.data['DATE_DE_POSE_RISQUE']).forEach(mat =>{
              colorsRisque2.push(colors[Object.keys(res.data['DATE_DE_POSE']).indexOf(mat)])
            });

            var data4 = [{
              values: Object.values(res.data['DATE_DE_POSE_RISQUE']),
              labels: Object.keys(res.data['DATE_DE_POSE_RISQUE']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colorsRisque2
              }
            }];

            var layout4 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInRisque'),
            };

            Plotly.newPlot('distributionTermsYearsRisque', data4, layout4);
            scope.distributionTermsYearsRisque = true;
            // diametre
            var data5 = [{
              values: Object.values(res.data['DIAMETER']),
              labels: Object.keys(res.data['DIAMETER']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];

            var layout5 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInService'),
            };

            Plotly.newPlot('distributionTermsDiam', data5, layout5);
            scope.distributionTermsDiam = true;

            let colorsRisque3 = [];
            Object.keys(res.data['DIAMETER_RISQUE']).forEach(mat =>{
              colorsRisque3.push(colors[Object.keys(res.data['DIAMETER']).indexOf(mat)])
            })

            var data6 = [{
              values: Object.values(res.data['DIAMETER_RISQUE']),
              labels: Object.keys(res.data['DIAMETER_RISQUE']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colorsRisque3
              }
            }];

            var layout6 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInRisque'),
            };

            Plotly.newPlot('distributionTermsDiamRisque', data6, layout6);
            scope.distributionTermsDiamRisque = true;

            // cohortes
            var data7 = [{
              values: Object.values(res.data['COHORTES']),
              labels: Object.keys(res.data['COHORTES']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];

            var layout7 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInService'),
            };

            Plotly.newPlot('distributionTermsCohortes', data7, layout7);
            scope.distributionTermsCohortes = true;

            let colorsRisque4 = [];
            Object.keys(res.data['COHORTES_RISQUE']).forEach(mat =>{
              colorsRisque4.push(colors[Object.keys(res.data['COHORTES']).indexOf(mat)])
            })

            var data8 = [{
              values: Object.values(res.data['COHORTES_RISQUE']),
              labels: Object.keys(res.data['COHORTES_RISQUE']),
              type: 'pie',
              sort:false,
              marker: {
                colors: colorsRisque4
              }
            }];

            var layout8 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipesInRisque'),
            };

            Plotly.newPlot('distributionTermsCohortesRisque', data8, layout8);
            scope.distributionTermsCohortesRisque = true;

            scope.redActive = true;
            scope.orangeActive = true;
            scope.yellowActive = true;
            scope.bleuActive = true;

            if (res.data.HTML_MAP_URL) {
              // -- Une URL de page HTML de carte est fournie
              scope.loadingIframe = true;
              scope.mapUrl = res.data.HTML_MAP_URL;
            }
            else {
              // -- Dessin de la carte habituelle
              var geometriesBleu = [];
              var geometriesyellow = [];
              var geometriesOrange = [];
              var geometriesRed = [];
              res.data.GEOMETRY.bleu.forEach(function(g) {
                let feature = gcMapUtils.toGeometry(g);
                if (feature) geometriesBleu.push(feature);
              });
              res.data.GEOMETRY.yellow.forEach(function(g) {
                let feature = gcMapUtils.toGeometry(g);
                if (feature) geometriesyellow.push(feature);
              });
              res.data.GEOMETRY.orange.forEach(function(g) {
                let feature = gcMapUtils.toGeometry(g);
                if (feature) geometriesOrange.push(feature);
              });
              res.data.GEOMETRY.red.forEach(function(g) {
                let feature = gcMapUtils.toGeometry(g);
                if (feature) geometriesRed.push(feature);
              });

              var vectorBleu = new ol.layer.Vector({
                source: new ol.source.Vector({
                  features: geometriesBleu
                }),
                style: new ol.style.Style({
                  stroke: new ol.style.Stroke({color: '#009CCD', width: 1})
                })
              });

              var vectorYellow = new ol.layer.Vector({
                source: new ol.source.Vector({
                  features: geometriesyellow
                }),
                style: new ol.style.Style({
                  stroke: new ol.style.Stroke({color: '#FFC000', width: 2})
                })
              });

              var vectorOrange = new ol.layer.Vector({
                source: new ol.source.Vector({
                  features: geometriesOrange
                }),
                style: new ol.style.Style({
                  stroke: new ol.style.Stroke({color: '#ED7D31', width: 3})
                })
              });

              var vectorRed = new ol.layer.Vector({
                source: new ol.source.Vector({
                  features: geometriesRed
                }),
                style: new ol.style.Style({
                  stroke: new ol.style.Stroke({color: '#FF0000', width: 4})
                })
              });

              let geometriesAll = [...geometriesRed,...geometriesOrange,...geometriesyellow,...geometriesBleu];

              var vectorAll = new ol.layer.Vector({
                source: new ol.source.Vector({
                  features: geometriesAll
                })
              });

              let extent= geometriesAll.length>0?vectorAll.getSource().getExtent():[0,0,0,0];
              let source;
              if(!scope.baseMap || scope.baseMap === 'osm'){
                source = new ol.source.OSM();
              } else {
                source = new ol.source.XYZ({
                  url:'http://{1-4}.basemaps.cartocdn.com/'+scope.baseMap+'/{z}/{x}/{y}.png',
                });
              }
              var map = new ol.Map({
                layers: [
                  new ol.layer.Tile({
                    source: source,
                  }),
                  vectorBleu,
                  vectorYellow,
                  vectorOrange,
                  vectorRed,
                ],
                interactions: ol.interaction.defaults({mouseWheelZoom: false}).extend([gcMapUtils.altZoomInteraction()]),
                target: 'previewmap',
                view: new ol.View({
                  projection: res.data.srid,
                  center: ol.extent.getCenter(extent),
                  zoom: 13,
                }),
                ol3Logo: false,
              });
              map.getView().fit(extent,map.getSize());
              scope.mapIsSet = true;
              scope.addRemoveLayer =  (type) =>{
                switch(type){
                  case 'bleu':
                    if(scope.bleuActive){
                      map.removeLayer(vectorBleu);
                      scope.bleuActive = false;
                    }else{
                      map.addLayer(vectorBleu);
                      scope.bleuActive = true;
                    }break;
                  case 'yellow':
                    if(scope.yellowActive){
                      map.removeLayer(vectorYellow);
                      scope.yellowActive = false;
                    }else{
                      map.addLayer(vectorYellow);
                      scope.yellowActive = true;
                    }break;
                  case 'orange':
                    if(scope.orangeActive){
                      map.removeLayer(vectorOrange);
                      scope.orangeActive = false;
                    }else{
                      map.addLayer(vectorOrange);
                      scope.orangeActive = true;
                    }break;
                  case 'red':
                    if(scope.redActive){
                      map.removeLayer(vectorRed);
                      scope.redActive = false;
                    }else{
                      map.addLayer(vectorRed);
                      scope.redActive = true;
                    }break;
                }
              };
            }
            scope.legend = res.data.LEGEND;

          },() =>{
            gaDomUtils.hideGlobalLoader();
          });

        }
      },
    };
  };

  dashboardHpoValidation.$inject = [
    'HpoCarteAppFactory',
    'HpoDataVisServices',
    'FeatureTypeFactory',
    '$filter',
    'gaDomUtils',
    'gcMapUtils', '$timeout'
  ];
  return dashboardHpoValidation;
});
