'use strict';
define(function() {
  var dashboardHpoChantierauto = function(
    HpoCarteAppFactory,
    HpoDataVisServices,
    FeatureTypeFactory,
    $filter,
    gaDomUtils,
    $timeout,
    gcMapUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/dashboard_hpo_chantierAuto.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.typeArray = [];
        
        var cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
        scope.baseMap = cfg.baseMap?cfg.baseMap:'toner-lite';
        let defined = false
        if(scope.dataVisChantierAuto){
          defined = true;
          scope.components = {
            uidJeu: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
              'jeu_de_donnee'
            )[0].uid,
            uidCalage: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
              'calage'
            )[0].uid,
            identifiant: scope.dataVisChantierAuto.properties.IDENTIFIANT,
            identifiantModel: scope.dataVisChantierAuto.properties.INFO.IDENTIFIANT_MODELE,
            identifiantPrevision: scope.dataVisChantierAuto.properties.INFO.IDENTIFIANT,
            identifiantCalage: scope.dataVisChantierAuto.properties.INFO.IDENTIFIANT_CALAGE,
            cfg: cfg,
            s3: true,
            type: scope.typeDataVis
          };

        }
        const colors = ['#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8']
        scope.distributionTermsMat = {};
        scope.distributionTermsYears = {};
        scope.distributionTermsDiam = {};
        scope.distributionTermsCohortes = {};
        var geometriesBleu = {};
        var geometriesRed = {};
        var vectorBleu = {};
        var vectorRed = {};
        var map = {};
        scope.mapIsSet = {};
        scope.redActive = {};
        scope.bleuActive = {};
        if (defined){
          scope.previewftis = [FeatureTypeFactory.getFeatureByUid(cfg.ftiStatuid),FeatureTypeFactory.getFeatureByUid(cfg.ftiStatdefailuid)];
          gaDomUtils.showGlobalLoader();
          HpoDataVisServices.getStatsChantierAuto(scope.components).then((res)=>{
            gaDomUtils.hideGlobalLoader();
            scope.typeArray = res.data.CS_METHODE_MAPPING;
            $timeout(() => {
              scope.typeArray.forEach((type)=>{
                statChantierCore(res,type);
              });
            },0);
          }, () =>{
            gaDomUtils.hideGlobalLoader();
          });
        }
        let statChantierCore = (res, type) => {
          if (!scope.mapURL) {
            scope.mapURL = {};
          }
      
          if(res.data.MATERIAU_ALL[type]){
            var data1 = [{
              values: Object.values(res.data.MATERIAU_ALL[type]),
              labels: Object.keys(res.data.MATERIAU_ALL[type]),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];
            
            var layout1 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.materials'),
            };
            
            Plotly.newPlot('distributionTermsMat'+ type, data1, layout1);
            scope.distributionTermsMat[type] = true;
          }

          // DATE_DE_POSE
          if(res.data.ANNEE_POSE_ALL[type]){
            var data3 = [{
              values: Object.values(res.data.ANNEE_POSE_ALL[type]),
              labels: Object.keys(res.data.ANNEE_POSE_ALL[type]),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];
            
            var layout3 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.installationPeriod'),
            };
            
            Plotly.newPlot('distributionTermsYears'+ type, data3, layout3);
            scope.distributionTermsYears[type] = true;
          }

          // diametre
          if(res.data.DIAMETRE_ALL[type]){
            var data5 = [{
              values: Object.values(res.data.DIAMETRE_ALL[type]),
              labels: Object.keys(res.data.DIAMETRE_ALL[type]),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];
            
            var layout5 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.diameterGroup'),
            };
            
            Plotly.newPlot('distributionTermsDiam'+ type, data5, layout5);
            scope.distributionTermsDiam[type] = true;
          }

          // cohortes
          if(res.data.COHORTES_ALL[type]){
            var data7 = [{
              values: Object.values(res.data.COHORTES_ALL[type]),
              labels: Object.keys(res.data.COHORTES_ALL[type]),
              type: 'pie',
              sort:false,
              marker: {
                colors: colors
              }
            }];
            
            var layout7 = {
              height: 500,
              title:$filter('translate')('hpo.admin.dashBoardAutomatique.pipeCohorts'),
            };
            
            Plotly.newPlot('distributionTermsCohortes' + type, data7, layout7);
            scope.distributionTermsCohortes[type] = true;
          }

          let geometry = 'GEOMETRY' + type;
          
          if(res.data.GEOMETRY_ALL[type] && res.data.GEOMETRY_ALL[type].red && res.data.GEOMETRY_ALL[type].red.length>0){
            if(type == "allMethode" && res.data.HTML_MAP_URL_allMethode) {
              scope.mapURL[type] = res.data.HTML_MAP_URL_allMethode;
            } else {
              geometriesBleu[type] = [];
              geometriesRed[type] = [];
              res.data.GEOMETRY_ALL[type].bleu.forEach(function(g) {
                let feature = gcMapUtils.toGeometry(g)
                if (feature) geometriesBleu[type].push(feature);
              });
              res.data.GEOMETRY_ALL[type].red.forEach(function(g) {
                let feature = gcMapUtils.toGeometry(g)
                if (feature) geometriesRed[type].push(feature);
              });
    
              vectorBleu[type] = new ol.layer.Vector({
                source: new ol.source.Vector({
                    features: geometriesBleu[type]
                }),
                style: new ol.style.Style({
                  stroke: new ol.style.Stroke({color: '#009CCD', width: 2})
                })
              });
    
              vectorRed[type] = new ol.layer.Vector({
                source: new ol.source.Vector({
                    features: geometriesRed[type]
                }),
                style: new ol.style.Style({
                  stroke: new ol.style.Stroke({color: '#FF0000', width: 4})
                })
              });

              let geometriesAll = [...geometriesBleu[type],...geometriesRed[type]];

              var vectorAll = new ol.layer.Vector({
                source: new ol.source.Vector({
                    features: geometriesAll
                })
              });

              let extent= geometriesAll.length>0?vectorAll.getSource().getExtent():[0,0,0,0];

              let source;
              if(!scope.baseMap || scope.baseMap === 'osm'){
                source = new ol.source.OSM();
              } else {
                source = new ol.source.XYZ({ 
                  url:'http://{1-4}.basemaps.cartocdn.com/'+scope.baseMap+'/{z}/{x}/{y}.png',
                })
              }
    
              map[type] = new ol.Map({
                layers: [
                  new ol.layer.Tile({
                    source: source,
                  }),
                  vectorBleu[type],
                  vectorRed[type],
                ],
                interactions: ol.interaction.defaults({mouseWheelZoom: false}).extend([gcMapUtils.altZoomInteraction()]),
                target: 'previewmap'+type,
                view: new ol.View({
                  projection: res.data.srid,
                  center: ol.extent.getCenter(extent),
                  zoom: 13,
                }),
                ol3Logo: false,
              });
              map[type].getView().fit(extent,map[type].getSize());
              scope.mapIsSet[type] = true;
              scope.redActive[type] = true;
              scope.bleuActive[type] = true;
            }
          }
        }

        scope.addRemoveLayer =  (couche,type) =>{
          switch(couche){
            case 'bleu': 
              if(scope.bleuActive[type]){
                map[type].removeLayer(vectorBleu[type]);
                scope.bleuActive[type] = false;
              }else{
                map[type].addLayer(vectorBleu[type]);
                scope.bleuActive[type] = true;
              }break;
            case 'red': 
              if(scope.redActive[type]){
                map[type].removeLayer(vectorRed[type]);
                scope.redActive[type] = false;
              }else{
                map[type].addLayer(vectorRed[type]);
                scope.redActive[type] = true;
              }break;
          }
        }
        scope.getTitleByType = (type) =>{
          if(type.startsWith('constructionsiteoptimizedbyconstraintsn')){
            return $filter('translate')('hpo.admin.dashBoardAutomatique.ReminderPepInService.' + 
                      type.replaceAll(/[0-9]/g,'')) + type.replaceAll(/[^0-9]/g,'');
          }
          return $filter('translate')('hpo.admin.dashBoardAutomatique.ReminderPepInService.' + type);
        }
      },
    };
  };

  dashboardHpoChantierauto.$inject = [
    'HpoCarteAppFactory',
    'HpoDataVisServices',
    'FeatureTypeFactory',
    '$filter',
    'gaDomUtils',
    '$timeout',
    'gcMapUtils'
  ];
  return dashboardHpoChantierauto;
});
