'use strict';
define(function() {
  var cassesPerYearsPerKmPerCommune = function(
    HpoCarteAppFactory,
    HpoDataVisServices,
    FeatureTypeFactory,
    $filter,
    gaDomUtils,
    $q,
    $rootScope
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/cassesPerYearsPerKmPerCommune.html',
      restrict: 'EA',
      link: function(scope) {
        const MSG_PREFIX = 'hpo.admin.dashBoardAutomatique';
        let directiveFunction = () => {
          const cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
          let defined = false;
          let ftiStat;
          let ftiStatdefail;
          scope.portalid = $rootScope.xgos.portal.uid;
          
          if(scope.objStandardisation){
            defined = true;
            scope.components = {
              uidJeu: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
                'jeu_de_donnee'
              )[0].uid,
              identifiantJeuDonnee: scope.objStandardisation.properties.SELECTED_JEU,
              composant: scope.objStandardisation.properties.COMPOSANT,
              cfg: cfg,
              s3: true,
              type:'standardisation'
            };
            ftiStat
              = FeatureTypeFactory.getFeatureByName(scope.objStandardisation.properties.COMPOSANT);
            ftiStat.visible = true;
            let resource = HpoCarteAppFactory.getAppFactory().getResourceFromUidCana(ftiStat.uid);
            ftiStatdefail = FeatureTypeFactory.getFeatureByUid(resource.defail_uid);
            ftiStatdefail.visible = true;
          }
          else if( cfg.ftiStatuid || cfg.ftiStatdefailuid){
            defined = true;
            scope.components = {
              canalisation: cfg.ftiStatuid,
              defailcanalisation: cfg.ftiStatdefailuid,
              cfg: cfg,
              s3: false
            };
            ftiStat = FeatureTypeFactory.getFeatureByUid(cfg.ftiStatuid);
            ftiStat.visible = true;
            if(cfg.ftiStatdefailuid){
              ftiStatdefail = FeatureTypeFactory.getFeatureByUid(cfg.ftiStatdefailuid);
              ftiStatdefail.visible = true;
            }
          }
          if (defined){
            let promises = [];
            gaDomUtils.showGlobalLoader();
            if(cfg.ftiStatdefailuid){
              let promiseAutoCassesPerYears
                = HpoDataVisServices.getStatsDashboardAutoCassesPerYears(scope.components).then(
                  (res)=>{
                    scope.linearLoaded = 0;
                    scope.casesLoaded = 0;
                    if(scope.objStandardisation){
                      scope.linearLoaded = res.data['linearLoaded'];
                      scope.casesLoaded = res.data['casesLoaded'];
                    }
                    var data = [
                      {
                        x: Object.keys(res.data['cassePerYears']),
                        y: Object.values(res.data['cassePerYears']),
                        type: 'bar',
                        xaxis: {
                          title: {
                            text: $filter('translate')(MSG_PREFIX + '.kilometers')
                          },
                        },
                        marker: {color: '#6D607F'},
                      }
                    ];
                    var layout = {
                      xaxis: {
                        title: {
                          text: $filter('translate')(MSG_PREFIX + '.years')
                        },
                      },
                      yaxis: {
                        title: {
                          text: $filter('translate')(MSG_PREFIX + '.nbreBreaksYear')
                        },
                      }
                    };

                    Plotly.newPlot('cassesPerYears', data, layout);
                    scope.cassesPerYears = true;

                    data = [
                      {
                        x: Object.keys(res.data['cassePerYearsPerKm']),
                        y: Object.values(res.data['cassePerYearsPerKm']),
                        type: 'bar',
                        xaxis: {
                          title: {
                            text: $filter('translate')(MSG_PREFIX + '.kilometers')
                          },
                        },
                        marker: {color: '#47B8DD'},
                      }
                    ];
                    layout = {
                      xaxis: {
                        title: {
                          text: $filter('translate')(MSG_PREFIX + '.years')
                        },
                      },
                      yaxis: {
                        title: {
                          text: $filter('translate')(MSG_PREFIX + '.tauxBreaks')
                        },
                      }
                    };

                    Plotly.newPlot('cassePerYearsPerKm', data, layout);
                    scope.cassePerYearsPerKm = true;
                    data = [];
                    layout = {
                      height: 800,
                      yaxis: {
                        autotick: false,
                        autorange: true,
                        tickfont: {
                          size: 9,
                        },
                        automargin: true,
                      },
                    };
                    let scatterValues =  Object.keys(res.data['cassePerCommuneYears']);
                    let scatterSize= [3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41];
                    let i = 0;
                    for (const key of scatterValues) {
                      let communes = res.data['cassePerCommuneCommune'][key];
                      // Si le nom de commune dépasse 20 caractère, on l'abrévie
                      let truncatedCommunes = communes.map(name => {
                        return name.length>20?name.slice(0,17)+'...': name;
                      }
                      );
                      // Ajoute la clé 'key' à chaque nom de commune pour le texte de survol
                      let hoverTexts = communes.map(name => `${name} ${key}`);
                      var trace = {
                        x: res.data['cassePerCommuneYears'][key],
                        y: truncatedCommunes,
                        mode: 'markers+text',
                        type: 'scatter',
                        name: key,
                        textposition: 'top center',
                        textfont: {
                          family:  'Raleway, sans-serif',
                          size:50
                        },
                        marker: { size: i<20?scatterSize[i]:41, color: '#c0504d'},
                        hovertext: hoverTexts,
                        hoverinfo: 'x+text'
                      };
                      data.push(trace);
                      i++;
                    }
                    Plotly.newPlot('fuitesparCommune', data,layout);
                    scope.fuitesparCommune = true;
                  });
              promises.push(promiseAutoCassesPerYears);
            }
            $q.all(promises).then(()=>{
              gaDomUtils.hideGlobalLoader();
            }, () =>{
              gaDomUtils.hideGlobalLoader();
            });
          }
        };
        directiveFunction();
        // on reload la fonction quand on change la langue en locale
        $rootScope.$on('localeChanged', () => {
          directiveFunction();
        });
      },
    };
  };

  cassesPerYearsPerKmPerCommune.$inject = [
    'HpoCarteAppFactory',
    'HpoDataVisServices',
    'FeatureTypeFactory',
    '$filter',
    'gaDomUtils',
    '$q',
    '$rootScope'
  ];
  return cassesPerYearsPerKmPerCommune;
});
