'use strict';
define(function() {
  var calculDashboardHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    UnitFactory,
    CalculFactory,
    HpoUserAppFactory,
    InitProvider,
    HpoAppServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/calcul_dashboard_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.values = {
          canalisation: 0,
          branchement: 0,
          defailcanalisation: 0,
          defailbranchement: 0,
          calcul: 0,
          confiance: 0,
        };

        scope.components = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'home'
        );
        var ftivalidation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'validation'
        )[0];
        var ftiprevision = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];
        var cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
        if (
          cfg.ftiuid ||
          cfg.ftidefailuid ||
          cfg.ftibuid ||
          cfg.ftibdefailuid
        ) {
          scope.components = {
            canalisation: cfg.ftiuid || scope.components.canalisation,
            defailcanalisation:
              cfg.ftidefailuid || scope.components.defailcanalisation,
            branchement: cfg.ftibuid || scope.components.branchement,
            defailbranchement:
              cfg.ftibdefailuid || scope.components.defailbranchement,
            addedstatistics: cfg.addedstatistics,
            ftiuidvalidation: ftivalidation.uid,
            ftiuidprevision: ftiprevision.uid,
            cfg: cfg,
          };
        }
        gaDomUtils.showGlobalLoader();
        HpoAppServices.getStats(scope.components).then(
          function(res) {
            gaDomUtils.hideGlobalLoader();
            if (res && res.data) {
              for (var key in res.data) {
                if (
                  key &&
                  res.data.hasOwnProperty(key) &&
                  angular.isDefined(res.data[key]) &&
                  res.data[key] !== 0 &&
                  key !== 'confiance' &&
                  key !== 'calcul'
                ) {
                  if (key !== 'addedstats') {
                    res.data[key] = res.data[key].toFixed(0);
                    if (key.indexOf('defail') === -1) {
                      res.data[key] =
                        (Math.round(res.data[key] * 100) / 100).toFixed(0) +
                        ' ' +
                        'km';

                      res.data[
                        key
                      ] = HpoCarteAppFactory.getAppFactory().numberWithSpaces(
                        res.data[key]
                      );
                    }
                  } else {
                    if (res.data[key] && res.data[key].length > 0) {
                      for (var i = 0; i < res.data[key].length; i++) {
                        for (var nkey in res.data[key][i]) {
                          if (
                            nkey &&
                            res.data[key][i].hasOwnProperty(nkey) &&
                            angular.isDefined(res.data[key][i][nkey]) &&
                            res.data[key][i][nkey] !== 0 &&
                            nkey !== 'name'
                          ) {
                            res.data[key][i][nkey] = res.data[key][i][
                              nkey
                            ].toFixed(0);
                            if (nkey.indexOf('defail') === -1) {
                              res.data[key][i][nkey] =
                                (
                                  Math.round(res.data[key][i][nkey] * 100) / 100
                                ).toFixed(0) +
                                ' ' +
                                'km';

                              res.data[key][i][
                                nkey
                              ] = HpoCarteAppFactory.getAppFactory().numberWithSpaces(
                                res.data[key][i][nkey]
                              );
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
              Object.assign(scope.values, res.data);
            }
          },
          function(res) {
            gaDomUtils.hideGlobalLoader();
            AlertHpoFactory.showErrorMessage(res);
          }
        );

        scope.getCalcOrPrevInfo = function(type) {
          scope.infoType = type;
          scope.infoFilter = '"FINALISER" IS NULL OR "FINALISER" = FALSE';
          var dialog = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.home.validationorprevision.html',
            className: 'ngdialog-theme-plain width1100 nopadding miniclose',
            scope: scope,
          });
        };
      },
    };
  };

  calculDashboardHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'UnitFactory',
    'CalculFactory',
    'HpoUserAppFactory',
    'InitProvider',
    'HpoAppServices',
  ];
  return calculDashboardHpo;
});
