'use strict';
define(function() {
  var addComponentConfigHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppModelServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/add_component_config_hpo.html',
      restrict: 'EA',
      scope: {
        config: '=?',
        ftis: '=?',
        res: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        if (angular.isUndefined(scope.ftis))
          scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'admin'
          );

        scope.res = {
          component: undefined,
          attributes: {
            identifiant: undefined,
            date_de_pose: undefined,
            date_abandon: undefined,
            materiau: undefined,
            diametre: undefined,
            longueur: undefined,
            commune: undefined,
          },
          component_defail: undefined,
          attributes_defail: {
            id_component: undefined,
            date_fuite: undefined,
          },
          valves: undefined,
          connections: undefined
        };
        if (scope.config) {
          var uid = scope.config.uid;
          var uid_defail = scope.config.defail_uid;
          let valves =  scope.config.valves;
          let connections =  scope.config.connections;
          scope.ftis.map(function(x, i) {
            if (uid && x.uid === uid){
              scope.res.component = x;
            }else if (uid_defail && x.uid === uid_defail){
              scope.res.component_defail = x;
            }else if (valves && x.uid === valves){
              scope.res.valves = x;
            }else if (connections && x.uid === connections){
              scope.res.connections = x;
            }         
          });
          if (scope.res.component && scope.res.component.attributes) {
            scope.res.component.attributes.map(function(x) {
              if (
                x.name &&
                scope.config.identifiant &&
                x.name === scope.config.identifiant
              )
                scope.res.attributes.identifiant = x;
              else if (
                x.name &&
                scope.config.date_de_pose &&
                x.name === scope.config.date_de_pose
              )
                scope.res.attributes.date_de_pose = x;
              else if (
                x.name &&
                scope.config.date_abandon &&
                x.name === scope.config.date_abandon
              )
                scope.res.attributes.date_abandon = x;
              else if (
                x.name &&
                scope.config.materiau &&
                x.name === scope.config.materiau
              )
                scope.res.attributes.materiau = x;
              else if (
                x.name &&
                scope.config.diametre &&
                x.name === scope.config.diametre
              )
                scope.res.attributes.diametre = x;
              else if (
                x.name &&
                scope.config.longueur &&
                x.name === scope.config.longueur
              )
                scope.res.attributes.longueur = x;
              else if (
                x.name &&
                scope.config.commune &&
                x.name === scope.config.commune
              )
                scope.res.attributes.commune = x;
            });
          }
          if (scope.config.format_date_de_pose)
            scope.res.format_date_pose = scope.config.format_date_de_pose;
          if (scope.config.format_date_abandon)
            scope.res.format_date_abandon = scope.config.format_date_abandon;
          if (
            scope.res.component_defail &&
            scope.res.component_defail.attributes
          ) {
            scope.res.component_defail.attributes.map(function(x) {
              if (
                x.name &&
                scope.config.defail_identifiant &&
                x.name === scope.config.defail_identifiant
              )
                scope.res.attributes_defail.id_component = x;
              else if (
                x.name &&
                scope.config.defail_date_fuite &&
                x.name === scope.config.defail_date_fuite
              )
                scope.res.attributes_defail.date_fuite = x;
            });
          }
          if (scope.config.defail_format_date_fuite)
            scope.res.format_date_fuite = scope.config.defail_format_date_fuite;
          if (scope.config.id) scope.res.id = scope.config.id
        }

        scope.selectedFti = function() {
          if (scope.res.component && scope.res.component.attributes) {
            var attributes = Object.keys(scope.res.attributes);
            var assignedAttribute = [];
            scope.res.component.attributes.map(function(x) {
              var name = x.name.toLowerCase();
              for (var i = 0; i < attributes.length; i++) {
                if (
                  assignedAttribute.indexOf(attributes[i]) &&
                  attributes[i].score(name.toLowerCase()) > 0.4
                ) {
                  scope.res.attributes[attributes[i]] = x;
                  assignedAttribute.push(attributes[i]);
                }
              }
            });
            if (
              scope.res.component.relations &&
              scope.res.component.relations.length > 0
            ) {
              for (var i = 0; i < scope.res.component.relations.length; i++) {
                var rel = scope.res.component.relations[i];
                if (rel.type === 'REL_SIMPLE') {
                  var uid = rel.idEnd;
                  var idx = scope.ftis
                    .map(function(x) {
                      return x.uid;
                    })
                    .indexOf(uid);
                  if (~idx) {
                    scope.res.component_defail = scope.ftis[idx];
                    attributes = Object.keys(scope.res.attributes_defail);
                    assignedAttribute = [];
                    scope.res.component_defail.attributes.map(function(x) {
                      var name = x.name.toLowerCase();
                      for (var i = 0; i < attributes.length; i++) {
                        if (
                          assignedAttribute.indexOf(attributes[i]) &&
                          attributes[i].score(name.toLowerCase()) > 0.4
                        ) {
                          scope.res.attributes_defail[attributes[i]] = x;
                          assignedAttribute.push(attributes[i]);
                        }
                      }
                    });
                  }
                  var field_end = rel.fieldEnd;
                  if (field_end) {
                    var idx = scope.res.component_defail.attributes
                      .map(function(x) {
                        return x.name;
                      })
                      .indexOf(field_end);
                    if (~idx) {
                      scope.res.attributes_defail.id_component =
                        scope.res.component_defail.attributes[idx];
                    }
                  }
                }
              }
            }
          }
        };

        scope.selectedFtiDefail = function() {
          if (scope.res.attributes_defail) {
            var attributes = Object.keys(scope.res.attributes_defail);
            var assignedAttribute = [];
            scope.res.component_defail.attributes.map(function(x) {
              var name = x.name.toLowerCase();
              for (var i = 0; i < attributes.length; i++) {
                if (
                  assignedAttribute.indexOf(attributes[i]) &&
                  attributes[i].score(name.toLowerCase()) > 0.4
                ) {
                  scope.res.attributes_defail[attributes[i]] = x;
                  assignedAttribute.push(attributes[i]);
                }
              }
            });
          }
        };

        scope.infoDateFormat = function() {
          var dialog = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/date_format_info.html',
            className:
              'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.checkDateFormat = function(ftiuid, date_attribute, date_format) {
          gaDomUtils.showGlobalLoader();
          HpoAppModelServices.checkDateFormat(
            ftiuid,
            date_attribute.name,
            date_format
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res.data) {
                if (
                  res.data &&
                  res.data.status &&
                  JSON.parse(res.data.status)
                ) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')(res.data.message),
                    true,
                    'success'
                  );
                } else if (res.data && !res.data.status && res.data.results) {
                  var newScope = $rootScope.$new();
                  newScope.result = res.data;
                  newScope.currentResources = res.data.results;
                  newScope.editListCfg = {
                    dataModule: 'hpo',
                    resource_type: 'admin',
                    cols: ['value', 'status'],
                    deleteResourceButton: false,
                    dontShowLength: false,
                    notAddMode: false,
                    notPagination: false,
                    hideHeader: true,
                    hideDetails: true,
                    colsFunction: {
                      status: 'booleanToCheck',
                    },
                  };
                  var dialog = ngDialog.open({
                    template:
                      'js/XG/widgets/hpoapp/home_admin_data/views/dialog/date_format_show_result.html',
                    className:
                      'ngdialog-theme-plain width800 minheight500 nopadding miniclose',
                    closeByDocument: false,
                    scope: newScope,
                  });
                } else {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')(res.data.message),
                    true,
                    'error'
                  );
                }
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
      },
    };
  };

  addComponentConfigHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppModelServices',
  ];
  return addComponentConfigHpo;
});
