'use strict';
define(function() {
  var statisticAnalyseHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    ngDialog,
    $filter,
    $rootScope,
    $timeout,
    ParametersFactory,
    gaDomUtils,
    QueryFactory,
    HpoAppServices,
    InitProvider
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/statistic_analyse_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoStatisticAnalyseDataConfig';
        scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
        scope.modes = [
          {
            id: 'graphe',
            label: 'hpo.common.graphic',
          },
          {
            id: 'table',
            label: 'hpo.common.table',
          },
          {
            id: 'counts',
            label: 'hpo.common.counts',
          },
          // ,{
          //   "id" : "map",
          //   "label" : "hpo.common.map"
          // }
        ];

        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'stat_hist'
        )[0];
        scope.statistic = {
          tableselected: undefined,
          filter: {},
          operands: [],
          mode: scope.modes[0].id,
          interpreteattributes: 'and',
          interpreteconditions: 'and',
          applied: false,
          clauseWhere: '1=1',
          result: {},
          selectedftis: {},
          usedftis: undefined,
          ftis: [],
          configName: scope.configName + '_' + Math.random(),
          added: false,
          selectall: false,
          chartoptions: undefined,
          chartconfig: undefined,
          attrchoice: undefined,
          savedconfig: false,
          configid: undefined,
          historicfti: scope.ftihistory.uid,
          name: undefined,
          commentaire: undefined,
        };

        scope.propertiestoexclude = {
          selectedftis: {},
          usedftis: undefined,
          ftis: [],
          applied: false,
          chartoptions: undefined,
          chartconfig: undefined,
          attrchoice: undefined,
          savedconfig: false,
          configid: undefined,
          name: undefined,
          commentaire: undefined,
        };

        scope.selectAll = function() {
          scope.ftis.map(function(x) {
            scope.statistic.selectedftis[x.uid] = scope.statistic.selectall;
          });
        };

        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.statistic = dataHpo.savedata;
            if (
              scope.statistic.tableselected &&
              scope.statistic.tableselected.uid
            ) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.statistic.tableselected.uid);
              if (~idx) {
                scope.statistic.tableselected = scope.ftis[idx];
              }
            }
          }
        };

        var applychange = function() {
          if (scope.statistic.applied) {
            scope.statistic.applied = false;
            $timeout(function() {
              scope.statistic.applied = true;
            }, 500);
          } else {
            scope.statistic.applied = true;
          }
        };

        function applyCountsConfig() {
          scope.statistic.counts = scope.counts;
        }

        scope.applyConfig = function() {
          if (
            (scope.statistic.mode === 'graphe' ||
              scope.statistic.mode === 'table') &&
            scope.statistic.tableselected &&
            scope.statistic.operands &&
            scope.statistic.operands.length > 0
          ) {
            gaDomUtils.showGlobalLoader();
            HpoAppServices.createFilter(scope.statistic).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.statistic.clauseWhere = res.data;
                }
                scope.authorisedAttributes = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
                  scope.statistic.tableselected
                );
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.info'),
                  $filter('translate')('hpo.data.analyse.applied'),
                  false,
                  'success'
                );
                applychange();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          } else {
            if (
              scope.statistic.mode === 'map' &&
              scope.statistic.selectedftis
            ) {
              scope.statistic.ftis = [];
              var ftiuids = scope.ftis.map(function(x) {
                return x.uid;
              });
              for (var key in scope.statistic.selectedftis) {
                if (
                  key &&
                  scope.statistic.selectedftis.hasOwnProperty(key) &&
                  scope.statistic.selectedftis[key] &&
                  ~ftiuids.indexOf(key)
                )
                  scope.statistic.ftis.push(scope.ftis[ftiuids.indexOf(key)]);
              }
              scope.statistic.usedftis = scope.statistic.ftis
                .map(function(x) {
                  return x.uid;
                })
                .join(',');
              scope.authorisedAttributes = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
                scope.statistic.tableselected
              );
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('hpo.common.info'),
                $filter('translate')('hpo.data.analyse.applied'),
                false,
                'success'
              );
            } else {
              if (scope.statistic.mode == 'counts') {
                applyCountsConfig();
              } else {
                scope.authorisedAttributes = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
                  scope.statistic.tableselected
                );
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.info'),
                  $filter('translate')('hpo.data.analyse.applied'),
                  false,
                  'success'
                );
              }
            }
            applychange();
          }
        };

        scope.filterShowPosibilities = function() {
          if (
            ((scope.statistic.tableselected &&
              (scope.statistic.mode === 'table' ||
                scope.statistic.mode === 'graphe')) ||
              (scope.statistic.ftis &&
                scope.statistic.mode === 'map' &&
                scope.statistic.usedftis) ||
              (scope.statistic.mode == 'counts' &&
                scope.counts.groups.length != 0)) &&
            scope.statistic.applied
          )
            return true;
          else {
            return false;
          }
        };

        scope.changedMode = function() {
          scope.statistic.applied = false;
        };

        scope.addToDashboard = function() {
          var dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.adddashboard.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            if (data) {
              scope.statistic = data;
              scope.statistic.applied = true;
              scope.statistic.added = true;
              gaDomUtils.showGlobalLoader();
              HpoAppServices.addToDashboard(scope.statistic).then(
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  if (res.data && JSON.parse(res.data)) {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.info'),
                      $filter('translate')('hpo.data.analyse.added'),
                      true,
                      'success'
                    );
                    $rootScope.$broadcast(
                      'reloadDatatable',
                      scope.statistic.historicfti
                    );
                  } else {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.info'),
                      $filter('translate')('hpo.error.data.adddashboard'),
                      true,
                      'error'
                    );
                    $rootScope.$broadcast(
                      'reloadDatatable',
                      scope.statistic.historicfti
                    );
                  }
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          });
        };

        var emptySavedConfig = function() {
          if (
            !scope.statistic.added &&
            scope.statistic.savedconfig &&
            scope.statistic.configid
          ) {
            ParametersFactory.remove(scope.statistic.configid).then(
              function(res) {
                console.log(res);
              },
              function(res) {
                console.log(res);
              }
            );
          }
        };

        scope.$on('changedBranchStatistics', function(evt, arg) {
          emptySavedConfig();
        });
        window.onbeforeunload = function() {
          emptySavedConfig();
        };

        scope.filter =
          '"USER" = \'' +
          HpoCarteAppFactory.getInitProvider().getUser().login +
          "'";

        scope.$on('removeCountGrp',function(evt,params){
          scope.counts.groups.splice(params.index,1);
          scope.$broadcast('refreshCountsGroup',scope.counts);
        });

        scope.addCountsComponentGroup = function() {
          let group = {};
          group.ftiUids = [];
          for (let prop in scope.statistic.selectedftis) {
            if (scope.statistic.selectedftis[prop]) {
              group.ftiUids.push(prop);
            }
          }
          group.operand = 'count';
          if (group.ftiUids.length != 0) scope.counts.groups.push(group);
        };
        scope.counts = {};
        scope.counts.groups = [];

        var canCreateMapF = function() {
          var filter = scope.filter + ' AND "TYPE" = \'map\'';
          QueryFactory.data(
            scope.ftihistory.uid,
            filter,
            HpoCarteAppFactory.getAppFactory().getSrid(),
            1,
            10,
            ''
          ).then(
            function(res) {
              if (
                res.data &&
                res.data.features &&
                res.data.features.length > 0
              ) {
                scope.canCreateMap = false;
              }
              console.log('can create map : ' + scope.canCreateMap);
            },
            function(res) {
              console.error(res);
            }
          );
        };
        canCreateMapF();
        scope.canCreateMap = true;
      },
    };
  };

  statisticAnalyseHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    'ngDialog',
    '$filter',
    '$rootScope',
    '$timeout',
    'ParametersFactory',
    'gaDomUtils',
    'QueryFactory',
    'HpoAppServices',
    'InitProvider',
  ];
  return statisticAnalyseHpo;
});
