'use strict';
define(function() {
  var preparationDataHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/preparation_data_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoPreparationDataConfig';

        var fti = HpoCarteAppFactory.getAppFactory().getFeatureTypes('prep')[0];
        scope.datatableHeightImport =
          angular.element('.xgos_content').height() - 50 - 100 + 'px';
        scope.historique = {
          ftis: [fti],
          selectedfti: fti,
          attributes: fti.attributes.filter(function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                fti.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(fti.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  fti.name
                ))
            )
              return x;
          }),
          clauseWhere: '1=1',
          result: [],
        };

        scope.disableResult = function() {
          if (
            !scope.analysis ||
            scope.analysis.geoj ||
            scope.analysis.geoj.length === 0
          )
            return true;
          else {
            return false;
          }
        };

        scope.tabs = [
          {
            title: $filter('translate')('hpo.data.prepare.analyse'),
          },
          {
            title: $filter('translate')('hpo.data.prepare.correction'),
          },
          {
            title: $filter('translate')('hpo.data.prepare.datatable'),
          },
        ];

        scope.tabs.activeTab = 0;

        scope.disabledEdit = HpoCarteAppFactory.getAppFactory().getDisabledEditAttributes(
          fti.name
        );
        scope.translateFtiAttributes = HpoCarteAppFactory.getAppFactory().getTranslateAttributes(
          fti.name
        );
        scope.hideFilter = Object.keys(scope.translateFtiAttributes);

        scope.doCorrection = function(obj) {
          console.log(obj);
          var callback = function(confirmed) {
            if (confirmed) {
              gaDomUtils.showGlobalLoader();
              HpoAppServices.doOrUndoCorrection(
                fti.uid,
                obj.properties.TRANSACTION_UID,
                'do'
              ).then(
                function(res) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')(
                      'hpo.data.prepare.correctiontools.correctsuccess.general'
                    ),
                    true
                  );
                  try {
                    scope.initApplicationInformations();
                  } catch (e) {
                    console.error(e.stack);
                  }
                  gaDomUtils.hideGlobalLoader();
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            $filter('translate')('hpo.data.prepare.correctiontools.surdo'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.unDoCorrection = function(obj) {
          console.log(obj);
          var callback = function(confirmed) {
            if (confirmed) {
              gaDomUtils.showGlobalLoader();
              HpoAppServices.doOrUndoCorrection(
                fti.uid,
                obj.properties.TRANSACTION_UID,
                'undo'
              ).then(
                function(res) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')(
                      'hpo.data.prepare.correctiontools.correctsuccess.generalundo'
                    ),
                    true
                  );
                  try {
                    scope.initApplicationInformations();
                  } catch (e) {
                    console.error(e.stack);
                  }
                  gaDomUtils.hideGlobalLoader();
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            $filter('translate')('hpo.data.prepare.correctiontools.surundo'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.buttonSpecialActions = [
          {
            class: 'btn btn-default btn-xs',
            icone: 'fa fa-undo',
            text: $filter('translate')('hpo.data.prepare.correctiontools.undo'),
            callFunction: scope.unDoCorrection,
          },
          {
            class: 'btn btn-success btn-xs',
            icone: 'fa fa-play',
            text: $filter('translate')('hpo.data.prepare.correctiontools.do'),
            callFunction: scope.doCorrection,
          },
        ];

        scope.addFeature = function() {
          scope.tabs.activeTab = 1;
        };

        scope.datatableCrudHpo = {
          create: { func: scope.addFeature },
          remove: true,
        };

        scope.changedTab = function(newval) {
          if (angular.isDefined(newval) && newval === 2) {
            $timeout(function() {
              scope.datatableHeight =
                angular
                  .element(
                    '#hpoPrepareDataHistorique .fixInner .table.table-striped'
                  )
                  .height() +
                angular
                  .element(
                    '#hpoPrepareDataHistorique .fixInner [ng-table-pagination]'
                  )
                  .height() +
                angular
                  .element('#hpoPrepareDataHistorique .fixThWrapper')
                  .height() +
                50 +
                'px';
            }, 500);
          }
        };
      },
    };
  };

  preparationDataHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
  ];
  return preparationDataHpo;
});
