'use strict';
define(function() {
  var ImportHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/import_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        /**
         * Ouvre l'IHM de choix du format csv en entrée.
         * @returns {undefined}
         *
         */
        var ngDialogPromise;
        scope.columnDelimiter = ';';
        scope.decimalDelimiter = '.';
        var fileExtension;
        var toaddfeatures = [];
        scope.components = FeatureTypeFactory.resources.featuretypes.filter(
          function(x) {
            if (
              x.name.indexOf(HpoCarteAppFactory.getAppFactory().getPrefix()) ===
                -1 &&
              x.name.indexOf(
                HpoCarteAppFactory.getAppFactory().getOtherPrefix()
              ) === -1
            )
              return x;
          }
        );
        scope.importFile = function() {
          var promises = [];
          if (scope.hpo.dropzoneComponent.files.length > 0) {
            if (checkExtensionExists('csv')) {
              var promise = ImportExportFactory.loadSchemaCsv(
                scope.hpo.uploadProcessID,
                scope.columnDelimiter,
                scope.decimalDelimiter
              );
              promise.then(function(importResult) {
                if (
                  importResult &&
                  importResult.status === 200 &&
                  importResult.data &&
                  importResult.data instanceof Array
                ) {
                  var data = importResult.data
                    .map(function(x) {
                      return {
                        type: 'Feature',
                        properties: {
                          NOM_FICHIER: x.name,
                          UID_FICHIER: x.uid,
                          TYPE_FICHIER: x.fileType,
                          SOURCE: x.fileType,
                          PROCESSID: x.processid,
                          DATE_IMPORT: HpoCarteAppFactory.getAppFactory().formatDate(
                            new Date()
                          ),
                          USER: $rootScope.xgos.user.login,
                          USERID: $rootScope.xgos.user.uid,
                          PARTAGER: false,
                          CONFIGURER: false,
                        },
                      };
                    })
                    .filter(function(x) {
                      if (x) return x;
                    });
                  toaddfeatures = toaddfeatures.concat(data);
                }
              });
              promises.push(promise);
            }

            if (checkExtensionExists('shp')) {
              var promised = ImportExportFactory.loadSchema(
                scope.hpo.uploadProcessID
              );
              promised.then(function(importResult) {
                if (
                  importResult &&
                  importResult.status === 200 &&
                  importResult.data &&
                  importResult.data instanceof Array
                ) {
                  var data = importResult.data
                    .map(function(x) {
                      return {
                        type: 'Feature',
                        properties: {
                          NOM_FICHIER: x.name,
                          UID_FICHIER: x.uid,
                          TYPE_FICHIER: x.fileType,
                          SOURCE: x.fileType,
                          PROCESSID: x.processid,
                          DATE_IMPORT: HpoCarteAppFactory.getAppFactory().formatDate(
                            new Date()
                          ),
                          USER: $rootScope.xgos.user.login,
                          USERID: $rootScope.xgos.user.uid,
                          PARTAGER: false,
                          CONFIGURER: false,
                        },
                      };
                    })
                    .filter(function(x) {
                      if (x) return x;
                    });
                  toaddfeatures = toaddfeatures.concat(data);
                }
              });
              promises.push(promised);
            }
          }

          if (checkOrGetSelectedComponent()) {
            toaddfeatures = toaddfeatures.concat(transferData);
          }

          if (promises.length > 0 || toaddfeatures.length > 0) {
            $q.all(promises).then(function() {
              scope.addImportedData(toaddfeatures);
            });
          }
        };

        /**
         * [clearDropzone description]
         * @return {[type]} [description]
         */
        scope.clearDropzone = function() {
          if (
            scope.hpo.dropzoneComponent.files.length > 0 ||
            (scope.hpo && angular.isDefined(scope.hpo.uploadProcessID))
          ) {
            if (
              scope.hpo &&
              scope.hpo.importcfg &&
              scope.hpo.importcfg.sourceslayers &&
              scope.hpo.importcfg.sourceslayers.length > 0
            ) {
              var callback = function(isconfirm) {
                if (isconfirm) {
                  $rootScope.$broadcast('removeAllelement');
                  scope.hpo.dropzoneComponent.removeAllFiles();
                  toaddfeatures = [];
                  scope.hpo.importedFeatures = [];
                  transferData = [];
                  scope.initSelection();
                }
              };
              var message =
                $filter('translate')('hpo.data.exchange.currentmapping') +
                ' ' +
                $filter('translate')('hpo.common.sur');
              AlertHpoFactory.alertConfirmCallback(
                $filter('translate')('hpo.common.warning'),
                message,
                'warning',
                true,
                undefined,
                '#F50072',
                true,
                undefined,
                undefined,
                true,
                true,
                callback
              );
            } else {
              $rootScope.$broadcast('removeAllelement');
              scope.hpo.dropzoneComponent.removeAllFiles();
              scope.hpo.importedFeatures = [];
              toaddfeatures = [];
              transferData = [];
              scope.initSelection();
            }
          }
        };

        /**
         * file extension
         * @param {string} firstFileName
         * @returns {string}
         */
        var getFileExtension = function(firstFileName) {
          return firstFileName.substring(
            firstFileName.lastIndexOf('.') + 1,
            firstFileName.length
          );
        };

        /**
         * check extension of type
         * @param {string} ext
         * @returns {boolean}
         */
        var checkExtensionExists = function(ext) {
          for (var i = 0; i < scope.hpo.dropzoneComponent.files.length; i++) {
            var file = scope.hpo.dropzoneComponent.files[i];
            var extension = getFileExtension(file.name);
            if (extension === ext) return true;
          }
          return false;
        };

        var transferData = [];
        var checkOrGetSelectedComponent = function() {
          var b = false;
          transferData = scope.components
            .map(function(x) {
              if (angular.isDefined(x.selected) && x.selected) {
                return {
                  type: 'Feature',
                  properties: {
                    NOM_FICHIER: x.name,
                    UID_FICHIER: x.uid,
                    TYPE_FICHIER: x.fileType,
                    SOURCE: x.storeName,
                    PROCESSID: x.processid,
                    DATE_IMPORT: HpoCarteAppFactory.getAppFactory().formatDate(
                      new Date()
                    ),
                    USER: $rootScope.xgos.user.login,
                    USERID: $rootScope.xgos.user.uid,
                    PARTAGER: false,
                    CONFIGURER: false,
                  },
                };
              }
            })
            .filter(function(x) {
              if (x) return x;
            });
          return transferData.length > 0;
        };

        scope.initSelection = function() {
          scope.components.map(function(x) {
            x.selected = false;
          });
          scope.searchMode = false;
          scope.filter = undefined;
        };

        scope.searchMode = false;
        scope.filter = undefined;
        scope.toogleFilter = function() {
          scope.searchMode = !scope.searchMode;
          if (!scope.searchMode) scope.filter = undefined;
        };
        scope.filterFunc = function(name) {
          var b = true;
          if (
            scope.filter &&
            name &&
            name.toLowerCase().indexOf(scope.filter.toLowerCase()) === -1
          )
            b = false;
          return b;
        };

        scope.$on('clearDropzone', function() {
          scope.clearDropzone();
        });
      },
    };
  };

  ImportHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
  ];
  return ImportHpo;
});
