'use strict';
define(function() {
  /*
        Import data into existing feature
     */
  var gcimportfeatures = function(
    FeatureTypeFactory,
    $timeout,
    $rootScope,
    ParametersFactory,
    ngDialog,
    HpoCarteAppFactory,
    $filter,
    AlertHpoFactory,
    gaUrlUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/importFeatures.html',
      restrict: 'EA',
      scope: {
        res: '=', // result
        sources: '=', // array of column names
        maj: '=?',
        sourceslayers: '=?',
        submitFunction: '=?',
        ftid: '=?', // destination
        dateattributes: '=?',
        destinationsftis: '=?',
        editable: '=?', // whether you can change the ftid,
        allowDefaultValues: '=?', // allow default values for destinations fields
        defaultValues: '=?', // actual default values
        defaultDateFormat: '=?',
        hideTopButtons: '=?',
        resetAtChange: '=?',
      },

      link: function(scope, element, attrs, ctrl) {
        scope.maj = {
          maj_component: false,
          attribut: undefined,
          value: undefined,
        };
        scope.waitExport = false;

        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'hpoimportfeatures';

        scope.mapping = [];
        scope.datetypes = [
          'java.lang.Date',
          'java.util.Date',
          'java.sql.Timestamp',
        ];

        scope.$watch('selectedFti.fti', function(newval) {
          if (newval) {
            scope.sources = newval.attributes.map(function(x) {
              return x.name;
            });
            if (newval.filetype === 'db') {
              var attributesAuthorized = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
                newval
              );
              scope.sources = attributesAuthorized.map(function(x) {
                return x.name;
              });
            }
            scope.resetLiaisons();
          }
        });

        /**
         * resetLiaisons
         */
        scope.resetLiaisons = function(btn) {
          if (btn) {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.selectedSource = {
                  idx: scope.sources[0],
                };
                scope.liaisons = {};
                scope.usedAttributes = {};
                scope.setToDefault = {};
                scope.canSubmit = false;
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('gcimportfeatures.reset') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          } else {
            scope.selectedSource = { idx: scope.sources[0] };
            scope.liaisons = {};
            scope.usedAttributes = {};
            scope.setToDefault = {};
            scope.canSubmit = false;
          }
        };

        /**
         * resetLiaisons
         */
        scope.resetLiaisonsALL = function(btn) {
          if (btn) {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.selectedSource = {
                  idx: scope.sources[0],
                };
                scope.liaisons = {};
                scope.usedAttributes = {};
                scope.setToDefault = {};
                scope.canSubmit = false;
                scope.importFeature = {};
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.model.choice.empty') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          } else {
            scope.selectedSource = { idx: scope.sources[0] };
            scope.liaisons = {};
            scope.usedAttributes = {};
            scope.setToDefault = {};
            scope.canSubmit = false;
            scope.importFeature = {};
          }
        };

        scope.resetLiaisons();

        scope.importFeature = {};

        var updateDateAttributes = function() {
          if (
            scope.importFeature &&
            scope.importFeature.fti &&
            scope.importFeature.fti.attributes
          )
            scope.dateattributes = scope.importFeature.fti.attributes
              .map(function(attr) {
                if (scope.datetypes.indexOf(attr.type) !== -1) return attr.name;
              })
              .filter(function(x) {
                if (x) return x;
              });
        };

        if (scope.ftid) {
          if (!FeatureTypeFactory.resources.featuretypes.length) {
            FeatureTypeFactory.get().then(function() {
              scope.importFeature.fti = FeatureTypeFactory.getFeatureByUid(
                scope.ftid
              );
              updateDateAttributes();
            });
          } else {
            scope.importFeature.fti = FeatureTypeFactory.getFeatureByUid(
              scope.ftid
            );
            updateDateAttributes();
          }

          /* load existing cfg if any */
          if (angular.isDefined(scope.res)) {
            scope.liaisons = angular.copy(scope.res);
            for (var i in scope.liaisons) {
              scope.usedAttributes[scope.liaisons[i]] = true;
              scope.canSubmit = true;
            }
          }
        }

        function inArray(tab, name) {
          for (var k = 0; k < tab.length; k++) {
            if (name == tab[k]) {
              return true;
            }
          }
          return false;
        }
        function getTabAttsNames(tab) {
          var tabNames = [];
          for (var i = 0; i < tab.length; i++) {
            tabNames.push(tab[i].name);
          }
          return tabNames;
        }

        var attFId = {
          name: 'fid',
          alias: 'fid',
          type: 'java.lang.String',
          isNillable: false,
          size: 500,
          restrictions: [],
          popup: false,
          autoCalcul: null,
        };
        var addSpecialFid = function() {
          scope.attributesDestination = angular.copy(
            HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
              scope.importFeature.fti,
              'w'
            )
          );
          if (scope.importFeature.fti) {
            var tab = getTabAttsNames(scope.attributesDestination);
            if (!inArray(tab, 'fid')) {
              scope.attributesDestination.push(attFId);
            }
          }
        };

        // reset when the fti changes
        scope.attributesDestination = [];
        scope.$watch('importFeature.fti', function(fti, prevfti) {
          if (fti) {
            addSpecialFid();

            if (scope.maj && scope.maj.maj_component && scope.maj.value) {
              var idx = scope.attributesDestination.indexOf(
                scope.maj.value.name
              );
              if (idx != -1) scope.maj.value = scope.attributesDestination[idx];
            }

            if (angular.isDefined(fti) && angular.isDefined(prevfti)) {
              if (fti != prevfti) {
                scope.resetLiaisons();
              }
            }
            updateDateAttributes();
            scope.ftid = fti.uid;
          }
        });

        scope.allAutomaticMap = function(sources, tab) {
          var toremove = false;
          if (
            Object.keys(scope.liaisons) &&
            Object.keys(scope.liaisons).length > 0
          )
            toremove = true;
          sources.forEach(function(source) {
            if (source !== 'fid') {
              scope.selectedSource.idx = source;
              for (var i = 0; i < tab.length; i++) {
                if (
                  tab[i].name.toLowerCase() == source.toLowerCase() ||
                  tab[i].name.substr(0, 10).toLowerCase() ==
                    source.toLowerCase()
                ) {
                  var attmap = tab[i];
                  scope.checkDestination(attmap);
                }
              }
            }
          });
          if (!toremove) {
            if (
              Object.keys(scope.liaisons) &&
              Object.keys(scope.liaisons).length > 0
            ) {
              var message =
                Object.keys(scope.liaisons).length +
                $filter('translate')('hpo.data.exchange.liaisonsfound');
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('hpo.common.info'),
                message,
                true,
                'info'
              );
            } else {
              var message = $filter('translate')(
                'hpo.data.exchange.noliaisons'
              );
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('hpo.common.info'),
                message,
                true,
                'info'
              );
            }
          } else {
            var message = $filter('translate')(
              'hpo.data.exchange.removedliason'
            );
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('hpo.common.info'),
              message,
              false,
              'info'
            );
          }
        };

        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
        scope.atomaticMap = function(source, tab) {
          //source = scope.selectedSource.idx;
          var attmap = {};
          //console.log(source,tab);
          for (var i = 0; i < tab.length; i++) {
            if (tab[i].name.toLowerCase() == source.toLowerCase()) {
              attmap = tab[i];
            }
          }
          scope.checkDestination(attmap);
        };

        /**
         * checkDestination
         * @param attr
         */
        scope.checkDestination = function(attr) {
          if (
            scope.maj &&
            scope.maj.maj_component &&
            scope.maj.value &&
            scope.maj.value.name &&
            attr.name === scope.maj.value.name
          )
            return;

          var previousAttr;

          // if has default value
          //if(scope.allowDefaultValues==true || scope.defaultValues[attr.name]){
          if (
            scope.allowDefaultValues == true &&
            scope.defaultValues &&
            scope.defaultValues[attr.name]
          ) {
            //delete scope.defaultValues[attr.name];
            scope.setToDefault[attr.name] = false;
          }

          // if already used for another source
          if (scope.usedAttributes[attr.name]) {
            if (scope.liaisons[scope.selectedSource.idx] != attr.name) {
              return false;
            }
          }

          if (angular.isDefined(scope.liaisons[scope.selectedSource.idx])) {
            previousAttr = scope.liaisons[scope.selectedSource.idx];
            delete scope.liaisons[scope.selectedSource.idx];
            scope.usedAttributes[previousAttr] = false;
          }

          if (previousAttr != attr.name) {
            scope.liaisons[scope.selectedSource.idx] = attr.name;
            scope.usedAttributes[attr.name] = true;
          }

          scope.canSubmitValues = Object.keys(scope.liaisons).length;
        };

        Object.defineProperty(Object.prototype, 'keysLength', {
          enumerable: false,
          value: function(a) {
            return Object.keys(this).length;
          },
        });

        /**
         * activateDefaultValues
         * @param attr
         */
        scope.activateDefaultValues = function(attr, event) {
          event.stopPropagation();
          scope.setToDefault[attr.name] = true;
        };

        /**
         * submitLiaisons
         */
        scope.submitLiaisons = function() {
          $timeout(function() {
            var liaisonsObj = [];
            for (var key in scope.liaisons) {
              if (scope.liaisons.hasOwnProperty(key))
                liaisonsObj.push({
                  source: key,
                  destination: scope.liaisons[key],
                });
            }

            if (scope.maj && scope.maj.maj_component)
              liaisonsObj.push({
                source: scope.maj.attribut,
                destination: scope.maj.value.name,
              });

            scope.res = {
              ftisourcename:
                angular.isDefined(scope.selectedFti.fti.copydata) &&
                scope.selectedFti.fti.copydata
                  ? scope.selectedFti.fti.uid
                  : scope.selectedFti.fti.name,
              ftiuidsource: scope.selectedFti.fti.uid,
              filetype: scope.selectedFti.fti.filetype,
              ftuiddestination: scope.importFeature.fti.uid,
              ftidestinationalias: scope.importFeature.fti.alias,
              liaison: liaisonsObj,
              defaultvalues: scope.defaultValues,
              defaultDateFormat: scope.defaultDateFormat,
              copydata:
                angular.isDefined(scope.selectedFti.fti.filetype) &&
                scope.selectedFti.fti.filetype === 'db'
                  ? true
                  : false,
              maj: scope.maj,
              processid: scope.selectedFti.fti.processid,
              srsid: scope.selectedFti.fti.srid,
            };
            scope.submitFunction(scope.res);
            scope.attributesDestination = [];
            // removeFid();
          });
        };

        var removeFid = function() {
          try {
            if (
              scope.importFeature &&
              scope.importFeature.fti &&
              scope.importFeature.fti.attributes
            ) {
              var deletedfidfromimport = [];
              scope.importFeature.fti.attributes.map(function(attr, i) {
                if (
                  attr &&
                  attr.name === 'fid' &&
                  attr.alias === 'fid' &&
                  !attr.hasOwnProperty('type')
                )
                  deletedfidfromimport.push(i);
              });
              deletedfidfromimport.reverse();
              deletedfidfromimport.map(function(t) {
                scope.importFeature.fti.attributes.splice(t, 1);
              });
            }
          } catch (e) {
            console.error(e.stack);
          }
        };

        scope.cancelLiaisons = function() {
          scope.cancelFunction();
        };

        scope.$on('addedelement', function(evt, arg) {
          if (
            arg &&
            scope.selectedFti &&
            scope.selectedFti.fti &&
            (arg === scope.selectedFti.fti.name ||
              arg === scope.selectedFti.fti.uid)
          ) {
            scope.selectedFti.fti = undefined;
            if (scope.sourceslayers.length === 0)
              scope.importFeature.fti = undefined;
            scope.resetLiaisons();
            if (scope.sourceslayers.length === 0) scope.importFeature = {};
            scope.canSubmit = false;
            scope.maj = {
              maj_component: false,
              attribut: undefined,
              value: undefined,
            };
          }
        });

        scope.$on('removedelement', function(evt, arg) {
          if (
            arg &&
            scope.selectedFti &&
            scope.selectedFti.fti &&
            (arg === scope.selectedFti.fti.name ||
              arg === scope.selectedFti.fti.uid)
          ) {
            var idx = scope.sourceslayers
              .map(function(x) {
                return x.name;
              })
              .indexOf(scope.selectedFti.fti.name);
            if (idx !== -1) scope.sourceslayers.splice(idx, 1);
            scope.selectedFti.fti = undefined;
            if (scope.sourceslayers.length === 0)
              scope.importFeature.fti = undefined;
            scope.defaultValues = {};
            scope.defaultDateFormat = {};
            scope.resetLiaisons();
            if (scope.sourceslayers.length === 0) scope.importFeature = {};
            scope.canSubmit = false;
            scope.maj = {
              maj_component: false,
              attribut: undefined,
              value: undefined,
            };
            if (scope.sourceslayers.length === 0)
              $rootScope.$broadcast('clearDropzone');
          }
        });

        scope.$on('removeAllelement', function(evt, arg) {
          scope.sourceslayers = [];
          scope.selectedFti.fti = undefined;
          if (scope.sourceslayers.length === 0)
            scope.importFeature.fti = undefined;
          scope.defaultValues = {};
          scope.defaultDateFormat = {};
          scope.resetLiaisons();
          if (scope.sourceslayers.length === 0) scope.importFeature = {};
          scope.canSubmit = false;
          scope.maj = {
            maj_component: false,
            attribut: undefined,
            value: undefined,
          };
        });

        scope.$on('showwait', function(evt, arg) {
          scope.waitExport = true;
        });

        scope.$on('hidewait', function(evt, arg) {
          scope.waitExport = false;
        });

        scope.$on('changedsourceLayers', function(evt, arg) {
          if (
            scope.sourceslayers &&
            scope.sourceslayers.length > 0 &&
            (!scope.selectedFti || !scope.selectedFti.fti)
          ) {
            scope.selectedFti = {
              fti: scope.sourceslayers[0],
            };
            if (scope.resetAtChange) scope.resetLiaisons();
          }
        });

        var ngDialogPromise;

        scope.writequeryname = true;
        scope.changeWrtieMode = function() {
          scope.writequeryname = !scope.writequeryname;
        };

        scope.saveTemplate = function() {
          ParametersFactory.getbytype(scope.configName).then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                };
              }
            },
            function(data) {
              console.log(scope.config);
            }
          );
          scope.saveData = {
            user: $rootScope.xgos.user.login,
            maj: scope.maj,
            liaisons: scope.liaisons,
            fti: scope.importFeature.fti,
          };
          if (scope.defaultDateFormat)
            scope.saveData.defaultDateFormat = scope.defaultDateFormat;
          if (scope.defaultValues)
            scope.saveData.defaultValues = scope.defaultValues;

          scope.queryname = undefined;
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.exchange.templates.html',
            scope: scope,
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
          });
          ngDialogPromise.then(
            function(data) {
              ParametersFactory.getbytype(scope.configName).then(function(res) {
                var nameSaved = res.data.map(function(x) {
                  return x.name;
                });
                if (nameSaved.indexOf(data) !== -1) {
                  var idx = res.data
                    .map(function(x) {
                      return x.name;
                    })
                    .indexOf(data);
                  var id = res.data[idx].id;
                  ParametersFactory.remove(id).then(
                    function() {
                      ParametersFactory.add(
                        scope.saveData,
                        scope.configName,
                        data
                      ).then(
                        function() {
                          require('toastr').success(
                            $filter('translate')('elastic.search.save_ok')
                          );
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')('elastic.search.save_nok')
                          );
                        }
                      );
                    },
                    function() {
                      require('toastr').error(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                } else {
                  ParametersFactory.add(
                    scope.saveData,
                    scope.configName,
                    data
                  ).then(
                    function() {
                      require('toastr').success(
                        $filter('translate')('elastic.search.save_ok')
                      );
                    },
                    function() {
                      require('toastr').error(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                }
              });
            },
            function(data) {
              require('toastr').info(
                $filter('translate')('elastic.search.annuler')
              );
            }
          );
        };

        scope.removeSavedAdvanced = function(idx, array) {
          var callback = function(confirmed) {
            if (confirmed) {
              $timeout(function() {
                ParametersFactory.deletebyname(
                  scope.saved.realNames[idx].name
                ).then(
                  function(res) {
                    scope.saved.realNames.splice(idx, 1);
                    scope.saved.queries.splice(idx, 1);
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.data.exchange.succes'),
                      $filter('translate')('hpo.data.exchange.updates'),
                      false
                    );
                  },
                  function(res) {
                    AlertHpoFactory.getSimpleFail(
                      $filter('translate')('hpo.data.exchange.fail'),
                      $filter('translate')('hpo.data.exchange.updatesfail'),
                      true
                    );
                  }
                );
              }, 600);
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            $filter('translate')('hpo.data.exchange.templateremove'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.getTemplate = function() {
          ParametersFactory.getbytype(scope.configName).then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                };
                scope.currentuser = $rootScope.xgos.user.login;
                ngDialogPromise = ngDialog.openConfirm({
                  template:
                    'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.exchange.gettemplates.html',
                  scope: scope,
                  className:
                    'ngdialog-theme-plain width600 nopadding miniclose',
                });
                ngDialogPromise.then(
                  function(data) {
                    var filename = data.query;
                    var filenames = scope.datas.map(function(x) {
                      return x.name;
                    });
                    var index = filenames.indexOf(filename);
                    var dataHPO = scope.datas[index].data;

                    if (dataHPO.fti && !scope.importFeature.fti) {
                      var idx = scope.destinationsftis
                        .map(function(x) {
                          return x.uid;
                        })
                        .indexOf(dataHPO.fti.uid);
                      if (~idx)
                        scope.importFeature.fti = scope.destinationsftis[idx];
                    }

                    verifyLoadedData(dataHPO);
                    scope.maj = dataHPO.maj;
                    scope.liaisons = dataHPO.liaisons;
                    addSpecialFid();
                    if (dataHPO.defaultDateFormat && data.getdateFormat)
                      scope.defaultDateFormat = dataHPO.defaultDateFormat;
                    if (dataHPO.defaultValues && data.getDefaultValue)
                      scope.defaultValues = dataHPO.defaultValues;
                  },
                  function(data) {
                    //scope.getConfig();
                    console.log(scope.config);
                    require('toastr').info(
                      $filter('translate')('elastic.search.annuler')
                    );
                  }
                );
              } else {
                require('toastr').info(
                  $filter('translate')('elastic.search.no_save')
                );
              }
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
            }
          );
        };

        var verifyLoadedData = function(dataHPO) {
          var attributesUse = scope.importFeature.fti.attributes.concat([
            attFId,
          ]);
          var destinationAttributes = attributesUse.map(function(x) {
            return x.name;
          });
          var sourceAttributes = scope.selectedFti.fti.attributes.map(function(
            x
          ) {
            return x.name;
          });
          var deletedelements = false;
          var deletedelementsliaisons = false;
          /**
           * Vérification maj
           */
          if (dataHPO.maj && dataHPO.maj.maj_component && dataHPO.maj.value) {
            var idx = destinationAttributes.indexOf(dataHPO.maj.value.name);
            if (idx != -1) dataHPO.maj.value = attributesUse[idx];
            else {
              delete dataHPO.maj.value;
              deletedelements = true;
              scope.canSubmit = false;
            }
            idx = sourceAttributes.indexOf(dataHPO.maj.attribut);
            if (idx === -1) {
              delete dataHPO.maj.attribut;
              deletedelements = true;
              scope.canSubmit = false;
            }
          }

          if (dataHPO.liaisons) {
            var todeletekeys = [];
            angular.forEach(dataHPO.liaisons, function(v, k) {
              if (
                destinationAttributes.indexOf(v) === -1 ||
                sourceAttributes.indexOf(k) === -1
              )
                todeletekeys.push(k);
            });
            for (var i = 0; i < todeletekeys.length; i++) {
              delete dataHPO.liaisons[todeletekeys[i]];
              deletedelementsliaisons = true;
            }
          }

          if (deletedelements || deletedelementsliaisons)
            AlertHpoFactory.showAlertTemplateUpdate();

          if (Object.keys(dataHPO.liaisons).length > 0) scope.canSubmit = true;
        };

        scope.encodeAffichage = function(x) {
          if (x) return gaUrlUtils.tryDecodeURIComponent(x);
          else {
            return x;
          }
        };
      },
    };
  };

  gcimportfeatures.$inject = [
    'FeatureTypeFactory',
    '$timeout',
    '$rootScope',
    'ParametersFactory',
    'ngDialog',
    'HpoCarteAppFactory',
    '$filter',
    'AlertHpoFactory',
    'gaUrlUtils',
  ];
  return gcimportfeatures;
});
