'use strict';
define(function() {
  var adminHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    EditFactory,
    $rootScope,
    $filter,
    ngDialog,
    $timeout,
    ParametersFactory,
    gaDomUtils,
    HpoAppServices,
    ImportExportFactory,
    licenceFactory,
    InitProvider,
    ConfigFactory,
    $q
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/admin_hpo.html',
      restrict: 'EA',
      link: function(scope) {
        scope.configureName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoAdministrationConfig';
        scope.hpo = {
          pages: [
            {
              label: 'hpo.admin.datastore',
            },
            {
              label: 'hpo.admin.components',
            },
            {
              label: 'hpo.admin.basemap',
            },
            {
              label: 'hpo.admin.componentshpo',
            },
            {
              label: 'hpo.admin.home.title',
            },
            {
              label: 'hpo.data.analyse.title',
            },
            {
              label: 'hpo.admin.table.title',
            } /*,
                  {
                    "label" : 'hpo.admin.correct.title'
                  }*/,
          ],
          activeTab: 0,
          cfg: HpoCarteAppFactory.getInitProvider().getHpoConfig(),
        };
        scope.tabs = [
          {
            title: 'hpo.data.analyse.newanalyse',
          },
          {
            title: 'hpo.data.analyse.dashboardconfig',
          },
        ];
        scope.tabs.activeTab = 0;
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoAnalyseDataConfig';
        scope.description1 = $filter('translate')(
          'hpo.admin.component.description'
        );
        scope.description2 = $filter('translate')('hpo.admin.home.description');
        scope.baseMapDataVis = [
          {
            name: "light_all",
            alias: "Light with All Labels"
          },
          {
            name: "dark_all",
            alias: "Dark with All Labels"
          },
          {
            name: "light_nolabels",
            alias: "Light without Labels"
          },
          {
            name: "light_only_labels",
            alias: "Light Labels Only"
          },
          {
            name: "dark_nolabels",
            alias: "Dark without Labels"
          },
          {
            name: "dark_only_labels",
            alias: "Dark Labels Only"
          },
          {
            name: "rastertiles/voyager",
            alias: "Voyager with Labels"
          },
          {
            name: "rastertiles/voyager_nolabels",
            alias: "Voyager without Labels"
          },
          {
            name: "rastertiles/voyager_only_labels",
            alias: "Voyager Labels Only"
          },
          {
            name: "rastertiles/voyager_labels_under",
            alias: "Voyager Labels Under"
          }, 
          {
            name:"osm",
            alias:"OSM"
          }
        ];
        if(!scope.hpo.cfg.baseMap){
          scope.hpo.cfg.baseMap = 'light_all';
        }

        if (scope.hpo.cfg && !scope.hpo.cfg.currentResources) {
          scope.hpo.cfg.currentResources = [];
          scope.currentResources = [];
        } else {
          scope.currentResources = angular.copy(scope.hpo.cfg.currentResources);
        }

        var checkRelationSimple = function(data) {
          var relation = {
            type: 'REL_SIMPLE',
            relationType: null,
            disabled: false,
            name:
              'RELATION_' +
              data.component.name +
              '_' +
              data.component_defail.name,
            componentStart: data.component.name,
            componentEnd: data.component_defail.name,
            fieldStart: data.attributes.identifiant.name,
            fieldEnd: data.attributes_defail.id_component.name,
            alias:
              'RELATION ' +
              data.component.name +
              ' ' +
              data.component_defail.name,
            idStart: data.component.uid,
            idEnd: data.component_defail.uid,
          };
          return relation;
        };

        var checkRelationChantiers = function(data) {
          var relation;
          var uid = data.component.uid;
          var exists = false;
          for (var i = 0; i < ftiChantiers.relations.length; i++) {
            var rel = ftiChantiers.relations[i];
            if (
              rel.type === 'REL_NM' &&
              rel.idStart === ftiChantiers.uid &&
              rel.idEnd === uid
            ) {
              exists = true;
            }
          }
          if (!exists) {
            relation = {
              type: 'REL_NM',
              relationType: null,
              disabled: false,
              name: 'RELATION_CHANTIERS_' + data.component.name,
              componentStart: ftiChantiers.name,
              componentEnd: data.component.name,
              alias: 'relation chantiers et ' + data.component.alias,
              idStart: ftiChantiers.uid,
              idEnd: data.component.uid,
            };
          }
          return relation;
        };

        var checkAttributesRequired = function(data) {
          var response = false;
          var attributes = Object.keys(data.attributes).map(function(x) {
            return data.attributes[x].name;
          });
          data.component.attributes.map(function(x) {
            if (attributes.indexOf(x.name) !== -1 && x.isNillable) {
              response = true;
              x.isNillable = false;
            }
          });
          attributes = Object.keys(data.attributes_defail).map(function(x) {
            return data.attributes_defail[x].name;
          });
          data.component_defail.attributes.map(function(x) {
            if (attributes.indexOf(x.name) !== -1 && x.isNillable) {
              response = true;
              x.isNillable = false;
            }
          });
          return response;
        };

        var addElement = function(data) {
          var treateddata = {
            id: Math.random(),
            uid: data.component.uid,
            alias: data.component.alias,
            identifiant: data.attributes.identifiant.name,
            date_de_pose: data.attributes.date_de_pose.name,
            format_date_de_pose: data.format_date_pose,
            date_abandon: angular.isDefined(data.attributes.date_abandon)?data.attributes.date_abandon.name:'',
            format_date_abandon: data.format_date_abandon,
            materiau: data.attributes.materiau.name,
            diametre: data.attributes.diametre.name,
            longueur: data.attributes.longueur.name,
            commune: data.attributes.commune.name,
            defail_uid: data.component_defail.uid,
            defail_alias: data.component_defail.alias,
            defail_identifiant: data.attributes_defail.id_component.name,
            defail_date_fuite: data.attributes_defail.date_fuite.name,
            defail_format_date_fuite: data.format_date_fuite,
            valves: data.valves && data.valves.uid?data.valves.uid: "",
            connections: data.connections && data.connections.uid?data.connections.uid: ""
          };
          scope.currentResources.push(treateddata);
          scope.hpo.cfg.currentResources.push(treateddata);
          gaDomUtils.showGlobalLoader();
          ConfigFactory.add(scope.hpo.cfg, 'main', 'appconfig').then(
            function(res) {
              if (res && res.data) {
                HpoCarteAppFactory.getInitProvider().setHpoConfig(
                  scope.hpo.cfg
                );
                HpoCarteAppFactory.getInitProvider()
                  .initialiseApplication()
                  .then(
                    function() {
                      HpoCarteAppFactory.getAppFactory().initFactory();
                      refreshList();
                      refreshFtis();
                      gaDomUtils.hideGlobalLoader();
                    },
                    function() {
                      gaDomUtils.hideGlobalLoader();
                    }
                  );
                if (
                  angular.isDefined(data.attributes.date_abandon) &&
                  angular.isDefined(data.attributes.date_abandon.name)
                ) {
                  HpoCarteAppFactory.getAppFactory()
                    .writeRelationAdminStyle(
                      data.component.uid,
                      data.attributes.date_abandon.name
                    )
                    .catch(error => {
                      require('toastr').error(
                        "Le style du composant n'a pas été créé"
                      );
                      gaDomUtils.hideGlobalLoader();
                    });
                }
              } else {
                gaDomUtils.hideGlobalLoader();
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        var ftiChantiers = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'chantiers'
        )[0];
        scope.ftischantiers = angular.copy(ftiChantiers);
        var ngdialog;
        scope.addComponent = function() {
          scope.newItem = true;
          scope.configuser = {};
          scope.selected_resource = {};
          var dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.admin.component.html',
            className:
              'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
          dialog.then(function(data) {
            var relationExists = checkRelationSimple(data);
            var relationChantiers = checkRelationChantiers(data);
            if (
              relationExists ||
              relationChantiers ||
              checkAttributesRequired(data)
            ) {
              var sendata = {};
              sendata[data.component.uid] = null;
              sendata[ftiChantiers.uid] = null;
              if (relationExists) sendata[data.component.uid] = relationExists;
              if (relationChantiers)
                sendata[ftiChantiers.uid] = relationChantiers;
              gaDomUtils.showGlobalLoader();
              HpoCarteAppFactory.getAppFactory()
                .addRelationAdmin(data.component.uid, ftiChantiers.uid, sendata)
                .then(
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    addElement(data);
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
            } else {
              addElement(data);
            }
          });
        };

        var updateCon = function(data, treateddata) {
          var idx = scope.currentResources
            .map(function(x) {
              return x.id;
            })
            .indexOf(data.id);
          if (~idx) scope.currentResources[idx] = treateddata;
          idx = scope.hpo.cfg.currentResources
            .map(function(x) {
              return x.id;
            })
            .indexOf(data.id);
          if (~idx) scope.hpo.cfg.currentResources[idx] = treateddata;
          gaDomUtils.showGlobalLoader();
          ConfigFactory.add(scope.hpo.cfg, 'main', 'appconfig').then(
            function(res) {
              if (res && res.data) {
                HpoCarteAppFactory.getInitProvider().setHpoConfig(
                  scope.hpo.cfg
                );
                HpoCarteAppFactory.getInitProvider()
                  .initialiseApplication()
                  .then(
                    function() {
                      HpoCarteAppFactory.getAppFactory().initFactory();
                      refreshList();
                      refreshFtis();
                      gaDomUtils.hideGlobalLoader();
                    },
                    function() {
                      gaDomUtils.hideGlobalLoader();
                    }
                  );
                if (
                  angular.isDefined(data.attributes.date_abandon) &&
                  angular.isDefined(data.attributes.date_abandon.name)
                ) {
                  HpoCarteAppFactory.getAppFactory()
                    .writeRelationAdminStyle(
                      data.component.uid,
                      data.attributes.date_abandon.name
                    )
                    .catch(error => {
                      require('toastr').error(
                        "Le style du composant n'a pas été créé"
                      );
                      gaDomUtils.hideGlobalLoader();
                    });
                }
              } else {
                gaDomUtils.hideGlobalLoader();
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.updateComponent = function() {
          scope.newItem = false;
          scope.configuser = angular.copy(scope.selected_resource);
          var dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.admin.component.html',
            className:
              'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
          dialog.then(function(data) {
            var treateddata = {
              id: data.id,
              uid: data.component.uid,
              alias: data.component.alias,
              identifiant: data.attributes.identifiant.name,
              date_de_pose: data.attributes.date_de_pose.name,
              format_date_de_pose: data.format_date_pose,
              date_abandon: angular.isDefined(data.attributes.date_abandon)?data.attributes.date_abandon.name:'',
              format_date_abandon: data.format_date_abandon,
              materiau: data.attributes.materiau.name,
              diametre: data.attributes.diametre.name,
              longueur: data.attributes.longueur.name,
              commune: data.attributes.commune.name,
              defail_uid: data.component_defail.uid,
              defail_alias: data.component_defail.alias,
              defail_identifiant: data.attributes_defail.id_component.name,
              defail_date_fuite: data.attributes_defail.date_fuite.name,
              defail_format_date_fuite: data.format_date_fuite,
              valves: data.valves && data.valves.uid?data.valves.uid: "",
              connections: data.connections && data.connections.uid?data.connections.uid: ""
            };
            var relationExists = checkRelationSimple(data);
            var relationChantiers = checkRelationChantiers(data);
            if (
              relationExists ||
              relationChantiers ||
              checkAttributesRequired(data)
            ) {
              var sendata = {};
              sendata[data.component.uid] = null;
              sendata[ftiChantiers.uid] = null;
              if (relationExists) sendata[data.component.uid] = relationExists;
              if (relationChantiers)
                sendata[ftiChantiers.uid] = relationChantiers;
              gaDomUtils.showGlobalLoader();
              HpoCarteAppFactory.getAppFactory()
                .addRelationAdmin(data.component.uid, ftiChantiers.uid, sendata)
                .then(
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    updateCon(data, treateddata);
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
            } else {
              updateCon(data, treateddata);
            }
          });
        };

        var saveInitConf = function() {
          ConfigFactory.add(scope.hpo.cfg, 'main', 'appconfig').then(
            function(res) {
              if (res && res.data) {
                HpoCarteAppFactory.getInitProvider().setHpoConfig(
                  scope.hpo.cfg
                );
                HpoCarteAppFactory.getInitProvider()
                  .initialiseApplication()
                  .then(
                    function() {
                      HpoCarteAppFactory.getAppFactory().initFactory();
                      refreshList();
                      refreshFtis();
                      gaDomUtils.hideGlobalLoader();
                    },
                    function() {
                      gaDomUtils.hideGlobalLoader();
                    }
                  );
              } else {
                gaDomUtils.hideGlobalLoader();
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.removeComponent = function(v) {
          if (angular.isDefined(v)) {
            var data = scope.currentResources[v];
            scope.removedData = angular.copy(scope.currentResources[v]);
            var idx = scope.hpo.cfg.currentResources
              .map(function(x) {
                return x.id;
              })
              .indexOf(data.id);
            if (~idx) scope.hpo.cfg.currentResources.splice(idx, 1);
            scope.currentResources.splice(v, 1);

            if (
              scope.hpo.cfg.ftiuid ||
              scope.hpo.cfg.ftibuid ||
              scope.hpo.cfg.ftidefailuid ||
              scope.hpo.cfg.ftibdefailuid
            ) {
              if (
                [data.uid, data.defail_uid].indexOf(scope.hpo.cfg.ftiuid) !== -1
              )
                scope.hpo.cfg.ftiuid = HpoCarteAppFactory.getAppFactory().getByName(
                  scope.ftisnodefail_valid,
                  HpoCarteAppFactory.getAppFactory().HPO_CANA_VALID()
                ).uid;
              if (
                [data.uid, data.defail_uid].indexOf(scope.hpo.cfg.ftibuid) !==
                -1
              )
                scope.hpo.cfg.ftibuid = HpoCarteAppFactory.getAppFactory().getByName(
                  scope.ftisnodefail_valid,
                  HpoCarteAppFactory.getAppFactory().HPO_BRANCHEMENT_VALID()
                ).uid;
              if (
                [data.uid, data.defail_uid].indexOf(
                  scope.hpo.cfg.ftidefailuid
                ) !== -1
              )
                scope.hpo.cfg.ftidefailuid = HpoCarteAppFactory.getAppFactory().getByName(
                  scope.ftisdefail_valid,
                  HpoCarteAppFactory.getAppFactory().HPO_CANA_DEFAILLANCE_VALID()
                ).uid;
              if (
                [data.uid, data.defail_uid].indexOf(
                  scope.hpo.cfg.ftibdefailuid
                ) !== -1
              )
                scope.hpo.cfg.ftibdefailuid = HpoCarteAppFactory.getAppFactory().getByName(
                  scope.ftisdefail_valid,
                  HpoCarteAppFactory.getAppFactory().HPO_BRANCHEMENT_DEFAILLANCE_VALID()
                ).uid;
            }

            var callback = function(isconfirm) {
              if (isconfirm) {
                gaDomUtils.showGlobalLoader();
                HpoCarteAppFactory.getAppFactory()
                  .removeFeaturesAdmin(
                    scope.removedData.uid,
                    scope.removedData.defail_uid,
                    scope.hpo.cfg.datastoreName
                  )
                  .then(
                    function(res) {
                      if (res && res.data && JSON.parse(res.data)) {
                        AlertHpoFactory.successDelete();
                        saveInitConf();
                      } else {
                        gaDomUtils.hideGlobalLoader();
                        AlertHpoFactory.failDelete();
                      }
                    },
                    function(res) {
                      AlertHpoFactory.showErrorMessage(res);
                      saveInitConf();
                    }
                  );
                try {
                  scope.$apply();
                } catch (err) {}
              } else {
                gaDomUtils.showGlobalLoader();
                saveInitConf();
              }
            };
            var message = $filter('translate')(
              'hpo.common.removeAllInformations'
            );
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };

        scope.$on('saveConfig', function(save) {
          if (save) scope.save();
        });

        scope.save = function() {
          gaDomUtils.showGlobalLoader();
          ConfigFactory.add(scope.hpo.cfg, 'main', 'appconfig').then(
            function(res) {
              if (res && res.data) {
                HpoCarteAppFactory.getInitProvider().setHpoConfig(
                  scope.hpo.cfg
                );
                HpoCarteAppFactory.getInitProvider()
                  .initialiseApplication()
                  .then(
                    function() {
                      HpoCarteAppFactory.getAppFactory().initFactory();
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.common.success'),
                        false,
                        'info'
                      );
                      gaDomUtils.hideGlobalLoader();
                    },
                    function() {
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.error.data.updateconf'),
                        true,
                        'error'
                      );
                      gaDomUtils.hideGlobalLoader();
                    }
                  );
              } else {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.info'),
                  $filter('translate')('hpo.error.data.updateconf'),
                  true,
                  'error'
                );
                gaDomUtils.hideGlobalLoader();
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.editListCfg = {
          dataModule: 'hpo',
          resource_type: 'admin',
          cols: [
            'alias',
            'identifiant',
            'date_de_pose',
            'date_abandon',
            'materiau',
            'diametre',
            'longueur',
            'commune',
            'defail_alias',
            'defail_identifiant',
            'defail_date_fuite',
          ],
          addFunction: scope.addComponent,
          editFunction: scope.updateComponent,
          removeFunction: scope.removeComponent,
          deleteResourceButton: true,
          dontShowLength: false,
          notAddMode: false,
          notPagination: false,
        };

        scope.calculheight =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          angular.element('.description').height() -
          50 +
          'px';

        scope.calculheightSpecial =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          25 +
          'px';

        /* Conf base pages
         */
        var refreshFtis = function() {
          scope.ftis = [];
          scope.ftisdefail = [];
          scope.ftis_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'valid'
          );
          scope.ftisnodefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'valid_no_defail'
          );
          scope.ftisdefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'valid_defail'
          );

          var ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
          for (var i = 0; i < ftis.length; i++) {
            var fti = ftis[i];
            if (!HpoCarteAppFactory.getAppFactory().getFuiteTables(fti)) {
              scope.ftis.push(fti);
              var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
                fti
              );
              var idx = ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(ftidefailuid);
              if (idx !== -1) scope.ftisdefail.push(ftis[idx]);
            }
          }
        };
        refreshFtis();

        if (
          scope.hpo.cfg &&
          !scope.hpo.cfg.ftiuid &&
          !scope.hpo.cfg.ftidefailuid
        ) {
          scope.hpo.cfg.ftiuid = scope.ftisnodefail_valid
            .map(function(x) {
              if (
                x.name.indexOf(
                  HpoCarteAppFactory.getAppFactory().HPO_CANA_VALID()
                ) !== -1
              )
                return x;
            })
            .filter(function(x) {
              if (x) return x;
            })[0].uid;
          scope.hpo.cfg.ftidefailuid = scope.ftisdefail_valid
            .map(function(x) {
              if (
                x.name.indexOf(
                  HpoCarteAppFactory.getAppFactory().HPO_CANA_DEFAILLANCE_VALID()
                ) !== -1
              )
                return x;
            })
            .filter(function(x) {
              if (x) return x;
            })[0].uid;
        }

        scope.changedCorrectionToolOrFti = function() {
          if (scope.hpo.cfg.ftiuid) {
            var fti = HpoCarteAppFactory.getAppFactory().getById(
              scope.ftis,
              scope.hpo.cfg.ftiuid
            );
            if (fti) {
              var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
                fti
              );
              if (ftidefailuid)
                scope.hpo.cfg.ftidefailuid = HpoCarteAppFactory.getAppFactory().getById(
                  scope.ftisdefail,
                  ftidefailuid
                ).uid;
            }
          }
        };

        if (
          scope.hpo.cfg &&
          !scope.hpo.cfg.ftibuid &&
          !scope.hpo.cfg.ftibdefailuid
        ) {
          scope.hpo.cfg.ftibuid = scope.ftisnodefail_valid
            .map(function(x) {
              if (
                x.name.indexOf(
                  HpoCarteAppFactory.getAppFactory().HPO_BRANCHEMENT_VALID()
                ) !== -1
              )
                return x;
            })
            .filter(function(x) {
              if (x) return x;
            })[0].uid;
          scope.hpo.cfg.ftibdefailuid = scope.ftisdefail_valid
            .map(function(x) {
              if (
                x.name.indexOf(
                  HpoCarteAppFactory.getAppFactory().HPO_BRANCHEMENT_DEFAILLANCE_VALID()
                ) !== -1
              )
                return x;
            })
            .filter(function(x) {
              if (x) return x;
            })[0].uid;
        }

        scope.changedCorrectionToolOrFti2 = function() {
          if (scope.hpo.cfg.ftibuid) {
            var fti = HpoCarteAppFactory.getAppFactory().getById(
              scope.ftis,
              scope.hpo.cfg.ftibuid
            );
            if (fti) {
              var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
                fti
              );
              if (ftidefailuid)
                scope.hpo.cfg.ftibdefailuid = HpoCarteAppFactory.getAppFactory().getById(
                  scope.ftisdefail,
                  ftidefailuid
                ).uid;
            }
          }
        };

        scope.changedCorrectionToolOrFtiStat = function() {
          if (scope.hpo.cfg.ftiStatuid) {
            var fti = HpoCarteAppFactory.getAppFactory().getById(
              scope.ftis,
              scope.hpo.cfg.ftiStatuid
            );
            if (fti) {
              var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
                fti
              );
              if (ftidefailuid)
                scope.hpo.cfg.ftiStatdefailuid = HpoCarteAppFactory.getAppFactory().getById(
                  scope.ftisdefail,
                  ftidefailuid
                ).uid;
            }
          }
        };

        scope.changedCorrectionToolOrFti3 = function(addedstat) {
          if (addedstat.ftiuid) {
            var fti = HpoCarteAppFactory.getAppFactory().getById(
              scope.ftis,
              addedstat.ftiuid
            );
            if (fti) {
              var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
                fti
              );
              if (ftidefailuid)
                addedstat.ftidefailuid = HpoCarteAppFactory.getAppFactory().getById(
                  scope.ftisdefail,
                  ftidefailuid
                ).uid;
            }
          }
        };

        /*add features
         */
        if (scope.hpo.cfg && !scope.hpo.cfg.otherftis)
          scope.hpo.cfg.otherftis = [];
        var refreshList = function() {
          var sourceFeatures = HpoCarteAppFactory.getAppFactory().getOtherFeatures();
          sourceFeatures = sourceFeatures
            .map(function(x) {
              if (
                scope.hpo.cfg.otherftis
                  .map(function(x) {
                    return x.uid;
                  })
                  .indexOf(x.uid) === -1
              )
                return x;
            })
            .filter(function(x) {
              if (x) return x;
            });
          if (scope.hpo.cfg.otherftis) {
            scope.hpo.cfg.otherftis = scope.hpo.cfg.otherftis
              .map(function(x) {
                if (!HpoCarteAppFactory.getAppFactory().getAdminConfig(x))
                  return x;
              })
              .filter(function(x) {
                if (x) return x;
              });
          }
          scope.editTypeList = {
            leftData: sourceFeatures,
            leftDisplayAttribute: 'alias',
            rightData: scope.hpo.cfg.otherftis,
            rightDisplayAttribute: 'alias',
            leftTitle: $filter('translate')('hpo.admin.correct.notused'),
            rightTitle: $filter('translate')('hpo.admin.correct.added'),
            source: 'left',
          };
        };
        refreshList();

        scope.xgos = $rootScope.xgos;
        scope.reinitApplicationConfig = function() {
          var callback = function(isconfirm) {
            if (isconfirm) {
              gaDomUtils.showGlobalLoader();
              HpoCarteAppFactory.getAppFactory()
                .updateConfig(scope.hpo.cfg, true)
                .then(
                  function(res) {
                    if (res && res.data) {
                      scope.hpo.cfg = res.data;
                      HpoCarteAppFactory.getInitProvider().setHpoConfig(
                        scope.hpo.cfg
                      );
                      HpoCarteAppFactory.getInitProvider()
                        .initialiseApplication()
                        .then(
                          function() {
                            HpoCarteAppFactory.getAppFactory().initFactory();
                            AlertHpoFactory.getSimpleSuccess(
                              $filter('translate')('hpo.data.exchange.succes'),
                              $filter('translate')(
                                'hpo.common.reinitapplication'
                              ),
                              false
                            );
                            gaDomUtils.hideGlobalLoader();
                          },
                          function() {
                            gaDomUtils.hideGlobalLoader();
                          }
                        );
                    } else {
                      gaDomUtils.hideGlobalLoader();
                    }
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              try {
                scope.$apply();
              } catch (err) {}
            }
          };
          var message =
            $filter('translate')('hpo.common.reinitapp') +
            '. ' +
            $filter('translate')('hpo.common.sur');
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        /* Ajout de composant et des statistiques
         */
        if (scope.hpo.cfg && !scope.hpo.cfg.addedstatistics)
          scope.hpo.cfg.addedstatistics = [];
        scope.hideCompnents = {};

        scope.addStat = function(element, idx) {
          if (element) {
            scope.statistic = angular.copy(element);
            scope.statistic.idx = idx;
            scope.isNew = false;
          } else {
            scope.statistic = {};
            scope.idx = undefined;
            scope.isNew = true;
          }
          var dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.addstatistic.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            if (data) {
              if (angular.isDefined(data.idx)) {
                var idx = data.idx;
                delete data.idx;
                scope.hpo.cfg.addedstatistics[idx] = angular.copy(data);
                AlertHpoFactory.successUpdate();
              } else {
                scope.hpo.cfg.addedstatistics.push(angular.copy(data));
                AlertHpoFactory.successAdd();
              }
            }
          });
        };

        scope.removeStat = function(idx) {
          var callback = function(isconfirm) {
            if (isconfirm) {
              scope.hpo.cfg.addedstatistics.splice(idx, 1);
              AlertHpoFactory.successDelete();
              try {
                scope.$apply();
              } catch (err) {}
            }
          };
          var message =
            $filter('translate')('hpo.common.removestat') +
            '. ' +
            $filter('translate')('hpo.common.sur');
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };
      },
    };
  };

  adminHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'EditFactory',
    '$rootScope',
    '$filter',
    'ngDialog',
    '$timeout',
    'ParametersFactory',
    'gaDomUtils',
    'HpoAppServices',
    'ImportExportFactory',
    'licenceFactory',
    'InitProvider',
    'ConfigFactory',
    '$q',
  ];
  return adminHpo;
});
