'use strict';
define(function() {
  var multicritereParametersConfig = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    ngProgressFactory,
    $location,
    InitProvider,
    $interval,
    HpoMulticritereServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/analye_multicritere/views/directives/multicritere_parameters_config.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.lang = localStorage.getItem('current_language');
        /**
         * Template
         * @type {String}
         */
        scope.multicritereTemplate =
          'js/XG/widgets/hpoapp/analye_multicritere/views/templates/parametrage.tpl.html';

        /**
         * New element creation
         * @return {[type]} [description]
         */
        scope.initNewParam = function() {
          return {
            isNew: true,
            uid: HpoCarteAppFactory.getAppFactory().getRandomInteger(),
            label: 'hpo.multicritere.parameters.new_parameter',
            name: undefined,
            type: undefined,
            date: HpoCarteAppFactory.getAppFactory().formatDate(new Date()),
          };
        };

        /**
         * CRUD SERVICES
         * @type {[type]}
         */
        scope.getService = HpoMulticritereServices.getParameters;
        scope.deleteService = HpoMulticritereServices.deleteParameters;
        scope.saveService = HpoMulticritereServices.saveParameter;

        /**
         * Widget config
         * @type {[type]}
         */
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoParametrageConfig';
        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            if (
              scope.currentParameter.isNew &&
              scope.currentParameter.uid !== dataHpo.savedata.uid
            ) {
              dataHpo.savedata.uid = HpoCarteAppFactory.getAppFactory().getRandomInteger();
              scope.oldParameter.uid = dataHpo.savedata.uid;
            } else {
              dataHpo.savedata.uid = scope.currentParameter.uid;
            }
            if (scope.currentParameter.isNew) {
              dataHpo.savedata.isNew = true;
              dataHpo.savedata.date = scope.currentParameter.date;
              delete dataHpo.savedata.id;
              delete scope.oldParameter.id;
            } else {
              dataHpo.savedata.id = scope.currentParameter.id;
            }
            if (scope.currentParameter.name)
              dataHpo.savedata.name = scope.currentParameter.name;
            if (scope.currentParameter.commentaire)
              dataHpo.savedata.commentaire = scope.currentParameter.commentaire;
            scope.currentParameter = angular.copy(dataHpo.savedata);
          }
        };
        scope.disableButtons = function() {
          return !(
            scope.currentParameter &&
            (scope.currentParameter.hasOwnProperty('type') ||
              scope.currentParameter.isNew)
          );
        };

        var fti_correspondance = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'correspondance'
        )[0];
        var fti_ponderation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'ponderation'
        )[0];
        var fti_indicateur = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'indicateur'
        )[0];
        var fti_parametrage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'parameters'
        )[0];
        var fti_criterea = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'critereas'
        )[0];
        var fti_compare = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'compare'
        )[0];
        var fti_priority = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'priority'
        )[0];

        scope.fti_component = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'parameters'
        )[0];
        scope.ftis = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();
        scope.types = [
          {
            id: 'simple',
            label: $filter('translate')(
              'hpo.multicritere.parameters.type.simple'
            ),
          },
          {
            id: 'auxiliaire',
            label: $filter('translate')(
              'hpo.multicritere.parameters.type.auxiliaire'
            ),
          },
          {
            id: 'matrix',
            label: $filter('translate')(
              'hpo.multicritere.parameters.type.matrix'
            ),
          },
        ];
        scope.keysToCheckOblig = ['name', 'type', 'categorie'];
        scope.keysToCheckNotoblig = [
          'commentaire',
          'uid',
          'label',
          'isNew',
          'data',
          'columnDefs',
          'id',
          'date',
        ];

        scope.addTitle = 'hpo.multicritere.parameters.add';
        scope.removeTitle = 'hpo.multicritere.parameters.remove';
        scope.elementsNames = 'hpo.multicritere.parameters.parameters';
      },
    };
  };

  multicritereParametersConfig.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'ngProgressFactory',
    '$location',
    'InitProvider',
    '$interval',
    'HpoMulticritereServices',
  ];
  return multicritereParametersConfig;
});
