'use strict';
define(function() {
  var multicritereFilterConfig = function(
    HpoCarteAppFactory,
    $rootScope,
    QueryFactory,
    HpoMulticritereServices,
    $filter,
    extendedNgDialog
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/analye_multicritere/views/directives/multicritere_Filter_config.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {

        var fti_filter = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'amc_filter'
        )[0];
        scope.ftis = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();
        scope.resultat = [];
        scope.reload = true;
        scope.initialseFilter =function(fti){
          var filter = '"FTI_TABLE" = \'' + fti.uid + "'";
          scope.reload = false;
          var promise = QueryFactory.data(
            fti_filter.uid,
            filter,
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          );
          promise.then(
            function(res) {
              if (res && res.data && res.data.features.length > 0) {
                scope.features = res.data.features;
                let filtredFeature = res.data.features.filter(feature => feature.properties.USED==true);
                scope.resultat.clauseWhere = filtredFeature.length>0?filtredFeature[0].properties.FILTER:"1=1";
              }else{
                delete scope.features;
                scope.resultat.clauseWhere = "1=1";
              }
              scope.reload = true;
            },
            function(res) {
              delete scope.features;
              scope.resultat.clauseWhere = "1=1";
              scope.reload = true;
            }
          );
        }
        scope.changeFilter =function(index){
          scope.reload = false;
          HpoMulticritereServices.selectAmcFilter(scope.features[index].id,fti_filter.uid,scope.fti.uid).then(function(res){
            scope.reload = true;
            require('toastr').success(
              $filter('translate')('hpo.multicritere.filter.filtersaved')
            );
          });
        }
        scope.removeFilter =function(index){
          scope.reload = false;
          HpoMulticritereServices.removeAmcFilter(scope.features[index].id,fti_filter.uid).then(function(res){
            scope.reload = true;
            scope.initialseFilter(scope.fti);
          });
        }
        scope.addFilter =function(newFilterName){
          HpoMulticritereServices.addAmcFilter(fti_filter.uid,scope.filterValue,scope.fti.uid,newFilterName).then(function(res){
              delete scope.filterValue;
              scope.showFilterAdd = false;
              scope.initialseFilter(scope.fti);
            });
        }
        $rootScope.$on('changedHpoValue',function(event,data){
           scope.filterValue = data.clauseWhere;
           var featureslist = angular.isDefined(scope.features)?scope.features.filter(feature => feature.properties.FILTER==data.clauseWhere):[];
           if(featureslist.length ==0){
            scope.showFilterAdd = true;
           }else{
            HpoMulticritereServices.selectAmcFilter(featureslist[0].id,fti_filter.uid,scope.fti.uid).then(function(res){
               require('toastr').info(
                $filter('translate')('hpo.multicritere.filter.filterAlreadyExist')+ featureslist[0].properties.NAME
              );
              scope.initialseFilter(scope.fti);
            });
           }
        });

      },
    };
  };

  multicritereFilterConfig.$inject = [
    'HpoCarteAppFactory',
    '$rootScope',
    'QueryFactory',
    'HpoMulticritereServices',
    '$filter',
    'extendedNgDialog',
  ];
  return multicritereFilterConfig;
});
