'use strict';
define(function() {
  var multicritereCompareConfig = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    ngProgressFactory,
    $location,
    InitProvider,
    $interval,
    HpoMulticritereServices,
    HpoAppModelServices,
    chartFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/analye_multicritere/views/directives/multicritere_compare_config.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        /**
         * Module Config
         * @type {[type]}
         */
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoCompareCritereaConfig';
        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';
        scope.propertiestoexclude = { result: undefined };
        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            if (dataHpo.savedata.ftiuid) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(dataHpo.savedata.ftiuid);
              if (~idx) {
                dataHpo.savedata.fti = scope.ftis[idx];
              } else {
                AlertHpoFactory.showAlertTemplateUpdate();
                dataHpo.savedata.fti = undefined;
                dataHpo.savedata.ftiuid = undefined;
              }
            } else if (dataHpo.savedata.fti) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(dataHpo.savedata.fti.uid);
              if (~idx) {
                dataHpo.savedata.fti = scope.ftis[idx];
              } else {
                AlertHpoFactory.showAlertTemplateUpdate();
                dataHpo.savedata.fti = undefined;
                dataHpo.savedata.ftiuid = undefined;
              }
            }

            if (
              scope.currentParameter.isNew &&
              scope.currentParameter.uid !== dataHpo.savedata.uid
            ) {
              dataHpo.savedata.uid = HpoCarteAppFactory.getAppFactory().getRandomInteger();
              scope.oldParameter.uid = dataHpo.savedata.uid;
            } else {
              dataHpo.savedata.uid = scope.currentParameter.uid;
            }
            if (scope.currentParameter.isNew) {
              dataHpo.savedata.isNew = true;
              dataHpo.savedata.date = scope.currentParameter.date;
              delete dataHpo.savedata.id;
              delete scope.oldParameter.id;
            } else {
              dataHpo.savedata.id = scope.currentParameter.id;
            }
            if (scope.currentParameter.name)
              dataHpo.savedata.name = scope.currentParameter.name;
            if (scope.currentParameter.commentaire)
              dataHpo.savedata.commentaire = scope.currentParameter.commentaire;
            scope.currentParameter = angular.copy(dataHpo.savedata);
            scope.currentParameter.fti = dataHpo.savedata.fti;
          }
        };

        /**
         * Conf widgets
         * @type {[type]}
         */
        scope.tabs = [
          {
            title: 'hpo.multicritere.compare.informations',
          },
          {
            title: 'hpo.multicritere.compare.historic',
          },
        ];
        scope.tabs.activeTab = 0;
        scope.loading = false;
        /**
         * Init object
         * @type {Object}
         */
        scope.emptyParameter = function(btn) {
          if (btn) {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.currentParameter = {
                  ponderation: {},
                  indicateur: {},
                  selectedallponderation: false,
                  selectedallindicateur: false,
                  seuil: 1,
                  result: undefined,
                  date: HpoCarteAppFactory.getAppFactory().formatDate(
                    new Date()
                  ),
                  save: true,
                };
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.multicritere.parameters.empty') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          } else {
            scope.currentParameter = {
              ponderation: {},
              indicateur: {},
              selectedallponderation: false,
              selectedallindicateur: false,
              seuil: 1,
              result: undefined,
              date: HpoCarteAppFactory.getAppFactory().formatDate(new Date()),
              save: true,
            };
          }
        };
        scope.emptyParameter(false);
        scope.availablePonderations = [];
        scope.availableIndicateurs = [];

        /**
         * Supplements
         * @type {Boolean}
         */
        scope.hasFti = true;
        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;

        /**
         * Get required ftis
         * @type {Array}
         */
        var fti_ponderation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'ponderation'
        )[0];
        var fti_indicateur = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'indicateur'
        )[0];
        var fti_parametrage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'parameters'
        )[0];
        var fti_criterea = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'critereas'
        )[0];
        var fticalage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage'
        )[0];
        scope.ftiprevision = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];
        var ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        var ftimodele = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        scope.ftiCompare = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'compare'
        )[0];
        var fti_filter = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'amc_filter'
        )[0];
        var initialseFilter =function(fti){
          var filter = '"FTI_TABLE" = \'' + fti.uid + "'";
          var promise = QueryFactory.data(
            fti_filter.uid,
            filter,
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          );
          promise.then(
            function(res) {
              if (res && res.data && res.data.features.length > 0) {
                let filtredFeature = res.data.features.filter(feature => feature.properties.USED==true);
                 scope.clauseWhere = filtredFeature.length>0?filtredFeature[0].properties.FILTER:"1=1";
              }else{
                 scope.clauseWhere = "1=1";
              }
            },
            function(res) {
               scope.clauseWhere = "1=1";
            }
          );
        }
        scope.ftiCompareattributes = scope.ftiCompare.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftiCompare.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftiCompare.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftiCompare.name
                ))
            )
              return x;
          }
        );
        scope.ftis = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();

        scope.getAvailableData = function(featuid, fti, data, newscope) {
          var filter = '"FEATID" = \'' + fti.uid + "'";
          var promise = QueryFactory.data(
            featuid,
            filter,
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          );
          promise.then(
            function(res) {
              if (res && res.data) {
                if (newscope) newscope[data] = res.data.features;
                else scope[data] = res.data.features;
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
          return promise;
        };

        scope.$watch('currentParameter.fti', function(newval, oldval) {
          if (newval) {
            scope.getAvailableData(
              fti_ponderation.uid,
              newval,
              'availablePonderations'
            );
            scope.getAvailableData(
              fti_indicateur.uid,
              newval,
              'availableIndicateurs'
            );
            initialseFilter(newval);
          } else {
            scope.availablePonderations = [];
            scope.availableIndicateurs = [];
          }
        });

        /**
         * Selection
         * @type {Array}
         */
        scope.selectOrdeAll = function(bool, availabledata, data) {
          if (bool) {
            availabledata.map(function(x) {
              scope.currentParameter[data][x.properties.IDENTIFIANT] = true;
            });
          } else {
            scope.currentParameter[data] = {};
          }
        };

        /**
         * Check form correct
         * @type {Array}
         */
        scope.lang = $rootScope.xgos.portal.lang;
        scope.checkInformations = function() {
          if (
            !scope.currentParameter ||
            !scope.currentParameter.fti ||
            !scope.currentParameter.fti.uid
          )
            return true;

          if (
            !scope.currentParameter ||
            !scope.currentParameter.ponderation ||
            !scope.currentParameter.indicateur
          )
            return true;

          var selectedPonderation = Object.keys(
            scope.currentParameter.ponderation
          )
            .map(function(x) {
              if (scope.currentParameter.ponderation[x]) return x;
            })
            .filter(function(x) {
              if (x) return x;
            });
          if (selectedPonderation.length === 0) return true;

          var selectedIndicateur = Object.keys(
            scope.currentParameter.indicateur
          )
            .map(function(x) {
              if (scope.currentParameter.indicateur[x]) return x;
            })
            .filter(function(x) {
              if (x) return x;
            });
          if (selectedIndicateur.length === 0) return true;

          if (
            angular.isUndefined(scope.currentParameter.seuil) ||
            scope.currentParameter.seuil < 0 ||
            scope.currentParameter.seuil > 100
          )
            return true;

          return false;
        };

        scope.run = function() {
          var sendata = angular.copy(scope.currentParameter);
          sendata.clauseWhere = scope.clauseWhere;
          sendata.featid = sendata.fti.uid;
          delete sendata.fti;
          delete sendata.selectedallponderation;
          delete sendata.selectedallindicateur;
          var ponderations = Object.keys(sendata.ponderation)
            .map(function(x) {
              if (sendata.ponderation[x]) return x;
            })
            .filter(function(x) {
              if (x) return x;
            });
          var indicateurs = Object.keys(sendata.indicateur)
            .map(function(x) {
              if (sendata.indicateur[x]) return x;
            })
            .filter(function(x) {
              if (x) return x;
            });
          sendata.ponderation = ponderations.join(',');
          sendata.indicateur = indicateurs.join(',');
          Object.assign(sendata, {
            fti_ponderation: fti_ponderation.uid,
            fti_indicateur: fti_indicateur.uid,
            fti_parametrage: fti_parametrage.uid,
            fti_criterea: fti_criterea.uid,
          });
          if (scope.ftiprevision && scope.ftiprevision.uid) {
            Object.assign(sendata, {
              fti_calage: fticalage.uid,
              fti_prevision: scope.ftiprevision.uid,
              fti_jeudonnee: ftijeudonnee.uid,
              fti_modele: ftimodele.uid,
              clauseWhere : scope.clauseWhere,
            });
          }
          scope.loading = true;
          gaDomUtils.showGlobalLoader();
          HpoMulticritereServices.compareAnalyses(sendata).then(
            function(res) {
              try {
                if (
                  res &&
                  res.data &&
                  (!res.data.code || res.data.code !== 500)
                ) {
                  scope.currentParameter.indicateurresult =
                    scope.currentParameter.indicateurresult ||
                    'benefice_escompte';
                  scope.currentParameter.result = res.data;
                  scope.currentParameter.chartOpt = chartFactory.getLineOption(
                    500,
                    450
                  );
                  scope.currentParameter.chartOpt.chart.xAxis.axisLabel = $filter(
                    'translate'
                  )('hpo.multicritere.compare.chartXtitle');
                  scope.currentParameter.chartOpt.chart.xAxis.tickSize = 6;
                  scope.currentParameter.chartOpt.chart.xAxis.domain = [0, 1];
                  scope.currentParameter.chartOpt.chart.xAxis.range = [0, 1];
                  scope.currentParameter.chartOpt.chart.xAxis.showMaxMin = false;
                  scope.currentParameter.chartOpt.chart.xAxis.showLabels = false;
                  scope.currentParameter.chartOpt.chart.xAxis.tickFormat = function(
                    d
                  ) {
                    if (
                      d !== 0 &&
                      d - 1 <= scope.currentParameter.result.labels.length
                    )
                      return scope.currentParameter.result.labels[d - 1];
                    else {
                      return d;
                    }
                  };
                  scope.currentParameter.chartOpt.chart.xAxis.staggerLabels = true;
                  scope.currentParameter.chartOpt.chart.xAxis.rotateYLabel = false;
                  scope.currentParameter.chartOpt.chart.xAxis.axisLabelDistance = 7;
                  scope.currentParameter.chartOpt.chart.xAxis.ticks =
                    scope.currentParameter.result.labels.length + 1;
                  scope.currentParameter.chartOpt.chart.yAxis.ticks = 2;
                  scope.currentParameter.chartOpt.chart.yAxis.domain = [0, 100];
                  scope.currentParameter.chartOpt.chart.yAxis.range = [0, 100];
                  scope.currentParameter.chartOpt.chart.forceY = [
                    0,
                    res.data['y_' + scope.currentParameter.indicateurresult],
                  ];
                  scope.currentParameter.chartOpt.chart.forceX = [
                    0,
                    res.data.x,
                  ];
                  scope.currentParameter.chartOpt.chart.yAxis.showMaxMin = false;
                  scope.currentParameter.chartOpt.chart.yAxis.axisLabel = $filter(
                    'translate'
                  )('hpo.multicritere.compare.chartYtitle');
                  scope.currentParameter.chartOpt.chart.showLegend = true;
                  scope.currentParameter.chartOpt.title.enable = true;
                  scope.currentParameter.chartOpt.title.className = 'h4';
                  scope.currentParameter.chartOpt.title.text =
                    $filter('translate')(
                      'hpo.multicritere.compare.charttitle'
                    ) +
                    ' ' +
                    scope.currentParameter.seuil +
                    $filter('translate')(
                      'hpo.multicritere.compare.charttitlesub'
                    );
                  scope.currentParameter.percentage = 100;
                  scope.gridHpo = {
                    enableGridMenu: true,
                    enableFiltering: false,
                    exporterMenuCsv: true,
                    exporterMenuPdf: false,
                    enableSelectAll: true,
                    multiSelect: true,
                    enableFullRowSelection: true,
                    enableRowSelection: true,
                    exporterCsvFilename: 'download.csv',
                    paginationPageSizes: [25, 50, 75, 100],
                    paginationPageSize: 25,
                    // modifierKeysToMultiSelectCells: true,
                    // keyDownOverrides: [{ keyCode: 39, ctrlKey: true }],
                    importerDataAddCallback: function(grid, newObjects) {
                      scope.gridHpo.data = scope.gridHpo.data.concat(
                        newObjects
                      );
                    },
                    // showGridFooter: true,
                    onRegisterApi: function(gridApi) {
                      scope.gridApi = gridApi;
                    },
                    columnDefs: res.data.columnDefs,
                    data:
                      res.data[
                        'grid_' + scope.currentParameter.indicateurresult
                      ],
                  };
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.multicritere.compare.succes'),
                    $filter('translate')(
                      'hpo.multicritere.compare.resultavailable'
                    ),
                    true
                  );
                } else {
                  scope.currentParameter.result = undefined;
                  scope.currentParameter.chartOpt = undefined;
                  scope.gridHpo = undefined;
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                e.stack;
              }
              scope.loading = false;
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
              scope.loading = false;
            }
          );
        };

        scope.editComparaison = function(obj) {
          if (obj) {
            gaDomUtils.showGlobalLoader();
            var sendata = {};
            Object.assign(sendata, {
              fti_ponderation: fti_ponderation.uid,
              fti_indicateur: fti_indicateur.uid,
              fti_parametrage: fti_parametrage.uid,
              fti_criterea: fti_criterea.uid,
            });
            if (scope.ftiprevision && scope.ftiprevision.uid) {
              Object.assign(sendata, {
                fti_calage: fticalage.uid,
                fti_prevision: scope.ftiprevision.uid,
                fti_jeudonnee: ftijeudonnee.uid,
                fti_modele: ftimodele.uid,
              });
            }
            HpoMulticritereServices.getComparaison(
              scope.ftiCompare.uid,
              obj.id,
              sendata
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  if (res.data.ftiuid) {
                    var idx = scope.ftis
                      .map(function(x) {
                        return x.uid;
                      })
                      .indexOf(res.data.ftiuid);
                    if (~idx) res.data.fti = scope.ftis[idx];
                  }
                  scope.newCurrentModel = res.data;
                  var prom1 = scope.getAvailableData(
                    fti_ponderation.uid,
                    scope.newCurrentModel.fti,
                    'newAvailablePonderations'
                  );
                  var prom2 = scope.getAvailableData(
                    fti_indicateur.uid,
                    scope.newCurrentModel.fti,
                    'newAvailableIndicateurs'
                  );
                  $q.all([prom1, prom2]).then(
                    function() {
                      scope.newCurrentModel.indicateurresult =
                        scope.newCurrentModel.indicateurresult ||
                        'benefice_escompte';
                      scope.newCurrentModel.chartOpt = chartFactory.getLineOption(
                        500,
                        450
                      );
                      scope.newCurrentModel.chartOpt.chart.xAxis.axisLabel = $filter(
                        'translate'
                      )('hpo.multicritere.compare.chartXtitle');
                      scope.newCurrentModel.chartOpt.chart.xAxis.tickSize = 6;
                      scope.newCurrentModel.chartOpt.chart.xAxis.domain = [
                        0,
                        1,
                      ];
                      scope.newCurrentModel.chartOpt.chart.xAxis.range = [0, 1];
                      scope.newCurrentModel.chartOpt.chart.xAxis.showMaxMin = false;
                      scope.newCurrentModel.chartOpt.chart.xAxis.showLabels = false;
                      scope.newCurrentModel.chartOpt.chart.xAxis.tickFormat = function(
                        d
                      ) {
                        if (
                          d !== 0 &&
                          d - 1 <= scope.newCurrentModel.result.labels.length
                        )
                          return scope.newCurrentModel.result.labels[d - 1];
                        else {
                          return d;
                        }
                      };
                      scope.newCurrentModel.chartOpt.chart.xAxis.staggerLabels = true;
                      scope.newCurrentModel.chartOpt.chart.xAxis.rotateYLabel = false;
                      scope.newCurrentModel.chartOpt.chart.xAxis.axisLabelDistance = 7;
                      scope.newCurrentModel.chartOpt.chart.xAxis.ticks =
                        scope.newCurrentModel.result.labels.length + 1;
                      scope.newCurrentModel.chartOpt.chart.yAxis.ticks = 2;
                      scope.newCurrentModel.chartOpt.chart.yAxis.domain = [
                        0,
                        100,
                      ];
                      scope.newCurrentModel.chartOpt.chart.yAxis.range = [
                        0,
                        100,
                      ];
                      scope.newCurrentModel.chartOpt.chart.forceY = [
                        0,
                        res.data.result[
                          'y_' + scope.newCurrentModel.indicateurresult
                        ],
                      ];
                      scope.newCurrentModel.chartOpt.chart.forceX = [
                        0,
                        res.data.result.x,
                      ];
                      scope.newCurrentModel.chartOpt.chart.yAxis.showMaxMin = false;
                      scope.newCurrentModel.chartOpt.chart.yAxis.axisLabel = $filter(
                        'translate'
                      )('hpo.multicritere.compare.chartYtitle');
                      scope.newCurrentModel.chartOpt.chart.showLegend = true;
                      scope.newCurrentModel.chartOpt.title.enable = true;
                      scope.newCurrentModel.chartOpt.title.className = 'h4';
                      scope.newCurrentModel.chartOpt.title.text =
                        $filter('translate')(
                          'hpo.multicritere.compare.charttitle'
                        ) +
                        ' ' +
                        scope.newCurrentModel.seuil +
                        $filter('translate')(
                          'hpo.multicritere.compare.charttitlesub'
                        );
                      scope.newCurrentModel.percentage = 100;
                      scope.gridHpo = {
                        enableGridMenu: true,
                        enableFiltering: false,
                        exporterMenuCsv: true,
                        exporterMenuPdf: false,
                        enableSelectAll: true,
                        multiSelect: true,
                        enableFullRowSelection: true,
                        enableRowSelection: true,
                        exporterCsvFilename: 'download.csv',
                        paginationPageSizes: [25, 50, 75, 100],
                        paginationPageSize: 25,
                        // modifierKeysToMultiSelectCells: true,
                        // keyDownOverrides: [{ keyCode: 39, ctrlKey: true }],
                        importerDataAddCallback: function(grid, newObjects) {
                          scope.gridHpo.data = scope.gridHpo.data.concat(
                            newObjects
                          );
                        },
                        // showGridFooter: true,
                        onRegisterApi: function(gridApi) {
                          scope.gridApi = gridApi;
                        },
                        columnDefs: res.data.result.columnDefs,
                        data:
                          res.data.result[
                            'grid_' + scope.newCurrentModel.indicateurresult
                          ],
                      };

                      var dialog = ngDialog.open({
                        template:
                          'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.multicritere.compare.info.html',
                        className:
                          'ngdialog-theme-plain width1100 nopadding miniclose',
                        scope: scope,
                      });
                    },
                    function(res1) {
                      gaDomUtils.hideGlobalLoader();
                      AlertHpoFactory.showErrorMessage(res1);
                    }
                  );
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.$watch('currentParameter.indicateurresult', function(newval) {
          if (
            newval &&
            scope.gridHpo &&
            scope.gridHpo.data &&
            scope.currentParameter &&
            scope.currentParameter.result
          ) {
            scope.gridHpo.data =
              scope.currentParameter.result[
                'grid_' + scope.currentParameter.indicateurresult
              ];
            scope.currentParameter.chartOpt.chart.forceY = [
              0,
              scope.currentParameter.result[
                'y_' + scope.currentParameter.indicateurresult
              ],
            ];
            if(scope.currentParameter.indicateurresult==='benefice_escompte'){
              scope.newCurrentModel.chartOpt.chart.yAxis.axisLabel = $filter(
                'translate'
              )('hpo.multicritere.compare.chartYtitle');
            }else if(scope.currentParameter.indicateurresult==='efficience_escompte'){
              scope.newCurrentModel.chartOpt.chart.yAxis.axisLabel = $filter(
                'translate'
              )('hpo.multicritere.compare.chartYtitle2');
            }
          }
        });

        scope.changedNewCurrent = function(newCurrent, gridHpo) {
          gridHpo.data =
            newCurrent.result['grid_' + newCurrent.indicateurresult];
          newCurrent.chartOpt.chart.forceY = [
            0,
            newCurrent.result['y_' + newCurrent.indicateurresult],
          ];
          if(newCurrent.indicateurresult==='benefice_escompte'){
            newCurrent.chartOpt.chart.yAxis.axisLabel = $filter(
              'translate')('hpo.multicritere.compare.chartYtitle');
          }else if(newCurrent.indicateurresult==='efficience_escompte'){
            newCurrent.chartOpt.chart.yAxis.axisLabel = $filter(
              'translate')('hpo.multicritere.compare.chartYtitle2');
          }
        };

        scope.saveParameter = function() {
          scope.statistic = {
            name: undefined,
            commentaire: undefined,
          };
          var dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.adddashboard.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            if (data) {
              gaDomUtils.showGlobalLoader();
              var sendata = angular.copy(scope.currentParameter);
              if (!sendata.ftiuid && sendata.fti) {
                sendata.ftiuid = sendata.fti.uid;
                sendata.ftialias = sendata.fti.alias;
                delete sendata.fti;
              }
              Object.assign(sendata, data);
              HpoMulticritereServices.saveComparaison(
                sendata,
                scope.ftiCompare.uid
              ).then(
                function(res) {
                  try {
                    if (res && res.data) {
                      scope.currentParameter.id = res.data;
                      $rootScope.$broadcast(
                        'reloadDatatable',
                        scope.ftiCompare.uid
                      );
                      AlertHpoFactory.successSave();
                    } else {
                      $rootScope.$broadcast(
                        'reloadDatatable',
                        scope.ftiCompare.uid
                      );
                      AlertHpoFactory.failSave();
                    }
                  } catch (e) {
                    e.stack;
                  }
                  gaDomUtils.hideGlobalLoader();
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                  scope.loading = false;
                }
              );
            }
          });
        };

        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';

        scope.refreshData = function() {
          $rootScope.$broadcast('reloadDatatable', scope.ftiCompare.uid);
        };

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ];

        scope.datatableCalageCrudHpo = {
          update: { func: scope.editComparaison },
          remove: true,
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-left',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        scope.getPonderationInfo = function(ponderation) {
          HpoMulticritereServices.getPonderation(
            fti_ponderation.uid,
            ponderation.id
          ).then(
            function(res) {
              if (res && res.data) {
                var newScope = $rootScope.$new();
                newScope.currentParameter = res.data[0];
                if (newScope.currentParameter.ftiuid) {
                  var idx = scope.ftis
                    .map(function(x) {
                      return x.uid;
                    })
                    .indexOf(newScope.currentParameter.ftiuid);
                  if (~idx) newScope.currentParameter.fti = scope.ftis[idx];
                }
                newScope.readonly = true;
                newScope.templateTpl =
                  'js/XG/widgets/hpoapp/analye_multicritere/views/templates/analyse.tpl.html';
                newScope.ftis = scope.ftis;
                newScope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
                var prom2 = scope.getAvailableData(
                  fti_criterea.uid,
                  newScope.currentParameter.fti,
                  'availableCritereas',
                  newScope
                );
                prom2.then(
                  function() {
                    ngDialog.open({
                      template:
                        'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.preview.general.tpl.html',
                      className:
                        'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
                      closeByDocument: false,
                      scope: newScope,
                    });
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.getIndicateurInfo = function(indicateur) {
          HpoMulticritereServices.getIndicateur(
            fti_indicateur.uid,
            indicateur.id
          ).then(
            function(res) {
              if (res && res.data) {
                var newScope = $rootScope.$new();
                newScope.currentParameter = res.data[0];
                if (newScope.currentParameter.ftiuid) {
                  var idx = scope.ftis
                    .map(function(x) {
                      return x.uid;
                    })
                    .indexOf(newScope.currentParameter.ftiuid);
                  if (~idx) newScope.currentParameter.fti = scope.ftis[idx];
                }
                newScope.readonly = true;
                newScope.templateTpl =
                  'js/XG/widgets/hpoapp/analye_multicritere/views/templates/indicateur.tpl.html';
                newScope.ftis = scope.ftis;
                newScope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
                ngDialog.open({
                  template:
                    'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.preview.general.tpl.html',
                  className:
                    'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
                  closeByDocument: false,
                  scope: newScope,
                });
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
      },
    };
  };

  multicritereCompareConfig.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'ngProgressFactory',
    '$location',
    'InitProvider',
    '$interval',
    'HpoMulticritereServices',
    'HpoAppModelServices',
    'chartFactory',
  ];
  return multicritereCompareConfig;
});
