'use strict';

define(function() {
  var DCCtrl = function(
    $scope,
    AncAppFactory,
    ngDialog,
    FeatureTypeFactory,
    EditFactory,
    UsersFactory,
    $timeout,
    $filter
  ) {
    $scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_listes_deroulantes_controles'
    );

    if (!$scope.cdata.anomalie_ep){
      $scope.cdata.anomalie_ep = {};
    }
    if (!$scope.cdata.anomalie_eu){
      $scope.cdata.anomalie_eu = {};
    }

    $timeout(()=> {
      if ($scope.cdata.branchement && !Array.isArray(
        $scope.cdata.branchement)) {
        $scope.cdata.branchement = [];
      }

      if ($scope.cdata.boite_branchement
        && !Array.isArray($scope.cdata.boite_branchement)) {
        $scope.cdata.boite_branchement = [];
      }
    },0);

    $scope.genereEnvoiCourrier = function(type_courrier) {
      $scope.getDocxControle('rdr_' + type_courrier + '.docx');
    };

    $scope.addAgentUrbanisme = function() {
      $scope.agent_urbanisme = {};
      if (angular.isUndefined($scope.showAdd)) $scope.showAdd = 1;
      else $scope.showAdd = $scope.showAdd == 1 ? 0 : 1;
    };

    $scope.setAgentUrbanisme = function() {
      var agent_urba = {};

      if (!angular.isDefined($scope.cdata.conformite.agent_urbanisme))
        $scope.cdata.conformite.agent_urbanisme = [];

      if (angular.isDefined($scope.agent_urbanisme)) {
        Object.keys($scope.agent_urbanisme).forEach(function(elem) {
          agent_urba[elem] = $scope.agent_urbanisme[elem];
        });

        if (Object.keys(agent_urba).length)
          $scope.cdata.conformite.agent_urbanisme.push(agent_urba);
        else
          require('toastr').warning('Aucune information saisie.', '', {
            positionClass: 'toast-bottom-left',
          });
      }
      delete $scope.showAdd;
    };

    $scope.deleteAgentUrbanisme = function(idx) {
      if (angular.isDefined($scope.cdata.conformite.agent_urbanisme))
        $scope.cdata.conformite.agent_urbanisme.splice(idx, 1);
    };

    $scope.setDateLimite = function() {
      if (angular.isDefined($scope.cdata.datesDossier.date_fixee_daact)) {
        $scope.cdata.datesDossier.date_limite = $filter('date')(
          moment($scope.cdata.datesDossier.date_fixee_daact)
            .add(30, 'd')
            .format('YYYY-MM-DDTHH:mm:ss.sssZ'),
          'yyyy-MM-ddTHH:mm:ss.sssZ'
        );
      }
    };

    $scope.$watch('cdata.datesDossier.date_fixee_daact', function(cc) {
      if (angular.isDefined(cc)) {
        $scope.setDateLimite();
      }
    });

    $scope.num_dau = [];
    $scope.getDau = function() {
      console.log($scope.currentControles);
      console.log('getdau');
      $scope.currentControles.forEach(function(ctrl) {
        if (
          ctrl.properties.type === 'DUB' &&
          ctrl.properties.ref_demande_autorisation_urbanisme != null &&
          ctrl.properties.ref_demande_autorisation_urbanisme != ''
        ) {
          $scope.num_dau.push(
            ctrl.properties.ref_demande_autorisation_urbanisme
          );
        }
      });
    };

    /**
     *Ajouter une ligne
     */
    $scope.addLines = (number, type)=> {
      switch (type) {
          case 'installation_eu':{
            for (let i = 0; i < number; i++) {
              $scope.cdata[type].push({
                reference: '',
                eu_batiment: {},
                eu_situation: {},
                eu_localisation: {},
                eu_equipement: {},
                nombre: null,
                eu_destination_eau: {},
                eu_type_essai: {},
                eu_etat: {},
                commentaire: '',
              });
            }
            break;
          }
          case 'installation_ep':{
            for (let i = 0; i < number; i++) {
              $scope.cdata[type].push({
                reference: '',
                ep_batiment: {},
                ep_situation: {},
                ep_localisation: {},
                ep_equipement: {},
                nombre: null,
                ep_destination_eau: {},
                ep_type_essai: {},
                ep_etat: {},
                commentaire: '',
              });
            }
            break;
          }
          case 'branchement':
          case 'boite_branchement':{
            if (!$scope.cdata[type] || !Array.isArray($scope.cdata[type])) {
              $scope.cdata[type] = [];
            }
            $scope.cdata[type][number] = {};
            break;
          }
        }
    };

    /**
     * Init Table installation_ep / installation_eu
     */
    $scope.initTable = function(type) {
      if (!$scope.cdata[type]) {
        $scope.cdata[type] = [];
      }

      if ($scope.cdata[type].length === 0)
        $scope.addLines(1, type);
    };

    $scope.addBranchAndBranchBoxLine = (index)=>{
      index = isNaN(index) ? 0 : index;
      $scope.addLines(index,'branchement');
      $scope.addLines(index,'boite_branchement');
    };

    [
      'installation_eu',
      'installation_ep',
    ].forEach(function(type) {
      $timeout(()=>{
        $scope.initTable(type);
      }, 0);
    });

    /**
     * supprimer une ligne de table installation_ep / installation_eu
     */
    $scope.deleteLine = function(index, type) {
      var tmpArr = [];
      $scope.cdata[type].forEach(function(l, i) {
        if (index != i) {
          tmpArr.push($scope.cdata[type][i]);
        }
      });

      if (tmpArr.length == 0) {
        $scope.cdata[type] = [];
        if (type !== 'branchement' && type !== 'boite_branchement')
          $scope.addLines(1, type);
      } else {
        $scope.cdata[type] = tmpArr;
      }
    };
    $scope.resetTab = function(type) {
      var ans = confirm(
        'Êtes-vous certain de vouloir réinitialiser le tableau  ?'
      );

      if (ans) {
        $scope.cdata[type] = [];
        $scope.addLines(1, type);
      }
    };
    if (angular.isUndefined($scope.cdata.general)) {
      $scope.cdata.general = {};
    }

    if (
      angular.isUndefined($scope.cdata.general.eau) ||
      $scope.cdata.general.eau == null
    ) {
      $scope.cdata.general.eau = 0;
    }

    $scope.showAno = true;
    $scope.cdata.toggleAddBrB = false;
    $scope.resetAno = function() {
      if (
        angular.isDefined($scope.cdata.anomalie.aucune_anomalie) &&
        $scope.cdata.anomalie.aucune_anomalie == 'true'
      ) {
        console.log($scope.cdata.anomalie.aucune_anomalie);
        var ans = confirm(
          "Les valeurs inscrites au sein des feuillets d'anomalie seront supprimées. Êtes-vous sûr ?"
        );
        if (ans) {
          $scope.showAno = false;
          if (angular.isDefined($scope.cdata.anomalie_ep))
            delete $scope.cdata.anomalie_ep;
          if (angular.isDefined($scope.cdata.anomalie_eu))
            delete $scope.cdata.anomalie_eu;
        }
      }

      if (
        angular.isDefined($scope.cdata.anomalie.aucune_anomalie) &&
        $scope.cdata.anomalie.aucune_anomalie == 'false'
      ) {
        $scope.showAno = true;
        if (angular.isUndefined($scope.cdata.anomalie_ep))
          $scope.cdata.anomalie_ep = {};
        if (angular.isUndefined($scope.cdata.anomalie_eu))
          $scope.cdata.anomalie_eu = {};
      }
    };
  };

  DCCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
    'UsersFactory',
    '$timeout',
    '$filter',
  ];
  return DCCtrl;
});
