'use strict';

define(function() {
  var CCICtrl = function(
    $scope,
    FeatureTypeFactory,
    gaJsUtils,
    $timeout
  ) {
    /*******************************************************************************
     *    Ftis
     * ********************************************************************************/
    $scope.activitePrincipaleEtablissementFti = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_etablissement_activite_principale'
    );

    $scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_listes_deroulantes_controles'
    );

    $scope.etablissementFti = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_etablissement'
    );

    $scope.resetTab = function(type) {
      let nomtableau = '';
      switch (type) {
        case 'tableau_produit':
          nomtableau = 'des produits';
          break;
        case 'dechets_produit':
          nomtableau = 'des déchets';
          break;
        case 'points_rejet':
          nomtableau = 'des rejets';
          break;
        case 'eaux_usees':
          nomtableau = 'Eaux usées';
          break;
        case 'eaux_pluviales':
          nomtableau = 'Eaux pluviales';
          break;
        case 'transmission_etablissement':
          nomtableau = 'Transmission vers établissement';
          break;
        case 'conformite':
          nomtableau = 'Bilan conformité';
          break;
        case 'origine_usage_eau':
          nomtableau = 'Origine et usage eau';
          break;
      }
      var ans = confirm(
        'Êtes-vous certain de vouloir réinitialiser le tableau ' +
          nomtableau +
          ' ?'
      );

      if (ans) {
        $scope.cdata[type] = [];
        $scope.addLines(1, type);
      }
    };

    /**
     *Ajouter une ligne
     */
    $scope.addLines = function(number, type) {
      for (var i = 0; i < number; i++) {
        switch (type) {
          case'tableau_produit': {
            $scope.cdata[type].push({
              reference: null,
              fiche_produit: {},
              toxicite: {},
              securite_transmise: {},
              commentaire: '',
            });
            break;
          }
          case 'dechets_produit': {
            $scope.cdata[type].push({
              quantite_dechet: '',
              origine_dechet: '',
              risque_dechet: null,
              type_dechet: '',
              stockage_dechet: {},
              destination_dechet: {},
              commentaire: '',
            });
            break;
          }
          case 'points_rejet': {
            $scope.cdata[type].push({
              rejet_branchement_type: null,
              rejet_branchement_adresse: '',
              rejet_branchement_localisation: {},
              rejet_niveau_evacuation: {},
              rejet_clapet: {},
              commentaire: '',
            });
            break;
          }
          case 'transmission_etablissement': {
            $scope.cdata[type].push({
              date_transmission: null,
              objet_transmission: {},
              destinaire_transmission: {},
              commentaire: '',
            });
            break;
          }
          case 'eaux_usees': {
            $scope.cdata[type].push({
              eaux_usees_origine_rejet: null,
              eaux_usees_caracteristiques_effluents: {},
              eaux_usees_type_ouvrage: {},
              eaux_usees_localisation: '',
              eaux_usees_dimensions: '',
              eaux_usees_entretien: {},
              eaux_usees_avis: {},
              commentaire: '',
            });
            break;
          }
          case 'eaux_pluviales': {
            $scope.cdata[type].push({
              eaux_pluviales_origine_rejet: null,
              eaux_pluviales_caracteristiques_effluents: {},
              eaux_pluviales_type_ouvrage: {},
              eaux_pluviales_localisation: '',
              eaux_pluviales_dimensions: '',
              eaux_pluviales_entretien: {},
              eaux_pluviales_avis: {},
              commentaire: '',
            });
            break;
          }
          case 'bilan_conformite': {
            $scope.cdata[type].push({
              conformite_priorite: {},
              conformite_insuffisance: '',
              conformite_preconisations: '',
              conformite_delais: {},
              commentaire: '',
            });
            break;
          }
          case 'origine_usage_eau': {
            $scope.cdata[type].push({
              origine_usage_eau: null,
              numero_branchement: '',
              numero_compteur: '',
              regime_redevance: {},
              usage_eau: '',
              consommation_eau: '',
              commentaire: '',
            });
            break;
          }
          case 'activite_secondaire': {
            $scope.cdata[type].push({
              batiment_activite: '',
              nature_activite: null,
              commentaires: '',
              id_etablissement: '',
            });
            break;
          }
          case 'details_icpe': {
            $scope.cdata[type].push({
              numero_icpe: '',
              intitule_icpe: '',
              seuil_icpe: '',
              regime_icpe: null,
              document_icpe: '',
              commentaires: '',
            });
            break;
          }
          default:{
            break;
          }
        }
      }
    };

    $scope.initTable = function(type) {
      if (!$scope.cdata[type]) {
        $scope.cdata[type] = [];
      }

      if($scope.cdata[type].length === 0){
        $scope.addLines(1, type);
      }
    };

    $scope.deleteLine = function(index, type) {
      var tmpArr = [];
      $scope.cdata[type].forEach(function(l, i) {
        if (index != i) {
          tmpArr.push($scope.cdata[type][i]);
        }
      });
      $scope.cdata[type] = tmpArr;
    };

    $scope.getListePays = function() {
      gaJsUtils.getListePays().then(function(listePays) {
        $scope.listePays = listePays;
      });
    };

    $scope.getListePays();
    [
      'tableau_produit',
      'dechets_produit',
      'points_rejet',
      'eaux_usees',
      'eaux_pluviales',
      'transmission_etablissement',
      'bilan_conformite',
      'origine_usage_eau',
      'activite_secondaire',
      'details_icpe',
      'origine_usage_eau'
    ].forEach(function(type) {
      $timeout(()=>{
        $scope.initTable(type);
        }, 0);
    });
  };

  CCICtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'gaJsUtils',
    '$timeout'
  ];

  return CCICtrl;
});
