'use strict';
define(function() {
  var BacAppSearchFactory = function($http) {
    var BacAppSearchFactory = undefined;
    var SearchFTI = undefined;

    function setSearchResult(r) {
      BacAppSearchFactory = r;
    }

    function getSearchResult() {
      return BacAppSearchFactory;
    }

    function setSearchFTI(r) {
      SearchFTI = r;
    }

    function getSearchFTI() {
      return SearchFTI;
    }

    /**
     * Function: saveConfig
     */
    function saveConfig(sendata) {
      var promise = $http.post(
        '/services/{portalid}/bacapp/{appname}/save/config?f=json',
        sendata
      );

      return promise;
    }

    /**
     * Function: getConfig
     */
    function getConfig() {
      var promise = $http.get(
        '/services/{portalid}/bacapp/{appname}/get/config?f=json'
      );

      return promise;
    }

    return {
      BacAppSearchFactory: BacAppSearchFactory,
      setSearchResult: setSearchResult,
      getSearchResult: getSearchResult,
      setSearchFTI: setSearchFTI,
      getSearchFTI: getSearchFTI,
      saveConfig: saveConfig,
      getConfig: getConfig,
    };
  };
  BacAppSearchFactory.$inject = ['$http'];
  return BacAppSearchFactory;
});
