'use strict';
define(function() {
  var bacNavigation = function(
    $location,
    BacAppFactory,
    ApplicationFactory,
    $sce,
    $window,
    $rootScope,
    ThemesFactory,
    PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/bacapp/main/views/directives/bac_navigation.html',
      restrict: 'EA',
      scope: {},
      link: function(scope, elt, attrs, ctrl) {
        scope.togglenav = false;

        scope.navigation = [
          {
            key: 'home',
            label: 'Accueil',
            goto: '/bac/',
            icon: 'home',
            description: 'Accueil',
          },
          {
            key: 'folder',
            label: 'Dossiers',
            goto: '/bac/reports/',
            icon: 'folder',
            description: 'La gestion des instructions',
          },
          {
            key: 'documents',
            label: 'Documents',
            goto: '/bac/documents/',
            icon: 'folder-open-o',
            description: 'Rapports, Documents, Notices',
          },
          {
            key: 'dashboard',
            label: 'Tableaux de bord',
            goto: '/bac/dashboard/',
            icon: 'pie-chart',
            description: "Bilan d'activité",
          },
          {
            key: 'mails',
            label: 'Publipostage',
            goto: '/bac/mails/',
            icon: 'envelope-o',
            description: 'Gestion et envoi des courriers et des avis ',
          },
          {
            key: 'config_mobile',
            label: 'Mobilite',
            goto: '/bac/config_mobile/',
            icon: 'mobile',
            description: 'Gestion des tournées',
          },
        ];

        // if there is a ANC app on the same portal
        let ancApp;
        let mapApp;
        ApplicationFactory.get().then(function() {
          ancApp = ApplicationFactory.resources.applications.filter(
            function(x) {
              return x.type === 'AncApp';
            }
          );
          mapApp = ApplicationFactory.resources.applications.filter(
            function(x) {
              return x.type === 'MapApp';
            }
          );
        });
        // admins only
        var navigationset = false;
        scope.$on('BacAppCfgSet', function(event, args) {
          if (!navigationset) {
            if (args.cfg.hasAccess.facturation) {
              scope.navigation.push({
                key: 'facturation',
                label: 'Facturation',
                goto: '/bac/facturation/',
                icon: 'files-o',
                description: 'Gestion des factures',
              });
            }
            if (args.cfg.isAdmin) {
              scope.navigation.push({
                key: 'admin',
                label: 'Administration',
                goto: '/bac/admin/',
                icon: 'gears',
                description: "Administration de l'application",
              });
            }

            if (args.cfg.allowedtoopenanc ===  true){
              scope.navigation.push({
                key: 'ancbac',
                label: 'ANC',
                goto: '/anc/',
                icon: 'exchange',
                description: "Administration de l'application",
                gotoapp_name: ancApp[0].name,
              });
            };

            if (args.cfg.hasAccess.mapApp === true) {
              
              scope.navigation.push({
                key: 'ancbacmap',
                label: 'CARTO',
                goto: '/map',
                icon: 'exchange',
                
                description: $sce.trustAsHtml(
                  "Accès à l'application <em>" + mapApp[0].name + '</em>'
                ),
              
                gotoapp_name: mapApp[0].name,
              });
            }
            navigationset = true;
          }
        });

        scope.mode = 'reduced';
        /**
         * set the navigation class (mini or full) according to current route
         */
        var setNavigationClass = function(path) {
          scope.mode = $location.path() === '/bac/' ? 'expanded' : 'reduced';
        };

        scope.$on('resetBacNavigation', function(event, args) {
          setNavigationClass();
        });

        setNavigationClass();

        /**
         * setCurrent navigation item
         */
        var setCurrentItemClass = function() {
          scope.navigation.forEach(function(i) {
            i.current = i.goto === $location.path();
          });
        };
        setCurrentItemClass();

        /**
         * goto navigation item path
         * @param item
         */
        scope.goto = function(item) {
          console.log(item)
          if (item.key === 'ancbac') {
            $window.open(
              '#/anc/?portal=' +
                PortalsFactory.getPortalId() +
                '&app=' +
                item.gotoapp_name
            );
            return;
          } else if (item.key === 'ancbacmap') {
            $window.open(
              '#/map?portal=' +
                PortalsFactory.getPortalId() +
                '&app=' +
                item.gotoapp_name
            );
            return;
          }
          $location.path(item.goto);
          setNavigationClass();
          setCurrentItemClass();
          scope.togglenav = false;
        };

        scope.getCurrentPageLabel = function() {
          var titre = '';
          scope.navigation.forEach(function(i) {
            if (i.goto === $location.path()) {
              titre = i.label;
            }
          });

          return titre;
        };

        /**
         * Au changement du bouton toggle switch du thème,<ul><li>
         * Enregistre le nouveau thème dans l'utilisateur</li><li>
         * Met à jour l'utilisateur</li></ul>
         */
        scope.addThemeToUser = () => {
          ThemesFactory.addDarkOrDefaultThemeToUser();
        };
      },
    };
  };

  bacNavigation.$inject = [
    '$location',
    'BacAppFactory',
    'ApplicationFactory',
    '$sce',
    '$window',
    '$rootScope',
    'ThemesFactory',
    'PortalsFactory'
  ];
  return bacNavigation;
});
